/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.iscloc2;

import cn.org.gddsn.seis.location.iscloc2.Config;
import cn.org.gddsn.seis.location.iscloc2.EC_COEF;
import cn.org.gddsn.seis.location.iscloc2.Interpolate;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import org.apache.log4j.Logger;
import org.netlib.util.intW;

public class EllipticityCorr {
    static Logger logger = Logger.getLogger(EllipticityCorr.class);

    private EllipticityCorr() {
    }

    public static double get_ellip_corr(EC_COEF[] ec, String phase, double ecolat, double delta, double depth, double esaz) {
        int k = -1;
        double azim = 0.0;
        double tau0 = 0.0;
        double tau1 = 0.0;
        double tau2 = 0.0;
        double s3 = Math.sqrt(3.0) / 2.0;
        double tcor = 0.0;
        double sc0 = 0.0;
        double sc1 = 0.0;
        double sc2 = 0.0;
        azim = esaz * (Math.PI / 180);
        k = EllipticityCorr.phase_index(phase, delta);
        if (k < 0) {
            return 0.0;
        }
        tau0 = Interpolate.bilinear_int(delta, depth, ec[k].num_dists, ec[k].num_depths, ec[k].delta, ec[k].depth, ec[k].t0);
        tau1 = Interpolate.bilinear_int(delta, depth, ec[k].num_dists, ec[k].num_depths, ec[k].delta, ec[k].depth, ec[k].t1);
        tau2 = Interpolate.bilinear_int(delta, depth, ec[k].num_dists, ec[k].num_depths, ec[k].delta, ec[k].depth, ec[k].t2);
        sc0 = 0.25 * (1.0 + 3.0 * Math.cos(2.0 * ecolat));
        sc1 = s3 * Math.sin(2.0 * ecolat);
        sc2 = s3 * Math.sin(ecolat) * Math.sin(ecolat);
        tcor = sc0 * tau0 + sc1 * Math.cos(azim) * tau1 + sc2 * Math.cos(2.0 * azim) * tau2;
        return tcor;
    }

    private static int phase_index(String phase, double delta) {
        if (Config.streq(phase, "Pup") || Config.streq(phase, "p")) {
            return 0;
        }
        if (Config.streq(phase, "P") || Config.streq(phase, "Pg") || Config.streq(phase, "Pb") || Config.streq(phase, "Pn") || Config.streq(phase, "PgPg") || Config.streq(phase, "PbPb")) {
            return 1;
        }
        if (Config.streq(phase, "Pdiff") || Config.streq(phase, "Pdif")) {
            return 2;
        }
        if (Config.streq(phase, "PKPab")) {
            return 3;
        }
        if (Config.streq(phase, "PKPbc")) {
            return 4;
        }
        if (Config.streq(phase, "PKPdf")) {
            return 5;
        }
        if (Config.streq(phase, "PKiKP")) {
            return 6;
        }
        if (Config.streq(phase, "pP") || Config.streq(phase, "pPg") || Config.streq(phase, "pPb") || Config.streq(phase, "pPn") || Config.streq(phase, "pwP")) {
            return 7;
        }
        if (Config.streq(phase, "pPKPab")) {
            return 8;
        }
        if (Config.streq(phase, "pPKPbc")) {
            return 9;
        }
        if (Config.streq(phase, "pPKPdf")) {
            return 10;
        }
        if (Config.streq(phase, "pPKiKP")) {
            return 11;
        }
        if (Config.streq(phase, "sP") || Config.streq(phase, "sPg") || Config.streq(phase, "sPb") || Config.streq(phase, "sPn")) {
            return 12;
        }
        if (Config.streq(phase, "sPKPab")) {
            return 13;
        }
        if (Config.streq(phase, "sPKPbc")) {
            return 14;
        }
        if (Config.streq(phase, "sPKPdf")) {
            return 15;
        }
        if (Config.streq(phase, "sPKiKP")) {
            return 16;
        }
        if (Config.streq(phase, "PcP")) {
            return 17;
        }
        if (Config.streq(phase, "ScP")) {
            return 18;
        }
        if (Config.streq(phase, "SKPab")) {
            return 19;
        }
        if (Config.streq(phase, "SKPbc")) {
            return 20;
        }
        if (Config.streq(phase, "SKPdf")) {
            return 21;
        }
        if (Config.streq(phase, "SKiKP")) {
            return 22;
        }
        if (Config.streq(phase, "PKKPab")) {
            return 23;
        }
        if (Config.streq(phase, "PKKPbc")) {
            return 24;
        }
        if (Config.streq(phase, "PKKPdf")) {
            return 25;
        }
        if (Config.streq(phase, "SKKPab")) {
            return 26;
        }
        if (Config.streq(phase, "SKKPbc")) {
            return 27;
        }
        if (Config.streq(phase, "SKKPdf")) {
            return 28;
        }
        if (Config.streq(phase, "PP") || Config.streq(phase, "PnPn")) {
            return 29;
        }
        if (Config.streq(phase, "P'P'ab") || Config.streq(phase, "P'P'bc") || Config.streq(phase, "P'P'df")) {
            return 30;
        }
        if (Config.streq(phase, "Sup") || Config.streq(phase, "s")) {
            return 31;
        }
        if (Config.streq(phase, "S") || Config.streq(phase, "Sg") || Config.streq(phase, "Sb") || Config.streq(phase, "Sn") || Config.streq(phase, "SgSg") || Config.streq(phase, "SbSb")) {
            return 32;
        }
        if (Config.streq(phase, "Sdiff") || Config.streq(phase, "Sdif")) {
            return 33;
        }
        if (Config.streq(phase, "SKSac")) {
            return 34;
        }
        if (Config.streq(phase, "SKSdf")) {
            return 35;
        }
        if (Config.streq(phase, "pS") || Config.streq(phase, "pSg") || Config.streq(phase, "pSb") || Config.streq(phase, "pSn")) {
            return 36;
        }
        if (Config.streq(phase, "pSKSac")) {
            return 37;
        }
        if (Config.streq(phase, "pSKSdf")) {
            return 38;
        }
        if (Config.streq(phase, "sS") || Config.streq(phase, "sSg") || Config.streq(phase, "sSb") || Config.streq(phase, "sSn")) {
            return 39;
        }
        if (Config.streq(phase, "sSKSac")) {
            return 40;
        }
        if (Config.streq(phase, "sSKSdf")) {
            return 41;
        }
        if (Config.streq(phase, "ScS")) {
            return 42;
        }
        if (Config.streq(phase, "PcS")) {
            return 43;
        }
        if (Config.streq(phase, "PKSab")) {
            return 44;
        }
        if (Config.streq(phase, "PKSbc")) {
            return 45;
        }
        if (Config.streq(phase, "PKSdf")) {
            return 46;
        }
        if (Config.streq(phase, "PKKSab")) {
            return 47;
        }
        if (Config.streq(phase, "PKKSbc")) {
            return 48;
        }
        if (Config.streq(phase, "PKKSdf")) {
            return 49;
        }
        if (Config.streq(phase, "SKKSac")) {
            return 50;
        }
        if (Config.streq(phase, "SKKSdf")) {
            return 51;
        }
        if (Config.streq(phase, "SS") || Config.streq(phase, "SnSn")) {
            return 52;
        }
        if (Config.streq(phase, "S'S'ac") || Config.streq(phase, "S'S'df")) {
            return 53;
        }
        if (Config.streq(phase, "SP") || Config.streq(phase, "SPg") || Config.streq(phase, "SPb") || Config.streq(phase, "SPn") || Config.streq(phase, "SnP")) {
            return 54;
        }
        if (Config.streq(phase, "PS") || Config.streq(phase, "PSg") || Config.streq(phase, "PSb") || Config.streq(phase, "PSn")) {
            return 55;
        }
        if (Config.streq(phase, "PnS")) {
            return 56;
        }
        if (delta <= 100.0) {
            if (Config.streq(phase, "pPdiff") || Config.streq(phase, "pPdif")) {
                return 7;
            }
            if (Config.streq(phase, "sPdiff") || Config.streq(phase, "sPdif")) {
                return 12;
            }
            if (Config.streq(phase, "pSdiff") || Config.streq(phase, "pSdif")) {
                return 36;
            }
            if (Config.streq(phase, "sSdiff") || Config.streq(phase, "sSdif")) {
                return 39;
            }
        }
        if (delta > 100.0) {
            if (Config.streq(phase, "pPdiff") || Config.streq(phase, "sPdiff") || Config.streq(phase, "pPdif") || Config.streq(phase, "sPdif")) {
                return 2;
            }
            if (Config.streq(phase, "pSdiff") || Config.streq(phase, "sSdiff") || Config.streq(phase, "pSdif") || Config.streq(phase, "sSdif")) {
                return 33;
            }
        }
        if (delta <= 165.0) {
            if (Config.streq(phase, "PKPdiff") || Config.streq(phase, "PKPdif")) {
                return 4;
            }
            if (Config.streq(phase, "pPKPdiff") || Config.streq(phase, "pPKPdif")) {
                return 9;
            }
            if (Config.streq(phase, "sPKPdiff") || Config.streq(phase, "sPKPdif")) {
                return 14;
            }
        }
        return -1;
    }

    public static EC_COEF[] read_elcor_tbl(intW num_phases, String filename) {
        EC_COEF[] ec = null;
        int num_pha = 0;
        int num_dist = 0;
        int num_depths = 6;
        double mindist = 0.0;
        double maxdist = 0.0;
        double d = 0.0;
        double t = 0.0;
        Scanner sc = null;
        try {
            sc = new Scanner(new File(filename));
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            Config.errorcode = 2;
            return null;
        }
        String delimiter = "((#.*\n)+|(#.*\r\n)+|(#.*\r)+|\\p{javaWhitespace}+)+";
        sc.useDelimiter(delimiter);
        while (sc.hasNext()) {
            String w = sc.next();
            if (!Character.isLetter(w.charAt(0))) continue;
            ++num_pha;
        }
        sc.close();
        try {
            sc = new Scanner(new File(filename));
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        sc.useDelimiter(delimiter);
        num_phases.val = num_pha;
        ec = new EC_COEF[num_pha];
        int i = 0;
        while (i < num_pha) {
            ec[i] = new EC_COEF();
            sc.next();
            num_dist = sc.nextInt();
            mindist = sc.nextDouble();
            maxdist = sc.nextDouble();
            ec[i].num_dists = num_dist;
            ec[i].mindist = mindist;
            ec[i].maxdist = maxdist;
            ec[i].num_depths = num_depths;
            ec[i].depth[0] = 0.0;
            ec[i].depth[1] = 100.0;
            ec[i].depth[2] = 200.0;
            ec[i].depth[3] = 300.0;
            ec[i].depth[4] = 500.0;
            ec[i].depth[5] = 700.0;
            ec[i].delta = new double[num_dist];
            ec[i].t0 = new double[num_dist][num_depths];
            ec[i].t1 = new double[num_dist][num_depths];
            ec[i].t2 = new double[num_dist][num_depths];
            int j = 0;
            while (j < num_dist) {
                ec[i].delta[j] = d = sc.nextDouble();
                int k = 0;
                while (k < num_depths) {
                    ec[i].t0[j][k] = t = sc.nextDouble();
                    ++k;
                }
                k = 0;
                while (k < num_depths) {
                    ec[i].t1[j][k] = t = sc.nextDouble();
                    ++k;
                }
                k = 0;
                while (k < num_depths) {
                    ec[i].t2[j][k] = t = sc.nextDouble();
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        sc.close();
        return ec;
    }

    public static void free_elcor_tbl(EC_COEF[] ec, int num_phases) {
        int i = 0;
        while (i < num_phases) {
            ec[i].t2 = null;
            ec[i].t1 = null;
            ec[i].t0 = null;
            ec[i].delta = null;
            ++i;
        }
        ec = null;
    }
}

