/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.iscloc2;

import cn.org.gddsn.seis.location.iscloc2.Config;
import cn.org.gddsn.seis.location.iscloc2.DataCovariance;
import cn.org.gddsn.seis.location.iscloc2.EC_COEF;
import cn.org.gddsn.seis.location.iscloc2.EllipticityCorr;
import cn.org.gddsn.seis.location.iscloc2.FE;
import cn.org.gddsn.seis.location.iscloc2.GeoRegion;
import cn.org.gddsn.seis.location.iscloc2.ISCEvent;
import cn.org.gddsn.seis.location.iscloc2.ISCHyp;
import cn.org.gddsn.seis.location.iscloc2.ISCPha;
import cn.org.gddsn.seis.location.iscloc2.ISCSol;
import cn.org.gddsn.seis.location.iscloc2.ISFIO;
import cn.org.gddsn.seis.location.iscloc2.Locator;
import cn.org.gddsn.seis.location.iscloc2.MAGQ;
import cn.org.gddsn.seis.location.iscloc2.MSZH;
import cn.org.gddsn.seis.location.iscloc2.RDMAG;
import cn.org.gddsn.seis.location.iscloc2.STAMAG;
import cn.org.gddsn.seis.location.iscloc2.TT_TABLE;
import cn.org.gddsn.seis.location.iscloc2.TravelTimes;
import cn.org.gddsn.seis.location.iscloc2.Utils;
import cn.org.gddsn.seis.location.iscloc2.VarioGram;
import cn.org.gddsn.util.Log4jConfig;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Scanner;
import org.apache.log4j.Logger;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class ISCLoc {
    static Logger logger = Logger.getLogger(ISCLoc.class);
    static int mindepthpha_cf = 5;
    static int ndepagency_cf = 2;
    static int minlocalsta_cf = 1;
    static int min_s_p_cf = 5;
    static int min_corepha_cf = 5;
    static double localdist_cf = 0.2;
    static double spdist_cf = 3.0;
    static int do_gridsearch_cf = 0;
    static int do_correlated_errors_cf = 1;
    static int update_db_cf = 0;
    static long iseed_cf = 5590L;
    static double na_radius_cf = 5.0;
    static double na_deptol_cf = 300.0;
    static double na_ottol_cf = 30.0;
    static int na_nsamplei_cf = 1000;
    static int na_nsample_cf = 100;
    static int na_ncells_cf = 20;
    static int na_itermax_cf = 10;
    static boolean depfix_cf;
    static boolean surfix_cf;
    static boolean hypofix_cf;

    public static void main(String[] args) {
        String buffer;
        String delimiter;
        String yyyymm;
        Log4jConfig.loadForMain((String)"ISCLoc.properties");
        Scanner instructSc = null;
        InputStream isfin = null;
        PrintWriter isfout = null;
        ISCEvent e = new ISCEvent();
        ISCSol s = new ISCSol();
        ISCHyp[] h = null;
        ISCPha[] p = null;
        TT_TABLE[] tt_tables = null;
        EC_COEF[] ec = null;
        VarioGram variogram = new VarioGram();
        MAGQ mbQ = new MAGQ();
        STAMAG[] stamag_mb = null;
        STAMAG[] stamag_ms = null;
        RDMAG[] rdmag_mb = null;
        RDMAG[] rdmag_ms = null;
        MSZH[] mszh = null;
        FE fe = new FE();
        double[][] depthgrid = null;
        double[] grn_depth = null;
        short[][] topo = null;
        intW total = new intW(0);
        intW fail = new intW(0);
        int[] opt = new int[7];
        intW ismbQ = new intW(0);
        int isf = 1;
        int database = 0;
        boolean noinstruct = false;
        intW ngrid = new intW(0);
        intW num_ecphases = new intW(0);
        doubleW gres = new doubleW(1.0);
        double d = 0.2617993877991494;
        int i = 0;
        while (i < 7) {
            opt[i] = 0;
            ++i;
        }
        double t00 = (double)System.currentTimeMillis() / 1000.0;
        Utils.t0 = (double)System.currentTimeMillis() / 1000.0;
        Config.verbose = 0;
        Config.errorcode = 0;
        String usage = "usage: iscloc [isf|yyyymmv|-|] [instructions]";
        if (args.length == 0) {
            System.err.printf("ABORT: No argument is given!\n%s\n", usage);
            System.err.printf("EVENT %.6f\n\n", Utils.secs(Utils.t0));
            System.exit(1);
        } else if (args[0].equals("-")) {
            yyyymm = "";
            instructSc = new Scanner(System.in);
            delimiter = "((#.*\n)+|(#.*\r\n)+|(#.*\r)+|=|\\p{javaWhitespace}+)+";
            instructSc.useDelimiter(delimiter);
        } else if (Config.streq(args[0], "isf")) {
            yyyymm = "";
            instructSc = new Scanner(System.in);
            delimiter = "((#.*\n)+|(#.*\r\n)+|(#.*\r)+|=|\\p{javaWhitespace}+)+";
            instructSc.useDelimiter(delimiter);
            isf = 1;
        } else {
            i = 0;
            while (i < 6) {
                if (!Character.isDigit(args[0].charAt(i))) {
                    System.err.printf("%s", usage);
                    System.exit(1);
                }
                ++i;
            }
            yyyymm = args[0].substring(0, 6);
            if (!Character.isLowerCase(args[0].charAt(6))) {
                System.err.printf("%s", usage);
                System.err.printf("EVENT %.6f\n", Utils.secs(Utils.t0));
                System.exit(1);
            }
            char version = args[0].charAt(6);
            buffer = System.getenv("QEDIT");
            if (buffer == null) {
                logger.warn((Object)String.format("QEDIT not defined, use current directory.", new Object[0]));
                buffer = System.getProperty("user.dir");
            }
            String editdir = buffer;
            String instructfile = String.format("%s/%s/%s%c.in", editdir, yyyymm, yyyymm, Character.valueOf(version));
            try {
                instructSc = new Scanner(new BufferedInputStream(new FileInputStream(instructfile)));
                delimiter = "((#.*\n)+|(#.*\r\n)+|(#.*\r)+|=|\\p{javaWhitespace}+)+";
                instructSc.useDelimiter(delimiter);
            }
            catch (IOException ex) {
                System.err.printf("Cannot open instruction file %s\n", instructfile);
                System.err.printf("EVENT %.6f\n", Utils.secs(Utils.t0));
                System.exit(1);
            }
        }
        buffer = System.getenv("QETC");
        String configdir = buffer != null ? String.format("%s", buffer) : String.valueOf(System.getProperty("user.dir")) + File.separator + "etc";
        String configfile = String.format("%s/iscloc/config.txt", configdir);
        System.out.printf("read_config: %s\n", configfile);
        if (Config.read_config(configfile) != 0) {
            System.err.printf("EVENT %.6f\n", Utils.secs(Utils.t0));
            System.exit(1);
        }
        mindepthpha_cf = Config.mindepthpha;
        ndepagency_cf = Config.ndepagency;
        localdist_cf = Config.localdist;
        minlocalsta_cf = Config.minlocalsta;
        spdist_cf = Config.spdist;
        min_s_p_cf = Config.min_s_p;
        min_corepha_cf = Config.min_corepha;
        do_gridsearch_cf = Config.do_gridsearch;
        na_radius_cf = Config.na_radius;
        na_deptol_cf = Config.na_deptol;
        na_ottol_cf = Config.na_ottol;
        na_nsamplei_cf = Config.na_nsamplei;
        na_nsample_cf = Config.na_nsample;
        na_ncells_cf = Config.na_ncells;
        na_itermax_cf = Config.na_itermax;
        update_db_cf = Config.update_db;
        iseed_cf = Config.iseed;
        do_correlated_errors_cf = Config.do_correlated_errors;
        if (isf != 0) {
            e.evid = 9999999;
            e.depth_agency = "";
            e.location_agency = "";
            e.time_agency = "";
            e.hypo_agency = "";
            e.start_time = 9999999.0;
            e.start_depth = 9999999.0;
            e.start_lon = 9999999.0;
            e.start_lat = 9999999.0;
            e.hypo_fix = false;
            e.surface_fix = false;
            e.depth_fix = false;
            e.time_fix = false;
            e.epi_fix = false;
            e.depth_fix_editor = false;
            e.fix_depth_depdp = false;
            e.fix_depth_default = false;
            if (!noinstruct && instructSc.hasNext()) {
                String instruction = instructSc.nextLine();
                instruction = instruction.trim();
                logger.info((Object)String.format("Instruction: %s", instruction));
                Config.parse_instruction(instruction, e, isf);
                depfix_cf = e.depth_fix;
                surfix_cf = e.surface_fix;
                hypofix_cf = e.hypo_fix;
            }
            Config.ndepagency = 1;
        }
        if (Config.isf_infile.length() != 0) {
            if (Config.streq(Config.isf_infile, "stdin")) {
                isfin = System.in;
            } else {
                try {
                    isfin = new BufferedInputStream(new FileInputStream(Config.isf_infile));
                }
                catch (IOException ex) {
                    logger.warn((Object)String.format("Cannot open isf input file %s", Config.isf_infile));
                    logger.info((Object)String.format("EVENT %.6f\n\n", Utils.secs(Utils.t0)));
                    System.exit(1);
                }
            }
            if (Config.isf_outfile.length() != 0) {
                if (Config.streq(Config.isf_outfile, "stdout")) {
                    isfout = new PrintWriter(System.out);
                } else {
                    try {
                        isfout = new PrintWriter(new FileWriter(Config.isf_outfile));
                    }
                    catch (IOException ex) {
                        logger.warn((Object)String.format("Cannot open isf output file %s", Config.isf_outfile));
                        logger.info((Object)String.format("EVENT %.6f\n", Utils.secs(Utils.t0)));
                        if (isf != 0) {
                            Config.stationlist = null;
                        }
                        System.exit(1);
                    }
                }
            }
            if (Config.verbose > 0) {
                logger.info((Object)String.format("    read_stafile", new Object[0]));
            }
            if ((Config.stationlist = ISFIO.read_stafile()) == null) {
                logger.warn((Object)String.format("read_stafile: %s", ISFIO.isf_error));
                logger.info((Object)String.format("EVENT %.6f\n", Utils.secs(Utils.t0)));
                System.exit(1);
            }
        }
        logger.info((Object)String.format("read_data_files (%.2f)", Utils.secs(Utils.t0)));
        Config.DataStruct ds = new Config.DataStruct();
        ds.ismbQ = ismbQ;
        ds.mbQp = mbQ;
        ds.fep = fe;
        ds.gres = gres;
        ds.ngrid = ngrid;
        ds.num_ecphases = num_ecphases;
        ds.variogramp = variogram;
        if (Config.read_data_files(configdir, ds) != 0) {
            logger.info((Object)String.format("EVENT %.6f\n", Utils.secs(Utils.t0)));
            if (isf != 0) {
                Config.stationlist = null;
            }
            System.exit(1);
        }
        grn_depth = ds.grn_depth;
        depthgrid = ds.depthgrid;
        topo = ds.topo;
        ec = ds.ec;
        tt_tables = ds.tt_tables;
        if (isf != 0) {
            ISFIO.ISFStruct isfs = new ISFIO.ISFStruct();
            isfs.ep = e;
            isfs.hp = h;
            isfs.pp = p;
            isfs.stamag_mb = stamag_mb;
            isfs.stamag_ms = stamag_ms;
            isfs.rdmag_mb = rdmag_mb;
            isfs.rdmag_ms = rdmag_ms;
            isfs.mszh = mszh;
            isfs.stationlist = Config.stationlist;
            Scanner sc = new Scanner(isfin);
            String delimiter2 = "((#.*\n)+|(#.*\r\n)+|(#.*\r)+|\\p{javaWhitespace}+)+";
            sc.useDelimiter(delimiter2);
            while (ISFIO.read_isf(sc, isfs) == 0) {
                h = isfs.hp;
                p = isfs.pp;
                stamag_mb = isfs.stamag_mb;
                stamag_ms = isfs.stamag_ms;
                rdmag_mb = isfs.rdmag_mb;
                rdmag_ms = isfs.rdmag_ms;
                mszh = isfs.mszh;
                if (Config.verbose > 0) {
                    logger.info((Object)String.format("    eventloc (%.2f)", Utils.secs(Utils.t0)));
                }
                if (Locator.eventloc(isf, database, total, fail, opt, e, h, s, p, stamag_mb, stamag_ms, rdmag_mb, rdmag_ms, mszh, ismbQ.val, mbQ, ec, tt_tables, variogram, gres.val, ngrid.val, depthgrid, fe, grn_depth, topo, isfout) != 0) {
                    logger.warn((Object)String.format("CAUTION: No solution found due to %s", Config.errorcodes[Config.errorcode]));
                }
                logger.info((Object)String.format("EVENT %.6f %d %d", Utils.secs(Utils.t0), e.evid, s.numphas));
                h = null;
                p = null;
                stamag_mb = null;
                stamag_ms = null;
                rdmag_mb = null;
                rdmag_ms = null;
                mszh = null;
                logger.info((Object)String.format("\n", new Object[0]));
                e.depth_fix = depfix_cf;
                e.surface_fix = surfix_cf;
                e.hypo_fix = hypofix_cf;
            }
            try {
                sc.close();
                isfin.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Config.stationlist = null;
        }
        if (!noinstruct) {
            instructSc.close();
        }
        GeoRegion.free_fe(fe);
        depthgrid = null;
        topo = null;
        grn_depth = null;
        if (tt_tables != null) {
            TravelTimes.free_tt_tbl(tt_tables);
        }
        if (ec != null) {
            EllipticityCorr.free_elcor_tbl(ec, num_ecphases.val);
        }
        if (ismbQ.val != 0) {
            mbQ.deltas = null;
            mbQ.depths = null;
            mbQ.q = null;
        }
        DataCovariance.free_variogram(variogram);
        logger.info((Object)String.format("Totals: option 0: %d, 1: %d, 2: %d 3: %d, 4: %d, 5: %d converged: %d failed: %d time %.2f", opt[0], opt[1], opt[2], opt[3], opt[4], opt[5], total.val, fail.val, Utils.secs(t00)));
        if (Config.isf_outfile.length() != 0) {
            isfout.close();
        }
        System.exit(0);
    }
}

