/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.iscloc2;

import cn.org.gddsn.seis.location.iscloc2.Config;
import cn.org.gddsn.seis.location.iscloc2.ISCPha;
import cn.org.gddsn.seis.location.iscloc2.ISCSol;
import cn.org.gddsn.seis.location.iscloc2.Interpolate;
import cn.org.gddsn.seis.location.iscloc2.MAGQ;
import cn.org.gddsn.seis.location.iscloc2.MSZH;
import cn.org.gddsn.seis.location.iscloc2.RDMAG;
import cn.org.gddsn.seis.location.iscloc2.READING;
import cn.org.gddsn.seis.location.iscloc2.STAMAG;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Scanner;
import org.apache.log4j.Logger;

public class Magnitude {
    static Logger logger = Logger.getLogger(Magnitude.class);

    private Magnitude() {
    }

    public static int calc_netmag(ISCSol sp, READING[] rdindx, ISCPha[] p, STAMAG[] stamag_mb, STAMAG[] stamag_ms, RDMAG[] rdmag_mb, RDMAG[] rdmag_ms, MSZH[] mszh, int ismbQ, MAGQ mbQ) {
        sp.bodymag = 9999999.0;
        sp.bodymag_uncertainty = 0.0;
        sp.nsta_mb = 0;
        sp.nass_mb = 0;
        sp.nmbagency = 0;
        sp.surfmag = 9999999.0;
        sp.surfmag_uncertainty = 0.0;
        sp.nsta_ms = 0;
        sp.nass_ms = 0;
        sp.nMsagency = 0;
        if (Magnitude.netmag(sp, rdindx, p, stamag_mb, rdmag_mb, mszh, 1, ismbQ, mbQ) != 0) {
            return 1;
        }
        if (Config.verbose > 0) {
            if (sp.bodymag != 9999999.0) {
                logger.info((Object)String.format("    bodymag=%.2f stderr=%.2f nsta=%d", sp.bodymag, sp.bodymag_uncertainty, sp.nsta_mb));
            } else {
                logger.info((Object)String.format("    No data for mb", new Object[0]));
            }
        }
        if (sp.depth > Config.surf_mag_max_depth) {
            return 0;
        }
        if (Magnitude.netmag(sp, rdindx, p, stamag_ms, rdmag_ms, mszh, 0, 0, null) != 0) {
            return 1;
        }
        if (Config.verbose > 0) {
            if (sp.surfmag != 9999999.0) {
                logger.info((Object)String.format("    surfmag=%.2f stderr=%.2f nsta=%d", sp.surfmag, sp.surfmag_uncertainty, sp.nsta_ms));
            } else {
                logger.info((Object)String.format("    No data for Ms", new Object[0]));
            }
        }
        return 0;
    }

    static int netmag(ISCSol sp, READING[] rdindx, ISCPha[] p, STAMAG[] stamag, RDMAG[] rdmag, MSZH[] mszh, int ismb, int isQ, MAGQ magQ) {
        int m;
        String mtype;
        Object[] rmag = null;
        double[] adev = null;
        double reading_mag = 0.0;
        double median = 0.0;
        double smad = 0.0;
        double min_mag = 0.0;
        double max_mag = 0.0;
        int nass = 0;
        int nsta = 0;
        int nagent = 0;
        int mtypeid = 0;
        int[] ageindex = new int[1024];
        if (ismb != 0) {
            mtype = "mb";
            mtypeid = 1;
        } else {
            mtype = "MS";
            mtypeid = 2;
        }
        int i = 0;
        while (i < sp.nreading) {
            m = rdindx[i].start;
            int np = rdindx[i].start + rdindx[i].npha;
            reading_mag = ismb != 0 ? Magnitude.calc_sta_mb(m, np, p, mtypeid, sp.depth, isQ, magQ) : Magnitude.calc_sta_ms(m, np, p, mtypeid, mszh[nass]);
            if (reading_mag > -999.0) {
                rdmag[nass].rdid = p[m].rdid;
                rdmag[nass].magdef = 0;
                rdmag[nass].mtypeid = mtypeid;
                rdmag[nass].sta = p[m].prista;
                rdmag[nass].agency = p[m].agency;
                rdmag[nass].magnitude = reading_mag;
                ++nass;
            }
            ++i;
        }
        if (nass == 0) {
            return 0;
        }
        if (ismb != 0) {
            sp.nass_mb = nass;
        } else {
            sp.nass_ms = nass;
        }
        i = 0;
        while (i < Config.numagencies) {
            ageindex[i] = 0;
            ++i;
        }
        int j = 0;
        while (j < nass) {
            i = 0;
            while (i < Config.numagencies) {
                if (Config.streq(rdmag[j].agency, Config.agencies[i])) {
                    int n = i;
                    ageindex[n] = ageindex[n] + 1;
                }
                ++i;
            }
            ++j;
        }
        rmag = new RDMAG[nass];
        Arrays.sort(rdmag, 0, nass, new RDMAG.SortBySta());
        String prev_prista = rdmag[0].sta;
        j = 0;
        nsta = 0;
        i = 0;
        while (i < nass) {
            if (!rdmag[i].sta.equals(prev_prista) && j != 0) {
                Arrays.sort(rmag, 0, j);
                m = j / 2;
                if (j % 2 != 0) {
                    median = ((RDMAG)rmag[m]).magnitude;
                    rdmag[i - m - 1].magdef = 1;
                } else {
                    median = 0.5 * (((RDMAG)rmag[m - 1]).magnitude + ((RDMAG)rmag[m]).magnitude);
                    rdmag[i - m - 1].magdef = 1;
                    rdmag[i - m].magdef = 1;
                }
                j = 0;
                stamag[nsta].sta = prev_prista;
                stamag[nsta].agency = ((RDMAG)rmag[m]).agency;
                stamag[nsta].magnitude = median;
                stamag[nsta].magdef = 0;
                stamag[nsta].mtypeid = mtypeid;
                ++nsta;
            }
            rmag[j] = new RDMAG(rdmag[i]);
            prev_prista = rdmag[i].sta;
            ++j;
            ++i;
        }
        if (j != 0) {
            Arrays.sort(rmag, 0, j);
            m = j / 2;
            if (j % 2 != 0) {
                median = ((RDMAG)rmag[m]).magnitude;
                rdmag[i - 1 - m].magdef = 1;
            } else {
                median = 0.5 * (((RDMAG)rmag[m - 1]).magnitude + ((RDMAG)rmag[m]).magnitude);
                rdmag[i - 1 - m - 1].magdef = 1;
                rdmag[i - 1 - m].magdef = 1;
            }
            stamag[nsta].sta = prev_prista;
            stamag[nsta].agency = ((RDMAG)rmag[m]).agency;
            stamag[nsta].magnitude = median;
            stamag[nsta].magdef = 0;
            stamag[nsta].mtypeid = mtypeid;
            ++nsta;
        }
        rmag = null;
        if (ismb != 0) {
            sp.nsta_mb = nsta;
        } else {
            sp.nsta_ms = nsta;
        }
        if (nsta < 3) {
            logger.info((Object)String.format("    netmag: %s: insufficient number of stations %d", mtype, nsta));
            return 0;
        }
        Arrays.sort(stamag, 0, nsta);
        i = nsta / 2;
        median = nsta % 2 != 0 ? stamag[i].magnitude : 0.5 * (stamag[i - 1].magnitude + stamag[i].magnitude);
        m = (int)Math.floor(0.2 * (double)nsta);
        min_mag = stamag[m].magnitude;
        max_mag = stamag[nsta - m - 1].magnitude;
        adev = new double[nsta];
        j = 0;
        i = m;
        while (i < nsta - m) {
            adev[j] = Math.abs(stamag[i].magnitude - median);
            stamag[i].magdef = 1;
            ++j;
            ++i;
        }
        Arrays.sort(adev, 0, j);
        m = j / 2;
        smad = j % 2 != 0 ? 1.4826 * adev[m] : 0.7413 * (adev[m - 1] + adev[m]);
        adev = null;
        logger.info((Object)String.format("    %s station magnitudes", mtype));
        i = 0;
        while (i < nsta) {
            logger.info((Object)String.format("      %-6s stamag=%.3f magdef=%d", stamag[i].sta, stamag[i].magnitude, stamag[i].magdef));
            ++i;
        }
        logger.info((Object)String.format("    agencies contributing to ISC %s", mtype));
        nagent = 0;
        i = 0;
        while (i < Config.numagencies) {
            if (ageindex[i] != 0) {
                logger.info((Object)String.format("      %3d %-17s %4d readings", ++nagent, Config.agencies[i], ageindex[i]));
            }
            ++i;
        }
        if (ismb != 0) {
            sp.bodymag = median;
            sp.bodymag_uncertainty = smad;
            sp.nmbagency = nagent;
        } else {
            sp.surfmag = median;
            sp.surfmag_uncertainty = smad;
            sp.nMsagency = nagent;
        }
        if (max_mag - min_mag > Config.mag_range_warn_thresh) {
            logger.info((Object)String.format("WARNING: %s RANGE %.1f - %.1f", mtype, min_mag, max_mag));
        }
        return 0;
    }

    static double calc_sta_mb(int start, int n, ISCPha[] p, int mtypeid, double depth, int isQ, MAGQ magQ) {
        int j;
        double logat = 0.0;
        double amp = 0.0;
        double apert = 0.0;
        double delta = 0.0;
        double reading_mb = -999.0;
        double q = 0.0;
        double maxat = 0.0;
        int ind_amp = 0;
        int ind_pha = 0;
        ind_pha = -1;
        ind_amp = -1;
        maxat = -999.0;
        delta = p[start].delta;
        int i = start;
        while (i < n) {
            if (p[i].numamps != 0 && p[i].purged == 0) {
                j = 0;
                while (j < Config.mb_phase_num) {
                    if (Config.streq(p[i].phase, Config.mb_phase[j])) break;
                    ++j;
                }
                if (j != Config.mb_phase_num && !(delta < Config.body_mag_min_dist) && !(delta > Config.body_mag_max_dist)) {
                    j = 0;
                    while (j < p[i].numamps) {
                        if (!(p[i].a[j].comp == 'N' || p[i].a[j].comp == 'E' || p[i].a[j].per < Config.body_mag_min_per || p[i].a[j].per > Config.body_mag_max_per || Math.abs(p[i].a[j].amp) < 1.0E-8 || p[i].a[j].amp == 9999999.0 || Math.abs(p[i].a[j].per) < 1.0E-8 || p[i].a[j].per == 9999999.0)) {
                            amp = isQ == 2 ? 2.0 * p[i].a[j].amp : p[i].a[j].amp;
                            apert = amp / p[i].a[j].per;
                            if (apert > maxat) {
                                maxat = apert;
                                ind_amp = j;
                                ind_pha = i;
                            }
                            logat = Math.log10(apert);
                            q = Magnitude.get_magQ(delta, depth, isQ, magQ);
                            p[i].a[j].magnitude = logat + q;
                            p[i].a[j].ampdef = 0;
                            p[i].a[j].mtypeid = mtypeid;
                            if (Config.verbose > 2) {
                                logger.info((Object)String.format("          i=%2d j=%2d amp=%.2f per=%.2f logat%.2f magnitude: %.2f", i, j, p[i].a[j].amp, p[i].a[j].per, logat, p[i].a[j].magnitude));
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (ind_pha > -1) {
            p[ind_pha].a[ind_amp].ampdef = 1;
            reading_mb = p[ind_pha].a[ind_amp].magnitude;
            if (Config.verbose > 1) {
                logger.info((Object)String.format("        rdid=%d %-6s depth=%.2f delta=%.2f mb=%.2f", p[ind_pha].rdid, p[ind_pha].sta, depth, delta, reading_mb));
            }
            return reading_mb;
        }
        ind_pha = -1;
        ind_amp = -1;
        maxat = -999.0;
        i = start;
        while (i < n) {
            if (p[i].numamps != 0 && p[i].purged == 0) {
                j = 0;
                while (j < Config.mb_phase_num) {
                    if (Config.streq(p[i].phase, Config.mb_phase[j])) break;
                    ++j;
                }
                if (j != Config.mb_phase_num && !(delta < Config.body_mag_min_dist) && !(delta > Config.body_mag_max_dist)) {
                    j = 0;
                    while (j < p[i].numamps) {
                        if (p[i].a[j].logat != 9999999.0) {
                            logat = p[i].a[j].logat;
                            if (logat > maxat) {
                                maxat = logat;
                                ind_amp = j;
                                ind_pha = i;
                            }
                            q = Magnitude.get_magQ(delta, depth, isQ, magQ);
                            p[i].a[j].magnitude = logat + q;
                            p[i].a[j].ampdef = 0;
                            p[i].a[j].mtypeid = mtypeid;
                            if (Config.verbose > 2) {
                                logger.info((Object)String.format("          i=%2d j=%2d amp=%.2f per=%.2f logat%.2f magnitude: %.2f", i, j, p[i].a[j].amp, p[i].a[j].per, logat, p[i].a[j].magnitude));
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (ind_pha > -1) {
            p[ind_pha].a[ind_amp].ampdef = 1;
            reading_mb = p[ind_pha].a[ind_amp].magnitude;
            if (Config.verbose > 1) {
                logger.info((Object)String.format("        rdid=%d %-6s depth=%.2f delta=%.2f mb=%.2f", p[ind_pha].rdid, p[ind_pha].sta, depth, delta, reading_mb));
            }
            return reading_mb;
        }
        return -999.0;
    }

    static double get_magQ(double delta, double depth, int isQ, MAGQ magQ) {
        double q = 0.0;
        if (isQ == 0 || depth < magQ.mindepth || depth > magQ.maxdepth || delta < magQ.mindist || delta > magQ.maxdist) {
            return q;
        }
        q = Interpolate.bilinear_int(delta, depth, magQ.num_dists, magQ.num_depths, magQ.deltas, magQ.depths, magQ.q);
        if (isQ == 1) {
            q -= 3.0;
        }
        return q;
    }

    static double calc_sta_ms(int start, int n, ISCPha[] p, int mtypeid, MSZH mszh) {
        int j;
        double reading_ms = -999.0;
        double apert = 0.0;
        double apertn = 0.0;
        double maxatz = 0.0;
        double maxate = 0.0;
        double maxatn = 0.0;
        double ms_h = 0.0;
        double ms_z = 0.0;
        double logat = 0.0;
        double delta = 0.0;
        double minper = Config.surf_mag_min_per;
        double maxper = Config.surf_mag_max_per;
        int ind_phaz = 0;
        int ind_phae = 0;
        int ind_phan = 0;
        int ind_ampz = 0;
        int ind_ampe = 0;
        int ind_ampn = 0;
        ind_phan = -1;
        ind_phae = -1;
        ind_phaz = -1;
        ind_ampn = -1;
        ind_ampe = -1;
        ind_ampz = -1;
        maxatn = -999.0;
        maxate = -999.0;
        maxatz = -999.0;
        ms_h = 9999999.0;
        ms_z = 9999999.0;
        delta = p[start].delta;
        int i = start;
        while (i < n) {
            if (p[i].numamps != 0 && p[i].purged == 0) {
                j = 0;
                while (j < Config.ms_phase_num) {
                    if (Config.streq(p[i].phase, Config.ms_phase[j])) break;
                    ++j;
                }
                if (j != Config.ms_phase_num && !(delta < Config.surf_mag_min_dist) && !(delta > Config.surf_mag_max_dist)) {
                    j = 0;
                    while (j < p[i].numamps) {
                        if (!(p[i].a[j].per < Config.surf_mag_min_per || p[i].a[j].per > Config.surf_mag_max_per || Math.abs(p[i].a[j].amp) < 1.0E-8 || p[i].a[j].amp == 9999999.0 || Math.abs(p[i].a[j].per) < 1.0E-8 || p[i].a[j].per == 9999999.0 || p[i].a[j].comp != 'Z')) {
                            apert = p[i].a[j].amp / p[i].a[j].per;
                            if (apert > maxatz) {
                                maxatz = apert;
                                ind_ampz = j;
                                ind_phaz = i;
                            }
                            logat = Math.log10(p[i].a[j].amp / p[i].a[j].per);
                            p[i].a[j].magnitude = logat + 1.66 * Math.log10(delta) + 0.3;
                            p[i].a[j].ampdef = 0;
                            p[i].a[j].mtypeid = mtypeid;
                            if (Config.verbose > 2) {
                                logger.info((Object)String.format("          i=%2d j=%2d comp=%c amp=%.2f per=%.2f logat%.2f magnitude: %.2f", i, j, Character.valueOf(p[i].a[j].comp), p[i].a[j].amp, p[i].a[j].per, logat, p[i].a[j].magnitude));
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (ind_phaz > -1) {
            minper = p[ind_phaz].a[ind_ampz].per - 5.0;
            maxper = p[ind_phaz].a[ind_ampz].per + 5.0;
            p[ind_phaz].a[ind_ampz].ampdef = 1;
            ms_z = p[ind_phaz].a[ind_ampz].magnitude;
            if (Config.verbose > 1) {
                logger.info((Object)String.format("        rdid=%d %-6s delta=%.2f MS_z=%.2f", p[ind_phaz].rdid, p[ind_phaz].sta, delta, ms_z));
            }
        }
        i = start;
        while (i < n) {
            if (p[i].numamps != 0 && p[i].purged == 0) {
                j = 0;
                while (j < Config.ms_phase_num) {
                    if (Config.streq(p[i].phase, Config.ms_phase[j])) break;
                    ++j;
                }
                if (j != Config.ms_phase_num && !(delta < Config.surf_mag_min_dist) && !(delta > Config.surf_mag_max_dist)) {
                    j = 0;
                    while (j < p[i].numamps) {
                        if (!(p[i].a[j].per < minper || p[i].a[j].per > maxper || Math.abs(p[i].a[j].amp) < 1.0E-8 || p[i].a[j].amp == 9999999.0 || p[i].a[j].comp != 'N' && p[i].a[j].comp != 'E')) {
                            if (p[i].a[j].comp == 'E' && (apert = p[i].a[j].amp / p[i].a[j].per) > maxate) {
                                maxate = apert;
                                ind_ampe = j;
                                ind_phae = i;
                            }
                            if (p[i].a[j].comp == 'N' && (apertn = p[i].a[j].amp / p[i].a[j].per) > maxatn) {
                                maxatn = apertn;
                                ind_ampn = j;
                                ind_phan = i;
                            }
                            logat = Math.log10(p[i].a[j].amp / p[i].a[j].per);
                            p[i].a[j].magnitude = logat + 1.66 * Math.log10(delta) + 0.3;
                            p[i].a[j].ampdef = 0;
                            p[i].a[j].mtypeid = mtypeid;
                            if (Config.verbose > 2) {
                                logger.info((Object)String.format("          i=%2d j=%2d comp=%c amp=%.2f per=%.2f logat%.2f magnitude: %.2f", i, j, Character.valueOf(p[i].a[j].comp), p[i].a[j].amp, p[i].a[j].per, logat, p[i].a[j].magnitude));
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (ind_phan > -1 && ind_phae > -1) {
            p[ind_phan].a[ind_ampn].ampdef = 1;
            p[ind_phae].a[ind_ampe].ampdef = 1;
            apert = Math.sqrt(maxatn * maxatn + maxate * maxate);
            ms_h = Math.log10(apert) + 1.66 * Math.log10(delta) + 0.3;
            if (Config.verbose > 0) {
                logger.info((Object)String.format("        rdid=%d %-6s delta=%.2f MS_h=%.2f", p[ind_phae].rdid, p[ind_phae].sta, delta, ms_h));
            }
        } else if (ind_phae > -1) {
            p[ind_phae].a[ind_ampe].ampdef = 1;
            apert = Math.sqrt(2.0 * maxate * maxate);
            ms_h = Math.log10(apert) + 1.66 * Math.log10(delta) + 0.3;
            if (Config.verbose > 0) {
                logger.info((Object)String.format("        rdid=%d %-6s delta=%.2f MS_h=%.2f", p[ind_phae].rdid, p[ind_phae].sta, delta, ms_h));
            }
        } else if (ind_phan > -1) {
            p[ind_phan].a[ind_ampn].ampdef = 1;
            apert = Math.sqrt(2.0 * maxatn * maxatn);
            ms_h = Math.log10(apert) + 1.66 * Math.log10(delta) + 0.3;
            if (Config.verbose > 0) {
                logger.info((Object)String.format("        rdid=%d %-6s delta=%.2f MS_h=%.2f", p[ind_phan].rdid, p[ind_phan].sta, delta, ms_h));
            }
        }
        if (ms_h != 9999999.0) {
            mszh.rdid = p[start].rdid;
            mszh.msh = ms_h;
            mszh.mshdef = 1;
            if (ms_z != 9999999.0) {
                reading_ms = (ms_h + ms_z) / 2.0;
                mszh.msz = ms_z;
                mszh.mszdef = 1;
            } else {
                reading_ms = ms_h;
                mszh.msz = ms_z;
                mszh.mszdef = 0;
            }
        } else if (ms_z != 9999999.0) {
            reading_ms = ms_z;
            mszh.rdid = p[start].rdid;
            mszh.msz = ms_z;
            mszh.mszdef = 1;
            mszh.msh = ms_h;
            mszh.mshdef = 0;
        }
        return reading_ms;
    }

    public static int read_magQ(String filename, MAGQ magq) {
        int ndis = 0;
        int ndep = 0;
        Scanner sc = null;
        try {
            sc = new Scanner(new File(filename));
        }
        catch (FileNotFoundException ex) {
            logger.info((Object)String.format("read_magQ: cannot open %s", filename));
            return 1;
        }
        String delimiter = "((#.*\n)+|(#.*\r\n)+|(#.*\r)+|\\p{javaWhitespace}+)+";
        sc.useDelimiter(delimiter);
        ndis = sc.nextInt();
        magq.deltas = new double[ndis];
        magq.num_dists = ndis;
        int i = 0;
        while (i < ndis) {
            magq.deltas[i] = sc.nextDouble();
            ++i;
        }
        magq.mindist = magq.deltas[0];
        magq.maxdist = magq.deltas[ndis - 1];
        ndep = sc.nextInt();
        magq.depths = new double[ndep];
        magq.num_depths = ndep;
        i = 0;
        while (i < ndep) {
            magq.depths[i] = sc.nextDouble();
            ++i;
        }
        magq.mindepth = magq.depths[0];
        magq.maxdepth = magq.depths[ndep - 1];
        i = sc.nextInt();
        int j = sc.nextInt();
        magq.q = new double[ndis][ndep];
        i = 0;
        while (i < ndis) {
            j = 0;
            while (j < ndep) {
                magq.q[i][j] = sc.nextDouble();
                ++j;
            }
            ++i;
        }
        sc.close();
        return 0;
    }
}

