/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.iscloc2;

import cn.org.gddsn.seis.location.iscloc2.Config;
import cn.org.gddsn.seis.location.iscloc2.EC_COEF;
import cn.org.gddsn.seis.location.iscloc2.ISCPha;
import cn.org.gddsn.seis.location.iscloc2.ISCSol;
import cn.org.gddsn.seis.location.iscloc2.READING;
import cn.org.gddsn.seis.location.iscloc2.TT_TABLE;
import cn.org.gddsn.seis.location.iscloc2.TravelTimes;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class PhaseIds {
    static Logger logger = Logger.getLogger(PhaseIds.class);

    private PhaseIds() {
    }

    public static int id_pha(ISCSol sp, READING[] rdindx, ISCPha[] p, EC_COEF[] ec, TT_TABLE[] tt_tables, short[][] topo) {
        int j;
        int n = 0;
        int i = 0;
        while (i < sp.numphas) {
            p[i].prevphase = "";
            p[i].dupsigma = 0.0;
            p[i].prevtimedef = false;
            p[i].timedef = false;
            p[i].firstS = false;
            p[i].firstP = false;
            p[i].duplicate = false;
            if (!p[i].phase_fixed) {
                p[i].phase = "";
                if (Config.streq(p[i].rep_phase, "") && p[i].init != 0) {
                    p[i].phase = "P";
                }
                j = 0;
                while (j < Config.phase_map_num) {
                    if (Config.streq(p[i].rep_phase, Config.phase_map[j].rep_phase)) {
                        p[i].phase = Config.phase_map[j].phase;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < sp.nreading) {
            int np = rdindx[i].start + rdindx[i].npha;
            j = rdindx[i].start;
            while (j < np) {
                if (p[j].phase.length() > 0 && p[j].phase.charAt(0) == 'P' || p[j].phase.length() > 1 && Character.isLowerCase(p[j].phase.charAt(0)) && (p[j].phase.charAt(1) == 'P' || p[j].phase.charAt(1) == 'w')) {
                    p[j].firstP = true;
                    break;
                }
                ++j;
            }
            j = rdindx[i].start;
            while (j < np) {
                if (p[j].phase.length() > 0 && p[j].phase.charAt(0) == 'S' || p[j].phase.length() > 1 && Character.isLowerCase(p[j].phase.charAt(0)) && p[j].phase.charAt(1) == 'S') {
                    p[j].firstS = true;
                    break;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < sp.nreading) {
            PhaseIds.phaseid(sp, rdindx[i], p, ec, tt_tables, topo);
            ++i;
        }
        n = 0;
        i = 0;
        while (i < sp.numphas) {
            if (!p[i].phase.equals(p[i].prevphase)) {
                PhaseIds.setsigma(p[i]);
                if (Config.verbose > 3) {
                    logger.info((Object)String.format("        %-6s %-8s: timedef=%d deltim=%.3f", p[i].sta, p[i].phase, p[i].timedef ? 1 : 0, p[i].measerr));
                }
            }
            if (p[i].timedef) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    public static int reidentify_pha(ISCSol sp, READING[] rdindx, ISCPha[] p, EC_COEF[] ec, TT_TABLE[] tt_tables, short[][] topo) {
        int isphasechange = 0;
        int i = 0;
        while (i < sp.numphas) {
            p[i].duplicate = false;
            p[i].firstS = false;
            p[i].firstP = false;
            ++i;
        }
        i = 0;
        while (i < sp.nreading) {
            int np = rdindx[i].start + rdindx[i].npha;
            int j = rdindx[i].start;
            while (j < np) {
                if (p[j].phase.length() > 0 && (p[j].phase.charAt(0) == 'P' || Character.isLowerCase(p[j].phase.charAt(0)) && p[j].phase.length() > 1 && (p[j].phase.charAt(1) == 'P' || p[j].phase.charAt(1) == 'w'))) {
                    p[j].firstP = true;
                    break;
                }
                ++j;
            }
            j = rdindx[i].start;
            while (j < np) {
                if (p[j].phase.length() > 0 && (p[j].phase.charAt(0) == 'S' || Character.isLowerCase(p[j].phase.charAt(0)) && p[j].phase.length() > 1 && p[j].phase.charAt(1) == 'S')) {
                    p[j].firstS = true;
                    break;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < sp.nreading) {
            PhaseIds.phaseid(sp, rdindx[i], p, ec, tt_tables, topo);
            ++i;
        }
        i = 0;
        while (i < sp.numphas) {
            if (!p[i].phase.equals(p[i].prevphase)) {
                PhaseIds.setsigma(p[i]);
                isphasechange = 1;
                if (Config.verbose > 2) {
                    logger.info((Object)String.format("        %-6s %-8s -> %-8s: timedef=%d deltim=%.3f", p[i].sta, p[i].prevphase, p[i].phase, p[i].timedef ? 1 : 0, p[i].measerr));
                }
                p[i].prevphase = p[i].phase;
            }
            ++i;
        }
        return isphasechange;
    }

    private static void phaseid(ISCSol sp, READING rdindx, ISCPha[] p, EC_COEF[] ec, TT_TABLE[] tt_tables, short[][] topo) {
        double bigres = 60.0;
        double dtdd = 9999999.0;
        double ttime = 9999999.0;
        double pPttime = 9999999.0;
        String candidate_phase = "";
        double mappedPhaResid = 0.0;
        double mappedPhaTTime = 0.0;
        int n = rdindx.start + rdindx.npha;
        int m = 0;
        int k = rdindx.start;
        while (k < n) {
            int j = 0;
            while (j < Config.no_resid_phase_num) {
                if (Config.streq(p[k].phase, Config.no_resid_phase[j])) break;
                ++j;
            }
            if (j == Config.no_resid_phase_num) {
                double min_resid = bigres + 1.0;
                double resid = 9999999.0;
                boolean stype = false;
                boolean ptype = false;
                boolean isp = false;
                boolean iss = false;
                boolean isP = false;
                boolean isS = false;
                if (p[k].phase.length() > 0 && p[k].phase.charAt(0) == 'P') {
                    isP = true;
                }
                if (p[k].phase.length() > 0 && p[k].phase.charAt(0) == 'S') {
                    isS = true;
                }
                if (p[k].phase.length() > 0 && Character.isLowerCase(p[k].phase.charAt(0))) {
                    if (p[k].phase.length() > 1 && (p[k].phase.charAt(1) == 'P' || p[k].phase.charAt(1) == 'w')) {
                        isp = true;
                    }
                    if (p[k].phase.length() > 1 && p[k].phase.charAt(1) == 'S') {
                        iss = true;
                    }
                }
                if (isP || isp || isS || iss) {
                    if (isP || isp) {
                        ptype = true;
                    }
                    if (isS || iss) {
                        stype = true;
                    }
                    if (p[k].phase_fixed) {
                        if (TravelTimes.read_ttime(sp, p[k], ec, tt_tables, topo, 0, -1) != 0) {
                            p[k].ttime = 9999999.0;
                            p[k].resid = 9999999.0;
                            if (Config.verbose > 0) {
                                logger.info((Object)String.format("    can't get TT for fixed phase %s! (depth=%.2f delta=%.2f sta=%s)", p[k].phase, sp.depth, p[k].delta, p[k].sta));
                            }
                        } else {
                            p[k].resid = p[k].time - sp.time - p[k].ttime;
                            if (Config.verbose > 4) {
                                logger.info((Object)String.format("              %-8s %9.4f %9.4f", p[k].phase, p[k].ttime, p[k].resid));
                            }
                        }
                    } else if (m != 0 && Math.abs(p[k].time - p[k - 1].time) < 0.01) {
                        if (Config.streq(p[k - 1].phase, "")) {
                            p[k - 1].phase = p[k].phase;
                            p[k - 1].ttime = p[k].ttime;
                            p[k - 1].resid = p[k].resid;
                            p[k - 1].dtdd = p[k].dtdd;
                        } else {
                            j = 0;
                            while (j < Config.no_resid_phase_num) {
                                if (Config.streq(p[k - 1].phase, Config.no_resid_phase[j])) break;
                                ++j;
                            }
                            if (j == Config.no_resid_phase_num) {
                                p[k].phase = p[k - 1].phase;
                                p[k].ttime = p[k - 1].ttime;
                                p[k].resid = p[k - 1].resid;
                                p[k - 1].dtdd = p[k].dtdd;
                            }
                        }
                    } else {
                        String mappedphase = p[k].phase;
                        int npha = Config.no_allowable_phase_num;
                        j = 0;
                        while (j < Config.no_allowable_phase_num) {
                            if (Config.streq(mappedphase, Config.allowable_phase[j])) break;
                            ++j;
                        }
                        if (j == Config.no_allowable_phase_num) {
                            Config.allowable_phase[npha++] = mappedphase;
                            if (Config.streq(mappedphase, "PnPn")) {
                                Config.allowable_phase[npha++] = "PbPb";
                                Config.allowable_phase[npha++] = "PgPg";
                            } else if (Config.streq(mappedphase, "PbPb")) {
                                Config.allowable_phase[npha++] = "PnPn";
                                Config.allowable_phase[npha++] = "PgPg";
                            } else if (Config.streq(mappedphase, "PgPg")) {
                                Config.allowable_phase[npha++] = "PnPn";
                                Config.allowable_phase[npha++] = "PbPb";
                            }
                            if (Config.streq(mappedphase, "SnSn")) {
                                Config.allowable_phase[npha++] = "SbSb";
                                Config.allowable_phase[npha++] = "SgSg";
                            } else if (Config.streq(mappedphase, "SbSb")) {
                                Config.allowable_phase[npha++] = "SnSn";
                                Config.allowable_phase[npha++] = "SgSg";
                            } else if (Config.streq(mappedphase, "SgSg")) {
                                Config.allowable_phase[npha++] = "SnSn";
                                Config.allowable_phase[npha++] = "SbSb";
                            }
                            if (Config.streq(mappedphase, "PS")) {
                                Config.allowable_phase[npha++] = "PnS";
                                Config.allowable_phase[npha++] = "PgS";
                            } else if (Config.streq(mappedphase, "PnS")) {
                                Config.allowable_phase[npha++] = "PS";
                                Config.allowable_phase[npha++] = "PgS";
                            } else if (Config.streq(mappedphase, "PgS")) {
                                Config.allowable_phase[npha++] = "PS";
                                Config.allowable_phase[npha++] = "PnS";
                            }
                            if (Config.streq(mappedphase, "SP")) {
                                Config.allowable_phase[npha++] = "SPn";
                                Config.allowable_phase[npha++] = "SPg";
                            } else if (Config.streq(mappedphase, "SPn")) {
                                Config.allowable_phase[npha++] = "SP";
                                Config.allowable_phase[npha++] = "SPg";
                            } else if (Config.streq(mappedphase, "SPg")) {
                                Config.allowable_phase[npha++] = "SP";
                                Config.allowable_phase[npha++] = "SPn";
                            }
                        }
                        if (Config.streq(mappedphase, "PP")) {
                            Config.allowable_phase[npha++] = "PnPn";
                            Config.allowable_phase[npha++] = "PbPb";
                            Config.allowable_phase[npha++] = "PgPg";
                        }
                        if (Config.streq(mappedphase, "SS")) {
                            Config.allowable_phase[npha++] = "SnSn";
                            Config.allowable_phase[npha++] = "SbSb";
                            Config.allowable_phase[npha++] = "SgSg";
                        }
                        j = 0;
                        while (j < npha) {
                            String phase = Config.allowable_phase[j];
                            int ttype = 0;
                            if (phase.length() > 0 && Character.isLowerCase(phase.charAt(0))) {
                                if (p[k].phase.length() > 1 && (phase.charAt(1) == 'P' || phase.charAt(1) == 'w')) {
                                    ttype = 80;
                                }
                                if (p[k].phase.length() > 1 && phase.charAt(1) == 'S') {
                                    ttype = 83;
                                }
                            } else {
                                int n2 = ttype = phase.length() > 0 ? Character.toUpperCase(phase.charAt(0)) : 0;
                            }
                            if (!(ttype == 80 && stype || ttype == 83 && ptype)) {
                                boolean isseen = false;
                                int ii = rdindx.start;
                                while (ii < k) {
                                    if (Config.streq(p[ii].phase, phase)) {
                                        isseen = true;
                                    }
                                    ++ii;
                                }
                                if (!(isseen || p[k].firstP && PhaseIds.isfirstP(phase, mappedphase) == 0 || p[k].firstS && PhaseIds.isfirstS(phase, mappedphase) == 0 || isS && phase.length() > 0 && Character.isLowerCase(phase.charAt(0)) && phase.charAt(1) == 'S')) {
                                    p[k].phase = phase;
                                    if (TravelTimes.read_ttime(sp, p[k], ec, tt_tables, topo, 0, -1) == 0) {
                                        if (Config.streq(phase, "pP")) {
                                            pPttime = p[k].ttime;
                                        }
                                        if (!Config.streq(phase, "pwP") || !(Math.abs(pPttime - p[k].ttime) < 1.0E-8)) {
                                            resid = p[k].time - sp.time - p[k].ttime;
                                            if (Config.verbose > 4) {
                                                logger.info((Object)String.format("              %-8s %9.4f %9.4f", p[k].phase, p[k].ttime, resid));
                                            }
                                            if (Math.abs(resid) < Math.abs(min_resid)) {
                                                candidate_phase = p[k].phase;
                                                min_resid = resid;
                                                ttime = p[k].ttime;
                                                dtdd = p[k].dtdd;
                                            }
                                            if (Config.streq(mappedphase, p[k].phase)) {
                                                mappedPhaResid = resid;
                                                mappedPhaTTime = p[k].ttime;
                                            }
                                        }
                                    }
                                }
                            }
                            ++j;
                        }
                        if (Math.abs(min_resid) > bigres) {
                            p[k].phase = "";
                            if (Config.verbose > 3) {
                                logger.info((Object)String.format("            %9d %9d %-6s cannot identify phase!", p[k].rdid, p[k].phid, p[k].sta));
                            }
                        } else if (Config.set_to_best_fitting_phase == 0) {
                            p[k].phase = mappedphase;
                            p[k].resid = mappedPhaResid;
                            p[k].ttime = mappedPhaTTime;
                        } else {
                            if (Config.verbose > 3) {
                                logger.info((Object)String.format("            %9d %9d %-6s %-8s -> %-8s %9.4f", p[k].rdid, p[k].phid, p[k].sta, mappedphase, candidate_phase, min_resid));
                            }
                            p[k].phase = candidate_phase;
                            p[k].resid = min_resid;
                            p[k].ttime = ttime;
                            p[k].dtdd = dtdd;
                        }
                    }
                }
            }
            ++m;
            ++k;
        }
    }

    private static int isfirstP(String phase, String mappedphase) {
        int j = 0;
        while (j < Config.firstPphase_num) {
            if (Config.streq(phase, Config.firstPphase[j])) {
                return 1;
            }
            ++j;
        }
        if (j == Config.firstPphase_num && Config.streq(mappedphase, phase)) {
            j = 0;
            while (j < Config.firstPopt_num) {
                if (Config.streq(phase, Config.firstPopt[j])) {
                    return 1;
                }
                ++j;
            }
        }
        return 0;
    }

    private static int isfirstS(String phase, String mappedphase) {
        int j = 0;
        while (j < Config.firstSphase_num) {
            if (Config.streq(phase, Config.firstSphase[j])) {
                return 1;
            }
            ++j;
        }
        if (j == Config.firstSphase_num && Config.streq(mappedphase, phase)) {
            j = 0;
            while (j < Config.firstSopt_num) {
                if (Config.streq(phase, Config.firstSopt[j])) {
                    return 1;
                }
                ++j;
            }
        }
        return 0;
    }

    private static void setsigma(ISCPha pp) {
        pp.timedef = false;
        pp.measerr = 9999999.0;
        if (pp.time == 9999999.0) {
            return;
        }
        int j = 0;
        while (j < Config.phase_weight_num) {
            if (Config.streq(pp.phase, Config.phase_weight[j].phase) && pp.delta >= Config.phase_weight[j].delta1 && pp.delta < Config.phase_weight[j].delta2) {
                pp.measerr = Config.phase_weight[j].measurement_error;
                if (pp.dupsigma > 0.0) {
                    pp.measerr += pp.dupsigma;
                }
                pp.timedef = true;
                double threshold = Config.sigmathres * pp.measerr;
                if (Math.abs(pp.resid) > threshold) {
                    pp.timedef = false;
                }
                if (!pp.force_undef) break;
                pp.timedef = false;
                break;
            }
            ++j;
        }
    }

    public static int mark_duplicates(ISCSol sp, ISCPha[] p, EC_COEF[] ec, TT_TABLE[] tt_tables, short[][] topo) {
        int[] samesta = new int[80];
        int i = 0;
        while (i < sp.numphas) {
            int j = 0;
            if (!p[i].timedef) {
                ++i;
            } else {
                int k = i;
                while (k < sp.numphas) {
                    if (!p[k].prista.equals(p[i].prista)) break;
                    if (!p[k].timedef) {
                        ++i;
                    } else {
                        samesta[j++] = k;
                        if (j > 80) {
                            logger.info((Object)String.format("mark_duplicates: %s (%s): too many phases", p[i].sta, p[i].prista));
                            return 1;
                        }
                    }
                    ++k;
                }
                if (j > 1) {
                    PhaseIds.same_sta(samesta, j, sp, p, ec, tt_tables, topo);
                }
            }
            i += j;
        }
        return 0;
    }

    private static void same_sta(int[] samesta, int n, ISCSol sp, ISCPha[] p, EC_COEF[] ec, TT_TABLE[] tt_tables, short[][] topo) {
        int k;
        int j;
        int[] sametime = new int[80];
        int[] samepha = new int[80];
        int[] done = new int[80];
        if (Config.verbose > 3) {
            logger.info((Object)String.format("        same_sta: %s %d phases", p[samesta[0]].sta, n));
        }
        int i = 0;
        while (i < n) {
            done[i] = 0;
            ++i;
        }
        i = 0;
        while (i < n) {
            if (done[i] == 0) {
                j = 0;
                k = i;
                while (k < n) {
                    if (Math.abs(p[samesta[k]].time - p[samesta[i]].time) < 0.1) {
                        sametime[j++] = samesta[k];
                        done[k] = 1;
                    }
                    ++k;
                }
                if (j > 1) {
                    PhaseIds.same_time(sametime, j, sp, p, ec, tt_tables, topo);
                }
            }
            ++i;
        }
        if (Config.do_correlated_errors != 0) {
            return;
        }
        i = 0;
        while (i < n) {
            done[i] = 0;
            ++i;
        }
        i = 0;
        while (i < n) {
            if (done[i] == 0) {
                j = 0;
                k = i;
                while (k < n) {
                    if (Config.streq(p[samesta[k]].phase, p[samesta[i]].phase)) {
                        samepha[j++] = samesta[k];
                        done[k] = 1;
                    }
                    ++k;
                }
                k = 0;
                while (k < j) {
                    p[samepha[k]].dupsigma = p[samepha[k]].measerr - 1.0 / (double)j;
                    if (Config.verbose > 2) {
                        logger.info((Object)String.format("        duplicates: %d %-6s %-8s", samepha[k], p[samepha[k]].sta, p[samepha[k]].phase));
                    }
                    ++k;
                }
            }
            ++i;
        }
    }

    private static void same_time(int[] sametime, int n, ISCSol sp, ISCPha[] p, EC_COEF[] ec, TT_TABLE[] tt_tables, short[][] topo) {
        int[] phacode = new int[80];
        if (Config.verbose > 3) {
            logger.info((Object)String.format("        same_time: %s %f %d phases", p[sametime[0]].sta, p[sametime[0]].time, n));
        }
        phacode[0] = sametime[0];
        int number_of_codes = 1;
        double meantime = p[sametime[0]].time;
        int i = 1;
        while (i < n) {
            meantime += p[sametime[i]].time;
            boolean match = false;
            int j = 0;
            while (j < number_of_codes) {
                if (Config.streq(p[sametime[i]].phase, p[phacode[j]].phase)) {
                    match = true;
                    break;
                }
                ++j;
            }
            if (!match) {
                phacode[number_of_codes++] = sametime[i];
            }
            ++i;
        }
        meantime /= (double)n;
        if (Config.verbose > 3) {
            logger.info((Object)String.format("        %d different phases", number_of_codes));
        }
        i = 0;
        while (i < n) {
            p[sametime[i]].time = meantime;
            if (i != 0) {
                p[sametime[i]].duplicate = true;
            }
            ++i;
        }
        if (number_of_codes == 1) {
            return;
        }
        double min_resid = Math.abs(9999999);
        int min_resid_index = phacode[0];
        i = 0;
        while (i < number_of_codes) {
            if (p[phacode[i]].init != 0) {
                min_resid_index = phacode[i];
                break;
            }
            if (TravelTimes.read_ttime(sp, p[phacode[i]], ec, tt_tables, topo, 0, -1) == 0) {
                double resid = Math.abs(p[phacode[i]].time - sp.time - p[phacode[i]].ttime);
                if (resid < min_resid) {
                    min_resid = resid;
                    min_resid_index = phacode[i];
                }
                if (Config.verbose > 3) {
                    logger.info((Object)String.format("            %6s %f %f", p[phacode[i]].phase, p[phacode[i]].ttime, resid));
                }
            }
            ++i;
        }
        if (Config.verbose > 3) {
            logger.info((Object)String.format("            same_time: set to %s", p[min_resid_index].phase));
        }
        String temp_phase = p[min_resid_index].phase;
        i = 0;
        while (i < n) {
            p[sametime[i]].phase = temp_phase;
            ++i;
        }
    }

    public static void id_pfake(ISCSol sp, ISCPha[] p, EC_COEF[] ec, TT_TABLE[] tt_tables, short[][] topo) {
        double bigres = 100.0;
        double ttime = 9999999.0;
        String candidate_phase = "";
        int i = 0;
        while (i < sp.numphas) {
            if (Config.streq(p[i].rep_phase, "PFAKE")) {
                double min_resid = bigres + 1.0;
                int j = 0;
                while (j < Config.firstPphase_num) {
                    double resid;
                    p[i].phase = Config.firstPphase[j];
                    if (TravelTimes.read_ttime(sp, p[i], ec, tt_tables, topo, 0, -1) == 0 && Math.abs(resid = p[i].time - sp.time - p[i].ttime) < Math.abs(min_resid)) {
                        candidate_phase = p[i].phase;
                        min_resid = resid;
                        ttime = p[i].ttime;
                    }
                    ++j;
                }
                if (Math.abs(min_resid) > bigres) {
                    p[i].phase = "";
                    p[i].ttime = 9999999.0;
                    p[i].resid = 9999999.0;
                } else {
                    p[i].phase = candidate_phase;
                    p[i].resid = min_resid;
                    p[i].ttime = ttime;
                }
            }
            ++i;
        }
    }

    public static void remove_pfake(ISCSol sp, ISCPha[] p) {
        int i = 0;
        while (i < sp.numphas) {
            if (Config.streq(p[i].rep_phase, "PFAKE")) {
                p[i].phase = "";
            }
            ++i;
        }
    }

    public static void reported_phase_resid(ISCSol sp, ISCPha pp, EC_COEF[] ec, TT_TABLE[] tt_tables, short[][] topo) {
        if (pp.rep_phase.length() != 0) {
            int j = 0;
            while (j < Config.phase_map_num) {
                if (Config.streq(pp.rep_phase, Config.phase_map[j].rep_phase)) {
                    pp.phase = Config.phase_map[j].phase;
                    break;
                }
                ++j;
            }
            pp.phase = pp.rep_phase;
            if (TravelTimes.read_ttime(sp, pp, ec, tt_tables, topo, 0, -1) != 0) {
                pp.phase = "";
                pp.resid = 9999999.0;
                pp.ttime = 9999999.0;
            } else {
                pp.resid = pp.time - sp.time - pp.ttime;
            }
        } else {
            pp.phase = "";
            pp.resid = 9999999.0;
            pp.ttime = 9999999.0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class phaseid_thr
    implements Callable<Boolean> {
        final ISCSol sp;
        final READING rdindx;
        final ISCPha[] p;
        final EC_COEF[] ec;
        final TT_TABLE[] tt_tables;
        final short[][] topo;

        public phaseid_thr(ISCSol sp, READING rdindx, ISCPha[] p, EC_COEF[] ec, TT_TABLE[] tt_tables, short[][] topo) {
            this.sp = sp;
            this.rdindx = rdindx;
            this.p = p;
            this.ec = ec;
            this.tt_tables = tt_tables;
            this.topo = topo;
        }

        @Override
        public Boolean call() {
            PhaseIds.phaseid(this.sp, this.rdindx, this.p, this.ec, this.tt_tables, this.topo);
            return true;
        }
    }
}

