/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.iscloc2;

import cn.org.gddsn.seis.location.iscloc2.Config;
import cn.org.gddsn.seis.location.iscloc2.EC_COEF;
import cn.org.gddsn.seis.location.iscloc2.EllipticityCorr;
import cn.org.gddsn.seis.location.iscloc2.ISCPha;
import cn.org.gddsn.seis.location.iscloc2.ISCSol;
import cn.org.gddsn.seis.location.iscloc2.Interpolate;
import cn.org.gddsn.seis.location.iscloc2.PhaseIds;
import cn.org.gddsn.seis.location.iscloc2.TT_TABLE;
import cn.org.gddsn.seis.location.iscloc2.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Scanner;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class TravelTimes {
    static Logger logger = Logger.getLogger(TravelTimes.class);
    private static final int[] delta_step = new int[]{9, 13, 22, 41, 63, 72, 83, 124, 140, 180};

    private TravelTimes() {
    }

    public static TT_TABLE[] read_tt_tables(String dirname) {
        TT_TABLE[] tt_tables = null;
        int ndists = 0;
        int ndepths = 0;
        int ind = 0;
        boolean isdepthphase = false;
        tt_tables = new TT_TABLE[95];
        ind = 0;
        while (ind < 95) {
            block17: {
                int j;
                tt_tables[ind] = new TT_TABLE();
                isdepthphase = false;
                if (Config.phaseTT[ind].charAt(0) == 'p' || Config.phaseTT[ind].charAt(0) == 's') {
                    isdepthphase = true;
                }
                tt_tables[ind].phase = Config.phaseTT[ind];
                tt_tables[ind].ndel = 0;
                tt_tables[ind].ndep = 0;
                String fname = isdepthphase ? String.format("%s/%s.little%s.tab", dirname, Config.ttime_table, Config.phaseTT[ind]) : String.format("%s/%s.%s.tab", dirname, Config.ttime_table, Config.phaseTT[ind]);
                Scanner sc = null;
                try {
                    sc = new Scanner(new File(fname));
                }
                catch (FileNotFoundException e) {
                    if (Config.verbose > 0) {
                        logger.warn((Object)String.format("read_tt_tables: cannot open %s", fname));
                    }
                    Config.errorcode = 2;
                    break block17;
                }
                String delimiter = "((#.*\n)+|(#.*\r\n)+|(#.*\r)+|\\p{javaWhitespace}+)+";
                sc.useDelimiter(delimiter);
                ndists = sc.nextInt();
                ndepths = sc.nextInt();
                tt_tables[ind].ndel = ndists;
                tt_tables[ind].ndep = ndepths;
                tt_tables[ind].deltas = new double[ndists];
                tt_tables[ind].depths = new double[ndepths];
                if (isdepthphase) {
                    tt_tables[ind].bpdel = new double[ndists][ndepths];
                }
                tt_tables[ind].tt = new double[ndists][ndepths];
                tt_tables[ind].dtdd = new double[ndists][ndepths];
                tt_tables[ind].dtdh = new double[ndists][ndepths];
                int i = 0;
                while (i < ndists) {
                    tt_tables[ind].deltas[i] = sc.nextDouble();
                    ++i;
                }
                i = 0;
                while (i < ndepths) {
                    tt_tables[ind].depths[i] = sc.nextDouble();
                    ++i;
                }
                i = 0;
                while (i < ndists) {
                    j = 0;
                    while (j < ndepths) {
                        tt_tables[ind].tt[i][j] = sc.nextDouble();
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < ndists) {
                    j = 0;
                    while (j < ndepths) {
                        tt_tables[ind].dtdd[i][j] = sc.nextDouble();
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < ndists) {
                    j = 0;
                    while (j < ndepths) {
                        tt_tables[ind].dtdh[i][j] = sc.nextDouble();
                        ++j;
                    }
                    ++i;
                }
                if (isdepthphase) {
                    i = 0;
                    while (i < ndists) {
                        j = 0;
                        while (j < ndepths) {
                            tt_tables[ind].bpdel[i][j] = sc.nextDouble();
                            ++j;
                        }
                        ++i;
                    }
                }
                sc.close();
            }
            ++ind;
        }
        return tt_tables;
    }

    public static void free_tt_tbl(TT_TABLE[] tt_tables) {
        int i = 0;
        while (i < 95) {
            if (tt_tables[i].ndel != 0) {
                tt_tables[i].dtdh = null;
                tt_tables[i].dtdd = null;
                tt_tables[i].tt = null;
                if (Config.phaseTT[i].charAt(0) == 'p' || Config.phaseTT[i].charAt(0) == 's') {
                    tt_tables[i].bpdel = null;
                }
                tt_tables[i].depths = null;
                tt_tables[i].deltas = null;
            }
            ++i;
        }
        tt_tables = null;
    }

    public static short[][] read_etopo1(String filename) {
        ByteBuffer bb;
        FileChannel fc;
        short[][] topo;
        block5: {
            topo = null;
            fc = new FileInputStream(filename).getChannel();
            topo = new short[Config.etoponlat][Config.etoponlon];
            int n = Config.etoponlat * Config.etoponlon;
            bb = ByteBuffer.allocate(n * 2).order(ByteOrder.LITTLE_ENDIAN);
            int m = fc.read(bb);
            if (m == n * 2) break block5;
            return null;
        }
        try {
            bb.flip();
            int i = 0;
            while (i < Config.etoponlat) {
                int j = 0;
                while (j < Config.etoponlon) {
                    topo[i][j] = bb.getShort();
                    ++j;
                }
                ++i;
            }
            fc.close();
        }
        catch (IOException ex) {
            logger.warn((Object)String.format("Cannot open %s!", filename));
            Config.errorcode = 2;
            return null;
        }
        return topo;
    }

    private static double find_etopo1(double lat, double lon, short[][] topo) {
        int i = (int)((lon + 180.0) / Config.etopores);
        int j = (int)((90.0 - lat) / Config.etopores);
        double lon1 = (double)i * Config.etopores - 180.0;
        double lat1 = 90.0 - (double)j * Config.etopores;
        double lon2 = (double)(i + 1) * Config.etopores - 180.0;
        double lat2 = 90.0 - (double)(j + 1) * Config.etopores;
        int k1 = i;
        int k2 = i + 1;
        int m = j;
        double a1 = (lon2 - lon) / (lon2 - lon1);
        double a2 = (lat2 - lat) / (lat2 - lat1);
        if (i < 0 || i > Config.etoponlon - 2) {
            k1 = Config.etoponlon - 1;
            k2 = 0;
        }
        if (j < 0) {
            m = 0;
            a2 = 0.0;
        }
        if (j > Config.etoponlat - 2) {
            m = Config.etoponlat - 2;
            a2 = 1.0;
        }
        double topo1 = topo[m][k1];
        double topo2 = topo[m + 1][k1];
        double topo3 = topo[m][k2];
        double topo4 = topo[m + 1][k2];
        double top = (1.0 - a1) * (1.0 - a2) * topo1 + a1 * (1.0 - a2) * topo3 + (1.0 - a1) * a2 * topo2 + a1 * a2 * topo4;
        return top / 1000.0;
    }

    public static int get_phase_index(String phase) {
        int i = 0;
        while (i < 95) {
            if (Config.streq(phase, Config.phaseTT[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static double get_tt(TT_TABLE tt_tablep, double depth, double delta, int iszderiv, doubleW dtdd, doubleW dtdh, doubleW bpdel) {
        int jdep;
        int idel;
        boolean exactdelta = false;
        boolean exactdepth = false;
        boolean isdepthphase = false;
        double ttim = -1.0;
        doubleW dydx = new doubleW(0.0);
        doubleW d2ydx = new doubleW(0.0);
        double[] x = new double[6];
        double[] z = new double[6];
        double[] d2y = new double[6];
        double[] tx = new double[6];
        double[] tz = new double[6];
        double[] tmp = new double[6];
        double[] dx = new double[6];
        double[] dz = new double[6];
        double[] hx = new double[6];
        double[] hz = new double[6];
        double[] px = new double[6];
        double[] pz = new double[6];
        int ndep = tt_tablep.ndep;
        int ndel = tt_tablep.ndel;
        if (tt_tablep.phase.length() > 0 && (tt_tablep.phase.charAt(0) == 'p' || tt_tablep.phase.charAt(0) == 's')) {
            isdepthphase = true;
        }
        bpdel.val = 0.0;
        dtdd.val = -999.0;
        dtdh.val = -999.0;
        if (ndel == 0) {
            return ttim;
        }
        if (depth < tt_tablep.depths[0] || depth > tt_tablep.depths[ndep - 1] || delta < tt_tablep.deltas[0] || delta > tt_tablep.deltas[ndel - 1]) {
            return ttim;
        }
        intW iloW = new intW(0);
        intW ihiW = new intW(0);
        Interpolate.bracket(delta, ndel, tt_tablep.deltas, iloW, ihiW);
        int ilo = iloW.val;
        int ihi = ihiW.val;
        if (Math.abs(delta - tt_tablep.deltas[ilo]) < 1.0E-8) {
            idel = ilo;
            exactdelta = true;
        } else if (Math.abs(delta - tt_tablep.deltas[ihi]) < 1.0E-8) {
            idel = ihi;
            exactdelta = true;
        } else if (ndel <= 6) {
            ilo = 0;
            ihi = ndel;
            idel = ilo;
        } else {
            idel = ilo;
            ilo = idel - 3 + 1;
            ihi = idel + 3 + 1;
            if (ilo < 0) {
                ilo = 0;
                ihi = ilo + 6;
            }
            if (ihi > ndel - 1) {
                ihi = ndel;
                ilo = ihi - 6;
            }
        }
        intW jloW = new intW(0);
        intW jhiW = new intW(0);
        Interpolate.bracket(depth, ndep, tt_tablep.depths, jloW, jhiW);
        int jlo = jloW.val;
        int jhi = jhiW.val;
        if (Math.abs(depth - tt_tablep.depths[jlo]) < 1.0E-8) {
            jdep = jlo;
            exactdepth = true;
        } else if (Math.abs(depth - tt_tablep.depths[jhi]) < 1.0E-8) {
            jdep = jhi;
            jlo = jhi++;
            exactdepth = true;
        } else if (ndep <= 4) {
            jlo = 0;
            jhi = ndep;
            jdep = jlo;
        } else {
            jdep = jlo;
            jlo = jdep - 2 + 1;
            jhi = jdep + 2 + 1;
            if (jlo < 0) {
                jlo = 0;
                jhi = jlo + 4;
            }
            if (jhi > ndep - 1) {
                jhi = ndep;
                jlo = jhi - 4;
            }
        }
        if (exactdelta && exactdepth) {
            ttim = tt_tablep.tt[idel][jdep];
            dtdd.val = tt_tablep.dtdd[idel][jdep];
            if (iszderiv != 0) {
                dtdh.val = tt_tablep.dtdh[idel][jdep];
            }
            if (isdepthphase) {
                bpdel.val = tt_tablep.bpdel[idel][jdep];
            }
            return ttim;
        }
        int k = 0;
        int j = jlo;
        while (j < jhi) {
            if (exactdelta) {
                if (!(tt_tablep.tt[idel][j] < 0.0)) {
                    z[k] = tt_tablep.depths[j];
                    tz[k] = tt_tablep.tt[idel][j];
                    if (isdepthphase) {
                        pz[k] = tt_tablep.bpdel[idel][j];
                    }
                    dz[k] = tt_tablep.dtdd[idel][j];
                    if (iszderiv != 0) {
                        hz[k] = tt_tablep.dtdh[idel][j];
                    }
                    ++k;
                }
            } else {
                int m = 0;
                int i = ilo;
                while (i < ihi) {
                    if (!(tt_tablep.tt[i][j] < 0.0)) {
                        x[m] = tt_tablep.deltas[i];
                        tx[m] = tt_tablep.tt[i][j];
                        if (isdepthphase) {
                            px[m] = tt_tablep.bpdel[i][j];
                        }
                        dx[m] = tt_tablep.dtdd[i][j];
                        if (iszderiv != 0) {
                            hx[m] = tt_tablep.dtdh[i][j];
                        }
                        ++m;
                    }
                    ++i;
                }
                if (m >= 2) {
                    Interpolate.spline(m, x, tx, d2y, tmp);
                    z[k] = tt_tablep.depths[j];
                    tz[k] = Interpolate.spline_int(delta, m, x, tx, d2y, 0, dydx, d2ydx);
                    if (isdepthphase) {
                        Interpolate.spline(m, x, px, d2y, tmp);
                        pz[k] = Interpolate.spline_int(delta, m, x, px, d2y, 0, dydx, d2ydx);
                    }
                    Interpolate.spline(m, x, dx, d2y, tmp);
                    dz[k] = Interpolate.spline_int(delta, m, x, dx, d2y, 0, dydx, d2ydx);
                    if (iszderiv != 0) {
                        Interpolate.spline(m, x, hx, d2y, tmp);
                        hz[k] = Interpolate.spline_int(delta, m, x, hx, d2y, 0, dydx, d2ydx);
                    }
                    ++k;
                }
            }
            ++j;
        }
        if (k == 0) {
            return ttim;
        }
        if (exactdepth) {
            ttim = tz[0];
            if (isdepthphase) {
                bpdel.val = pz[0];
            }
            dtdd.val = dz[0];
            if (iszderiv != 0) {
                dtdh.val = hz[0];
            }
            return ttim;
        }
        if (k < 2) {
            return ttim;
        }
        Interpolate.spline(k, z, tz, d2y, tmp);
        ttim = Interpolate.spline_int(depth, k, z, tz, d2y, 0, dydx, d2ydx);
        if (isdepthphase) {
            Interpolate.spline(k, z, pz, d2y, tmp);
            bpdel.val = Interpolate.spline_int(depth, k, z, pz, d2y, 0, dydx, d2ydx);
        }
        Interpolate.spline(k, z, dz, d2y, tmp);
        dtdd.val = Interpolate.spline_int(depth, k, z, dz, d2y, 0, dydx, d2ydx);
        if (iszderiv != 0) {
            Interpolate.spline(k, z, hz, d2y, tmp);
            dtdh.val = Interpolate.spline_int(depth, k, z, hz, d2y, 0, dydx, d2ydx);
        }
        return ttim;
    }

    public static int calc_resid(ISCSol sp, ISCPha[] p, String mode, EC_COEF[] ec, TT_TABLE[] tt_tables, short[][] topo, int iszderiv) {
        int all = 0;
        if (Config.streq(mode, "all")) {
            all = 1;
        } else if (Config.streq(mode, "use")) {
            all = 0;
        } else {
            logger.info((Object)String.format("calc_resid: unrecognised mode %s", mode));
            return 1;
        }
        if (sp.depth == 9999999.0) {
            logger.info((Object)String.format("calc_resid: depthless hypocentre", new Object[0]));
            return 1;
        }
        if (sp.depth > Config.max_depth_km) {
            logger.info((Object)String.format("calc_resid: solution too deep %f > %f ", sp.depth, Config.max_depth_km));
            return 1;
        }
        int i = 0;
        while (i < sp.numphas) {
            p[i].resid = TravelTimes.timeres(p[i], all, sp, ec, tt_tables, topo, iszderiv);
            ++i;
        }
        return 0;
    }

    static double timeres(ISCPha pp, int all, ISCSol sp, EC_COEF[] ec, TT_TABLE[] tt_tables, short[][] topo, int iszderiv) {
        double obtime = 0.0;
        double resid = 9999999.0;
        int isfirst = 0;
        if (!(all != 0 || pp.timedef && pp.phase.length() != 0)) {
            pp.resid = resid;
            return resid;
        }
        if (pp.time == 9999999.0) {
            pp.resid = resid;
            return resid;
        }
        if (all != 0) {
            if (pp.phase.length() > 0) {
                int j = 0;
                while (j < Config.no_resid_phase_num) {
                    if (Config.streq(pp.phase, Config.no_resid_phase[j])) break;
                    ++j;
                }
                if (j != Config.no_resid_phase_num) {
                    pp.resid = resid;
                    return resid;
                }
            } else {
                PhaseIds.reported_phase_resid(sp, pp, ec, tt_tables, topo);
            }
        }
        obtime = pp.time - sp.time;
        if (Config.verbose > 3) {
            logger.info((Object)String.format("            %-6s %-8s obtime: %9.4f", pp.sta, pp.phase, obtime));
        }
        if (TravelTimes.read_ttime(sp, pp, ec, tt_tables, topo, iszderiv, isfirst = all != 0 && !pp.timedef ? -1 : 0) != 0) {
            if (all != 0 && !pp.phase_fixed) {
                pp.phase = "";
            }
            pp.resid = 9999999.0;
            pp.ttime = 9999999.0;
        } else {
            resid = obtime - pp.ttime;
        }
        if (Config.verbose > 2) {
            StringBuilder sb = new StringBuilder(128);
            sb.append(String.format("        %-6s %-8s ", pp.sta, pp.phase));
            sb.append(String.format("delta=%8.3f tt=", pp.delta));
            if (pp.ttime != 9999999.0) {
                sb.append(String.format("%9.4f ", pp.ttime));
            } else {
                sb.append(String.format("%9s ", ""));
            }
            sb.append(String.format("dtdd=%8.4f ", pp.dtdd));
            if (iszderiv != 0) {
                sb.append(String.format("dtdh=%8.4f ", pp.dtdh));
            }
            if (resid != 9999999.0) {
                sb.append(String.format("tres=%10.5f", resid));
            }
            logger.info((Object)sb.substring(0));
        }
        pp.resid = resid;
        return resid;
    }

    public static int read_ttime(ISCSol sp, ISCPha pp, EC_COEF[] ec, TT_TABLE[] tt_tables, short[][] topo, int iszderiv, int isfirst) {
        int pind = 0;
        boolean isdepthphase = false;
        boolean rstt_phase = false;
        double ttim = 0.0;
        doubleW dtdd = new doubleW(0.0);
        doubleW dtdh = new doubleW(0.0);
        doubleW bpdel = new doubleW(0.0);
        double dtdlat = 0.0;
        double dtdlon = 0.0;
        if (sp.depth < 0.0 || sp.depth > Config.max_depth_km || sp.depth == 9999999.0) {
            logger.info((Object)String.format("read_ttime: invalid depth! depth=%.2f phase=%s", sp.depth, pp.phase));
            return 1;
        }
        if (pp.delta < 0.0 || pp.delta > 180.0 || pp.delta == 9999999.0) {
            logger.info((Object)String.format("read_ttime: invalid delta! delta=%.2f phase=%s", pp.delta, pp.phase));
            return 1;
        }
        pind = isfirst == 1 ? (pp.phase.length() > 0 && Character.toUpperCase(pp.phase.charAt(0)) == 'P' ? 0 : (pp.phase.length() > 0 && Character.toUpperCase(pp.phase.charAt(0)) == 'S' ? 1 : -1)) : TravelTimes.get_phase_index(pp.phase);
        if (pind < 0) {
            if (Config.verbose > 1) {
                logger.info((Object)String.format("read_ttime: unknown phase %s!", pp.phase));
            }
            return 1;
        }
        isdepthphase = false;
        if (pp.phase.length() > 0 && (pp.phase.charAt(0) == 'p' || pp.phase.charAt(0) == 's')) {
            isdepthphase = true;
        }
        if ((ttim = TravelTimes.get_tt(tt_tables[pind], sp.depth, pp.delta, iszderiv, dtdd, dtdh, bpdel)) < 0.0 && isfirst == 0 && pp.delta < 23.0) {
            if (Config.streq(pp.phase, "Pg") || Config.streq(pp.phase, "Pb") || Config.streq(pp.phase, "Pn") || Config.streq(pp.phase, "P")) {
                ttim = TravelTimes.get_tt(tt_tables[0], sp.depth, pp.delta, iszderiv, dtdd, dtdh, bpdel);
            }
            if (Config.streq(pp.phase, "Sg") || Config.streq(pp.phase, "Sb") || Config.streq(pp.phase, "Sn") || Config.streq(pp.phase, "S")) {
                ttim = TravelTimes.get_tt(tt_tables[1], sp.depth, pp.delta, iszderiv, dtdd, dtdh, bpdel);
            }
        }
        if (ttim < 0.0) {
            if (Config.verbose > 4) {
                logger.info((Object)String.format("        read_ttime: can't get TT for %s! (depth=%.2f delta=%.2f)", pp.phase, sp.depth, pp.delta));
            }
            return 1;
        }
        pp.ttime = ttim;
        pp.dtdd = dtdd.val;
        if (iszderiv != 0) {
            pp.dtdh = dtdh.val;
        }
        if (isdepthphase) {
            pp.bpdel = bpdel.val;
        }
        TravelTimes.correct_ttime(sp, pp, ec, topo);
        return 0;
    }

    public static int is_rstt(ISCSol sp, ISCPha pp) {
        if (pp.delta > 15.0) {
            return 0;
        }
        if (sp.lat < 0.0 || sp.lon < -20.0 || sp.lon > 150.0 || pp.sta_lat < 0.0 || pp.sta_lon < -20.0 || pp.sta_lon > 150.0) {
            return 0;
        }
        if (!(Config.streq(pp.phase, "Pg") || Config.streq(pp.phase, "Lg") || Config.streq(pp.phase, "Pn") || Config.streq(pp.phase, "Sn") || Config.streq(pp.phase, "Sg") || Config.streq(pp.phase, "Sb") || Config.streq(pp.phase, "Pb"))) {
            return 0;
        }
        if (Config.streq(pp.phase, "Pg") && !pp.firstP) {
            return 0;
        }
        if (Config.streq(pp.phase, "Pb") && !pp.firstP) {
            return 0;
        }
        if ((Config.streq(pp.phase, "Sg") || Config.streq(pp.phase, "Lg")) && !pp.firstS) {
            return 0;
        }
        if (Config.streq(pp.phase, "Sb") && !pp.firstS) {
            return 0;
        }
        return 1;
    }

    private static void correct_ttime(ISCSol sp, ISCPha pp, EC_COEF[] ec, short[][] topo) {
        double geoid_corr = 0.0;
        double elev_corr = 0.0;
        double ellip_corr = 0.0;
        double bounce_corr = 0.0;
        doubleW water_corr = new doubleW(0.0);
        double f = 0.9933056200098735;
        double ecolat = 0.0;
        if (sp.lat != 9999999.0) {
            if (Config.streq(Config.ttime_table, "jb")) {
                geoid_corr = TravelTimes.calc_geoid_corr(sp.lat, pp);
                pp.ttime += geoid_corr;
                if (Config.verbose > 4) {
                    logger.info((Object)String.format("            %-6s geoid_corr=%.3f", pp.sta, geoid_corr));
                }
            } else {
                ecolat = 1.5707963267948966 - Math.atan(f * Math.tan(Math.PI / 180 * sp.lat));
                ellip_corr = EllipticityCorr.get_ellip_corr(ec, pp.phase, ecolat, pp.delta, sp.depth, pp.esaz);
                pp.ttime += ellip_corr;
                if (Config.verbose > 4) {
                    logger.info((Object)String.format("            %-6s ellip_corr=%.3f", pp.sta, ellip_corr));
                }
            }
        }
        elev_corr = TravelTimes.get_elev_corr(pp);
        pp.ttime += elev_corr;
        if (Config.verbose > 4) {
            logger.info((Object)String.format("            %-6s elev_corr=%.3f", pp.sta, elev_corr));
        }
        if (pp.phase.length() > 0 && (pp.phase.charAt(0) == 'p' || pp.phase.charAt(0) == 's')) {
            bounce_corr = TravelTimes.get_bounce_corr(sp, pp, topo, water_corr);
            pp.ttime += bounce_corr;
            if (Config.verbose > 4) {
                logger.info((Object)String.format("            %-8s bounce_corr=%.3f", pp.phase, bounce_corr));
            }
            if (Config.streq(pp.phase, "pwP")) {
                pp.ttime += water_corr.val;
                if (Config.verbose > 4) {
                    logger.info((Object)String.format("            %-8s bounce_corr=%.3f", pp.phase, water_corr.val));
                }
            }
        }
    }

    private static double get_bounce_corr(ISCSol sp, ISCPha pp, short[][] topo, doubleW tcorw) {
        int ips = 0;
        double tcor = 0.0;
        double bp2 = 0.0;
        double bpaz = 0.0;
        doubleW bplat = new doubleW(0.0);
        doubleW bplon = new doubleW(0.0);
        tcorw.val = 0.0;
        bp2 = pp.dtdd;
        bpaz = pp.esaz;
        if (bp2 < 0.0) {
            bpaz += 180.0;
        }
        if (bpaz > 360.0) {
            bpaz -= 360.0;
        }
        Utils.deltaloc(sp.lat, sp.lon, pp.bpdel, bpaz, bplat, bplon);
        ips = pp.phase.startsWith("pP") ? 1 : (pp.phase.startsWith("pwP") ? 1 : (pp.phase.startsWith("pS") ? 2 : (pp.phase.startsWith("sP") ? 2 : (pp.phase.startsWith("sS") ? 3 : 4))));
        tcor = TravelTimes.topcor(ips, bp2, bplat.val, bplon.val, topo, tcorw);
        return tcor;
    }

    public static double topcor(int ips, double rayp, double bplat, double bplon, short[][] topo, doubleW tcorw) {
        double watervel = 1.5;
        double delr = 0.0;
        double term = 0.0;
        double term1 = 0.0;
        double term2 = 0.0;
        double elev = 0.0;
        double bp2 = 0.0;
        double tcorc = 0.0;
        tcorw.val = 0.0;
        elev = TravelTimes.find_etopo1(bplat, bplon, topo);
        delr = 0.001 * elev;
        if (Math.abs(delr) < 1.0E-8) {
            return tcorc;
        }
        bp2 = Math.abs(rayp) * 57.29577951308232 / 6371.0;
        if (ips == 1) {
            term = Config.psurfvel * Config.psurfvel * bp2 * bp2;
            if (term > 1.0) {
                term = 1.0;
            }
            tcorc = 2.0 * delr * Utils.Sqrt(1.0 - term) / Config.psurfvel;
            if (delr < -1.5) {
                term = 2.25 * bp2 * bp2;
                if (term > 1.0) {
                    term = 1.0;
                }
                tcorw.val = -2.0 * delr * Utils.Sqrt(1.0 - term) / 1.5;
            }
        } else if (ips == 2) {
            term1 = Config.psurfvel * Config.psurfvel * bp2 * bp2;
            if (term1 > 1.0) {
                term1 = 1.0;
            }
            if ((term2 = Config.ssurfvel * Config.ssurfvel * bp2 * bp2) > 1.0) {
                term2 = 1.0;
            }
            tcorc = delr * (Utils.Sqrt(1.0 - term1) / Config.psurfvel + Utils.Sqrt(1.0 - term2) / Config.ssurfvel);
        } else if (ips == 3) {
            term = Config.ssurfvel * Config.ssurfvel * bp2 * bp2;
            if (term > 1.0) {
                term = 1.0;
            }
            tcorc = 2.0 * delr * Utils.Sqrt(1.0 - term) / Config.ssurfvel;
        } else {
            tcorc = 0.0;
        }
        return tcorc;
    }

    private static double get_elev_corr(ISCPha pp) {
        double elev_corr = 0.0;
        double surfvel = 0.0;
        int lastlag = 0;
        if (pp.sta_elev == 9999999.0) {
            return 0.0;
        }
        lastlag = TravelTimes.last_lag(pp.phase);
        if (lastlag == 1) {
            surfvel = Config.psurfvel;
        } else if (lastlag == 2) {
            surfvel = Config.ssurfvel;
        } else {
            return 0.0;
        }
        elev_corr = surfvel * (pp.dtdd / 111.19492664455873);
        elev_corr *= elev_corr;
        if (elev_corr > 1.0) {
            elev_corr = 1.0 / elev_corr;
        }
        elev_corr = Utils.Sqrt(1.0 - elev_corr);
        return elev_corr *= pp.sta_elev / (1000.0 * surfvel);
    }

    private static int last_lag(String phase) {
        int lastlag = 0;
        int n = phase.length();
        if (n == 0) {
            return lastlag;
        }
        int i = n - 1;
        while (i > -1) {
            if (Character.isUpperCase(phase.charAt(i))) {
                if (phase.charAt(i) == 'P') {
                    lastlag = 1;
                    break;
                }
                if (phase.charAt(i) == 'S') {
                    lastlag = 2;
                    break;
                }
            }
            --i;
        }
        return lastlag;
    }

    private static double calc_geoid_corr(double lat, ISCPha pp) {
        double epi_hams = 0.0;
        double sta_hams = 0.0;
        double elcor = 0.0;
        double geoid_corr = 0.0;
        epi_hams = TravelTimes.height_above_mean_sphere(lat * (Math.PI / 180));
        sta_hams = TravelTimes.height_above_mean_sphere(pp.sta_lat * (Math.PI / 180));
        if (Config.streq(pp.phase, "PKP")) {
            elcor = pp.delta < 140.0 ? 0.1 : 0.094;
        } else {
            int i = 0;
            while ((int)(pp.delta + 0.5) > delta_step[i]) {
                ++i;
            }
            elcor = 0.01 * (double)i;
        }
        geoid_corr = elcor * (epi_hams + sta_hams);
        return geoid_corr;
    }

    private static double height_above_mean_sphere(double lat) {
        return 10.738 * Math.cos(2.0 * lat) - 3.549 - 0.023 * Math.cos(4.0 * lat);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class timeres_thr
    implements Callable<Double> {
        final ISCPha pp;
        final int all;
        final ISCSol sp;
        final EC_COEF[] ec;
        final TT_TABLE[] tt_tables;
        final short[][] topo;
        final int iszderiv;

        public timeres_thr(ISCPha pp, int all, ISCSol sp, EC_COEF[] ec, TT_TABLE[] tt_tables, short[][] topo, int iszderiv) {
            this.pp = pp;
            this.all = all;
            this.sp = sp;
            this.ec = ec;
            this.tt_tables = tt_tables;
            this.topo = topo;
            this.iszderiv = iszderiv;
        }

        @Override
        public Double call() {
            return TravelTimes.timeres(this.pp, this.all, this.sp, this.ec, this.tt_tables, this.topo, this.iszderiv);
        }
    }
}

