/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.iscloc2;

import cn.org.gddsn.seis.location.iscloc2.Config;
import cn.org.gddsn.seis.location.iscloc2.GeoRegion;
import cn.org.gddsn.seis.location.iscloc2.ISCEvent;
import cn.org.gddsn.seis.location.iscloc2.ISCHyp;
import cn.org.gddsn.seis.location.iscloc2.ISCPha;
import cn.org.gddsn.seis.location.iscloc2.ISCSol;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.netlib.util.doubleW;

public class Utils {
    static Logger logger = Logger.getLogger(Utils.class);
    static double celat = 0.0;
    static double selat = 0.0;
    public static double t0;

    static double Sqrt(double d) {
        return d > 0.0 ? Math.sqrt(d) : 0.0;
    }

    static void swap(ISCPha[] x, int a, int b) {
        ISCPha t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    static void swap(ISCHyp[] x, int a, int b) {
        ISCHyp t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    static void swap(double[] x, int a, int b) {
        double t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    static void swap(int[] x, int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    public static void calc_delaz(ISCSol sp, ISCPha[] p, boolean verbosethistime) {
        double delta = 0.0;
        doubleW esaz = new doubleW(0.0);
        doubleW seaz = new doubleW(0.0);
        int i = 0;
        while (i < sp.numphas) {
            p[i].delta = delta = Utils.distaz(p[i].sta_lat, p[i].sta_lon, sp.lat, sp.lon, seaz, esaz, 1);
            p[i].esaz = esaz.val;
            p[i].seaz = seaz.val;
            ++i;
        }
        if (Config.verbose > 2 && verbosethistime) {
            Utils.print_pha(sp.numphas, p);
        }
    }

    public static double distaz(double slat, double slon, double elat, double elon, doubleW azi, doubleW baz, int isnew) {
        double cslat = 0.0;
        double sslat = 0.0;
        double cdlon = 0.0;
        double sdlon = 0.0;
        double rdlon = 0.0;
        double geoc_slat = 0.0;
        double geoc_elat = 0.0;
        double xazi = 0.0;
        double xbaz = 0.0;
        double yazi = 0.0;
        double ybaz = 0.0;
        double delta = 0.0;
        double cdel = 0.0;
        double f = 0.9933056200098735;
        if (isnew != 0) {
            geoc_elat = Math.atan(f * Math.tan(Math.PI / 180 * elat));
            celat = Math.cos(geoc_elat);
            selat = Math.sin(geoc_elat);
        }
        if (Math.abs(slat - elat) < 1.0E-8 && Math.abs(slon - elon) < 1.0E-8) {
            delta = 0.0;
            azi.val = 0.0;
            baz.val = 180.0;
            return delta;
        }
        geoc_slat = Math.atan(f * Math.tan(Math.PI / 180 * slat));
        rdlon = Math.PI / 180 * (elon - slon);
        cslat = Math.cos(geoc_slat);
        sslat = Math.sin(geoc_slat);
        cdlon = Math.cos(rdlon);
        sdlon = Math.sin(rdlon);
        cdel = sslat * selat + cslat * celat * cdlon;
        cdel = cdel < 1.0 ? cdel : 1.0;
        cdel = cdel > -1.0 ? cdel : -1.0;
        delta = 57.29577951308232 * Math.acos(cdel);
        yazi = sdlon * celat;
        xazi = cslat * selat - sslat * celat * cdlon;
        ybaz = -sdlon * cslat;
        xbaz = celat * sslat - selat * cslat * cdlon;
        azi.val = 57.29577951308232 * Math.atan2(yazi, xazi);
        baz.val = 57.29577951308232 * Math.atan2(ybaz, xbaz);
        if (azi.val < 0.0) {
            azi.val += 360.0;
        }
        if (baz.val < 0.0) {
            baz.val += 360.0;
        }
        return delta;
    }

    public static void deltaloc(double lat1, double lon1, double delta, double azim, doubleW lat2, doubleW lon2) {
        double a = 0.0;
        double b = 0.0;
        double c = 0.0;
        double sinlat = 0.0;
        double coslat = 0.0;
        double dlon = 0.0;
        double geoc_co_lat = 0.0;
        double r13 = 0.0;
        double r13sq = 0.0;
        double x1 = 0.0;
        double x2 = 0.0;
        double x3 = 0.0;
        double dist = 0.0;
        double azi = 0.0;
        double f = 0.9933056200098735;
        dist = Math.PI / 180 * (90.0 - delta);
        azi = Math.PI / 180 * (180.0 - azim);
        r13 = Math.cos(dist);
        x1 = r13 * Math.sin(azi);
        x2 = Math.sin(dist);
        x3 = r13 * Math.cos(azi);
        geoc_co_lat = 1.5707963267948966 - Math.atan(f * Math.tan(Math.PI / 180 * lat1));
        sinlat = Math.sin(geoc_co_lat);
        coslat = Math.cos(geoc_co_lat);
        b = x2;
        c = x3;
        x2 = b * coslat - c * sinlat;
        x3 = b * sinlat + c * coslat;
        r13sq = x3 * x3 + x1 * x1;
        r13 = Math.sqrt(r13sq);
        dlon = 57.29577951308232 * Math.atan2(x1, x3);
        a = Math.atan2(x2, r13);
        lat2.val = 57.29577951308232 * Math.atan(Math.tan(a) / f);
        lon2.val = lon1 + dlon;
        if (Math.abs(lat2.val) > 90.0) {
            a = 180.0 - Math.abs(lat2.val);
            double d = lat2.val = lat2.val >= 0.0 ? -a : a;
        }
        if (Math.abs(lon2.val) > 180.0) {
            a = 360.0 - Math.abs(lon2.val);
            lon2.val = lon2.val >= 0.0 ? -a : a;
        }
    }

    public static double epoch_time(int yyyy, int mm, int dd, int hh, int mi, int ss, int msec) {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.set(yyyy, mm - 1, dd, hh, mi, ss);
        double t = (double)(cal.getTime().getTime() / 1000L) + (double)msec / 1000.0;
        return t;
    }

    public static String human_time(double etime) {
        String s = String.format("%.3f", etime);
        double et0 = Double.parseDouble(s);
        Date d = new Date((long)(et0 * 1000.0));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(d);
    }

    public static String human_time(double etime, int[] ymdhms) {
        String s = String.format("%.3f", etime);
        double et0 = Double.parseDouble(s);
        Date d = new Date((long)(et0 * 1000.0));
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.setTime(d);
        ymdhms[0] = cal.get(1);
        ymdhms[1] = cal.get(2) + 1;
        ymdhms[2] = cal.get(5);
        ymdhms[3] = cal.get(11);
        ymdhms[4] = cal.get(12);
        ymdhms[5] = cal.get(13);
        ymdhms[6] = cal.get(14);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return sdf.format(d);
    }

    public static double secs(double t0) {
        return (double)System.currentTimeMillis() / 1000.0 - t0;
    }

    public static double read_time(String timestr) {
        Date d;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            d = sdf.parse(timestr);
        }
        catch (ParseException e) {
            return 0.0;
        }
        return (double)d.getTime() / 1000.0;
    }

    public static String print_sol(ISCSol sp, int grn) {
        StringBuffer rsb = new StringBuffer(2048);
        StringBuffer sb = new StringBuffer(128);
        if (grn != 0) {
            String gregname = GeoRegion.gregion(grn);
            sb.append(String.format("final : %s", gregname));
            rsb.append(sb);
            rsb.append("\n");
            logger.info((Object)sb.substring(0));
            sb = new StringBuffer(128);
        }
        String timestr = Utils.human_time(sp.time);
        sb.append(String.format("    OT = %s ", timestr));
        if (sp.error[0] != 9999999.0) {
            sb.append(String.format("+/- %.3f[s] ", sp.error[0]));
        }
        if (sp.error[1] != 9999999.0) {
            sb.append(String.format("Lat = %.3f +/- %.3f[deg] ", sp.lat, sp.error[1]));
        } else {
            sb.append(String.format("Lat = %.3f ", sp.lat));
        }
        if (sp.error[2] != 9999999.0) {
            sb.append(String.format("Lon = %.3f +/- %.3f[deg] ", sp.lon, sp.error[2]));
        } else {
            sb.append(String.format("Lon = %.3f ", sp.lon));
        }
        if (sp.error[3] != 9999999.0) {
            sb.append(String.format("Depth = %.1f +/- %.1f[km]", sp.depth, sp.error[3]));
        } else {
            sb.append(String.format("Depth = %.1f", sp.depth));
        }
        rsb.append(sb);
        rsb.append("\n");
        logger.info((Object)sb.substring(0));
        return rsb.substring(0);
    }

    public static String print_hyp(ISCEvent ep, ISCHyp[] h) {
        StringBuffer rsb = new StringBuffer(2048);
        StringBuffer sb = new StringBuffer(128);
        sb.append(String.format("numhyps=%d numphas=%d", ep.numhyps, ep.numphas));
        rsb.append(sb);
        rsb.append("\n");
        logger.info((Object)sb.substring(0));
        sb = new StringBuffer(128);
        sb.append(String.format("hypid     agency   time                     lat", new Object[0]));
        sb.append(String.format("     lon     depth  nsta sdef ndef nass gap  mindist ", new Object[0]));
        sb.append(String.format("stime sdep  smaj  score", new Object[0]));
        rsb.append(sb);
        rsb.append("\n");
        logger.info((Object)sb.substring(0));
        sb = new StringBuffer(128);
        int i = 0;
        while (i < ep.numhyps) {
            String timestr = Utils.human_time(h[i].time);
            sb.append(String.format("%9d ", h[i].hypid));
            sb.append(String.format("%-8s %s ", h[i].agency, timestr));
            sb.append(String.format("%7.3f %8.3f ", h[i].lat, h[i].lon));
            if (h[i].depth != 9999999.0) {
                sb.append(String.format("%5.1f  ", h[i].depth));
            } else {
                sb.append(String.format("%5s  ", ""));
            }
            if (h[i].nsta != 9999999) {
                sb.append(String.format("%4d ", h[i].nsta));
            } else {
                sb.append(String.format("%4s ", ""));
            }
            if (h[i].ndefsta != 9999999) {
                sb.append(String.format("%4d ", h[i].ndefsta));
            } else {
                sb.append(String.format("%4s ", ""));
            }
            if (h[i].ndef != 9999999) {
                sb.append(String.format("%4d ", h[i].ndef));
            } else {
                sb.append(String.format("%4s ", ""));
            }
            if (h[i].nass != 9999999) {
                sb.append(String.format("%4d ", h[i].nass));
            } else {
                sb.append(String.format("%4s ", ""));
            }
            if (h[i].azimgap != 9999999.0) {
                sb.append(String.format("%5.1f ", h[i].azimgap));
            } else {
                sb.append(String.format("%5s ", ""));
            }
            if (h[i].mindist != 9999999.0) {
                sb.append(String.format("%6.2f ", h[i].mindist));
            } else {
                sb.append(String.format("%6s ", ""));
            }
            if (h[i].stime != 9999999.0) {
                sb.append(String.format("%5.2f ", h[i].stime));
            } else {
                sb.append(String.format("%5s ", ""));
            }
            if (h[i].sdepth != 9999999.0) {
                sb.append(String.format("%5.2f ", h[i].sdepth));
            } else {
                sb.append(String.format("%5s ", ""));
            }
            if (h[i].smajax != 9999999.0) {
                sb.append(String.format("%5.1f ", h[i].smajax));
            } else {
                sb.append(String.format("%5s ", ""));
            }
            sb.append(String.format("%5d", h[i].rank));
            rsb.append(sb);
            rsb.append("\n");
            logger.info((Object)sb.substring(0));
            sb = new StringBuffer(128);
            ++i;
        }
        return rsb.substring(0);
    }

    public static String print_pha(int numphas, ISCPha[] p) {
        StringBuffer rsb = new StringBuffer(2048);
        StringBuffer sb = new StringBuffer(128);
        sb.append(String.format("    RDID   STA        REP      ISC      I TIME", new Object[0]));
        sb.append(String.format("                     DELTA   ESAZ  DELTIM T", new Object[0]));
        sb.append(String.format("    RESID       AMP  PER M", new Object[0]));
        rsb.append(sb);
        rsb.append("\n");
        logger.info((Object)sb.substring(0));
        sb = new StringBuffer(128);
        int i = 0;
        while (i < numphas) {
            if (p[i].purged == 0) {
                sb.append(String.format("    %-6d ", p[i].rdid));
                sb.append(String.format("%-8s ", p[i].sta));
                if (p[i].comp != '\u0000') {
                    sb.append(String.format("%c ", Character.valueOf(p[i].comp)));
                } else {
                    sb.append(String.format("  ", new Object[0]));
                }
                sb.append(String.format("%-8s ", p[i].rep_phase));
                sb.append(String.format("%-8s ", p[i].phase));
                sb.append(String.format("%d ", p[i].init));
                if (p[i].time != 9999999.0) {
                    String timestr = Utils.human_time(p[i].time);
                    sb.append(String.format("%s ", timestr));
                } else {
                    sb.append(String.format("%23s ", ""));
                }
                sb.append(String.format("%6.2f ", p[i].delta));
                sb.append(String.format("%6.2f ", p[i].esaz));
                if (p[i].phase_fixed) {
                    sb.append(String.format("F ", new Object[0]));
                } else {
                    sb.append(String.format("  ", new Object[0]));
                }
                if (p[i].measerr != 9999999.0) {
                    sb.append(String.format("%5.2f ", p[i].measerr));
                } else {
                    sb.append(String.format("%5s ", ""));
                }
                sb.append(String.format("%d ", p[i].timedef ? 1 : 0));
                if (p[i].resid != 9999999.0) {
                    sb.append(String.format("%8.3f ", p[i].resid));
                } else {
                    sb.append(String.format("%8s ", ""));
                }
                if (p[i].numamps > 0) {
                    if (p[i].a[0].amp != 9999999.0) {
                        sb.append(String.format("%9.1f ", p[i].a[0].amp));
                    } else {
                        sb.append(String.format("%9s ", ""));
                    }
                    if (p[i].a[0].per != 9999999.0) {
                        sb.append(String.format("%4.1f ", p[i].a[0].per));
                    } else {
                        sb.append(String.format("%4s ", ""));
                    }
                    sb.append(String.format("%d ", p[i].a[0].ampdef));
                }
                rsb.append(sb);
                rsb.append("\n");
                logger.info((Object)sb.substring(0));
                sb = new StringBuffer(128);
            }
            ++i;
        }
        return rsb.substring(0);
    }

    public static String print_defining_pha(int numphas, ISCPha[] p) {
        StringBuffer rsb = new StringBuffer(2048);
        StringBuffer sb = new StringBuffer(128);
        sb.append(String.format("    RDID      STA    PHASE    TIME                  ", new Object[0]));
        sb.append(String.format("   DELTA   ESAZ DELTIM  RESID", new Object[0]));
        rsb.append(sb);
        rsb.append("\n");
        logger.info((Object)sb.substring(0));
        sb = new StringBuffer(128);
        int i = 0;
        while (i < numphas) {
            if (p[i].timedef) {
                String timestr = Utils.human_time(p[i].time);
                sb.append(String.format("    %-6d ", p[i].rdid));
                sb.append(String.format("%-8s ", p[i].sta));
                sb.append(String.format("%-8s ", p[i].phase));
                sb.append(String.format("%s ", timestr));
                sb.append(String.format("%6.2f ", p[i].delta));
                sb.append(String.format("%6.2f ", p[i].esaz));
                sb.append(String.format("%5.2f ", p[i].measerr));
                sb.append(String.format("%9.4f", p[i].resid));
                rsb.append(sb);
                rsb.append("\n");
                logger.info((Object)sb.substring(0));
                sb = new StringBuffer(128);
            }
            ++i;
        }
        return rsb.substring(0);
    }

    public static void sort_phaserec_db(int numphas, ISCPha[] p) {
        int j;
        int i = 1;
        while (i < numphas) {
            j = i - 1;
            while (j > -1) {
                if (p[j].time > p[j + 1].time && p[j + 1].time != 9999999.0 || p[j].time == 9999999.0) {
                    Utils.swap(p, j, j + 1);
                }
                --j;
            }
            ++i;
        }
        i = 1;
        while (i < numphas) {
            j = i - 1;
            while (j > -1) {
                if (p[j].rdid > p[j + 1].rdid) {
                    Utils.swap(p, j, j + 1);
                }
                --j;
            }
            ++i;
        }
        i = 1;
        while (i < numphas) {
            j = i - 1;
            while (j > -1) {
                if (p[j].prista.compareTo(p[j + 1].prista) > 0) {
                    Utils.swap(p, j, j + 1);
                }
                --j;
            }
            ++i;
        }
        i = 1;
        while (i < numphas) {
            j = i - 1;
            while (j > -1) {
                if (p[j].delta > p[j + 1].delta) {
                    Utils.swap(p, j, j + 1);
                }
                --j;
            }
            ++i;
        }
    }
}

