/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.locsat;

import cn.org.gddsn.seis.evtformat.Location;
import cn.org.gddsn.seis.evtformat.TimeSeries;
import cn.org.gddsn.seis.location.StationMapping;
import java.util.Formatter;

public class Station {
    private String stationCode;
    private float lat;
    private float lon;
    private float elev;
    private int from = 0;

    public void parse(TimeSeries ts, StationMapping smap) {
        this.stationCode = smap == null || smap.getStation(ts.getNetworkCode(), ts.getStationCode()) == null ? ts.getStationCode() : smap.getStation(ts.getNetworkCode(), ts.getStationCode());
        Location sl = ts.getStationLocation();
        sl.getLatitude();
        this.lat = (float)sl.getLatitude();
        this.lon = (float)sl.getLongtitude();
        this.elev = (float)sl.getAltitude();
    }

    public void parse(String buf) {
        this.from = 0;
        this.stationCode = this.getNextField(buf, 6).trim();
        this.getNextField(buf, 1);
        this.lat = Float.parseFloat(this.getNextField(buf, 8).trim());
        this.getNextField(buf, 1);
        this.lon = Float.parseFloat(this.getNextField(buf, 9).trim());
        this.getNextField(buf, 1);
        this.elev = Float.parseFloat(this.getNextField(buf, 6).trim());
    }

    public String format() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        fmt.format("%1$6s %2$8.4f %3$9.4f %4$6.1f", this.stationCode, Float.valueOf(this.lat), Float.valueOf(this.lon), Float.valueOf(this.elev));
        return sb.substring(0);
    }

    private String getNextField(String buf, int width) {
        if (width == -1) {
            return buf.substring(this.from);
        }
        String field = buf.substring(this.from, this.from + width);
        this.from += width;
        return field;
    }

    public String getStationCode() {
        return this.stationCode;
    }

    public void setStationCode(String stationCode) {
        this.stationCode = stationCode;
    }

    public float getElev() {
        return this.elev;
    }

    public void setElev(float elev) {
        this.elev = elev;
    }

    public void setLat(float lat) {
        this.lat = lat;
    }

    public void setLon(float lon) {
        this.lon = lon;
    }

    public float getLat() {
        return this.lat;
    }

    public float getLon() {
        return this.lon;
    }
}

