/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.locsat.libgeo;

import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class GeoUtil {
    public static final double RAD_TO_DEG = 57.2957795;
    public static final double DEG_TO_RAD = 0.0174532925239284;

    private static double SIGN(double a1, double a2) {
        return a2 >= 0.0 ? -a1 : a1;
    }

    public static void azcros2(double alat1, double alon1, double aza, double alat2, double alon2, double azb, doubleW dista, doubleW distb, doubleW alat, doubleW alon, intW ierr) {
        doubleW delta = new doubleW(0.0);
        doubleW azi = new doubleW(0.0);
        doubleW baz = new doubleW(0.0);
        doubleW dist = new doubleW(0.0);
        doubleW az = new doubleW(0.0);
        doubleW alatin = new doubleW(0.0);
        doubleW alonin = new doubleW(0.0);
        GeoUtil.distaz2(alat1, alon1, alat2, alon2, delta, azi, baz);
        double fa = aza - azi.val;
        double fb = azb - baz.val;
        double ra = fa;
        double rb = fb;
        if (Math.abs(ra) > 180.0) {
            ra = GeoUtil.SIGN(360.0 - Math.abs(ra), ra);
        }
        if (Math.abs(rb) > 180.0) {
            rb = GeoUtil.SIGN(360.0 - Math.abs(rb), rb);
        }
        if (GeoUtil.SIGN(1.0, ra) == GeoUtil.SIGN(1.0, rb)) {
            ierr.val = 1;
            return;
        }
        if ((ra = Math.abs(ra)) + (rb = Math.abs(rb)) > 180.0) {
            ierr.val = 1;
            return;
        }
        double rc = delta.val * 0.0174532925239284;
        double c1 = Math.tan(0.5 * rc);
        double c2 = 0.5 * ((ra *= 0.0174532925239284) - (rb *= 0.0174532925239284));
        double c3 = 0.5 * (ra + rb);
        double f = c1 * Math.sin(c2);
        double g = Math.sin(c3);
        double h = c1 * Math.cos(c2);
        double e = Math.cos(c3);
        double c4 = Math.atan(f / g);
        double c5 = Math.atan(h / e);
        distb.val = (c4 + c5) * 57.2957795;
        dista.val = (c5 - c4) * 57.2957795;
        if (dista.val < 0.0 || distb.val < 0.0) {
            ierr.val = 1;
            return;
        }
        if (dista.val < distb.val) {
            dist.val = dista.val;
            az.val = aza;
            alatin.val = alat1;
            alonin.val = alon1;
        } else {
            dist.val = distb.val;
            az.val = azb;
            alatin.val = alat2;
            alonin.val = alon2;
        }
        GeoUtil.latlon2(alatin.val, alonin.val, dist.val, az.val, alat, alon);
        ierr.val = 0;
    }

    public static void crossings(doubleW olat1, doubleW olon1, doubleW olat2, doubleW olon2, doubleW rsmall, doubleW rlarge, doubleW xlat1, doubleW xlon1, doubleW xlat2, doubleW xlon2, intW icerr) {
        double arg;
        doubleW azi = new doubleW(0.0);
        doubleW baz = new doubleW(0.0);
        doubleW stadist = new doubleW(0.0);
        icerr.val = 0;
        if (rsmall.val > rlarge.val) {
            double tmp = rlarge.val;
            rlarge.val = rsmall.val;
            rsmall.val = tmp;
            tmp = olat1.val;
            olat1.val = olat2.val;
            olat2.val = tmp;
            tmp = olon1.val;
            olon1.val = olon2.val;
            olon2.val = tmp;
        }
        GeoUtil.distaz2(olat1.val, olon1.val, olat2.val, olon2.val, stadist, azi, baz);
        if (Math.abs(rsmall.val - stadist.val) > rlarge.val || rsmall.val + stadist.val < rlarge.val) {
            icerr.val = 1;
            return;
        }
        double s = (rsmall.val + rlarge.val + stadist.val) / 2.0;
        if ((arg = Math.sin((s *= 0.0174532925239284) - 0.0174532925239284 * stadist.val) * Math.sin(s - 0.0174532925239284 * rlarge.val) / (Math.sin(s) * Math.sin(s - 0.0174532925239284 * rsmall.val))) < 0.0) {
            icerr.val = 1;
            return;
        }
        double alpha = 2.0 * Math.atan(Math.sqrt(arg));
        azi.val = baz.val + (alpha /= 0.0174532925239284);
        if (Math.abs(azi.val) > 180.0) {
            azi.val = GeoUtil.SIGN(360.0 - Math.abs(azi.val), azi.val);
        }
        GeoUtil.latlon2(olat2.val, olon2.val, rlarge.val, azi.val, xlat1, xlon1);
        azi.val -= 2.0 * alpha;
        if (Math.abs(azi.val) > 180.0) {
            azi.val = GeoUtil.SIGN(360.0 - Math.abs(azi.val), azi.val);
        }
        GeoUtil.latlon2(olat2.val, olon2.val, rlarge.val, azi.val, xlat2, xlon2);
    }

    public static void distaz2(double alat1, double alon1, double alat2, double alon2, doubleW delta, doubleW azi, doubleW baz) {
        double esq = 0.9933054581454123;
        double alat3 = Math.atan(Math.tan(alat1 * 0.0174532925239284) * esq) * 57.2957795;
        double alat4 = Math.atan(Math.tan(alat2 * 0.0174532925239284) * esq) * 57.2957795;
        if (alat1 == alat2 && alon1 == alon2) {
            delta.val = 0.0;
            azi.val = 0.0;
            baz.val = 180.0;
            return;
        }
        double rlat1 = 0.0174532925239284 * alat3;
        double rlat2 = 0.0174532925239284 * alat4;
        double rdlon = 0.0174532925239284 * (alon2 - alon1);
        double clat1 = Math.cos(rlat1);
        double clat2 = Math.cos(rlat2);
        double slat1 = Math.sin(rlat1);
        double slat2 = Math.sin(rlat2);
        double cdlon = Math.cos(rdlon);
        double sdlon = Math.sin(rdlon);
        double cdel = slat1 * slat2 + clat1 * clat2 * cdlon;
        cdel = cdel < 1.0 ? cdel : 1.0;
        cdel = cdel > -1.0 ? cdel : -1.0;
        double yazi = sdlon * clat2;
        double xazi = clat1 * slat2 - slat1 * clat2 * cdlon;
        double ybaz = -sdlon * clat1;
        double xbaz = clat2 * slat1 - slat2 * clat1 * cdlon;
        delta.val = 57.2957795 * Math.acos(cdel);
        azi.val = 57.2957795 * Math.atan2(yazi, xazi);
        baz.val = 57.2957795 * Math.atan2(ybaz, xbaz);
        if (azi.val < 0.0) {
            azi.val += 360.0;
        }
        if (baz.val < 0.0) {
            baz.val += 360.0;
        }
    }

    public static void latlon2(double alat1, double alon1, double delta, double azi, doubleW alat2, doubleW alon2) {
        double esq = 0.9933054581454123;
        double alat3 = Math.atan(Math.tan(alat1 * 0.0174532925239284) * esq) * 57.2957795;
        double alat = 90.0 - delta;
        double alon = 180.0 - azi;
        double r13 = Math.cos(0.0174532925239284 * alat);
        double x1 = r13 * Math.sin(0.0174532925239284 * alon);
        double x2 = Math.sin(0.0174532925239284 * alat);
        double x3 = r13 * Math.cos(0.0174532925239284 * alon);
        double alatr = (90.0 - alat3) / 57.2957795;
        double sinlat = Math.sin(alatr);
        double coslat = Math.cos(alatr);
        double b = x2;
        double c = x3;
        x2 = b * coslat - c * sinlat;
        x3 = b * sinlat + c * coslat;
        double r13sq = x3 * x3 + x1 * x1;
        r13 = Math.sqrt(r13sq);
        double dlon = 57.2957795 * Math.atan2(x1, x3);
        alat3 = Math.atan2(x2, r13);
        alat2.val = 57.2957795 * Math.atan(Math.tan(alat3) / esq);
        alon2.val = alon1 + dlon;
        if (Math.abs(alon2.val) > 180.0) {
            alon2.val = GeoUtil.SIGN(360.0 - Math.abs(alon2.val), alon2.val);
        }
    }
}

