/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.nlloc;

public class GeoUtil {
    public static final double PI = 3.14159265359;
    public static final double TWOPI = 6.28318530718;
    public static final double DE2RA = 0.01745329252;
    public static final double RA2DE = 57.2957795129;
    public static final double ERAD = 6378.135;
    public static final double ERADM = 6378135.0;
    public static final double AVG_ERAD = 6371.0;
    public static final double FLATTENING = 0.003352779454167505;
    public static final double EPS = 5.0E-12;
    public static final double KM2MI = 0.621371;
    public static final double KM2DEG = 0.009;
    public static final double DEG2KM = 111.11111111111111;

    private GeoUtil() {
    }

    public double GCDistance(double lat1, double lon1, double lat2, double lon2) {
        if (lat1 == lat2 && lon1 == lon2) {
            return 0.0;
        }
        double d = Math.sin(lat1 *= 0.01745329252) * Math.sin(lat2 *= 0.01745329252) + Math.cos(lat1) * Math.cos(lat2) * Math.cos((lon1 *= 0.01745329252) - (lon2 *= 0.01745329252));
        return 6371.0 * Math.acos(d);
    }

    double GCAzimuth(double lat1, double lon1, double lat2, double lon2) {
        double result = 0.0;
        long ilat1 = (long)(0.5 + lat1 * 360000.0);
        long ilat2 = (long)(0.5 + lat2 * 360000.0);
        long ilon1 = (long)(0.5 + lon1 * 360000.0);
        long ilon2 = (long)(0.5 + lon2 * 360000.0);
        lat1 *= 0.01745329252;
        lon1 *= 0.01745329252;
        lat2 *= 0.01745329252;
        lon2 *= 0.01745329252;
        if (ilat1 == ilat2 && ilon1 == ilon2) {
            return result;
        }
        if (ilat1 == ilat2) {
            result = ilon1 > ilon2 ? 90.0 : 270.0;
        } else if (ilon1 == ilon2) {
            if (ilat1 > ilat2) {
                result = 180.0;
            }
        } else {
            double c = Math.acos(Math.sin(lat2) * Math.sin(lat1) + Math.cos(lat2) * Math.cos(lat1) * Math.cos(lon2 - lon1));
            double A = Math.asin(Math.cos(lat2) * Math.sin(lon2 - lon1) / Math.sin(c));
            result = A * 57.2957795129;
            if (ilat2 <= ilat1 || ilon2 <= ilon1) {
                if (ilat2 < ilat1 && ilon2 < ilon1) {
                    result = 180.0 - result;
                } else if (ilat2 < ilat1 && ilon2 > ilon1) {
                    result = 180.0 - result;
                } else if (ilat2 > ilat1 && ilon2 < ilon1) {
                    result += 360.0;
                }
            }
        }
        return result;
    }

    double ApproxDistance(double lat1, double lon1, double lat2, double lon2) {
        double F = ((lat1 *= 0.01745329252) + (lat2 *= 0.01745329252)) / 2.0;
        double G = (lat1 - lat2) / 2.0;
        double L = ((lon1 *= -0.01745329252) - (lon2 *= -0.01745329252)) / 2.0;
        double sing = Math.sin(G);
        double cosl = Math.cos(L);
        double cosf = Math.cos(F);
        double sinl = Math.sin(L);
        double sinf = Math.sin(F);
        double cosg = Math.cos(G);
        double S = sing * sing * cosl * cosl + cosf * cosf * sinl * sinl;
        double C = cosg * cosg * cosl * cosl + sinf * sinf * sinl * sinl;
        double W = Math.atan2(Math.sqrt(S), Math.sqrt(C));
        double R = Math.sqrt(S * C) / W;
        double H1 = (3.0 * R - 1.0) / (2.0 * C);
        double H2 = (3.0 * R + 1.0) / (2.0 * S);
        double D = 2.0 * W * 6378.135;
        return D * (1.0 + 0.003352779454167505 * H1 * sinf * sinf * cosg * cosg - 0.003352779454167505 * H2 * cosf * cosf * sing * sing);
    }

    double EllipsoidDistance(double lat1, double lon1, double lat2, double lon2) {
        double e;
        double cz;
        double c2a;
        double y;
        double cy;
        double sy;
        double c;
        double d;
        double distance = 0.0;
        double r = 0.9966472205458325;
        distance = 0.0;
        if (lon1 == lon2 && lat1 == lat2) {
            return distance;
        }
        lon1 *= 0.01745329252;
        lon2 *= 0.01745329252;
        double cosy1 = Math.cos(lat1 *= 0.01745329252);
        double cosy2 = Math.cos(lat2 *= 0.01745329252);
        if (cosy1 == 0.0) {
            cosy1 = 1.0E-10;
        }
        if (cosy2 == 0.0) {
            cosy2 = 1.0E-10;
        }
        double tu1 = r * Math.sin(lat1) / cosy1;
        double tu2 = r * Math.sin(lat2) / cosy2;
        double cu1 = 1.0 / Math.sqrt(tu1 * tu1 + 1.0);
        double su1 = cu1 * tu1;
        double cu2 = 1.0 / Math.sqrt(tu2 * tu2 + 1.0);
        double x = lon2 - lon1;
        distance = cu1 * cu2;
        double baz = distance * tu2;
        double faz = baz * tu1;
        do {
            double sx = Math.sin(x);
            double cx = Math.cos(x);
            tu1 = cu2 * sx;
            tu2 = baz - su1 * cu2 * cx;
            sy = Math.sqrt(tu1 * tu1 + tu2 * tu2);
            cy = distance * cx + faz;
            y = Math.atan2(sy, cy);
            double sa = distance * sx / sy;
            c2a = -sa * sa + 1.0;
            cz = faz + faz;
            if (c2a > 0.0) {
                cz = -cz / c2a + cy;
            }
            e = cz * cz * 2.0 - 1.0;
            c = ((-3.0 * c2a + 4.0) * 0.003352779454167505 + 4.0) * c2a * 0.003352779454167505 / 16.0;
            d = x;
            x = ((e * cy * c + cz) * sy * c + y) * sa;
        } while (Math.abs(d - (x = (1.0 - c) * x * 0.003352779454167505 + lon2 - lon1)) > 5.0E-12);
        x = Math.sqrt((1.0 / r / r - 1.0) * c2a + 1.0) + 1.0;
        x = (x - 2.0) / x;
        c = 1.0 - x;
        c = (x * x / 4.0 + 1.0) / c;
        d = (0.375 * x * x - 1.0) * x;
        x = e * cy;
        distance = 1.0 - e - e;
        distance = ((((sy * sy * 4.0 - 3.0) * distance * cz * d / 6.0 - x) * d / 4.0 + cz) * sy * d + y) * c * 6378.135 * r;
        return distance;
    }
}

