/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.nlloc;

public class MapProject {
    private static final double D2R = Math.PI / 180;
    private static final double R2D = 57.29577951308232;
    private static final double SMALL = 1.0E-10;
    private static final int N_ELLIPSOIDS = 13;
    static ELLIPSOID[] ellipse = new ELLIPSOID[]{new ELLIPSOID("WGS-84", 1984, 6378137.0, 6356752.1, 0.0033528469023047466), new ELLIPSOID("GRS-80", 1980, 6378137.0, 6356752.3, 0.0033528131778969143), new ELLIPSOID("WGS-72", 1972, 6378135.0, 6356750.5, 0.003352779454167505), new ELLIPSOID("Australian", 1965, 6378160.0, 6356774.7, 0.003352891869237217), new ELLIPSOID("Krasovsky", 1940, 6378245.0, 6356863.0, 0.003352329869259135), new ELLIPSOID("International", 1924, 6378388.0, 6356911.9, 0.003367003367003367), new ELLIPSOID("Hayford-1909", 1909, 6378388.0, 6356911.9, 0.003367003367003367), new ELLIPSOID("Clarke-1880", 1880, 6378249.1, 6356514.9, 0.0034076194370612693), new ELLIPSOID("Clarke-1866", 1866, 6378206.4, 6356583.8, 0.0033900603430741063), new ELLIPSOID("Airy", 1830, 6377563.4, 6356256.9, 0.0033409060537217695), new ELLIPSOID("Bessel", 1841, 6377397.2, 6356079.0, 0.003342804613070366), new ELLIPSOID("Hayford-1830", 1830, 6377276.3, 6356075.4, 0.003324468085106383), new ELLIPSOID("Sphere", 1980, 6371008.7714, 6371008.7714, 0.0)};
    private static final int NUM_PROJ_MAX = 2;
    private static double[] EQ_RAD = new double[2];
    private static double[] ECC = new double[2];
    private static double[] ECC2 = new double[2];
    private static double[] ECC4 = new double[2];
    private static double[] ECC6 = new double[2];
    private static boolean[] NorthPole = new boolean[2];
    private static double[] CentralMeridian = new double[2];
    private static double[] Pole = new double[2];
    private static double[] LambertConfConic_N = new double[2];
    private static double[] LambertConfConic_F = new double[2];
    private static double[] LambertConfConic_rho0 = new double[2];

    private static double d_log(double x) {
        return x <= 0.0 ? -1.0E10 : Math.log(x);
    }

    private static double d_sqrt(double x) {
        return x < 0.0 ? 0.0 : Math.sqrt(x);
    }

    public static int map_setup_proxy(int n_proj, String ellipsoid_name) {
        int num_ellipsoid = 0;
        while (num_ellipsoid < 13 && !ellipsoid_name.equals(MapProject.ellipse[num_ellipsoid].name)) {
            ++num_ellipsoid;
        }
        if (num_ellipsoid == 13) {
            return -1;
        }
        MapProject.EQ_RAD[n_proj] = MapProject.ellipse[num_ellipsoid].eq_radius;
        double f = MapProject.ellipse[num_ellipsoid].flattening;
        MapProject.ECC2[n_proj] = 2.0 * f - f * f;
        MapProject.ECC4[n_proj] = ECC2[n_proj] * ECC2[n_proj];
        MapProject.ECC6[n_proj] = ECC2[n_proj] * ECC4[n_proj];
        MapProject.ECC[n_proj] = MapProject.d_sqrt(ECC2[n_proj]);
        return 0;
    }

    public static int vlamb(int n_proj, double rlong0, double rlat0, double pha, double phb) {
        MapProject.NorthPole[n_proj] = rlat0 > 0.0;
        MapProject.Pole[n_proj] = NorthPole[n_proj] ? 90.0 : -90.0;
        double t_pha = Math.tan(0.7853981633974483 - 0.5 * (pha *= Math.PI / 180)) / Math.pow((1.0 - ECC[n_proj] * Math.sin(pha)) / (1.0 + ECC[n_proj] * Math.sin(pha)), 0.5 * ECC[n_proj]);
        double m_pha = Math.cos(pha) / MapProject.d_sqrt(1.0 - ECC2[n_proj] * Math.pow(Math.sin(pha), 2.0));
        double t_phb = Math.tan(0.7853981633974483 - 0.5 * (phb *= Math.PI / 180)) / Math.pow((1.0 - ECC[n_proj] * Math.sin(phb)) / (1.0 + ECC[n_proj] * Math.sin(phb)), 0.5 * ECC[n_proj]);
        double m_phb = Math.cos(phb) / MapProject.d_sqrt(1.0 - ECC2[n_proj] * Math.pow(Math.sin(phb), 2.0));
        double t_rlat0 = Math.tan(0.7853981633974483 - 0.5 * rlat0 * (Math.PI / 180)) / Math.pow((1.0 - ECC[n_proj] * Math.sin(rlat0 * (Math.PI / 180))) / (1.0 + ECC[n_proj] * Math.sin(rlat0 * (Math.PI / 180))), 0.5 * ECC[n_proj]);
        MapProject.LambertConfConic_N[n_proj] = pha != phb ? (MapProject.d_log(m_pha) - MapProject.d_log(m_phb)) / (MapProject.d_log(t_pha) - MapProject.d_log(t_phb)) : Math.sin(pha);
        MapProject.LambertConfConic_F[n_proj] = m_pha / (LambertConfConic_N[n_proj] * Math.pow(t_pha, LambertConfConic_N[n_proj]));
        MapProject.CentralMeridian[n_proj] = rlong0;
        MapProject.LambertConfConic_rho0[n_proj] = EQ_RAD[n_proj] * LambertConfConic_F[n_proj] * Math.pow(t_rlat0, LambertConfConic_N[n_proj]);
        return 0;
    }

    public static int lamb(int n_proj, double lon, double lat, double[] x, double[] y) {
        while (lon - CentralMeridian[n_proj] < -180.0) {
            lon += 360.0;
        }
        while (lon - CentralMeridian[n_proj] > 180.0) {
            lon -= 360.0;
        }
        double hold2 = Math.pow((1.0 - ECC[n_proj] * Math.sin(lat *= Math.PI / 180)) / (1.0 + ECC[n_proj] * Math.sin(lat)), 0.5 * ECC[n_proj]);
        double hold3 = Math.tan(0.7853981633974483 - 0.5 * lat);
        if (Math.abs(hold3) < 1.0E-10) {
            hold3 = 0.0;
        }
        double hold1 = hold3 == 0.0 ? 0.0 : Math.pow(hold3 / hold2, LambertConfConic_N[n_proj]);
        double rho = EQ_RAD[n_proj] * LambertConfConic_F[n_proj] * hold1;
        double theta = LambertConfConic_N[n_proj] * (lon - CentralMeridian[n_proj]) * (Math.PI / 180);
        x[0] = rho * Math.sin(theta);
        y[0] = LambertConfConic_rho0[n_proj] - rho * Math.cos(theta);
        return 0;
    }

    public static int ilamb(int n_proj, double[] lon, double[] lat, double x, double y) {
        double phi = 0.0;
        double theta = Math.atan(x / (LambertConfConic_rho0[n_proj] - y));
        lon[0] = theta / LambertConfConic_N[n_proj] * 57.29577951308232 + CentralMeridian[n_proj];
        double temp = x * x + (LambertConfConic_rho0[n_proj] - y) * (LambertConfConic_rho0[n_proj] - y);
        double rho = Math.copySign(MapProject.d_sqrt(temp), LambertConfConic_N[n_proj]);
        double t = Math.pow(rho / (EQ_RAD[n_proj] * LambertConfConic_F[n_proj]), 1.0 / LambertConfConic_N[n_proj]);
        double tphi = 1.5707963267948966 - 2.0 * Math.atan(t);
        double delta = 1.0;
        int i = 0;
        while (i < 100 && delta > 1.0E-8) {
            temp = (1.0 - ECC[n_proj] * Math.sin(tphi)) / (1.0 + ECC[n_proj] * Math.sin(tphi));
            phi = 1.5707963267948966 - 2.0 * Math.atan(t * Math.pow(temp, 0.5 * ECC[n_proj]));
            delta = Math.abs(Math.abs(tphi) - Math.abs(phi));
            tphi = phi;
            ++i;
        }
        lat[0] = phi * 57.29577951308232;
        return 0;
    }

    public static class ELLIPSOID {
        public String name;
        public int date;
        public double eq_radius;
        public double pol_radius;
        public double flattening;

        public ELLIPSOID(String name, int date, double eq_radius, double pol_radius, double flattening) {
            this.name = name;
            this.date = date;
            this.eq_radius = eq_radius;
            this.pol_radius = pol_radius;
            this.flattening = flattening;
        }
    }
}

