/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.nlloc;

public class Nrmatrix {
    private Nrmatrix() {
    }

    private static int nrerror_return(String error_text) {
        System.err.printf("Numerical Recipes run-time error: %s\n", error_text);
        return -1;
    }

    public static float[] vector(int nl, int nh) {
        int nl0 = nl;
        nl0 = 0;
        float[] v = new float[nh - nl0 + 1];
        return v;
    }

    public static int[] ivector(int nl, int nh) {
        int nl0 = nl;
        nl0 = 0;
        int[] v = new int[nh - nl0 + 1];
        return v;
    }

    public static float[][] matrix(int nrl, int nrh, int ncl, int nch) {
        return new float[nrh][nch];
    }

    public static double[][] dmatrix(int nrl, int nrh, int ncl, int nch) {
        return new double[nrh][nch];
    }

    private static void SWAP(float a, float b) {
        float temp = a;
        a = b;
        b = temp;
    }

    private static void DSWAP(double a, double b) {
        double temp = a;
        a = b;
        b = temp;
    }

    public static int gaussj(float[][] a, int n, float[][] b, int m) {
        int l;
        int k;
        int icol = -1;
        int irow = -1;
        int[] indxc = Nrmatrix.ivector(0, n - 1);
        int[] indxr = Nrmatrix.ivector(0, n - 1);
        int[] ipiv = Nrmatrix.ivector(0, n - 1);
        int j = 0;
        while (j < n) {
            ipiv[j] = 0;
            ++j;
        }
        int i = 0;
        while (i < n) {
            float big = 0.0f;
            j = 0;
            while (j < n) {
                if (ipiv[j] != 1) {
                    k = 0;
                    while (k < n) {
                        if (ipiv[k] == 0) {
                            if (Math.abs(a[j][k]) >= big) {
                                big = Math.abs(a[j][k]);
                                irow = j;
                                icol = k;
                            }
                        } else if (ipiv[k] > 1) {
                            return Nrmatrix.nrerror_return("GAUSSJ: Singular Matrix-1");
                        }
                        ++k;
                    }
                }
                ++j;
            }
            int n2 = icol;
            ipiv[n2] = ipiv[n2] + 1;
            if (irow != icol) {
                l = 0;
                while (l < n) {
                    Nrmatrix.SWAP(a[irow][l], a[icol][l]);
                    ++l;
                }
                l = 0;
                while (l < m) {
                    Nrmatrix.SWAP(b[irow][l], b[icol][l]);
                    ++l;
                }
            }
            indxr[i] = irow;
            indxc[i] = icol;
            if ((double)a[icol][icol] == 0.0) {
                return Nrmatrix.nrerror_return("GAUSSJ: Singular Matrix-2");
            }
            float pivinv = 1.0f / a[icol][icol];
            a[icol][icol] = 1.0f;
            l = 0;
            while (l < n) {
                float[] fArray = a[icol];
                int n3 = l++;
                fArray[n3] = fArray[n3] * pivinv;
            }
            l = 0;
            while (l < m) {
                float[] fArray = b[icol];
                int n4 = l++;
                fArray[n4] = fArray[n4] * pivinv;
            }
            int ll = 0;
            while (ll < n) {
                if (ll != icol) {
                    float dum = a[ll][icol];
                    a[ll][icol] = 0.0f;
                    l = 0;
                    while (l < n) {
                        float[] fArray = a[ll];
                        int n5 = l;
                        fArray[n5] = fArray[n5] - a[icol][l] * dum;
                        ++l;
                    }
                    l = 0;
                    while (l < m) {
                        float[] fArray = b[ll];
                        int n6 = l;
                        fArray[n6] = fArray[n6] - b[icol][l] * dum;
                        ++l;
                    }
                }
                ++ll;
            }
            ++i;
        }
        l = n - 1;
        while (l >= 0) {
            if (indxr[l] != indxc[l]) {
                k = 0;
                while (k < n) {
                    Nrmatrix.SWAP(a[k][indxr[l]], a[k][indxc[l]]);
                    ++k;
                }
            }
            --l;
        }
        return 0;
    }

    public static int dgaussj(double[][] a, int n, double[][] b, int m) {
        int l;
        int k;
        int icol = -1;
        int irow = -1;
        int[] indxc = Nrmatrix.ivector(0, n - 1);
        int[] indxr = Nrmatrix.ivector(0, n - 1);
        int[] ipiv = Nrmatrix.ivector(0, n - 1);
        int j = 0;
        while (j < n) {
            ipiv[j] = 0;
            ++j;
        }
        int i = 0;
        while (i < n) {
            double big = 0.0;
            j = 0;
            while (j < n) {
                if (ipiv[j] != 1) {
                    k = 0;
                    while (k < n) {
                        if (ipiv[k] == 0) {
                            if (Math.abs(a[j][k]) >= big) {
                                big = Math.abs(a[j][k]);
                                irow = j;
                                icol = k;
                            }
                        } else if (ipiv[k] > 1) {
                            return Nrmatrix.nrerror_return("GAUSSJ: Singular Matrix-1");
                        }
                        ++k;
                    }
                }
                ++j;
            }
            int n2 = icol;
            ipiv[n2] = ipiv[n2] + 1;
            if (irow != icol) {
                l = 0;
                while (l < n) {
                    Nrmatrix.DSWAP(a[irow][l], a[icol][l]);
                    ++l;
                }
                l = 0;
                while (l < m) {
                    Nrmatrix.DSWAP(b[irow][l], b[icol][l]);
                    ++l;
                }
            }
            indxr[i] = irow;
            indxc[i] = icol;
            if (a[icol][icol] == 0.0) {
                return Nrmatrix.nrerror_return("GAUSSJ: Singular Matrix-2");
            }
            double pivinv = 1.0 / a[icol][icol];
            a[icol][icol] = 1.0;
            l = 0;
            while (l < n) {
                double[] dArray = a[icol];
                int n3 = l++;
                dArray[n3] = dArray[n3] * pivinv;
            }
            l = 0;
            while (l < m) {
                double[] dArray = b[icol];
                int n4 = l++;
                dArray[n4] = dArray[n4] * pivinv;
            }
            int ll = 0;
            while (ll < n) {
                if (ll != icol) {
                    double dum = a[ll][icol];
                    a[ll][icol] = 0.0;
                    l = 0;
                    while (l < n) {
                        double[] dArray = a[ll];
                        int n5 = l;
                        dArray[n5] = dArray[n5] - a[icol][l] * dum;
                        ++l;
                    }
                    l = 0;
                    while (l < m) {
                        double[] dArray = b[ll];
                        int n6 = l;
                        dArray[n6] = dArray[n6] - b[icol][l] * dum;
                        ++l;
                    }
                }
                ++ll;
            }
            ++i;
        }
        l = n - 1;
        while (l >= 0) {
            if (indxr[l] != indxc[l]) {
                k = 0;
                while (k < n) {
                    Nrmatrix.DSWAP(a[k][indxr[l]], a[k][indxc[l]]);
                    ++k;
                }
            }
            --l;
        }
        return 0;
    }

    public static void DisplayMatrix(String name, float[][] matrix, int num_rows, int num_cols) {
        System.out.printf("\n%s Matrix: %d rows X %d columns\n", name, num_rows, num_cols);
        int nrow = 0;
        while (nrow < num_rows) {
            int ncol = 0;
            while (ncol < num_cols) {
                System.out.printf("%.1e ", Float.valueOf(matrix[nrow][ncol]));
                ++ncol;
            }
            System.out.printf("\n", new Object[0]);
            ++nrow;
        }
        System.out.printf("\n", new Object[0]);
    }

    public static void DisplayDMatrix(String name, double[][] matrix, int num_rows, int num_cols) {
        System.out.printf("\n%s Matrix: %d rows X %d columns\n", name, num_rows, num_cols);
        int nrow = 0;
        while (nrow < num_rows) {
            int ncol = 0;
            while (ncol < num_cols) {
                if (ncol == nrow) {
                    System.out.printf("\\ ", new Object[0]);
                }
                System.out.printf("%.1e ", matrix[nrow][ncol]);
                if (ncol == nrow) {
                    System.out.printf("\\ ", new Object[0]);
                }
                ++ncol;
            }
            System.out.printf("\n", new Object[0]);
            ++nrow;
        }
        System.out.printf("\n", new Object[0]);
    }

    private static float PYTHAG(float a, float b) {
        float bt;
        float at = Math.abs(a);
        if (at > (bt = Math.abs(b))) {
            float ct = bt / at;
            return at * (float)Math.sqrt(1.0 + (double)(ct * ct));
        }
        if (bt != 0.0f) {
            float ct = at / bt;
            return bt * (float)Math.sqrt(1.0 + (double)(ct * ct));
        }
        return 0.0f;
    }

    private static float SIGN(float a, float b) {
        return (double)b >= 0.0 ? Math.abs(a) : -Math.abs(a);
    }

    public static int svdcmp0(float[][] a, int m, int n, float[] w, float[][] v) {
        int j;
        float h;
        float f;
        int k;
        float s;
        int l = -1;
        int nm = -1;
        float anorm = 0.0f;
        float g = 0.0f;
        float scale = 0.0f;
        if (m < n) {
            return Nrmatrix.nrerror_return("SVDCMP: You must augment A with extra zero rows");
        }
        float[] rv1 = Nrmatrix.vector(0, n - 1);
        int i = 0;
        while (i < n) {
            l = i + 1;
            rv1[i] = scale * g;
            scale = 0.0f;
            s = 0.0f;
            g = 0.0f;
            if (i < m) {
                k = i;
                while (k < m) {
                    scale += Math.abs(a[k][i]);
                    ++k;
                }
                if (scale != 0.0f) {
                    k = i;
                    while (k < m) {
                        float[] fArray = a[k];
                        int n2 = i;
                        fArray[n2] = fArray[n2] / scale;
                        s += a[k][i] * a[k][i];
                        ++k;
                    }
                    f = a[i][i];
                    g = -Nrmatrix.SIGN((float)Math.sqrt(s), f);
                    h = f * g - s;
                    a[i][i] = f - g;
                    if (i != n - 1) {
                        j = l;
                        while (j < n) {
                            s = 0.0f;
                            k = i;
                            while (k < m) {
                                s += a[k][i] * a[k][j];
                                ++k;
                            }
                            f = s / h;
                            k = i;
                            while (k < m) {
                                float[] fArray = a[k];
                                int n3 = j;
                                fArray[n3] = fArray[n3] + f * a[k][i];
                                ++k;
                            }
                            ++j;
                        }
                    }
                    k = i;
                    while (k < m) {
                        float[] fArray = a[k];
                        int n4 = i;
                        fArray[n4] = fArray[n4] * scale;
                        ++k;
                    }
                }
            }
            w[i] = scale * g;
            scale = 0.0f;
            s = 0.0f;
            g = 0.0f;
            if (i < m && i != n - 1) {
                k = l;
                while (k < n) {
                    scale += Math.abs(a[i][k]);
                    ++k;
                }
                if (scale != 0.0f) {
                    k = l;
                    while (k < n) {
                        float[] fArray = a[i];
                        int n5 = k;
                        fArray[n5] = fArray[n5] / scale;
                        s += a[i][k] * a[i][k];
                        ++k;
                    }
                    f = a[i][l];
                    g = -Nrmatrix.SIGN((float)Math.sqrt(s), f);
                    h = f * g - s;
                    a[i][l] = f - g;
                    k = l;
                    while (k < n) {
                        rv1[k] = a[i][k] / h;
                        ++k;
                    }
                    if (i != m - 1) {
                        j = l;
                        while (j < m) {
                            s = 0.0f;
                            k = l;
                            while (k < n) {
                                s += a[j][k] * a[i][k];
                                ++k;
                            }
                            k = l;
                            while (k < n) {
                                float[] fArray = a[j];
                                int n6 = k;
                                fArray[n6] = fArray[n6] + s * rv1[k];
                                ++k;
                            }
                            ++j;
                        }
                    }
                    k = l;
                    while (k < n) {
                        float[] fArray = a[i];
                        int n7 = k++;
                        fArray[n7] = fArray[n7] * scale;
                    }
                }
            }
            anorm = Math.max(anorm, Math.abs(w[i]) + Math.abs(rv1[i]));
            ++i;
        }
        i = n - 1;
        while (i >= 0) {
            if (i < n - 1) {
                if (g != 0.0f) {
                    j = l;
                    while (j < n) {
                        v[j][i] = a[i][j] / a[i][l] / g;
                        ++j;
                    }
                    j = l;
                    while (j < n) {
                        s = 0.0f;
                        k = l;
                        while (k < n) {
                            s += a[i][k] * v[k][j];
                            ++k;
                        }
                        k = l;
                        while (k < n) {
                            float[] fArray = v[k];
                            int n8 = j;
                            fArray[n8] = fArray[n8] + s * v[k][i];
                            ++k;
                        }
                        ++j;
                    }
                }
                j = l;
                while (j < n) {
                    v[j][i] = 0.0f;
                    v[i][j] = 0.0f;
                    ++j;
                }
            }
            v[i][i] = 1.0f;
            g = rv1[i];
            l = i--;
        }
        i = n - 1;
        while (i >= 0) {
            l = i + 1;
            g = w[i];
            if (i < n - 1) {
                j = l;
                while (j < n) {
                    a[i][j] = 0.0f;
                    ++j;
                }
            }
            if (g != 0.0f) {
                g = 1.0f / g;
                if (i != n - 1) {
                    j = l;
                    while (j < n) {
                        s = 0.0f;
                        k = l;
                        while (k < m) {
                            s += a[k][i] * a[k][j];
                            ++k;
                        }
                        f = s / a[i][i] * g;
                        k = i;
                        while (k < m) {
                            float[] fArray = a[k];
                            int n9 = j;
                            fArray[n9] = fArray[n9] + f * a[k][i];
                            ++k;
                        }
                        ++j;
                    }
                }
                j = i;
                while (j < m) {
                    float[] fArray = a[j];
                    int n10 = i;
                    fArray[n10] = fArray[n10] * g;
                    ++j;
                }
            } else {
                j = i;
                while (j < m) {
                    a[j][i] = 0.0f;
                    ++j;
                }
            }
            float[] fArray = a[i];
            int n11 = i--;
            fArray[n11] = fArray[n11] + 1.0f;
        }
        k = n - 1;
        while (k >= 0) {
            int its = 1;
            while (its <= 30) {
                float z;
                float y;
                float c;
                boolean flag = true;
                l = k;
                while (l >= 0) {
                    nm = l - 1;
                    if (Math.abs(rv1[l]) + anorm == anorm) {
                        flag = false;
                        break;
                    }
                    if (Math.abs(w[nm]) + anorm == anorm) break;
                    --l;
                }
                if (flag) {
                    c = 0.0f;
                    s = 1.0f;
                    i = l;
                    while (i <= k) {
                        f = s * rv1[i];
                        if (Math.abs(f) + anorm != anorm) {
                            g = w[i];
                            w[i] = h = Nrmatrix.PYTHAG(f, g);
                            h = 1.0f / h;
                            c = g * h;
                            s = -f * h;
                            j = 0;
                            while (j < m) {
                                y = a[j][nm];
                                z = a[j][i];
                                a[j][nm] = y * c + z * s;
                                a[j][i] = z * c - y * s;
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
                z = w[k];
                if (l == k) {
                    if (!((double)z < 0.0)) break;
                    w[k] = -z;
                    j = 0;
                    while (j < n) {
                        v[j][k] = -v[j][k];
                        ++j;
                    }
                    break;
                }
                if (its == 30) {
                    return Nrmatrix.nrerror_return("No convergence in 30 SVDCMP iterations");
                }
                float x = w[l];
                nm = k - 1;
                y = w[nm];
                g = rv1[nm];
                h = rv1[k];
                f = ((y - z) * (y + z) + (g - h) * (g + h)) / (2.0f * h * y);
                g = Nrmatrix.PYTHAG(f, 1.0f);
                f = ((x - z) * (x + z) + h * (y / (f + Nrmatrix.SIGN(g, f)) - h)) / x;
                s = 1.0f;
                c = 1.0f;
                j = l;
                while (j <= nm) {
                    i = j + 1;
                    g = rv1[i];
                    y = w[i];
                    h = s * g;
                    g = c * g;
                    rv1[j] = z = Nrmatrix.PYTHAG(f, h);
                    c = f / z;
                    s = h / z;
                    f = x * c + g * s;
                    g = g * c - x * s;
                    h = y * s;
                    y *= c;
                    int jj = 0;
                    while (jj < n) {
                        x = v[jj][j];
                        z = v[jj][i];
                        v[jj][j] = x * c + z * s;
                        v[jj][i] = z * c - x * s;
                        ++jj;
                    }
                    w[j] = z = Nrmatrix.PYTHAG(f, h);
                    if (z != 0.0f) {
                        z = 1.0f / z;
                        c = f * z;
                        s = h * z;
                    }
                    f = c * g + s * y;
                    x = c * y - s * g;
                    jj = 0;
                    while (jj < m) {
                        y = a[jj][j];
                        z = a[jj][i];
                        a[jj][j] = y * c + z * s;
                        a[jj][i] = z * c - y * s;
                        ++jj;
                    }
                    ++j;
                }
                rv1[l] = 0.0f;
                rv1[k] = f;
                w[k] = x;
                ++its;
            }
            --k;
        }
        return 0;
    }

    public static int svdcmp(float[][] a, int m, int n, float[] w, float[][] v) {
        int j;
        float h;
        float f;
        int k;
        float s;
        int l = -1;
        int nm = -1;
        float anorm = 0.0f;
        float g = 0.0f;
        float scale = 0.0f;
        if (m < n) {
            return Nrmatrix.nrerror_return("SVDCMP: You must augment A with extra zero rows");
        }
        float[] rv1 = Nrmatrix.vector(1, n);
        int i = 1;
        while (i <= n) {
            l = i + 1;
            rv1[i] = scale * g;
            scale = 0.0f;
            s = 0.0f;
            g = 0.0f;
            if (i <= m) {
                k = i;
                while (k <= m) {
                    scale += Math.abs(a[k][i]);
                    ++k;
                }
                if (scale != 0.0f) {
                    k = i;
                    while (k <= m) {
                        float[] fArray = a[k];
                        int n2 = i;
                        fArray[n2] = fArray[n2] / scale;
                        s += a[k][i] * a[k][i];
                        ++k;
                    }
                    f = a[i][i];
                    g = -Nrmatrix.SIGN((float)Math.sqrt(s), f);
                    h = f * g - s;
                    a[i][i] = f - g;
                    if (i != n) {
                        j = l;
                        while (j <= n) {
                            s = 0.0f;
                            k = i;
                            while (k <= m) {
                                s += a[k][i] * a[k][j];
                                ++k;
                            }
                            f = s / h;
                            k = i;
                            while (k <= m) {
                                float[] fArray = a[k];
                                int n3 = j;
                                fArray[n3] = fArray[n3] + f * a[k][i];
                                ++k;
                            }
                            ++j;
                        }
                    }
                    k = i;
                    while (k <= m) {
                        float[] fArray = a[k];
                        int n4 = i;
                        fArray[n4] = fArray[n4] * scale;
                        ++k;
                    }
                }
            }
            w[i] = scale * g;
            scale = 0.0f;
            s = 0.0f;
            g = 0.0f;
            if (i <= m && i != n) {
                k = l;
                while (k <= n) {
                    scale += Math.abs(a[i][k]);
                    ++k;
                }
                if (scale != 0.0f) {
                    k = l;
                    while (k <= n) {
                        float[] fArray = a[i];
                        int n5 = k;
                        fArray[n5] = fArray[n5] / scale;
                        s += a[i][k] * a[i][k];
                        ++k;
                    }
                    f = a[i][l];
                    g = -Nrmatrix.SIGN((float)Math.sqrt(s), f);
                    h = f * g - s;
                    a[i][l] = f - g;
                    k = l;
                    while (k <= n) {
                        rv1[k] = a[i][k] / h;
                        ++k;
                    }
                    if (i != m) {
                        j = l;
                        while (j <= m) {
                            s = 0.0f;
                            k = l;
                            while (k <= n) {
                                s += a[j][k] * a[i][k];
                                ++k;
                            }
                            k = l;
                            while (k <= n) {
                                float[] fArray = a[j];
                                int n6 = k;
                                fArray[n6] = fArray[n6] + s * rv1[k];
                                ++k;
                            }
                            ++j;
                        }
                    }
                    k = l;
                    while (k <= n) {
                        float[] fArray = a[i];
                        int n7 = k++;
                        fArray[n7] = fArray[n7] * scale;
                    }
                }
            }
            anorm = Math.max(anorm, Math.abs(w[i]) + Math.abs(rv1[i]));
            ++i;
        }
        i = n;
        while (i >= 1) {
            if (i < n) {
                if (g != 0.0f) {
                    j = l;
                    while (j <= n) {
                        v[j][i] = a[i][j] / a[i][l] / g;
                        ++j;
                    }
                    j = l;
                    while (j <= n) {
                        s = 0.0f;
                        k = l;
                        while (k <= n) {
                            s += a[i][k] * v[k][j];
                            ++k;
                        }
                        k = l;
                        while (k <= n) {
                            float[] fArray = v[k];
                            int n8 = j;
                            fArray[n8] = fArray[n8] + s * v[k][i];
                            ++k;
                        }
                        ++j;
                    }
                }
                j = l;
                while (j <= n) {
                    v[j][i] = 0.0f;
                    v[i][j] = 0.0f;
                    ++j;
                }
            }
            v[i][i] = 1.0f;
            g = rv1[i];
            l = i--;
        }
        i = n;
        while (i >= 1) {
            l = i + 1;
            g = w[i];
            if (i < n) {
                j = l;
                while (j <= n) {
                    a[i][j] = 0.0f;
                    ++j;
                }
            }
            if (g != 0.0f) {
                g = 1.0f / g;
                if (i != n) {
                    j = l;
                    while (j <= n) {
                        s = 0.0f;
                        k = l;
                        while (k <= m) {
                            s += a[k][i] * a[k][j];
                            ++k;
                        }
                        f = s / a[i][i] * g;
                        k = i;
                        while (k <= m) {
                            float[] fArray = a[k];
                            int n9 = j;
                            fArray[n9] = fArray[n9] + f * a[k][i];
                            ++k;
                        }
                        ++j;
                    }
                }
                j = i;
                while (j <= m) {
                    float[] fArray = a[j];
                    int n10 = i;
                    fArray[n10] = fArray[n10] * g;
                    ++j;
                }
            } else {
                j = i;
                while (j <= m) {
                    a[j][i] = 0.0f;
                    ++j;
                }
            }
            float[] fArray = a[i];
            int n11 = i--;
            fArray[n11] = fArray[n11] + 1.0f;
        }
        k = n;
        while (k >= 1) {
            int its = 1;
            while (its <= 30) {
                float z;
                float y;
                float c;
                boolean flag = true;
                l = k;
                while (l >= 1) {
                    nm = l - 1;
                    if (Math.abs(rv1[l]) + anorm == anorm) {
                        flag = false;
                        break;
                    }
                    if (Math.abs(w[nm]) + anorm == anorm) break;
                    --l;
                }
                if (flag) {
                    c = 0.0f;
                    s = 1.0f;
                    i = l;
                    while (i <= k) {
                        f = s * rv1[i];
                        if (Math.abs(f) + anorm != anorm) {
                            g = w[i];
                            w[i] = h = Nrmatrix.PYTHAG(f, g);
                            h = 1.0f / h;
                            c = g * h;
                            s = -f * h;
                            j = 1;
                            while (j <= m) {
                                y = a[j][nm];
                                z = a[j][i];
                                a[j][nm] = y * c + z * s;
                                a[j][i] = z * c - y * s;
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
                z = w[k];
                if (l == k) {
                    if (!((double)z < 0.0)) break;
                    w[k] = -z;
                    j = 1;
                    while (j <= n) {
                        v[j][k] = -v[j][k];
                        ++j;
                    }
                    break;
                }
                if (its == 30) {
                    return Nrmatrix.nrerror_return("No convergence in 30 SVDCMP iterations");
                }
                float x = w[l];
                nm = k - 1;
                y = w[nm];
                g = rv1[nm];
                h = rv1[k];
                f = ((y - z) * (y + z) + (g - h) * (g + h)) / (2.0f * h * y);
                g = Nrmatrix.PYTHAG(f, 1.0f);
                f = ((x - z) * (x + z) + h * (y / (f + Nrmatrix.SIGN(g, f)) - h)) / x;
                s = 1.0f;
                c = 1.0f;
                j = l;
                while (j <= nm) {
                    i = j + 1;
                    g = rv1[i];
                    y = w[i];
                    h = s * g;
                    g = c * g;
                    rv1[j] = z = Nrmatrix.PYTHAG(f, h);
                    c = f / z;
                    s = h / z;
                    f = x * c + g * s;
                    g = g * c - x * s;
                    h = y * s;
                    y *= c;
                    int jj = 1;
                    while (jj <= n) {
                        x = v[jj][j];
                        z = v[jj][i];
                        v[jj][j] = x * c + z * s;
                        v[jj][i] = z * c - x * s;
                        ++jj;
                    }
                    w[j] = z = Nrmatrix.PYTHAG(f, h);
                    if (z != 0.0f) {
                        z = 1.0f / z;
                        c = f * z;
                        s = h * z;
                    }
                    f = c * g + s * y;
                    x = c * y - s * g;
                    jj = 1;
                    while (jj <= m) {
                        y = a[jj][j];
                        z = a[jj][i];
                        a[jj][j] = y * c + z * s;
                        a[jj][i] = z * c - y * s;
                        ++jj;
                    }
                    ++j;
                }
                rv1[l] = 0.0f;
                rv1[k] = f;
                w[k] = x;
                ++its;
            }
            --k;
        }
        return 0;
    }
}

