/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

import cn.org.gddsn.seis.location.rstt.SLBMException;
import com.nr.UniVarRealValueFun;
import org.netlib.util.doubleW;

public class Brents {
    private double zbTol;
    private UniVarRealValueFun zbF;
    private double bMinMaxFlg;

    public Brents() {
        this.zbTol = 1.0E-6;
        this.bMinMaxFlg = 1.0;
    }

    public Brents(Brents zb) {
        this.zbF = zb.zbF;
        this.zbTol = zb.zbTol;
        this.bMinMaxFlg = zb.bMinMaxFlg;
    }

    public Brents(UniVarRealValueFun f, double tol) {
        this.zbF = f;
        this.zbTol = tol;
        this.bMinMaxFlg = 1.0;
    }

    public Brents copy(Brents zb) {
        this.zbF = zb.zbF;
        this.zbTol = zb.zbTol;
        this.bMinMaxFlg = zb.bMinMaxFlg;
        return this;
    }

    public UniVarRealValueFun getF() {
        return this.zbF;
    }

    public double getTolerance() {
        return this.zbTol;
    }

    public boolean isMinimumSearch() {
        return this.bMinMaxFlg == 1.0;
    }

    public double minF(double ax, double bx, double cx, doubleW xmin) {
        double fx;
        double v;
        double b;
        double CGOLD = 0.3819660112501051;
        double ZEPS = 1.0E-10;
        int ITMAX = 100;
        UniVarRealValueFun f = this.zbF;
        double a = b = ax;
        if (cx < ax) {
            a = cx;
        } else {
            b = cx;
        }
        double w = v = bx;
        double x = v;
        double d = 0.0;
        double e = 0.0;
        double fv = fx = this.bMinMaxFlg * f.funk(x);
        double fw = fx;
        int iter = 0;
        while (iter < 100) {
            double u;
            double xm = 0.5 * (a + b);
            double tol1 = this.zbTol * Math.abs(x) + 1.0E-10;
            double tol2 = 2.0 * tol1;
            if (Math.abs(x - xm) <= tol2 - 0.5 * (b - a)) break;
            if (Math.abs(e) > tol1) {
                double r = (x - w) * (fx - fv);
                double q = (x - v) * (fx - fw);
                double p = (x - v) * q - (x - w) * r;
                if ((q = 2.0 * (q - r)) > 0.0) {
                    p = -p;
                }
                q = Math.abs(q);
                double etemp = e;
                e = d;
                if (Math.abs(p) >= Math.abs(0.5 * q * etemp) || p <= q * (a - x) || p >= q * (b - x)) {
                    e = x >= xm ? a - x : b - x;
                    d = 0.3819660112501051 * e;
                } else {
                    d = p / q;
                    u = x + d;
                    if (u - a < tol2 || b - u < tol2) {
                        d = Math.abs(tol1);
                        if (xm - x < 0.0) {
                            d = -d;
                        }
                    }
                }
            } else {
                e = x >= xm ? a - x : b - x;
                d = 0.3819660112501051 * e;
            }
            u = Math.abs(d) >= tol1 ? x + d : (d < 0.0 ? x - Math.abs(tol1) : x + Math.abs(tol1));
            double fu = this.bMinMaxFlg * f.funk(u);
            if (fu <= fx) {
                if (u >= x) {
                    a = x;
                } else {
                    b = x;
                }
                v = w;
                fv = fw;
                w = x;
                fw = fx;
                x = u;
                fx = fu;
            } else {
                if (u < x) {
                    a = u;
                } else {
                    b = u;
                }
                if (fu <= fw || w == x) {
                    v = w;
                    fv = fw;
                    w = u;
                    fw = fu;
                } else if (fu <= fv || v == x || v == w) {
                    v = u;
                    fv = fu;
                }
            }
            ++iter;
        }
        if (iter == 100) {
            throw new SLBMException("ERROR in minF(). max iterations exceeded", 306);
        }
        xmin.val = x;
        return this.bMinMaxFlg * fx;
    }

    public void setF(UniVarRealValueFun f) {
        this.zbF = f;
    }

    public void setMinimumSearch() {
        this.bMinMaxFlg = 1.0;
    }

    public void setMaximumSearch() {
        this.bMinMaxFlg = -1.0;
    }

    public void setTolerance(double tol) {
        this.zbTol = tol;
    }

    public double zeroF(double ax, double bx) {
        UniVarRealValueFun f = this.zbF;
        double a = ax;
        double b = bx;
        double fa = f.funk(a);
        double fb = f.funk(b);
        double c = a;
        double fc = fa;
        while (true) {
            double prev_step = b - a;
            if (Math.abs(fc) < Math.abs(fb)) {
                a = b;
                b = c;
                c = a;
                fa = fb;
                fb = fc;
                fc = fa;
            }
            double tol_act = 4.440892098500626E-16 * Math.abs(b) + 0.5 * this.zbTol;
            double new_step = 0.5 * (c - b);
            if (Math.abs(new_step) <= tol_act || fb == 0.0) {
                return b;
            }
            if (Math.abs(prev_step) >= tol_act && Math.abs(fa) > Math.abs(fb)) {
                double q;
                double p;
                double t1;
                double cb = c - b;
                if (a == c) {
                    t1 = fb / fa;
                    p = cb * t1;
                    q = 1.0 - t1;
                } else {
                    q = fa / fc;
                    t1 = fb / fc;
                    double t2 = fb / fa;
                    p = t2 * (cb * q * (q - t1) - (b - a) * (t1 - 1.0));
                    q = (q - 1.0) * (t1 - 1.0) * (t2 - 1.0);
                }
                if (p > 0.0) {
                    q = -q;
                } else {
                    p = -p;
                }
                if (p < 0.75 * cb * q - Math.abs(tol_act * q) / 2.0 && p < Math.abs(prev_step * q / 2.0)) {
                    new_step = p / q;
                }
            }
            if (Math.abs(new_step) < tol_act) {
                new_step = new_step > 0.0 ? tol_act : -tol_act;
            }
            a = b;
            fa = fb;
            fb = f.funk(b += new_step);
            if (!(fb * fc > 0.0)) continue;
            c = a;
            fc = fa;
        }
    }
}

