/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

import cn.org.gddsn.seis.location.rstt.CrustalProfile;
import cn.org.gddsn.seis.location.rstt.Grid;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;

public class CrustalProfileStore {
    private Grid grid;
    private int maxSize;
    private TreeMap<String, CrustalProfile> profiles = new TreeMap();
    private LinkedList<String> priority = new LinkedList();
    private LinkedList<CrustalProfile> pool = new LinkedList();

    public CrustalProfileStore(Grid _grid, int _maxSize) {
        this.grid = _grid;
        this.maxSize = _maxSize;
    }

    protected void finalize() {
        this.clear();
    }

    public void clear() {
        this.profiles.clear();
        this.priority.clear();
        this.pool.clear();
    }

    public int getNCrustalProfiles() {
        return this.profiles.size();
    }

    public CrustalProfile getCrustalProfile(int phase, double lat, double lon, double depth) {
        CrustalProfile profile = null;
        ByteBuffer bb = ByteBuffer.wrap(new byte[32]);
        bb.putInt(phase);
        bb.putInt(0);
        bb.putDouble(lat);
        bb.putDouble(lon);
        bb.putDouble(depth);
        String locString = new String(bb.array());
        CrustalProfile it = this.profiles.get(locString);
        if (it == null) {
            if (this.priority.size() >= this.maxSize) {
                String oldString = this.priority.getLast();
                it = this.profiles.get(oldString);
                this.pool.add(it);
                this.profiles.remove(oldString);
                this.priority.removeLast();
            }
            if (this.pool.size() > 0) {
                profile = this.pool.getFirst();
                this.pool.removeFirst();
            } else {
                profile = new CrustalProfile();
            }
            profile.setup(this.grid, phase, lat, lon, depth);
            this.profiles.put(locString, profile);
            this.priority.addFirst(locString);
        } else {
            profile = it;
            if (!locString.equals(this.priority.get(0))) {
                Iterator lit = this.priority.iterator();
                while (lit.hasNext()) {
                    String k = (String)lit.next();
                    if (!k.equals(locString)) continue;
                    lit.remove();
                }
                this.priority.add(0, locString);
            }
        }
        return profile;
    }
}

