/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoStack {
    protected static int geoStackClassCount = 0;
    protected int index;
    protected int refCount;
    protected double[] depth = new double[9];
    protected double[] pvelocity = new double[9];
    protected double[] svelocity = new double[9];
    protected double[] gradient = new double[2];

    public GeoStack() {
        ++geoStackClassCount;
    }

    public GeoStack(int ii, double[] depths, double[] pvelocities, double[] svelocities, double[] gradients) {
        this.index = ii;
        this.refCount = 0;
        ++geoStackClassCount;
        int i = 0;
        while (i < 9) {
            this.depth[i] = depths[i];
            this.pvelocity[i] = pvelocities[i];
            this.svelocity[i] = svelocities[i];
            ++i;
        }
        this.gradient[0] = gradients[0];
        this.gradient[1] = gradients[1];
    }

    public GeoStack(GeoStack other) {
        this.index = -1;
        this.refCount = 0;
        ++geoStackClassCount;
        int i = 0;
        while (i < 9) {
            this.depth[i] = other.depth[i];
            this.pvelocity[i] = other.pvelocity[i];
            this.svelocity[i] = other.svelocity[i];
            ++i;
        }
        this.gradient[0] = other.gradient[0];
        this.gradient[1] = other.gradient[1];
    }

    protected void finalize() {
        --geoStackClassCount;
    }

    public GeoStack copy(GeoStack other) {
        int i = 0;
        while (i < 9) {
            this.depth[i] = other.depth[i];
            this.pvelocity[i] = other.pvelocity[i];
            this.svelocity[i] = other.svelocity[i];
            ++i;
        }
        this.gradient[0] = other.gradient[0];
        this.gradient[1] = other.gradient[1];
        return this;
    }

    public boolean equals(GeoStack other) {
        int i = 0;
        while (i < 9) {
            if (this.depth[i] != other.depth[i]) {
                return false;
            }
            if (this.pvelocity[i] != other.pvelocity[i]) {
                return false;
            }
            if (this.svelocity[i] != other.svelocity[i]) {
                return false;
            }
            ++i;
        }
        if (this.gradient[0] != other.gradient[0]) {
            return false;
        }
        return this.gradient[1] == other.gradient[1];
    }

    public boolean equals_no(GeoStack other) {
        return !this.equals(other);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        String[] layers = new String[]{"water", "sediment1", "sediment2", "sediment3", "upper_crust", "middle_crust_n", "middle_crust_g", "lower_crust", "mantle"};
        sb.append(String.format(" %5s %-15s %8s %8s %9s %9s\n", "#", "Layer", "P_Vel", "S_Vel", "Top", "Thick"));
        int i = 0;
        while (i < 9) {
            sb.append(String.format(" %5d %-15s %8.4f %8.4f %9.4f", i + 1, layers[i], this.pvelocity[i], this.svelocity[i], this.depth[i]));
            if (i < 8) {
                if (i == 5) {
                    sb.append(String.format(" %9.4f", this.depth[7] - this.depth[5]));
                } else {
                    sb.append(String.format(" %9.4f", this.depth[i + 1] - this.depth[i]));
                }
            }
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    public static int getClassCount() {
        return geoStackClassCount;
    }

    public int getRefCount() {
        return this.refCount;
    }

    public void incRefCount() {
        ++this.refCount;
    }

    public void decRefCount() {
        --this.refCount;
    }

    public void setRefCount(int count) {
        this.refCount = count;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int idx) {
        this.index = idx;
    }

    public void getData(double[] d, double[] pv, double[] sv, double[] g) {
        int i = 0;
        while (i < 9) {
            d[i] = this.depth[i];
            pv[i] = this.pvelocity[i];
            sv[i] = this.svelocity[i];
            ++i;
        }
        g[0] = this.gradient[0];
        g[1] = this.gradient[1];
    }

    public void setData(double[] depths, double[] pvelocities, double[] svelocities, double[] gradients) {
        int i = 0;
        while (i < 9) {
            this.depth[i] = depths[i];
            this.pvelocity[i] = pvelocities[i];
            this.svelocity[i] = svelocities[i];
            ++i;
        }
        this.gradient[0] = gradients[0];
        this.gradient[1] = gradients[1];
    }

    public void setDepth(Vector<Double> z) {
        int i = 0;
        while (i < 9) {
            this.depth[i] = z.get(i);
            ++i;
        }
    }

    public void setVelocity(int waveType, Vector<Double> v) {
        block3: {
            block2: {
                if (waveType != 0) break block2;
                int i = 0;
                while (i < 9) {
                    this.pvelocity[i] = v.get(i);
                    ++i;
                }
                break block3;
            }
            if (waveType != 1) break block3;
            int i = 0;
            while (i < 9) {
                this.svelocity[i] = v.get(i);
                ++i;
            }
        }
    }

    public void setGradient(Vector<Double> g) {
        this.gradient[0] = g.get(0);
        this.gradient[1] = g.get(1);
    }

    public double getDepth(int k) {
        return this.depth[k];
    }

    public double[] getDepth() {
        return this.depth;
    }

    public double getVelocity(int waveType, int k) {
        if (waveType == 0) {
            return this.pvelocity[k];
        }
        return this.svelocity[k];
    }

    public double getMantleGradient(int waveType) {
        return this.gradient[waveType];
    }

    public double[] getVelocity(int waveType) {
        if (waveType == 0) {
            return this.pvelocity;
        }
        return this.svelocity;
    }

    public double[] getMantleGradient() {
        return this.gradient;
    }

    public boolean hasLowVelocityZone() {
        double vp = 0.0;
        double vs = 0.0;
        int i = 1;
        while (i <= 4) {
            if (this.depth[i + 1] - this.depth[i] > 1.0E-6) {
                vp = Math.max(vp, this.pvelocity[i]);
                vs = Math.max(vs, this.svelocity[i]);
            }
            ++i;
        }
        if (vp > this.pvelocity[6]) {
            return true;
        }
        i = 5;
        while (i <= 7) {
            if (this.depth[i + 1] - this.depth[i] > 1.0E-6) {
                vp = Math.max(vp, this.pvelocity[i]);
                vs = Math.max(vs, this.svelocity[i]);
            }
            ++i;
        }
        if (vp > this.pvelocity[8]) {
            return true;
        }
        return vs > this.svelocity[8];
    }
}

