/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

import cn.org.gddsn.seis.location.rstt.GreatCircle;
import cn.org.gddsn.seis.location.rstt.Grid;
import cn.org.gddsn.seis.location.rstt.LayerProfile;
import cn.org.gddsn.seis.location.rstt.SLBMException;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class GreatCircle_Xn
extends GreatCircle {
    private double ch_max;
    private double Vm;
    private double Gm;
    private double H;
    private double rMoho;
    private double rZm;
    private int udSign;
    private double V0;
    private double c;
    private double cm;
    private double zm;
    private double zhao_r;
    private double cz;
    private double cmz;
    private final double cmin;

    private double SIGN(double a, double b) {
        return b >= 0.0 ? (a >= 0.0 ? a : -a) : (a >= 0.0 ? -a : a);
    }

    public GreatCircle_Xn(int _phase, Grid _grid, double latSource, double lonSource, double depthSource, double latReceiver, double lonReceiver, double depthReceiver, double chMax) {
        super(_phase, _grid, latSource, lonSource, depthSource, latReceiver, lonReceiver, depthReceiver);
        this.ch_max = chMax;
        this.cmin = 1.0E-6;
        this.udSign = -999;
        this.computeTravelTime();
    }

    public GreatCircle_Xn(GreatCircle_Xn other) {
        super(other);
        this.cmin = other.cmin;
        this.ch_max = other.ch_max;
    }

    public GreatCircle_Xn copy(GreatCircle_Xn other) {
        super.copy(other);
        this.ch_max = other.ch_max;
        return this;
    }

    public void getZhaoParameters(doubleW Vm_, doubleW Gm_, doubleW H_, doubleW C_, doubleW Cm_, intW udSign_) {
        Vm_.val = this.Vm;
        Gm_.val = this.Gm;
        H_.val = this.H;
        C_.val = this.c;
        Cm_.val = this.cm;
        udSign_.val = this.udSign;
    }

    protected void computeTravelTime() {
        this.tGamma = 0.0;
        this.tHorizontal = 0.0;
        this.tReceiver = 0.0;
        this.tSource = 0.0;
        this.tTotal = 0.0;
        if (this.getDistance() > MAX_DISTANCE) {
            String err = String.format("\nERROR in computeTravelTime\nSource-receiver separation exceeds maximum value.\nSource-receiver separation (degrees) : %.2f\nMaximum allowed separation (degrees) : %.2f\nSource   location : %s\nReceiver location : %s\n", this.getDistance() * 57.29577951308232, MAX_DISTANCE * 57.29577951308232, this.source.getLocation().toString(), this.receiver.getLocation().toString());
            this.setNAValues();
            throw new SLBMException(err, 201);
        }
        if (this.source.getLocation().getDepth() > MAX_DEPTH) {
            String err = String.format("\nERROR in computeTravelTime\nSource depth exceeds maximum value.Source depth (km)          : %.2f\nMaximum allowed depth (km) : %.2f\nSource   location : %s\nReceiver location : %s\n", this.source.getLocation().getDepth(), MAX_DEPTH, this.source.getLocation().toString(), this.receiver.getLocation().toString());
            this.setNAValues();
            throw new SLBMException(err, 202);
        }
        if (!this.receiver.isInCrust()) {
            String err = String.format("\nERROR in computeTravelTime\nReceiver depth below Moho is illegal.\nSource   location : %s\nReceiver location : %s\nReceiver Moho depth : %.2f\n", this.source.getLocation().toString(), this.receiver.getLocation().toString(), this.receiver.getDepth(8));
            this.setNAValues();
            throw new SLBMException(err, 401);
        }
        if (this.source.isInCrust()) {
            this.computeTravelTimeCrust();
        } else {
            this.computeTravelTimeMantle();
        }
    }

    private void computeTravelTimeCrust() {
        int i;
        String err;
        this.solutionMethod = "computeTravelTimeCrust()";
        this.udSign = 0;
        this.rMoho = (this.source.getInterfaceRadius(8) + this.receiver.getInterfaceRadius(8)) / 2.0;
        boolean done = false;
        this.rayParameter = Math.min(this.source.getPCrit(this), this.receiver.getPCrit(this));
        int nIterations = 0;
        while (!done) {
            if (++nIterations == 10000) {
                err = String.format("\nERROR in computeTravelTimeCrust\nnIterations == %d\nSource   location : %s\nReceiver location : %s\n", nIterations, this.source.getLocation().toString(), this.receiver.getLocation().toString());
                this.setNAValues();
                throw new SLBMException(err, 300);
            }
            doubleW w_1 = new doubleW(this.xSource);
            doubleW w_2 = new doubleW(this.tSource);
            this.source.xtCrust(this, this.rayParameter, w_1, w_2);
            this.xSource = w_1.val;
            this.tSource = w_2.val;
            w_1 = new doubleW(this.xReceiver);
            w_2 = new doubleW(this.tReceiver);
            this.receiver.xtCrust(this, this.rayParameter, w_1, w_2);
            this.xReceiver = w_1.val;
            this.tReceiver = w_2.val;
            if (this.xSource + this.xReceiver > this.getDistance()) {
                String err2 = String.format("\nERROR in computeTravelTimeCrust\nHorizontal offset below the source (%.2f deg) plus\nhorizontal offset below the receiver (%.2f deg)\nis greater than the source-receiver separation (%.2f deg)\nSource   location : %s\nReceiver location : %s\n", this.xSource * 57.29577951308232, this.xReceiver * 57.29577951308232, this.getDistance() * 57.29577951308232, this.source.getLocation().toString(), this.receiver.getLocation().toString());
                this.setNAValues();
                throw new SLBMException(err2, 203);
            }
            this.sourceIndex = Math.max(0, (int)Math.floor(this.xSource / this.actual_path_increment));
            this.receiverIndex = Math.min(this.profiles.size() - 1, (int)Math.floor((this.getDistance() - this.xReceiver) / this.actual_path_increment));
            this.xHorizontal = 0.0;
            this.Vm = 0.0;
            this.Gm = 0.0;
            i = this.sourceIndex;
            while (i <= this.receiverIndex) {
                double dkm = this.getActualPathIncrement(i) * this.getProfile(i).getRadius();
                this.xHorizontal += dkm;
                this.Vm += ((LayerProfile)this.profiles.get(i)).getVelocity() * dkm;
                this.Gm += ((LayerProfile)this.profiles.get(i)).getGradient() * dkm;
                ++i;
            }
            this.Vm /= this.xHorizontal;
            this.Gm /= this.xHorizontal;
            this.cm = Math.max(this.cmin, this.Gm / this.Vm + 1.0 / this.rMoho);
            this.H = 1.0 / this.cm * (Math.sqrt(this.sqr(this.xHorizontal * this.cm / 2.0) + 1.0) - 1.0);
            this.turningRadius = this.rMoho - this.H;
            double p = this.turningRadius / (this.Vm + this.Gm * this.H);
            boolean bl = done = Math.abs(p - this.rayParameter) < 1.0E-6;
            if (done) continue;
            this.rayParameter = p;
        }
        if (this.H * this.cm > this.ch_max) {
            err = String.format("\nERROR in computeTravelTimeCrust\nc*H is greater than ch_max.\nSource   location : %s\nReceiver location : %s\nH      : %.6f\ncm     : %.6f\nH*cm   : %.6f\nch_max : %.6f\nGm     : %.6f\n", this.source.getLocation().toString(), this.receiver.getLocation().toString(), this.H, this.cm, this.H * this.cm, this.ch_max, this.Gm);
            this.setNAValues();
            throw new SLBMException(err, 301);
        }
        i = this.sourceIndex;
        while (i <= this.receiverIndex) {
            this.tHorizontal += this.getActualPathIncrement(i) * ((LayerProfile)this.profiles.get(i)).getRadius() / ((LayerProfile)this.profiles.get(i)).getVelocity();
            ++i;
        }
        this.V0 = this.grid.getAverageMantleVelocity(this.phase % 2);
        this.c = Math.max(this.cmin, this.Gm / this.V0 + 1.0 / this.rMoho);
        this.tGamma = -this.xHorizontal * this.xHorizontal * this.xHorizontal * this.c * this.c / (this.V0 * 24.0);
        this.tTotal = this.tSource + this.tReceiver + this.tHorizontal + this.tGamma;
        this.receiverRayParameter = this.rayParameter;
        this.sourceRayParameter = this.rayParameter;
    }

    private void computeTravelTimeMantle() {
        String err;
        double p;
        this.solutionMethod = "computeTravelTimeMantle()";
        this.xSource = 0.0;
        this.tSource = 0.0;
        this.sourceIndex = 0;
        this.tReceiver = 0.0;
        this.tHorizontal = 0.0;
        this.tGamma = 0.0;
        this.V0 = this.grid.getAverageMantleVelocity(this.phase % 2);
        this.rMoho = (this.source.getInterfaceRadius(8) + this.receiver.getInterfaceRadius(8)) / 2.0;
        this.zm = this.source.getInterfaceRadius(8) - this.source.getLocation().getRadius();
        this.rZm = this.source.getLocation().getRadius();
        this.zhao_r = this.source.getInterfaceRadius(8) / (this.source.getInterfaceRadius(8) - this.zm);
        this.rayParameter = this.receiver.getPCrit(this);
        doubleW h1 = new doubleW(0.0);
        doubleW h2 = new doubleW(0.0);
        doubleW h3 = new doubleW(0.0);
        doubleW f1 = new doubleW(0.0);
        doubleW f2 = new doubleW(0.0);
        doubleW f3 = new doubleW(0.0);
        int max_count = 0;
        do {
            double residual;
            if (++max_count > 200) {
                err = String.format("\nERROR in computeTravelTimeMantle\nCould not converge on stable ray parameter.\nSource   location : %s\nReceiver location : %s\n", this.source.getLocation().toString(), this.receiver.getLocation().toString());
                this.setNAValues();
                throw new SLBMException(err, 302);
            }
            doubleW w_1 = new doubleW(this.xReceiver);
            doubleW w_2 = new doubleW(this.tReceiver);
            this.receiver.xtCrust(this, this.rayParameter, w_1, w_2);
            this.xReceiver = w_1.val;
            this.tReceiver = w_2.val;
            if (this.xReceiver > this.getDistance()) {
                String err2 = String.format("\nERROR in computeTravelTimeMantle\nSource is too close to the receiver.\nSource-receiver separation = %.2f degSource   location : %s\nReceiver location : %s\n", this.getDistance() * 57.29577951308232, this.source.getLocation().toString(), this.receiver.getLocation().toString());
                this.setNAValues();
                throw new SLBMException(err2, 402);
            }
            this.receiverIndex = Math.min(this.profiles.size() - 1, (int)Math.floor((this.getDistance() - this.xReceiver) / this.actual_path_increment));
            this.Gm = 0.0;
            this.Vm = 0.0;
            this.xHorizontal = 0.0;
            int i = this.sourceIndex;
            while (i <= this.receiverIndex) {
                double dkm = this.getActualPathIncrement(i) * this.getProfile(i).getRadius();
                this.xHorizontal += dkm;
                this.Vm += ((LayerProfile)this.profiles.get(i)).getVelocity() * dkm;
                this.Gm += ((LayerProfile)this.profiles.get(i)).getGradient() * dkm;
                ++i;
            }
            this.Gm /= this.xHorizontal;
            this.Vm /= this.xHorizontal;
            this.cm = Math.max(this.cmin, this.Gm / this.Vm + 1.0 / this.rMoho);
            this.c = Math.max(this.cmin, this.Gm / this.V0 + 1.0 / this.rMoho);
            this.cmz = Math.max(this.cmin, this.Gm / this.Vm + 1.0 / this.rZm);
            this.cz = Math.max(this.cmin, this.Gm / this.V0 + 1.0 / this.rZm);
            this.udSign = 1;
            h1.val = this.zm;
            h2.val = 3000.0;
            this.mnbrak(h1, h2, h3, f1, f2, f3);
            if (h3.val != h1.val) {
                doubleW w_H = new doubleW(this.H);
                residual = this.brent(h1.val, h2.val, h3.val, 1.0E-8, w_H);
                this.H = w_H.val;
            } else {
                this.udSign = -1;
                h1.val = this.zm;
                h2.val = 10000.0;
                this.mnbrak(h1, h2, h3, f1, f2, f3);
                if (h3.val != h1.val) {
                    doubleW w_H = new doubleW(this.H);
                    residual = this.brent(h1.val, h2.val, h3.val, 1.0E-8, w_H);
                    this.H = w_H.val;
                } else {
                    this.H = this.zm;
                    residual = Math.abs(this.func(this.H));
                }
            }
            if (residual >= 1.0E-6) {
                String err3 = String.format("\nERROR in computeTravelTimeMantle\nsearch for minimum H failed.\nSource   location : %s\nReceiver location : %s\n", this.source.getLocation().toString(), this.receiver.getLocation().toString());
                this.setNAValues();
                throw new SLBMException(err3, 303);
            }
            this.turningRadius = this.rMoho - this.H;
            p = this.rayParameter;
            this.rayParameter = this.turningRadius / (this.Vm + this.Gm * this.H);
        } while (Math.abs(1.0 - p / this.rayParameter) > 1.0E-6);
        if (this.cm * this.H > this.ch_max) {
            err = String.format("\nERROR in computeTravelTimeMantle\nc*H > ch_max.\nSource   location : %s\nReceiver location : %s\nH      : %.6f\ncm     : %.6f\nH*cm   : %.6f\nch_max : %.6f\nGm     : %.6f\n", this.source.getLocation().toString(), this.receiver.getLocation().toString(), this.H, this.cm, this.H * this.cm, this.ch_max, this.Gm);
            this.setNAValues();
            throw new SLBMException(err, 304);
        }
        double xm = 2.0 / this.cm * Math.sqrt(this.sqr(1.0 + this.cm * this.H) - 1.0);
        double xz = 2.0 / this.cmz * Math.sqrt(this.sqr(1.0 + this.cmz * (this.H - this.zm)) - 1.0);
        this.tHorizontal = (xm - this.xHorizontal) / this.Vm + (double)this.udSign * xz / (this.Vm + this.Gm * this.zm);
        int i = this.sourceIndex;
        while (i <= this.receiverIndex) {
            this.tHorizontal += this.getActualPathIncrement(i) * ((LayerProfile)this.profiles.get(i)).getRadius() / ((LayerProfile)this.profiles.get(i)).getVelocity();
            ++i;
        }
        this.tHorizontal /= 2.0;
        this.tGamma = -(this.c * this.c * xm * xm * xm / this.V0 + (double)this.udSign * this.cz * this.cz * xz * xz * xz / (this.V0 + this.Gm * this.zm)) / 48.0;
        this.tTotal = this.tReceiver + this.tHorizontal + this.tGamma;
    }

    private double func(double h) {
        return this.sqr(Math.sqrt(this.sqr(1.0 + this.cm * h) - 1.0) + (double)this.udSign * this.zhao_r * (this.cm / this.cmz) * Math.sqrt(this.sqr(1.0 + this.cmz * (h - this.zm)) - 1.0) - this.xHorizontal * this.cm);
    }

    private void mnbrak(doubleW ax, doubleW bx, doubleW cx, doubleW fa, doubleW fb, doubleW fc) {
        fa.val = this.func(ax.val);
        fb.val = this.func(bx.val);
        cx.val = bx.val;
        fc.val = fb.val;
        bx.val = ax.val + 0.5 * (cx.val - ax.val);
        fb.val = this.func(bx.val);
        while (fb.val > fa.val || fb.val > fc.val) {
            if (cx.val - ax.val < 1.0E-8) {
                cx.val = bx.val = ax.val;
                fc.val = fb.val = fa.val;
                return;
            }
            cx.val = bx.val;
            fc.val = fb.val;
            bx.val = ax.val + 0.5 * (cx.val - ax.val);
            fb.val = this.func(bx.val);
        }
    }

    private double brent(double ax, double bx, double cx, double tol, doubleW xmin) {
        double fx;
        double v;
        int ITMAX = 100;
        double CGOLD = 0.381966;
        double ZEPS = 2.220446049250313E-19;
        double d = 0.0;
        double e = 0.0;
        double a = ax < cx ? ax : cx;
        double b = ax > cx ? ax : cx;
        double w = v = bx;
        double x = v;
        double fv = fx = this.func(x);
        double fw = fx;
        int iter = 0;
        while (iter < 100) {
            double u;
            double xm = 0.5 * (a + b);
            double tol1 = tol * Math.abs(x) + 2.220446049250313E-19;
            double tol2 = 2.0 * tol1;
            if (Math.abs(x - xm) <= tol2 - 0.5 * (b - a)) {
                xmin.val = x;
                return fx;
            }
            if (Math.abs(e) > tol1) {
                double r = (x - w) * (fx - fv);
                double q = (x - v) * (fx - fw);
                double p = (x - v) * q - (x - w) * r;
                if ((q = 2.0 * (q - r)) > 0.0) {
                    p = -p;
                }
                q = Math.abs(q);
                double etemp = e;
                e = d;
                if (Math.abs(p) >= Math.abs(0.5 * q * etemp) || p <= q * (a - x) || p >= q * (b - x)) {
                    e = x >= xm ? a - x : b - x;
                    d = 0.381966 * e;
                } else {
                    d = p / q;
                    u = x + d;
                    if (u - a < tol2 || b - u < tol2) {
                        d = this.SIGN(tol1, xm - x);
                    }
                }
            } else {
                e = x >= xm ? a - x : b - x;
                d = 0.381966 * e;
            }
            u = Math.abs(d) >= tol1 ? x + d : x + this.SIGN(tol1, d);
            double fu = this.func(u);
            if (fu <= fx) {
                if (u >= x) {
                    a = x;
                } else {
                    b = x;
                }
                v = w;
                w = x;
                x = u;
                fv = fw;
                fw = fx;
                fx = fu;
            } else {
                if (u < x) {
                    a = u;
                } else {
                    b = u;
                }
                if (fu <= fw || w == x) {
                    v = w;
                    w = u;
                    fv = fw;
                    fw = fu;
                } else if (fu <= fv || v == x || v == w) {
                    v = u;
                    fv = fu;
                }
            }
            ++iter;
        }
        String err = String.format("\nERROR in brent\nToo many iterations.\n", new Object[0]);
        this.setNAValues();
        throw new SLBMException(err, 305);
    }

    public String toString(int verbosity) {
        return null;
    }
}

