/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

import cn.org.gddsn.seis.location.rstt.CrustalProfile;
import cn.org.gddsn.seis.location.rstt.CrustalProfileStore;
import cn.org.gddsn.seis.location.rstt.DataBuffer;
import cn.org.gddsn.seis.location.rstt.GeoStack;
import cn.org.gddsn.seis.location.rstt.GreatCircle;
import cn.org.gddsn.seis.location.rstt.GridProfile;
import cn.org.gddsn.seis.location.rstt.LayerProfile;
import cn.org.gddsn.seis.location.rstt.LayerProfileG;
import cn.org.gddsn.seis.location.rstt.Location;
import cn.org.gddsn.seis.location.rstt.QueryProfile;
import cn.org.gddsn.seis.location.rstt.SLBMException;
import cn.org.gddsn.seis.location.rstt.Triangle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Grid {
    private String modelFileName;
    private String tessId = "";
    private String outputDirectory = "";
    private String inputDirectory;
    private Vector<GeoStack> geoStacks = new Vector();
    private Vector<GridProfile> profiles = new Vector();
    private Vector<Triangle> triangles = new Vector();
    private Vector<Triangle> specialTriangles = new Vector();
    private Vector<Integer> activeNodes = new Vector();
    private double cos_min;
    private double[] V0 = new double[2];
    private CrustalProfileStore sources = new CrustalProfileStore(this, 10);
    private CrustalProfileStore receivers = new CrustalProfileStore(this, 1000);

    protected void finalize() {
        this.clear();
    }

    public boolean equals(Grid other) {
        if (this.profiles.size() != other.profiles.size()) {
            return false;
        }
        int i = 0;
        while (i < this.profiles.size()) {
            if (!this.profiles.get(i).equals(other.profiles.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals_no(Grid other) {
        return !this.equals(other);
    }

    public void clear() {
        this.clearCrustalProfiles();
        this.profiles.clear();
        this.triangles.clear();
        this.specialTriangles.clear();
        this.geoStacks.clear();
        this.specialTriangles.clear();
        this.activeNodes.clear();
    }

    public void specifyOutputDirectory(String dirname) {
        this.outputDirectory = dirname;
    }

    public void saveVelocityModel(String filename) {
        if (filename.equals(this.modelFileName)) {
            String err = "\nERROR in saveVelocityModel\nOutput file name cannot equal input file name.\n";
            throw new SLBMException(err, 102);
        }
        try {
            PrintWriter fout = new PrintWriter(new FileWriter(filename));
            fout.printf("%d  %d %d 24\n", this.geoStacks.size(), this.profiles.size(), this.triangles.size());
            fout.printf("%.7f %.7f\n", this.V0[0], this.V0[1]);
            int i = 0;
            while (i < this.geoStacks.size()) {
                int k = 1;
                while (k < 9) {
                    if (k != 1 & k != 6) {
                        fout.printf(" %.7f", this.geoStacks.get(i).getDepth(k));
                    }
                    fout.printf(" %.7f %.7f", this.geoStacks.get(i).getVelocity(0, k), this.geoStacks.get(i).getVelocity(1, k));
                    ++k;
                }
                fout.printf(" %.7f %.7f\n", this.geoStacks.get(i).getMantleGradient(0), this.geoStacks.get(i).getMantleGradient(1));
                ++i;
            }
            i = 0;
            while (i < this.profiles.size()) {
                fout.printf("%.10f %.10f %.7f %.7f %.7f\n", this.profiles.get(i).getLat() * 57.29577951308232, this.profiles.get(i).getLon() * 57.29577951308232, -this.profiles.get(i).getDepth(), this.profiles.get(i).getWaterThick(), this.profiles.get(i).getGeoStackId());
                ++i;
            }
            i = 0;
            while (i < this.triangles.size()) {
                fout.printf("%d %d %d\n", this.triangles.get(i).getNode(0).getNodeId(), this.triangles.get(i).getNode(1).getNodeId(), this.triangles.get(i).getNode(2).getNodeId());
                ++i;
            }
            fout.close();
        }
        catch (IOException e) {
            String err = "\nERROR in saveVelocityModel\nCould not open file " + filename + "\n";
            throw new SLBMException(err, 103);
        }
    }

    public void saveVelocityModelBinary(DataBuffer buffer) {
        buffer.writeInt32(this.geoStacks.size());
        buffer.writeFloat((float)this.V0[0]);
        buffer.writeFloat((float)this.V0[1]);
        int i = 0;
        while (i < this.geoStacks.size()) {
            int k = 1;
            while (k < 9) {
                if (k != 6) {
                    buffer.writeFloat((float)this.geoStacks.get(i).getDepth(k));
                }
                buffer.writeFloat((float)this.geoStacks.get(i).getVelocity(0, k));
                buffer.writeFloat((float)this.geoStacks.get(i).getVelocity(1, k));
                ++k;
            }
            buffer.writeFloat((float)this.geoStacks.get(i).getMantleGradient(0));
            buffer.writeFloat((float)this.geoStacks.get(i).getMantleGradient(1));
            ++i;
        }
        buffer.writeString(this.tessId);
        buffer.writeInt32(this.profiles.size());
        i = 0;
        while (i < this.profiles.size()) {
            buffer.writeInt32(this.profiles.get(i).getGeoStackId());
            buffer.writeFloat((float)(-this.profiles.get(i).getDepth()));
            buffer.writeFloat((float)this.profiles.get(i).getWaterThick());
            ++i;
        }
        String s = "SLBM Tessellation";
        buffer.writeString(s);
        s = "Parameter list";
        buffer.writeString(s);
        s = "Comment";
        buffer.writeString(s);
        buffer.writeInt32(this.profiles.size());
        int i2 = 0;
        while (i2 < this.profiles.size()) {
            buffer.writeDouble(this.profiles.get(i2).getLatDegrees());
            buffer.writeDouble(this.profiles.get(i2).getLonDegrees());
            ++i2;
        }
        buffer.writeInt32(this.triangles.size());
        i2 = 0;
        while (i2 < this.triangles.size()) {
            int j = 0;
            while (j < 3) {
                buffer.writeInt32(this.triangles.get(i2).getNode(j).getNodeId());
                ++j;
            }
            ++i2;
        }
        buffer.writeInt32(0);
    }

    public int getBufferSize() {
        int bsiz = 0;
        bsiz += 16;
        bsiz += 2 * this.geoStacks.size() * 4;
        bsiz += 3 * this.geoStacks.size() * 8 * 4;
        bsiz += this.tessId.length() + 16;
        bsiz += this.profiles.size() * 12;
        bsiz += 72;
        bsiz += (this.profiles.size() * 2 + 1) * 8;
        return bsiz += 3 * (this.triangles.size() + 1) * 4;
    }

    public boolean is_directory(String dir) {
        return new File(dir).isDirectory();
    }

    public int getNNodes() {
        return this.profiles.size();
    }

    public int getNIntervals() {
        return 9;
    }

    public GridProfile getProfile(int n) {
        if (n < 0 || n >= this.getNNodes()) {
            String err = String.format("\nERROR in getProfile. NodeId is out of range.  %d is not between 0 and %d\n", n, this.getNNodes() - 1);
            throw new SLBMException(err, 107);
        }
        return this.profiles.get(n);
    }

    public GreatCircle getGreatCircle(int phase, double latSource, double lonSource, double depthSource, double latReceiver, double lonReceiver, double depthReceiver, double delta, double ch_max) {
        return GreatCircle.create(phase, this, latSource, lonSource, depthSource, latReceiver, lonReceiver, depthReceiver, ch_max);
    }

    public CrustalProfile getSourceProfile(int phase, double lat, double lon, double depth) {
        return this.sources.getCrustalProfile(phase, lat, lon, depth);
    }

    public CrustalProfile getReceiverProfile(int phase, double lat, double lon, double depth) {
        return this.receivers.getCrustalProfile(phase, lat, lon, depth);
    }

    public void clearCrustalProfiles() {
        this.receivers.clear();
        this.sources.clear();
    }

    public LayerProfile getLayerProfile(GreatCircle gc, Location location) {
        if (gc.getPhase() / 2 == 0) {
            return new LayerProfileG(gc, location);
        }
        return new LayerProfile(gc, location);
    }

    public QueryProfile getQueryProfile(Location location) {
        return new QueryProfile(this, location);
    }

    public double getAverageMantleVelocity(int waveType) {
        return this.V0[waveType];
    }

    public void setAverageMantleVelocity(int waveType, double velocity) {
        this.V0[waveType] = velocity;
    }

    public int getNCrustalProfiles() {
        return this.receivers.getNCrustalProfiles() + this.sources.getNCrustalProfiles();
    }

    public boolean findProfile(Location location, GridProfile[] neighbors, double[] coefficients) {
        Triangle tr = this.findTriangle(location, coefficients);
        int i = 0;
        while (i < 3) {
            neighbors[i] = tr.getNode(i);
            ++i;
        }
        return true;
    }

    public void initializeActiveNodes(double activeNodeLatMin, double activeNodeLonMin, double activeNodeLatMax, double activeNodeLonMax) {
        while (activeNodeLonMin < -Math.PI) {
            activeNodeLonMin += Math.PI * 2;
        }
        while (activeNodeLonMin >= Math.PI) {
            activeNodeLonMin -= Math.PI * 2;
        }
        while (activeNodeLonMax <= activeNodeLonMin) {
            activeNodeLonMax += Math.PI * 2;
        }
        while (activeNodeLonMax > activeNodeLonMin + Math.PI * 2) {
            activeNodeLonMax -= Math.PI * 2;
        }
        int i = 0;
        while (i < this.triangles.size()) {
            boolean active = false;
            int j = 0;
            while (j < 3) {
                double lat;
                double lon = this.triangles.get(i).getNode(j).getLon();
                if (lon < activeNodeLonMin) {
                    lon += Math.PI * 2;
                }
                if (lon <= activeNodeLonMax && (lat = this.triangles.get(i).getNode(j).getLat()) >= activeNodeLatMin && lat <= activeNodeLatMax) {
                    active = true;
                    break;
                }
                ++j;
            }
            if (active) {
                j = 0;
                while (j < 3) {
                    if (this.triangles.get(i).getNode(j).getActiveNodeId() < 0) {
                        this.triangles.get(i).getNode(j).setActiveNodeId(this.activeNodes.size());
                        this.activeNodes.add(this.triangles.get(i).getNode(j).getNodeId());
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public int getNActiveNodes() {
        return this.activeNodes.size();
    }

    public int getGridNodeId(int activeNodeId) {
        return activeNodeId < 0 ? -1 : this.activeNodes.get(activeNodeId);
    }

    public int getActiveNodeId(int nodeId) {
        return this.profiles.get(nodeId).getActiveNodeId();
    }

    public void getNodeNeighbors(int nodeid, int[] neighbors, intW nNeighbors) {
        double[] coeff = new double[3];
        Triangle start = this.findTriangle(this.profiles.get(nodeid), coeff);
        TreeSet<Integer> nbrs = new TreeSet<Integer>();
        start.findNodeNeighbors(nodeid, nbrs);
        nNeighbors.val = 0;
        for (Integer it : nbrs) {
            neighbors[nNeighbors.val++] = this.profiles.get(it).getNodeId();
        }
    }

    public void getNodeNeighbors(int nodeid, Vector<Integer> neighbors) {
        double[] coeff = new double[3];
        Triangle start = this.findTriangle(this.profiles.get(nodeid), coeff);
        TreeSet<Integer> nbrs = new TreeSet<Integer>();
        start.findNodeNeighbors(nodeid, nbrs);
        neighbors.clear();
        for (Integer it : nbrs) {
            neighbors.add(this.profiles.get(it).getNodeId());
        }
    }

    public void getNodeNeighborInfo(int nid, int[] neighbors, double[] distance, double[] azimuth, intW nNeighbors) {
        this.getNodeNeighbors(nid, neighbors, nNeighbors);
        int i = 0;
        while (i < nNeighbors.val) {
            doubleW w = new doubleW(distance[i]);
            this.getNodeSeparation(nid, neighbors[i], w);
            distance[i] = w.val;
            w = new doubleW(azimuth[i]);
            this.getNodeAzimuth(nid, neighbors[i], w);
            azimuth[i] = w.val;
            ++i;
        }
    }

    public void getNodeNeighborInfo(int nid, Vector<Integer> neighbors, Vector<Double> distance, Vector<Double> azimuth) {
        this.getNodeNeighbors(nid, neighbors);
        distance.setSize(neighbors.size());
        azimuth.setSize(neighbors.size());
        int i = 0;
        while (i < neighbors.size()) {
            doubleW w = new doubleW(distance.get(i).doubleValue());
            this.getNodeSeparation(nid, neighbors.get(i), w);
            distance.set(i, w.val);
            w = new doubleW(azimuth.get(i).doubleValue());
            this.getNodeAzimuth(nid, neighbors.get(i), w);
            azimuth.set(i, w.val);
            ++i;
        }
    }

    public void getActiveNodeNeighbors(int nodeid, Vector<Integer> neighbors) {
        double[] coeff = new double[3];
        int id = this.getGridNodeId(nodeid);
        Triangle start = this.findTriangle(this.profiles.get(id), coeff);
        TreeSet<Integer> nbrs = new TreeSet<Integer>();
        start.findNodeNeighbors(id, nbrs);
        neighbors.clear();
        for (int it : nbrs) {
            id = this.getActiveNodeId(this.profiles.get(it).getNodeId());
            if (id < 0) continue;
            neighbors.add(id);
        }
    }

    public void getActiveNodeNeighbors(int nodeid, int[] neighbors, intW nNeighbors) {
        double[] coeff = new double[3];
        int id = this.getGridNodeId(nodeid);
        Triangle start = this.findTriangle(this.profiles.get(id), coeff);
        TreeSet<Integer> nbrs = new TreeSet<Integer>();
        start.findNodeNeighbors(id, nbrs);
        nNeighbors.val = 0;
        for (int it : nbrs) {
            id = this.getActiveNodeId(this.profiles.get(it).getNodeId());
            if (id < 0) continue;
            neighbors[nNeighbors.val++] = id;
        }
    }

    public void getActiveNodeNeighborInfo(int nid, int[] neighbors, double[] distance, double[] azimuth, intW nNeighbors) {
        this.getActiveNodeNeighbors(nid, neighbors, nNeighbors);
        int id = this.getGridNodeId(nid);
        int i = 0;
        while (i < nNeighbors.val) {
            doubleW w = new doubleW(distance[i]);
            this.getNodeSeparation(id, this.getGridNodeId(neighbors[i]), w);
            distance[i] = w.val;
            w = new doubleW(azimuth[i]);
            this.getNodeAzimuth(id, this.getGridNodeId(neighbors[i]), w);
            azimuth[i] = w.val;
            ++i;
        }
    }

    public void getActiveNodeNeighborInfo(int nid, Vector<Integer> neighbors, Vector<Double> distance, Vector<Double> azimuth) {
        this.getActiveNodeNeighbors(nid, neighbors);
        int id = this.getGridNodeId(nid);
        distance.setSize(neighbors.size());
        azimuth.setSize(neighbors.size());
        int i = 0;
        while (i < neighbors.size()) {
            doubleW w = new doubleW(0.0);
            this.getNodeSeparation(id, this.getGridNodeId(neighbors.get(i)), w);
            distance.set(i, w.val);
            w = new doubleW(azimuth.get(i).doubleValue());
            this.getNodeAzimuth(id, this.getGridNodeId(neighbors.get(i)), w);
            azimuth.set(i, w.val);
            ++i;
        }
    }

    public void getNodeSeparation(int node1, int node2, doubleW distance) {
        distance.val = this.profiles.get(node1).distance(this.profiles.get(node2));
    }

    public void getNodeAzimuth(int node1, int node2, doubleW azimuth) {
        azimuth.val = this.profiles.get(node1).azimuth(this.profiles.get(node2));
    }

    public void getNodeHitCount(int nodeId, intW hitCount) {
        hitCount.val = this.profiles.get(nodeId).getHitCount();
    }

    public int addGeoStack(GeoStack geoStack) {
        this.geoStacks.add(geoStack);
        return this.geoStacks.size();
    }

    public int getGeoStacksSize() {
        return this.geoStacks.size();
    }

    public Vector<GeoStack> getGeoStacks() {
        return this.geoStacks;
    }

    public String getTessId() {
        return this.tessId;
    }

    public Vector<Triangle> getTriangles() {
        return this.triangles;
    }

    public void defineTessAdjacency(int nNodes, Vector<Vector<Triangle>> triset) {
        int i = 0;
        while (i < nNodes) {
            int j = 0;
            while (j < triset.get(i).size()) {
                int k = 0;
                block2: while (k < 3) {
                    if (triset.get(i).get(j).getNode(k).getNodeId() == this.profiles.get(i).getNodeId()) {
                        if (triset.get(i).get(j).getNeighbor(k) != null) break;
                        GridProfile nextNode = triset.get(i).get(j).getNode((k + 1) % 3);
                        boolean found = false;
                        int m = 0;
                        while (m < triset.get(i).size()) {
                            if (m != j) {
                                int n = 0;
                                while (n < 3) {
                                    if (triset.get(i).get(m).getNode(n) == nextNode) {
                                        triset.get(i).get(j).setNeighbor(k, triset.get(i).get(m));
                                        triset.get(i).get(m).setNeighbor(n, triset.get(i).get(j));
                                        found = true;
                                        break;
                                    }
                                    ++n;
                                }
                                if (found) break block2;
                            }
                            ++m;
                        }
                        break;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.findSpecialTriangles();
    }

    private Triangle findTriangle(Location location, double[] coefficients) {
        Triangle tr = null;
        double dmax = -1.0E30;
        int i = 0;
        while (i < this.specialTriangles.size()) {
            double dot = location.dot(this.specialTriangles.get(i).getNode(0));
            if (dot > dmax) {
                tr = this.specialTriangles.get(i);
                if (dot > this.cos_min) break;
                dmax = dot;
            }
            ++i;
        }
        tr = tr.walk(location, coefficients);
        this.specialTriangles.set(0, tr);
        return tr;
    }

    private void writeBufferToFile(DataBuffer buffer, String fileName) {
        try {
            FileOutputStream outFile = new FileOutputStream(fileName);
            buffer.writeToFile(outFile);
            outFile.close();
        }
        catch (IOException e) {
            String err = "\nERROR in writeBufferToFile().\nCannot open file " + fileName + "\n";
            throw new SLBMException(err, 105);
        }
    }

    private void reaDataBuffererFromFile(DataBuffer buffer, String dirname, String fileName) {
        File pathFile = new File(dirname, fileName);
        try {
            RandomAccessFile dataFile = new RandomAccessFile(pathFile, "r");
            int fileSize = (int)dataFile.length();
            buffer.readFromFile(dataFile, 0L, fileSize);
            buffer.resetPos();
            dataFile.close();
        }
        catch (IOException e) {
            String err = "\nERROR in reaDataBuffererFromFile\nCould not open file " + pathFile + "\n";
            throw new SLBMException(err, 106);
        }
    }

    private void findSpecialTriangles() {
        int nSpecial = 42;
        double[][] v = new double[42][3];
        int i = 0;
        v[i][0] = 0.0;
        v[i][1] = 0.0;
        v[i++][2] = 1.0;
        v[i][0] = 0.89442719099992;
        v[i][1] = -0.0;
        v[i++][2] = 0.44721359549996;
        v[i][0] = 0.27639320225002;
        v[i][1] = 0.85065080835204;
        v[i++][2] = 0.44721359549996;
        v[i][0] = -0.72360679774998;
        v[i][1] = 0.52573111211913;
        v[i++][2] = 0.44721359549996;
        v[i][0] = -0.72360679774998;
        v[i][1] = -0.52573111211913;
        v[i++][2] = 0.44721359549996;
        v[i][0] = 0.27639320225002;
        v[i][1] = -0.85065080835204;
        v[i++][2] = 0.44721359549996;
        v[i][0] = 0.72360679774998;
        v[i][1] = -0.52573111211913;
        v[i++][2] = -0.44721359549996;
        v[i][0] = 0.72360679774998;
        v[i][1] = 0.52573111211913;
        v[i++][2] = -0.44721359549996;
        v[i][0] = -0.27639320225002;
        v[i][1] = 0.85065080835204;
        v[i++][2] = -0.44721359549996;
        v[i][0] = -0.89442719099992;
        v[i][1] = 0.0;
        v[i++][2] = -0.44721359549996;
        v[i][0] = -0.27639320225002;
        v[i][1] = -0.85065080835204;
        v[i++][2] = -0.44721359549996;
        v[i][0] = 0.0;
        v[i][1] = 0.0;
        v[i++][2] = -1.0;
        v[i][0] = 0.16245984811645;
        v[i][1] = 0.5;
        v[i++][2] = 0.85065080835204;
        v[i][0] = 0.68819096023559;
        v[i][1] = 0.5;
        v[i++][2] = 0.52573111211913;
        v[i][0] = 0.52573111211913;
        v[i][1] = 0.0;
        v[i++][2] = 0.85065080835204;
        v[i][0] = -0.42532540417602;
        v[i][1] = 0.30901699437495;
        v[i++][2] = 0.85065080835204;
        v[i][0] = -0.26286555605957;
        v[i][1] = 0.80901699437495;
        v[i++][2] = 0.52573111211913;
        v[i][0] = -0.42532540417602;
        v[i][1] = -0.30901699437495;
        v[i++][2] = 0.85065080835204;
        v[i][0] = -0.85065080835204;
        v[i][1] = 0.0;
        v[i++][2] = 0.52573111211913;
        v[i][0] = 0.16245984811645;
        v[i][1] = -0.5;
        v[i++][2] = 0.85065080835204;
        v[i][0] = -0.26286555605957;
        v[i][1] = -0.80901699437495;
        v[i++][2] = 0.52573111211913;
        v[i][0] = 0.68819096023559;
        v[i][1] = -0.5;
        v[i++][2] = 0.52573111211913;
        v[i][0] = 0.58778525229247;
        v[i][1] = 0.80901699437495;
        v[i++][2] = 0.0;
        v[i][0] = 0.95105651629515;
        v[i][1] = 0.30901699437495;
        v[i++][2] = 0.0;
        v[i][0] = -0.58778525229247;
        v[i][1] = 0.80901699437495;
        v[i++][2] = 0.0;
        v[i][0] = 0.0;
        v[i][1] = 1.0;
        v[i++][2] = 0.0;
        v[i][0] = -0.95105651629515;
        v[i][1] = -0.30901699437495;
        v[i++][2] = 0.0;
        v[i][0] = -0.95105651629515;
        v[i][1] = 0.30901699437495;
        v[i++][2] = 0.0;
        v[i][0] = 0.0;
        v[i][1] = -1.0;
        v[i++][2] = 0.0;
        v[i][0] = -0.58778525229247;
        v[i][1] = -0.80901699437495;
        v[i++][2] = 0.0;
        v[i][0] = 0.95105651629515;
        v[i][1] = -0.30901699437495;
        v[i++][2] = 0.0;
        v[i][0] = 0.58778525229247;
        v[i][1] = -0.80901699437495;
        v[i++][2] = 0.0;
        v[i][0] = 0.85065080835204;
        v[i][1] = 0.0;
        v[i++][2] = -0.52573111211913;
        v[i][0] = 0.26286555605957;
        v[i][1] = 0.80901699437495;
        v[i++][2] = -0.52573111211913;
        v[i][0] = -0.68819096023559;
        v[i][1] = 0.5;
        v[i++][2] = -0.52573111211913;
        v[i][0] = -0.68819096023559;
        v[i][1] = -0.5;
        v[i++][2] = -0.52573111211913;
        v[i][0] = 0.26286555605957;
        v[i][1] = -0.80901699437495;
        v[i++][2] = -0.52573111211913;
        v[i][0] = 0.42532540417602;
        v[i][1] = 0.30901699437495;
        v[i++][2] = -0.85065080835204;
        v[i][0] = 0.42532540417602;
        v[i][1] = -0.30901699437495;
        v[i++][2] = -0.85065080835204;
        v[i][0] = -0.16245984811645;
        v[i][1] = 0.5;
        v[i++][2] = -0.85065080835204;
        v[i][0] = -0.52573111211913;
        v[i][1] = 0.0;
        v[i++][2] = -0.85065080835204;
        v[i][0] = -0.16245984811645;
        v[i][1] = -0.5;
        v[i++][2] = -0.85065080835204;
        this.cos_min = Math.cos(0.2792526803190927);
        double[] coefficients = new double[3];
        this.specialTriangles = new Vector(nSpecial + 1);
        this.specialTriangles.add(this.triangles.get(0));
        Location node = new Location();
        i = 0;
        while (i < nSpecial) {
            node.setUnitVector(v[i]);
            this.specialTriangles.add(this.findTriangle(node, coefficients));
            ++i;
        }
    }

    private void readGeoStacks(DataBuffer buffer) {
        int nStacks = buffer.readInt32();
        this.V0[0] = buffer.readFloat();
        this.V0[1] = buffer.readFloat();
        double[] depth = new double[9];
        double[] vp = new double[9];
        double[] vs = new double[9];
        double[] g = new double[2];
        this.geoStacks.setSize(nStacks);
        int i = 0;
        while (i < nStacks) {
            int k = 0;
            while (k < 9) {
                if (k == 0) {
                    depth[k] = 0.0;
                    vp[k] = 1.5;
                    vs[k] = 0.0;
                } else {
                    depth[k] = k == 6 ? depth[k - 1] : (double)buffer.readFloat();
                    vp[k] = buffer.readFloat();
                    vs[k] = buffer.readFloat();
                }
                ++k;
            }
            g[0] = buffer.readFloat();
            g[1] = buffer.readFloat();
            this.geoStacks.set(i, new GeoStack(i, depth, vp, vs, g));
            ++i;
        }
    }

    private void readConnectivity(DataBuffer buffer, intW nNodes, Vector<Float> elev, Vector<Float> waterThick, Vector<Integer> stackId) {
        this.tessId = buffer.readString();
        nNodes.val = buffer.readInt32();
        int i = 0;
        while (i < nNodes.val) {
            stackId.add(buffer.readInt32());
            elev.add(Float.valueOf(buffer.readFloat()));
            waterThick.add(Float.valueOf(buffer.readFloat()));
            ++i;
        }
    }

    private void readTessellationData(DataBuffer buffer, intW nNodes, Vector<Float> elev, Vector<Float> waterThick, Vector<Integer> stackId, Vector<Vector<Triangle>> triset) {
        String description = buffer.readString();
        System.out.print("Description: " + description + "\n");
        String parameters = buffer.readString();
        System.out.print("Parameters: " + parameters + "\n");
        String comments = buffer.readString();
        System.out.print("Comments: " + comments + "\n");
        nNodes.val = buffer.readInt32();
        this.profiles.setSize(nNodes.val);
        int i = 0;
        while (i < nNodes.val) {
            double lat = buffer.readDouble();
            double lon = buffer.readDouble();
            this.profiles.set(i, new GridProfile(this, i, lat * (Math.PI / 180), lon * (Math.PI / 180), elev.get(i).floatValue(), Math.abs(waterThick.get(i).floatValue()), this.geoStacks.get(stackId.get(i))));
            this.geoStacks.get(stackId.get(i)).incRefCount();
            if (this.geoStacks.get(stackId.get(i)).hasLowVelocityZone()) {
                String err = String.format("\nERROR in loadVelocityModelBinary\nGeostack has low velocity zone.\nNode ID, Stack Id = %d, %d\nNode lat, lon = %f, %f\n%s\n", i, stackId.get(i), lat, lon, this.geoStacks.get(stackId.get(i)).toString());
                throw new SLBMException(err, 504);
            }
            ++i;
        }
        int nTriangles = buffer.readInt32();
        triset.setSize(this.profiles.size());
        int i2 = 0;
        while (i2 < triset.size()) {
            triset.set(i2, new Vector(6));
            ++i2;
        }
        this.triangles.setSize(nTriangles);
        int i3 = 0;
        while (i3 < nTriangles) {
            int a = buffer.readInt32();
            int b = buffer.readInt32();
            int c = buffer.readInt32();
            this.triangles.set(i3, new Triangle(i3, this.profiles.get(a), this.profiles.get(b), this.profiles.get(c)));
            triset.get(a).add(this.triangles.get(i3));
            triset.get(b).add(this.triangles.get(i3));
            triset.get(c).add(this.triangles.get(i3));
            ++i3;
        }
    }

    public void loadVelocityModel(String filename) {
        this.modelFileName = filename;
        try {
            Scanner sc = new Scanner(new File(this.modelFileName));
            int nStacks = sc.nextInt();
            int nNodes = sc.nextInt();
            int nTriangles = sc.nextInt();
            int nData = sc.nextInt();
            if (nData != 24) {
                String err = "\nERROR in loadVelocityModel\nFile " + filename + " specifies a model with " + nData + "\n" + " data items per layer but the SLBM code expects models with 24 data items per layers.\n";
                throw new SLBMException(err, 503);
            }
            this.V0[0] = sc.nextDouble();
            this.V0[1] = sc.nextDouble();
            double[] depth = new double[9];
            double[] vp = new double[9];
            double[] vs = new double[9];
            double[] g = new double[2];
            this.geoStacks.clear();
            this.geoStacks.setSize(nStacks);
            int i = 0;
            while (i < nStacks) {
                int k = 0;
                while (k < 9) {
                    if (k == 0) {
                        depth[k] = 0.0;
                        vp[k] = 1.5;
                        vs[k] = 0.0;
                    } else {
                        depth[k] = k == 1 || k == 6 ? depth[k - 1] : sc.nextDouble();
                        vp[k] = sc.nextDouble();
                        vs[k] = sc.nextDouble();
                    }
                    ++k;
                }
                g[0] = sc.nextDouble();
                g[1] = sc.nextDouble();
                this.geoStacks.set(i, new GeoStack(i, depth, vp, vs, g));
                ++i;
            }
            this.profiles.clear();
            this.profiles.setSize(nNodes);
            i = 0;
            while (i < nNodes) {
                double lat = sc.nextDouble();
                double lon = sc.nextDouble();
                double elev = sc.nextDouble();
                double waterThick = sc.nextDouble();
                int stackId = sc.nextInt();
                this.profiles.set(i, new GridProfile(this, i, lat *= Math.PI / 180, lon *= Math.PI / 180, elev, Math.abs(waterThick), this.geoStacks.get(stackId)));
                this.geoStacks.get(stackId).incRefCount();
                ++i;
            }
            Vector<Vector<Triangle>> triset = new Vector<Vector<Triangle>>(this.profiles.size());
            int i2 = 0;
            while (i2 < triset.size()) {
                triset.add(new Vector(6));
                ++i2;
            }
            this.triangles.setSize(nTriangles);
            int i3 = 0;
            while (i3 < nTriangles) {
                int a = sc.nextInt();
                int b = sc.nextInt();
                int c = sc.nextInt();
                this.triangles.set(i3, new Triangle(i3, this.profiles.get(a), this.profiles.get(b), this.profiles.get(c)));
                triset.get(a).add(this.triangles.get(i3));
                triset.get(b).add(this.triangles.get(i3));
                triset.get(c).add(this.triangles.get(i3));
                ++i3;
            }
            this.defineTessAdjacency(nNodes, triset);
            sc.close();
        }
        catch (FileNotFoundException e) {
            String err = "\nERROR in loadVelocityModel\nCould not open file " + filename + "\n";
            throw new SLBMException(err, 101);
        }
        this.activeNodes.clear();
        this.tessId = "";
    }

    public void loadVelocityModelBinary(DataBuffer buffer) {
        this.readGeoStacks(buffer);
        Vector<Float> elev = new Vector<Float>();
        Vector<Float> waterThick = new Vector<Float>();
        Vector<Integer> stackId = new Vector<Integer>();
        intW nNodes = new intW(0);
        this.readConnectivity(buffer, nNodes, elev, waterThick, stackId);
        Vector<Vector<Triangle>> triset = new Vector<Vector<Triangle>>();
        this.readTessellationData(buffer, nNodes, elev, waterThick, stackId, triset);
        buffer.readInt32();
        this.defineTessAdjacency(nNodes.val, triset);
    }

    public void loadVelocityModelBinary(String dirname) {
        DataBuffer buffer = new DataBuffer();
        this.clear();
        this.inputDirectory = dirname;
        String filename = "geostacks";
        this.reaDataBuffererFromFile(buffer, this.inputDirectory, filename);
        this.readGeoStacks(buffer);
        buffer.clear();
        filename = "connectivity";
        this.reaDataBuffererFromFile(buffer, this.inputDirectory, filename);
        Vector<Float> elev = new Vector<Float>();
        Vector<Float> waterThick = new Vector<Float>();
        Vector<Integer> stackId = new Vector<Integer>();
        intW nNodes = new intW(0);
        this.readConnectivity(buffer, nNodes, elev, waterThick, stackId);
        buffer.clear();
        filename = "../tess/" + this.tessId;
        this.reaDataBuffererFromFile(buffer, this.inputDirectory, filename);
        Vector<Vector<Triangle>> triset = new Vector<Vector<Triangle>>();
        this.readTessellationData(buffer, nNodes, elev, waterThick, stackId, triset);
        this.defineTessAdjacency(nNodes.val, triset);
    }

    public void saveVelocityModelBinary() {
        String filename;
        DataBuffer buffer = new DataBuffer();
        if (this.outputDirectory.length() == 0) {
            String err = String.format("\nERROR in saveVelocityModelBinary()\noutputDirectory = <emptyString>.  Specify outputDirectory with call to method specifyOutpuDirectory()\n", new Object[0]);
            throw new SLBMException(err, 104);
        }
        if (this.tessId.length() == 0) {
            buffer.reserve(this.profiles.size() * 2 * 8 + this.triangles.size() * 3 * 4 + 1000);
            String s = "SLBM Tessellation";
            buffer.writeString(s);
            s = "Parameter list";
            buffer.writeString(s);
            s = "Comment";
            buffer.writeString(s);
            buffer.writeInt32(this.profiles.size());
            int i = 0;
            while (i < this.profiles.size()) {
                buffer.writeDouble(this.profiles.get(i).getLatDegrees());
                buffer.writeDouble(this.profiles.get(i).getLonDegrees());
                ++i;
            }
            buffer.writeInt32(this.triangles.size());
            i = 0;
            while (i < this.triangles.size()) {
                int j = 0;
                while (j < 3) {
                    buffer.writeInt32(this.triangles.get(i).getNode(j).getNodeId());
                    ++j;
                }
                ++i;
            }
            buffer.writeInt32(0);
            this.tessId = buffer.generateDataBufMD5HashKey();
            filename = String.valueOf(this.outputDirectory) + "/../tess/" + this.tessId;
            this.writeBufferToFile(buffer, filename);
            buffer.clear();
            buffer.reserve(this.profiles.size() * 7 * 4);
            buffer.writeString(this.tessId);
            buffer.writeInt32(this.profiles.size());
            Vector<Integer> neighbors = new Vector<Integer>(this.profiles.size());
            Vector<Double> azimuth = new Vector<Double>(this.profiles.size());
            Vector<Double> distance = new Vector<Double>(this.profiles.size());
            TreeMap<Double, Integer> nodeOrder = new TreeMap<Double, Integer>();
            int i2 = 0;
            while (i2 < this.profiles.size()) {
                this.getNodeNeighborInfo(this.profiles.get(i2).getNodeId(), neighbors, distance, azimuth);
                nodeOrder.clear();
                int j = 0;
                while (j < neighbors.size()) {
                    nodeOrder.put(-azimuth.get(j).doubleValue(), neighbors.get(j));
                    ++j;
                }
                buffer.writeInt32(neighbors.size());
                Iterator iterator = nodeOrder.values().iterator();
                while (iterator.hasNext()) {
                    int it = (Integer)iterator.next();
                    buffer.writeInt32(it);
                }
                ++i2;
            }
            filename = String.valueOf(this.outputDirectory) + "/../tess/" + this.tessId + "_adjacency";
            this.writeBufferToFile(buffer, filename);
            buffer.clear();
        }
        buffer.reserve(this.geoStacks.size() * 3 * 9 * 4 + 1000);
        buffer.writeInt32(this.geoStacks.size());
        buffer.writeFloat((float)this.V0[0]);
        buffer.writeFloat((float)this.V0[1]);
        int i = 0;
        while (i < this.geoStacks.size()) {
            int k = 1;
            while (k < 9) {
                if (k != 6) {
                    buffer.writeFloat((float)this.geoStacks.get(i).getDepth(k));
                }
                buffer.writeFloat((float)this.geoStacks.get(i).getVelocity(0, k));
                buffer.writeFloat((float)this.geoStacks.get(i).getVelocity(1, k));
                ++k;
            }
            buffer.writeFloat((float)this.geoStacks.get(i).getMantleGradient(0));
            buffer.writeFloat((float)this.geoStacks.get(i).getMantleGradient(1));
            ++i;
        }
        filename = String.valueOf(this.outputDirectory) + "/geostacks";
        this.writeBufferToFile(buffer, filename);
        buffer.clear();
        buffer.reserve(this.profiles.size() * 12 + 1000);
        buffer.writeString(this.tessId);
        buffer.writeInt32(this.profiles.size());
        i = 0;
        while (i < this.profiles.size()) {
            buffer.writeInt32(this.profiles.get(i).getGeoStackId());
            buffer.writeFloat((float)(-this.profiles.get(i).getDepth()));
            buffer.writeFloat((float)this.profiles.get(i).getWaterThick());
            ++i;
        }
        filename = String.valueOf(this.outputDirectory) + "/connectivity";
        this.writeBufferToFile(buffer, filename);
        buffer.clear();
    }
}

