/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

import cn.org.gddsn.seis.location.rstt.GeoStack;
import cn.org.gddsn.seis.location.rstt.Grid;
import cn.org.gddsn.seis.location.rstt.Location;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridProfile
extends Location {
    static int gridProfileClassCount = 0;
    Grid grid = new Grid();
    int nodeId;
    double waterThick;
    GeoStack geoStack;
    double weight;
    int activeNodeId;
    int nHits;

    public GridProfile(Grid g, int i, double lat, double lon, double elev, double zwater, GeoStack gstack) {
        super(lat, lon, -elev);
        this.grid = g;
        this.nodeId = i;
        this.activeNodeId = -1;
        this.geoStack = gstack;
        this.weight = -999999.0;
        this.nHits = 0;
        ++gridProfileClassCount;
        this.waterThick = zwater > 0.0 && elev < 0.0 ? Math.abs(elev) : 0.0;
    }

    public GridProfile(GridProfile other) {
        this.grid = other.grid;
        this.activeNodeId = other.activeNodeId;
        this.geoStack = other.geoStack;
        this.waterThick = other.waterThick;
        this.weight = other.weight;
        this.nHits = other.nHits;
        ++gridProfileClassCount;
        this.geoStack.incRefCount();
    }

    public void addWeight(double w) {
        this.weight += w;
    }

    public void clearHitCount() {
        this.nHits = 0;
    }

    public GridProfile copy(GridProfile other) {
        this.geoStack = other.geoStack;
        this.geoStack.incRefCount();
        this.waterThick = other.waterThick;
        this.weight = other.weight;
        this.nHits = other.nHits;
        return this;
    }

    @Override
    protected void finalize() {
        --gridProfileClassCount;
    }

    public int getActiveNodeId() {
        return this.activeNodeId;
    }

    public void getData(double[] d, double[] pv, double[] sv, double[] g) {
        double r = this.getEarthRadius();
        int k = 0;
        while (k < 9) {
            d[k] = r - this.getInterfaceRadius(k);
            pv[k] = this.geoStack.getVelocity(0, k);
            sv[k] = this.geoStack.getVelocity(1, k);
            ++k;
        }
        g[0] = this.geoStack.getMantleGradient(0);
        g[1] = this.geoStack.getMantleGradient(1);
    }

    public int getGeoStackId() {
        return this.geoStack.getIndex();
    }

    public int getHitCount() {
        return this.nHits;
    }

    public double getInterfaceDepth(int k) {
        return this.getEarthRadius() - this.getInterfaceRadius(k);
    }

    public void getInterfaceDepths(Vector<Double> depths) {
        depths.setSize(9);
        double r = this.getEarthRadius();
        int k = 0;
        while (k < 9) {
            depths.set(k, r - this.getInterfaceRadius(k));
            ++k;
        }
    }

    public double getInterfaceRadius(int k) {
        if (k > 0) {
            return this.radius - this.geoStack.getDepth(k);
        }
        return this.radius + this.waterThick;
    }

    public double[] getMantleGradient() {
        return this.geoStack.getMantleGradient();
    }

    public double getMantleGradient(int waveType) {
        return this.geoStack.getMantleGradient(waveType);
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public double[] getVelocity(int waveType) {
        return this.geoStack.getVelocity(waveType);
    }

    public double getVelocity(int waveType, int k) {
        return this.geoStack.getVelocity(waveType, k);
    }

    public double getWaterThick() {
        return this.waterThick;
    }

    public double getWeight() {
        return this.weight;
    }

    public void incrementHitCount() {
        ++this.nHits;
    }

    public void setActiveNodeId(int id) {
        this.activeNodeId = id;
    }

    public void setData(double[] depths, double[] pvelocities, double[] svelocities, double[] gradients) {
        if (this.geoStack.getRefCount() > 1) {
            this.geoStack.decRefCount();
            this.geoStack = new GeoStack(this.geoStack);
            this.geoStack.setIndex(this.grid.addGeoStack(this.geoStack) - 1);
        }
        double[] z0 = new double[9];
        this.setDepth(depths[0]);
        int i = 0;
        while (i < 9) {
            z0[i] = depths[i] - depths[0];
            ++i;
        }
        this.geoStack.setData(z0, pvelocities, svelocities, gradients);
        if (this.geoStack.hasLowVelocityZone()) {
            System.err.printf("\nERROR in setData\n", new Object[0]);
            System.err.printf("Geostack has low velocity zone.", new Object[0]);
            System.err.printf("Node ID, lat, lon = %d, %.4f, %.4f\n%s\n", this.nodeId, this.getLatDegrees(), this.getLonDegrees(), this.geoStack.toString());
        }
    }

    public void setGradient(Vector<Double> gradient) {
        if (this.geoStack.getRefCount() > 1) {
            this.geoStack.decRefCount();
            this.geoStack = new GeoStack(this.geoStack);
            this.geoStack.setIndex(this.grid.addGeoStack(this.geoStack) - 1);
        }
        this.geoStack.setGradient(gradient);
    }

    public void setVelocity(int waveType, Vector<Double> velocity) {
        if (this.geoStack.getRefCount() > 1) {
            this.geoStack.decRefCount();
            this.geoStack = new GeoStack(this.geoStack);
            this.geoStack.setIndex(this.grid.addGeoStack(this.geoStack) - 1);
        }
        this.geoStack.setVelocity(waveType, velocity);
    }

    public void setWeight(double w) {
        this.weight = w;
    }

    public void setDepths(Vector<Double> depths) {
        if (this.geoStack.getRefCount() > 1) {
            this.geoStack.decRefCount();
            this.geoStack = new GeoStack(this.geoStack);
            this.geoStack.setIndex(this.grid.addGeoStack(this.geoStack) - 1);
        }
        Vector<Double> z = new Vector<Double>(9);
        this.setDepth(depths.get(0));
        int i = 0;
        while (i < 9) {
            z.set(i, depths.get(i) - depths.get(0));
            ++i;
        }
        this.geoStack.setDepth(z);
    }

    public static int getClassCount() {
        return gridProfileClassCount;
    }
}

