/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

import cn.org.gddsn.seis.location.rstt.GreatCircle;
import cn.org.gddsn.seis.location.rstt.InterpolatedProfile;
import cn.org.gddsn.seis.location.rstt.Location;

public class LayerProfile
extends InterpolatedProfile {
    protected static int layerProfileClassCount;
    protected double radius;
    protected double velocity;

    public LayerProfile(GreatCircle greatCircle, Location loc) {
        super(greatCircle.getGrid(), loc);
        ++layerProfileClassCount;
        double[] w = new double[]{this.radius};
        this.interpRadius(greatCircle.getHeadWaveInterface(), w, 0);
        this.radius = w[0];
        w[0] = this.velocity;
        this.interpVelocity(greatCircle.getPhase() % 2, greatCircle.getHeadWaveInterface(), w, 0);
        this.velocity = w[0];
    }

    public LayerProfile(LayerProfile other) {
        super(other);
        this.radius = other.radius;
        this.velocity = other.velocity;
        ++layerProfileClassCount;
    }

    public LayerProfile copy(LayerProfile other) {
        super.copy(other);
        this.radius = other.radius;
        this.velocity = other.velocity;
        return this;
    }

    public boolean equals(LayerProfile other) {
        return super.equals(other) && this.radius == other.radius && this.velocity == other.velocity;
    }

    public boolean equals_no(LayerProfile other) {
        return !this.equals(other);
    }

    public int nIntervals() {
        return 1;
    }

    public double getRadius() {
        return this.radius;
    }

    double getVelocity() {
        return this.velocity;
    }

    public double getGradient() {
        return -999999.0;
    }

    protected void finalize() {
        --layerProfileClassCount;
    }

    public static int getClassCount() {
        return layerProfileClassCount;
    }
}

