/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

import cn.org.gddsn.seis.location.rstt.Grid;
import cn.org.gddsn.seis.location.rstt.InterpolatedProfile;
import cn.org.gddsn.seis.location.rstt.Location;
import org.netlib.util.doubleW;

public class QueryProfile
extends InterpolatedProfile {
    private static int queryProfileClassCount = 0;
    private Location location;
    private double[] depth = new double[9];
    private double[] pvelocity = new double[9];
    private double[] svelocity = new double[9];
    private double[] gradient = new double[2];
    private int[] nodeId = new int[3];

    public QueryProfile(Grid grid, Location loc) {
        super(grid, loc);
        ++queryProfileClassCount;
        this.location = loc;
        double R = this.location.getEarthRadius();
        int k = 0;
        while (k < 9) {
            this.interpRadius(k, this.depth, k);
            this.depth[k] = R - this.depth[k];
            this.interpVelocity(0, k, this.pvelocity, k);
            this.interpVelocity(1, k, this.svelocity, k);
            ++k;
        }
        this.interpGradient(0, this.gradient, 0);
        this.interpGradient(1, this.gradient, 1);
        this.getNodeIds(this.nodeId);
    }

    public QueryProfile(QueryProfile other) {
        super(other);
        ++queryProfileClassCount;
        int i = 0;
        while (i < 9) {
            this.depth[i] = other.depth[i];
            this.pvelocity[i] = other.pvelocity[i];
            this.svelocity[i] = other.svelocity[i];
            ++i;
        }
        this.gradient[0] = other.gradient[0];
        this.gradient[1] = other.gradient[1];
    }

    public QueryProfile copy(QueryProfile other) {
        super.copy(other);
        int i = 0;
        while (i < 9) {
            this.depth[i] = other.depth[i];
            this.pvelocity[i] = other.pvelocity[i];
            this.svelocity[i] = other.svelocity[i];
            ++i;
        }
        this.gradient[0] = other.gradient[0];
        this.gradient[1] = other.gradient[1];
        return this;
    }

    public boolean equals(QueryProfile other) {
        if (!super.equals(other)) {
            return false;
        }
        int i = 0;
        while (i < 9) {
            if (this.depth[i] != other.depth[i]) {
                return false;
            }
            if (this.pvelocity[i] != other.pvelocity[i]) {
                return false;
            }
            if (this.svelocity[i] != other.svelocity[i]) {
                return false;
            }
            ++i;
        }
        if (this.gradient[0] != other.gradient[0]) {
            return false;
        }
        return this.gradient[1] == other.gradient[1];
    }

    public boolean equal_no(QueryProfile other) {
        return !this.equals(other);
    }

    public int nIntervals() {
        return 9;
    }

    public void getData(int[] nodeIds, double[] c, double[] d, double[] pv, double[] sv, doubleW pg, doubleW sg) {
        this.getNodeIds(nodeIds);
        int i = 0;
        while (i < 3) {
            c[i] = this.coefficients[i];
            ++i;
        }
        i = 0;
        while (i < 9) {
            d[i] = this.depth[i];
            pv[i] = this.pvelocity[i];
            sv[i] = this.svelocity[i];
            ++i;
        }
        pg.val = this.gradient[0];
        sg.val = this.gradient[1];
    }

    public int[] getNodeId() {
        return this.nodeId;
    }

    public double[] getCoefficients() {
        return this.coefficients;
    }

    public double[] getDepth() {
        return this.depth;
    }

    public double[] getVelocity(int waveType) {
        return waveType == 0 ? this.pvelocity : this.svelocity;
    }

    public double[] getMantleGradient() {
        return this.gradient;
    }

    public String toString() {
        return "QueryProfile.toString() not implemented yet.\n";
    }

    protected void finalize() {
        --queryProfileClassCount;
    }

    public static int getClassCount() {
        return queryProfileClassCount;
    }
}

