/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

public class QueryProfileData {
    public double lat;
    public double lon;
    public double[] depth = new double[0];
    public double[][] velocity = new double[2][0];
    public double[] gradient = new double[0];
    public int[] nodeId = new int[0];
    public double[] coefficient = new double[0];

    public int getNIntervals() {
        return this.depth.length;
    }

    public int getNCoefficients() {
        return this.nodeId.length;
    }

    public String toString() {
        StringBuffer s = new StringBuffer("QueryProfile: \n");
        s.append(String.format("   Latitude : %10.4f%n", Math.toDegrees(this.lat)));
        s.append(String.format("   Longitude: %10.4f%n%n", Math.toDegrees(this.lon)));
        s.append("     Depth        Thick      P Vel      S Vel\n");
        int i = 0;
        while (i < this.getNIntervals() - 1) {
            s.append(String.format("%12.6f %10.4f %10.4f %10.4f%n", this.depth[i], this.depth[i + 1] - this.depth[i], this.velocity[0][i], this.velocity[1][i]));
            ++i;
        }
        i = this.getNIntervals() - 1;
        s.append(String.format("%12.6f %10s %10.4f %10.4f%n", this.depth[i], " ", this.velocity[0][i], this.velocity[1][i]));
        s.append("               P Grad     S Grad\n");
        s.append(String.format("%12s %10.6f %10.6f%n%n", "", this.gradient[0], this.gradient[1]));
        s.append(String.format("    NodeId      Coeff%n", new Object[0]));
        i = 0;
        while (i < this.nodeId.length) {
            s.append(String.format("%10d %10.4f%n", this.nodeId[i], this.coefficient[i]));
            ++i;
        }
        s.append('\n');
        return s.toString();
    }
}

