/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

import cn.org.gddsn.seis.location.rstt.Brents;
import cn.org.gddsn.seis.location.rstt.SplitDistance;
import cn.org.gddsn.seis.location.rstt.TPVelocityLayer;
import cn.org.gddsn.seis.location.rstt.TPZeroFunctional;
import cn.org.gddsn.seis.location.rstt.TauPException;
import cn.org.gddsn.seis.location.rstt.TravelTimeResult;
import cn.org.gddsn.seis.location.rstt.VelocityConst;
import cn.org.gddsn.seis.location.rstt.VelocityCubic;
import cn.org.gddsn.seis.location.rstt.VelocityLinear;
import cn.org.gddsn.seis.location.rstt.VelocityQuadratic;
import java.io.CharArrayWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.netlib.util.doubleW;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TauPSite {
    private static int tpsClassCount = 0;
    private static final double tpsDerivStepSize = 1.0E-7;
    private static final double tpsBrentsZeroInTol = 1.0E-6;
    private static Vector<TravelTimeResult> tpsReuseTTR = new Vector();
    private Vector<TPVelocityLayer> tpsVLayer = new Vector();
    private boolean tpsIsVelModlOwned;
    private String tpsRcvrName;
    private String tpsRcvrPhase;
    private String tpsModelName;
    private double tpsRcvrRad;
    private double tpsRcvrDepth;
    private double tpsSrcRad;
    private double tpsSrcDepth;
    private double tpsDist;
    private double tpsLastDist;
    private double tpsLastDepth;
    private TPZeroFunctional tpsZeroF = new TPZeroFunctional();
    private Brents tpsZeroIn = new Brents();
    private TreeMap<Double, TravelTimeResult> tpsTTR = new TreeMap();

    public void setSiteDepth(double depth) {
        this.tpsRcvrDepth = depth;
        this.tpsZeroF.setReceiverDepth(depth);
        this.tpsRcvrRad = this.tpsZeroF.getReceiverRadius();
    }

    public String class_name() {
        return "TauPSite";
    }

    public String get_class_name() {
        return this.class_name();
    }

    public String commonName() {
        return "1-D Radial TauP Travel Time Site Model";
    }

    public String getCommonName() {
        return this.commonName();
    }

    public String getName() {
        return this.tpsRcvrName;
    }

    public String getPhase() {
        return this.tpsRcvrPhase;
    }

    public void setModelName(String modname) {
        this.tpsModelName = modname;
    }

    public String getModelName() {
        return this.tpsModelName;
    }

    public Vector<TPVelocityLayer> getVelocityModels() {
        return this.tpsVLayer;
    }

    public void setEarthRadius(double r) {
        this.tpsZeroF.setPlanetRadius(r);
    }

    public double getEarthRadius() {
        return this.tpsZeroF.getPlanetRadius();
    }

    public void setBrentsTolerance(double tol) {
        this.tpsZeroIn.setTolerance(tol);
    }

    public double getBrentsTolerance() {
        return this.tpsZeroIn.getTolerance();
    }

    public TreeMap<Double, TravelTimeResult> getAllTravelTimes() {
        return this.tpsTTR;
    }

    public TauPSite() {
        ++tpsClassCount;
        this.tpsModelName = "";
        this.tpsIsVelModlOwned = false;
        this.tpsDist = 0.0;
        this.tpsSrcRad = 0.0;
        this.tpsSrcDepth = 0.0;
        this.tpsRcvrName = "";
        this.tpsRcvrRad = 0.0;
        this.tpsRcvrDepth = 0.0;
        this.tpsRcvrPhase = "";
        this.tpsLastDist = -1.0;
        this.tpsLastDepth = -1.0;
        this.tpsZeroF.setTauPSite(this);
        this.tpsZeroIn.setF(this.tpsZeroF);
        this.tpsZeroIn.setTolerance(1.0E-6);
    }

    public TauPSite(String staname, String phase) {
        this.tpsIsVelModlOwned = false;
        this.tpsDist = 0.0;
        this.tpsModelName = "";
        this.tpsSrcRad = 0.0;
        this.tpsSrcDepth = 0.0;
        this.tpsRcvrName = staname;
        this.tpsRcvrRad = 0.0;
        this.tpsRcvrDepth = 0.0;
        this.tpsRcvrPhase = phase;
        this.tpsLastDist = -1.0;
        this.tpsLastDepth = -1.0;
        ++tpsClassCount;
        this.tpsZeroF.setTauPSite(this);
        this.tpsZeroIn.setF(this.tpsZeroF);
        this.tpsZeroIn.setTolerance(1.0E-6);
    }

    TauPSite(TauPSite tps) {
        this.tpsIsVelModlOwned = tps.tpsIsVelModlOwned;
        this.tpsDist = tps.tpsDist;
        this.tpsModelName = tps.tpsModelName;
        this.tpsSrcRad = tps.tpsSrcRad;
        this.tpsSrcDepth = tps.tpsSrcDepth;
        this.tpsRcvrName = tps.tpsRcvrName;
        this.tpsRcvrRad = tps.tpsRcvrRad;
        this.tpsRcvrDepth = tps.tpsRcvrDepth;
        this.tpsRcvrPhase = tps.tpsRcvrPhase;
        this.tpsLastDist = -1.0;
        this.tpsLastDepth = -1.0;
        ++tpsClassCount;
        this.tpsZeroF.setTauPSite(this);
        this.tpsZeroIn.setF(this.tpsZeroF);
        this.tpsZeroIn.setTolerance(1.0E-6);
        this.tpsZeroF.setPTop(tps.tpsZeroF.getPTop());
        int i = 0;
        while (i < tps.tpsVLayer.size()) {
            if (this.tpsIsVelModlOwned) {
                this.tpsVLayer.add(TPVelocityLayer.newModelCopy(tps.tpsVLayer.get(i)));
            } else {
                this.tpsVLayer.add(tps.tpsVLayer.get(i));
            }
            ++i;
        }
    }

    protected void finalize() {
        this.tpsTTR.clear();
        this.clearVelocityModels();
        if (--tpsClassCount == 0) {
            tpsReuseTTR.clear();
        }
    }

    TauPSite copy(TauPSite tps) {
        this.tpsIsVelModlOwned = tps.tpsIsVelModlOwned;
        this.tpsDist = tps.tpsDist;
        this.tpsSrcRad = tps.tpsSrcRad;
        this.tpsSrcDepth = tps.tpsSrcDepth;
        this.tpsRcvrName = tps.tpsRcvrName;
        this.tpsRcvrRad = tps.tpsRcvrRad;
        this.tpsRcvrDepth = tps.tpsRcvrDepth;
        this.tpsRcvrPhase = tps.tpsRcvrPhase;
        this.tpsModelName = tps.tpsModelName;
        this.tpsZeroF.setPTop(tps.tpsZeroF.getPTop());
        int i = 0;
        while (i < tps.tpsVLayer.size()) {
            if (this.tpsIsVelModlOwned) {
                this.tpsVLayer.add(TPVelocityLayer.newModelCopy(tps.tpsVLayer.get(i)));
            } else {
                this.tpsVLayer.add(tps.tpsVLayer.get(i));
            }
            ++i;
        }
        return this;
    }

    public void setVelocityModels(Vector<TPVelocityLayer> vm) {
        this.clearVelocityModels();
        this.tpsIsVelModlOwned = false;
        this.tpsVLayer = vm;
    }

    public void appendVelocityModel(TPVelocityLayer vm) {
        if (this.tpsVLayer.size() > 0) {
            if (this.tpsIsVelModlOwned) {
                this.tpsVLayer.add(TPVelocityLayer.newModelCopy(vm));
            } else {
                this.tpsVLayer.add(vm);
            }
        } else {
            this.tpsVLayer.add(vm);
            this.tpsIsVelModlOwned = false;
        }
    }

    public void clearVelocityModels() {
        if (this.tpsIsVelModlOwned) {
            int i = 0;
            while (i < this.tpsVLayer.size()) {
                this.tpsVLayer.set(i, null);
                ++i;
            }
        }
        this.tpsVLayer.clear();
        this.tpsIsVelModlOwned = false;
    }

    public void calculateTravelTimes(double srcdist, double srcdepth, boolean evalderivs) {
        double pT = 0.0;
        double pB = 0.0;
        double derivstep = 1.0E-7;
        if (this.tpsVLayer.size() > 0) {
            TravelTimeResult ttr;
            if (srcdist == this.tpsLastDist && srcdepth == this.tpsLastDepth) {
                return;
            }
            this.tpsLastDist = srcdist;
            this.tpsLastDepth = srcdepth;
            if (this.tpsVLayer.get(0).getPmin() == -1.0) {
                this.findLimits();
            }
            this.clearTTRMap();
            this.tpsZeroF.setDist(srcdist);
            this.tpsZeroF.setSourceDepth(srcdepth);
            double pMin = this.tpsZeroF.getMinP();
            this.tpsZeroF.setPTop(this.tpsVLayer.get(0).getPt());
            this.tpsZeroF.setUpGoingZero();
            double tpzeroT = this.tpsZeroF.funk(pMin);
            boolean zeroTvalid = this.tpsZeroF.isUpGoingRayValid();
            double tpzeroB = this.tpsZeroF.funk(0.0);
            boolean zeroBvalid = this.tpsZeroF.isUpGoingRayValid();
            double p = -1.0;
            if (zeroTvalid && zeroBvalid) {
                if (tpzeroT == 0.0) {
                    p = pMin;
                } else if (tpzeroB == 0.0) {
                    p = 0.0;
                } else if (tpzeroT * tpzeroB < 0.0) {
                    p = this.tpsZeroIn.zeroF(pMin, 0.0);
                }
            }
            if (p != -1.0) {
                ttr = this.saveResult(p, -1, false, false, false, false, false);
                this.tpsTTR.put(ttr.ttrT, ttr);
                if (evalderivs) {
                    this.evaluateDerivatives(pMin, 0.0, ttr.ttrT, srcdist, srcdepth, derivstep, derivstep, ttr.ttrDerivs, -1.0, 0);
                }
            }
            this.tpsZeroF.setTurningZero();
            int i = 0;
            while (i < this.tpsVLayer.size()) {
                TPVelocityLayer vl = this.tpsVLayer.get(i);
                int lt = vl.getLayerType();
                if (lt == 0) {
                    pT = vl.getPt();
                    pB = vl.getPb();
                } else if (lt == 1) {
                    pT = vl.getPmin();
                    pB = vl.getPb();
                } else if (lt == 2) {
                    pT = vl.getPt();
                    pB = vl.getPmin();
                }
                if (pB < pMin) {
                    double pM;
                    this.tpsZeroF.setPTop(pT);
                    if (pT > pMin) {
                        pT = pMin;
                    }
                    tpzeroT = this.tpsZeroF.funk(pT);
                    zeroTvalid = this.tpsZeroF.isTurningRayValid();
                    if (vl.isSplitLayer() && (pM = vl.getPCrit()) < pT) {
                        tpzeroB = this.tpsZeroF.funk(pM);
                        zeroBvalid = this.tpsZeroF.isTurningRayValid();
                        p = -1.0;
                        if (zeroTvalid && zeroBvalid) {
                            if (tpzeroT == 0.0) {
                                p = pT;
                            } else if (tpzeroB == 0.0) {
                                p = pM;
                            } else if (tpzeroT * tpzeroB < 0.0) {
                                p = this.tpsZeroIn.zeroF(pT, pM);
                            } else {
                                double pTeps = pT + 1.0E-4;
                                double tpzeroTeps = this.tpsZeroF.funk(pTeps);
                                boolean zeroTepsvalid = this.tpsZeroF.isTurningRayValid();
                                if (zeroTepsvalid && tpzeroT * tpzeroTeps < 0.0) {
                                    p = this.tpsZeroIn.zeroF(pTeps, pM);
                                } else {
                                    pTeps = 0.5 * (pT + pM);
                                    tpzeroTeps = this.tpsZeroF.funk(pTeps);
                                    zeroTepsvalid = this.tpsZeroF.isTurningRayValid();
                                    if (zeroTepsvalid && tpzeroT * tpzeroTeps < 0.0) {
                                        p = this.tpsZeroIn.zeroF(pTeps, pM);
                                    } else if (Math.abs(tpzeroT) < 0.001) {
                                        Brents mnmxf = new Brents(this.tpsZeroF, 1.0E-7);
                                        if (pT < 0.0) {
                                            mnmxf.setMaximumSearch();
                                        } else {
                                            mnmxf.setMinimumSearch();
                                        }
                                        doubleW w = new doubleW(pTeps);
                                        tpzeroTeps = mnmxf.minF(pT, pTeps, pM, w);
                                        pTeps = w.val;
                                        zeroTepsvalid = this.tpsZeroF.isTurningRayValid();
                                        if (zeroTepsvalid && tpzeroT * tpzeroTeps < 0.0) {
                                            p = this.tpsZeroIn.zeroF(pTeps, pM);
                                        }
                                    }
                                }
                            }
                        }
                        if (p != -1.0) {
                            ttr = this.saveResult(p, i, false, false, false, true, this.tpsZeroF.isTurningZero());
                            this.tpsTTR.put(ttr.ttrT, ttr);
                            if (evalderivs) {
                                this.evaluateDerivatives(pT, pM, ttr.ttrT, srcdist, srcdepth, derivstep, derivstep, ttr.ttrDerivs, -1.0, 0);
                            }
                        }
                        pT = pM;
                        tpzeroT = tpzeroB;
                        zeroTvalid = zeroBvalid;
                    }
                    tpzeroB = this.tpsZeroF.funk(pB);
                    zeroBvalid = this.tpsZeroF.isTurningRayValid();
                    p = -1.0;
                    if (zeroTvalid && zeroBvalid) {
                        if (tpzeroT == 0.0 && !vl.isSplitLayer()) {
                            p = pT;
                        } else if (tpzeroB == 0.0) {
                            p = pB;
                        } else if (tpzeroT * tpzeroB < 0.0) {
                            p = this.tpsZeroIn.zeroF(pT, pB);
                        }
                    }
                    if (p != -1.0) {
                        ttr = this.saveResult(p, i, false, false, vl.isSplitLayer(), false, this.tpsZeroF.isTurningZero());
                        this.tpsTTR.put(ttr.ttrT, ttr);
                        if (evalderivs) {
                            this.evaluateDerivatives(pT, pB, ttr.ttrT, srcdist, srcdepth, derivstep, derivstep, ttr.ttrDerivs, -1.0, 0);
                        }
                    }
                    if (zeroTvalid && zeroBvalid && tpzeroB > 0.0 && i < this.tpsVLayer.size() - 1) {
                        if (vl.isPhaseDiffDefined()) {
                            double pI = vl.getRb() / vl.getVb();
                            ttr = this.saveResultI(pB, pI, tpzeroB, i, true, false);
                            this.tpsTTR.put(ttr.ttrT, ttr);
                            if (evalderivs) {
                                this.evaluateDerivatives(pT, pB, ttr.ttrT, srcdist, srcdepth, derivstep, derivstep, ttr.ttrDerivs, pI, 0);
                            }
                        }
                        if (vl.isPhaseDiffLowerDefined()) {
                            double pI = vl.getRb() / this.tpsVLayer.get(i + 1).getVt();
                            ttr = this.saveResultI(pB, pI, tpzeroB, i, false, true);
                            this.tpsTTR.put(ttr.ttrT, ttr);
                            if (evalderivs) {
                                this.evaluateDerivatives(pT, pB, ttr.ttrT, srcdist, srcdepth, derivstep, derivstep, ttr.ttrDerivs, pI, 0);
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    public void dumpLocalSrcRcvrLayers(PrintWriter os) {
        String maxNm;
        String minNm;
        double maxR;
        double minR;
        double Rrcvr;
        double Rsrc = this.tpsZeroF.getSourceRadius();
        if (Rsrc < (Rrcvr = this.tpsZeroF.getReceiverRadius())) {
            minR = Rsrc;
            maxR = Rrcvr;
            minNm = "Source  ";
            maxNm = "Receiver";
        } else {
            minR = Rrcvr;
            maxR = Rsrc;
            minNm = "Receiver";
            maxNm = "Source  ";
        }
        int ia = 0;
        while (ia < this.tpsVLayer.size() && maxR < this.tpsVLayer.get(ia).getRb()) {
            ++ia;
        }
        int ib = ia;
        while (ib < this.tpsVLayer.size() && minR < this.tpsVLayer.get(ib).getRt()) {
            ++ib;
        }
        --ib;
        os.printf("\n", new Object[0]);
        int i = ia;
        while (i <= ib) {
            if (i == ia) {
                os.printf("-- R = %.3f\n", this.tpsVLayer.get(i).getRt());
            }
            os.printf("  Pt = %.3f\n", this.tpsVLayer.get(i).getPt());
            os.printf("   Layer %d: V = %.3f\n\n", i, this.tpsVLayer.get(i).getVt());
            if (i == ia) {
                os.printf("    %d R = %.3f,  P = %.3f\n", maxNm, maxR, this.tpsVLayer.get(i).pAtR(maxR));
            }
            if (i == ib) {
                os.printf("    %d R = %.3f,  P = %.3f\n", minNm, minR, this.tpsVLayer.get(i).pAtR(minR));
            }
            os.printf("   Pb = %.3f\n", this.tpsVLayer.get(i).getPb());
            os.printf("--  R = %.3f\n", this.tpsVLayer.get(i).getRb());
            ++i;
        }
        os.printf("\n", new Object[0]);
    }

    public void dumpLayerInfo(PrintWriter os) {
        os.printf("\n", new Object[0]);
        int i = 0;
        while (i < this.tpsVLayer.size()) {
            if (i == 0) {
                os.printf("- R = %.3f\n", this.tpsVLayer.get(i).getRt());
            }
            os.printf("  Pt = %.3f\n", this.tpsVLayer.get(i).getPt());
            os.printf("  Vt = %.3f\n", this.tpsVLayer.get(i).getVt());
            os.printf("  Dt = %.3f\n", this.tpsVLayer.get(i).getDistT());
            os.printf(" Layer %d\n", i);
            os.printf("  Pb = %.3f\n", this.tpsVLayer.get(i).getPb());
            os.printf("  Vb = %.3f\n", this.tpsVLayer.get(i).getVb());
            os.printf("  Db = %.3f\n", this.tpsVLayer.get(i).getDistB());
            os.printf("- R = %.3f\n", this.tpsVLayer.get(i).getRb());
            ++i;
        }
        os.printf("\n", new Object[0]);
    }

    private void evaluateDerivatives(double pT, double pB, double T00, double dist, double depth, double edist, double edepth, double[] derivs, double pI, int derivcnt) {
        ++derivcnt;
        int bid = this.evalDerivsPrimary(pT, pB, T00, dist, depth, edist, edepth, derivs, pI);
        if (bid == 0) {
            return;
        }
        if (bid == 1) {
            if (this.evalDerivsAlternateB(pT, pB, T00, dist, depth, edist, edepth, derivs, pI) == 0 && this.evalDerivsAlternateA(pT, pB, T00, dist, depth, edist, edepth, derivs, pI) == 0) {
                this.reEvaluateDerivatives(pT, pB, T00, dist, depth, edist, edepth, derivs, pI, derivcnt);
            }
        } else if (bid == 2) {
            if (this.evalDerivsAlternateB(pT, pB, T00, dist, depth, edist, edepth, derivs, pI) == 0 && this.evalDerivsAlternateC(pT, pB, T00, dist, depth, edist, edepth, derivs, pI) == 0) {
                this.reEvaluateDerivatives(pT, pB, T00, dist, depth, edist, edepth, derivs, pI, derivcnt);
            }
        } else if (bid == 3) {
            if (this.evalDerivsAlternateE(pT, pB, T00, dist, depth, edist, edepth, derivs, pI) == 0 && this.evalDerivsAlternateF(pT, pB, T00, dist, depth, edist, edepth, derivs, pI) == 0) {
                this.reEvaluateDerivatives(pT, pB, T00, dist, depth, edist, edepth, derivs, pI, derivcnt);
            }
        } else if (bid == 4 && this.evalDerivsAlternateE(pT, pB, T00, dist, depth, edist, edepth, derivs, pI) == 0 && this.evalDerivsAlternateD(pT, pB, T00, dist, depth, edist, edepth, derivs, pI) == 0) {
            this.reEvaluateDerivatives(pT, pB, T00, dist, depth, edist, edepth, derivs, pI, derivcnt);
        }
    }

    private void reEvaluateDerivatives(double pT, double pB, double T00, double dist, double depth, double edist, double edepth, double[] derivs, double pI, int derivcnt) {
        if (derivcnt < 5) {
            this.evaluateDerivatives(pT, pB, T00, dist, depth, edist /= 2.0, edepth /= 2.0, derivs, pI, derivcnt);
        }
    }

    private int evalDerivsPrimary(double pT, double pB, double T00, double dist, double depth, double edist, double edepth, double[] derivs, double pI) {
        doubleW t1 = new doubleW(0.0);
        doubleW t2 = new doubleW(0.0);
        doubleW t3 = new doubleW(0.0);
        doubleW t4 = new doubleW(0.0);
        if (this.layeredTravelTime(pT, pB, dist - edist, depth + edepth, t1, pI) == -1.0) {
            return 1;
        }
        if (this.layeredTravelTime(pT, pB, dist + edist, depth - edepth, t2, pI) == -1.0) {
            return 2;
        }
        if (this.layeredTravelTime(pT, pB, dist + edist, depth + edepth, t3, pI) == -1.0) {
            return 3;
        }
        if (this.layeredTravelTime(pT, pB, dist - edist, depth + edepth, t4, pI) == -1.0) {
            return 4;
        }
        derivs[0] = (t2.val - t1.val + t3.val - t4.val) / edist / 4.0;
        derivs[1] = (t3.val - t2.val + t4.val - t1.val) / edepth / 4.0;
        derivs[2] = (t3.val - t4.val - t2.val + t1.val) / edist / edepth / 4.0;
        derivs[3] = (t3.val + t2.val - 4.0 * T00 + t4.val + t1.val) / edist / edist / 2.0;
        return 0;
    }

    private int evalDerivsAlternateA(double pT, double pB, double T00, double dist, double depth, double edist, double edepth, double[] derivs, double pI) {
        doubleW t1 = new doubleW(0.0);
        doubleW t2 = new doubleW(0.0);
        doubleW t3 = new doubleW(0.0);
        doubleW t4 = new doubleW(0.0);
        if (this.layeredTravelTime(pT, pB, dist + 0.5 * edist, depth, t1, pI) == -1.0) {
            return 1;
        }
        if (this.layeredTravelTime(pT, pB, dist + edist, depth, t2, pI) == -1.0) {
            return 2;
        }
        if (this.layeredTravelTime(pT, pB, dist + edist, depth + edepth, t3, pI) == -1.0) {
            return 3;
        }
        if (this.layeredTravelTime(pT, pB, dist, depth + edepth, t4, pI) == -1.0) {
            return 4;
        }
        derivs[0] = 2.0 * (t1.val - T00) / edist;
        derivs[1] = (t4.val - T00) / edepth;
        derivs[2] = (t3.val - t4.val - t2.val + T00) / edist / edepth;
        derivs[3] = 4.0 * (t2.val - 2.0 * t1.val + T00) / edist / edist;
        return 0;
    }

    private int evalDerivsAlternateB(double pT, double pB, double T00, double dist, double depth, double edist, double edepth, double[] derivs, double pI) {
        doubleW t1 = new doubleW(0.0);
        doubleW t2 = new doubleW(0.0);
        doubleW t3 = new doubleW(0.0);
        doubleW t4 = new doubleW(0.0);
        if (this.layeredTravelTime(pT, pB, dist - edist, depth, t1, pI) == -1.0) {
            return 1;
        }
        if (this.layeredTravelTime(pT, pB, dist + edist, depth, t2, pI) == -1.0) {
            return 2;
        }
        if (this.layeredTravelTime(pT, pB, dist + edist, depth + edepth, t3, pI) == -1.0) {
            return 3;
        }
        if (this.layeredTravelTime(pT, pB, dist - edist, depth + edepth, t4, pI) == -1.0) {
            return 4;
        }
        derivs[0] = (t2.val - t1.val) / edist / 2.0;
        derivs[1] = (t3.val - t2.val + t4.val - t1.val) / edepth / 2.0;
        derivs[2] = (t3.val - t4.val - t2.val + t1.val) / edist / edepth / 2.0;
        derivs[3] = (t2.val - 2.0 * T00 + t1.val) / edist / edist;
        return 0;
    }

    private int evalDerivsAlternateC(double pT, double pB, double T00, double dist, double depth, double edist, double edepth, double[] derivs, double pI) {
        doubleW t1 = new doubleW(0.0);
        doubleW t2 = new doubleW(0.0);
        doubleW t3 = new doubleW(0.0);
        doubleW t4 = new doubleW(0.0);
        if (this.layeredTravelTime(pT, pB, dist - edist, depth, t1, pI) == -1.0) {
            return 1;
        }
        if (this.layeredTravelTime(pT, pB, dist - 0.5 * edist, depth, t2, pI) == -1.0) {
            return 2;
        }
        if (this.layeredTravelTime(pT, pB, dist, depth + edepth, t3, pI) == -1.0) {
            return 3;
        }
        if (this.layeredTravelTime(pT, pB, dist - edist, depth + edepth, t4, pI) == -1.0) {
            return 4;
        }
        derivs[0] = 2.0 * (T00 - t2.val) / edist;
        derivs[1] = (t3.val - T00) / edepth;
        derivs[2] = (t3.val - t4.val - T00 + t1.val) / edist / edepth;
        derivs[3] = 4.0 * (T00 - 2.0 * t2.val + t1.val) / edist / edist;
        return 0;
    }

    private int evalDerivsAlternateD(double pT, double pB, double T00, double dist, double depth, double edist, double edepth, double[] derivs, double pI) {
        doubleW t1 = new doubleW(0.0);
        doubleW t2 = new doubleW(0.0);
        doubleW t3 = new doubleW(0.0);
        doubleW t4 = new doubleW(0.0);
        if (this.layeredTravelTime(pT, pB, dist, depth - edepth, t1, pI) == -1.0) {
            return 1;
        }
        if (this.layeredTravelTime(pT, pB, dist + edist, depth - edepth, t2, pI) == -1.0) {
            return 2;
        }
        if (this.layeredTravelTime(pT, pB, dist + edist, depth, t3, pI) == -1.0) {
            return 3;
        }
        if (this.layeredTravelTime(pT, pB, dist + 0.5 * edist, depth, t4, pI) == -1.0) {
            return 4;
        }
        derivs[0] = 2.0 * (t4.val - T00) / edist;
        derivs[1] = (T00 - t1.val) / edepth;
        derivs[2] = (t3.val - T00 - t2.val + t1.val) / edist / edepth;
        derivs[3] = 4.0 * (t3.val - 2.0 * t4.val + T00) / edist / edist;
        return 0;
    }

    private int evalDerivsAlternateE(double pT, double pB, double T00, double dist, double depth, double edist, double edepth, double[] derivs, double pI) {
        doubleW t1 = new doubleW(0.0);
        doubleW t2 = new doubleW(0.0);
        doubleW t3 = new doubleW(0.0);
        doubleW t4 = new doubleW(0.0);
        if (this.layeredTravelTime(pT, pB, dist - edist, depth - edepth, t1, pI) == -1.0) {
            return 1;
        }
        if (this.layeredTravelTime(pT, pB, dist + edist, depth - edepth, t2, pI) == -1.0) {
            return 2;
        }
        if (this.layeredTravelTime(pT, pB, dist + edist, depth, t3, pI) == -1.0) {
            return 3;
        }
        if (this.layeredTravelTime(pT, pB, dist - edist, depth, t4, pI) == -1.0) {
            return 4;
        }
        derivs[0] = (t3.val - t4.val) / edist / 2.0;
        derivs[1] = (t3.val - t2.val + t4.val - t1.val) / edepth / 2.0;
        derivs[2] = (t3.val - t4.val - t2.val + t1.val) / edist / edepth / 2.0;
        derivs[3] = (t3.val - 2.0 * T00 + t4.val) / edist / edist;
        return 0;
    }

    private int evalDerivsAlternateF(double pT, double pB, double T00, double dist, double depth, double edist, double edepth, double[] derivs, double pI) {
        doubleW t1 = new doubleW(0.0);
        doubleW t2 = new doubleW(0.0);
        doubleW t3 = new doubleW(0.0);
        doubleW t4 = new doubleW(0.0);
        if (this.layeredTravelTime(pT, pB, dist - edist, depth - edepth, t1, pI) == -1.0) {
            return 1;
        }
        if (this.layeredTravelTime(pT, pB, dist, depth - edepth, t2, pI) == -1.0) {
            return 2;
        }
        if (this.layeredTravelTime(pT, pB, dist - 0.5 * edist, depth, t3, pI) == -1.0) {
            return 3;
        }
        if (this.layeredTravelTime(pT, pB, dist - edist, depth, t4, pI) == -1.0) {
            return 4;
        }
        derivs[0] = 2.0 * (T00 - t3.val) / edist;
        derivs[1] = (T00 - t2.val) / edepth;
        derivs[2] = (T00 - t4.val - t2.val + t1.val) / edist / edepth;
        derivs[3] = 4.0 * (T00 - 2.0 * t3.val + t4.val) / edist / edist;
        return 0;
    }

    private double layeredTravelTime(double pT, double pB, double dist, double depth, doubleW T, double pI) {
        double p = -1.0;
        this.tpsZeroF.setDist(dist);
        this.tpsZeroF.setSourceDepth(depth);
        if (pI == -1.0) {
            double tpzeroT = this.tpsZeroF.funk(pT);
            double tpzeroB = this.tpsZeroF.funk(pB);
            if (tpzeroT == 0.0) {
                p = pT;
            } else if (tpzeroB == 0.0) {
                p = pB;
            } else if (tpzeroT * tpzeroB < 0.0) {
                p = this.tpsZeroIn.zeroF(pT, pB);
            }
            if (p != -1.0) {
                T.val = this.tpsZeroF.time(p);
            }
        } else {
            this.tpsZeroF.distance(pB);
            double D = this.tpsZeroF.getTurningZero();
            if (D >= 0.0) {
                p = pB;
                T.val = D * pI + this.tpsZeroF.time(p);
            }
        }
        return p;
    }

    private TravelTimeResult saveResultI(double pB, double pI, double dist, int i, boolean isUpper, boolean isLower) {
        TravelTimeResult ttr = this.saveResult(pB, i, isUpper, isLower, false, false, true);
        double ti = dist * pI;
        ttr.ttrDIntrfc = dist;
        ttr.ttrTIntrfc = ti;
        ttr.ttrT += ti;
        return ttr;
    }

    private TravelTimeResult saveResult(double p, int i, boolean isintrfcupper, boolean isintrfclower, boolean isspltlower, boolean isspltupper, boolean isturningzero) {
        TravelTimeResult ttr;
        double t = this.tpsZeroF.time(p);
        if (tpsReuseTTR.size() > 0) {
            ttr = tpsReuseTTR.lastElement();
            int idx = tpsReuseTTR.size() - 1;
            tpsReuseTTR.remove(idx);
        } else {
            ttr = new TravelTimeResult();
        }
        if (isturningzero) {
            TPVelocityLayer vl = this.tpsVLayer.get(i);
            ttr.ttrRayType = "Turning";
            String lvl = "" + i;
            if (isspltupper) {
                ttr.ttrPhaseEval = String.valueOf(vl.getPhaseType()) + lvl + "b+";
                ttr.ttrPhaseName = vl.getPhaseNameUpper();
                if (ttr.ttrPhaseName.length() == 0) {
                    ttr.ttrPhaseName = vl.getPhaseName();
                }
            } else if (isspltlower) {
                ttr.ttrPhaseEval = String.valueOf(vl.getPhaseType()) + lvl + "b-";
                ttr.ttrPhaseName = vl.getPhaseNameLower();
                if (ttr.ttrPhaseName.length() == 0) {
                    ttr.ttrPhaseName = vl.getPhaseName();
                }
            } else if (isintrfcupper) {
                ttr.ttrPhaseEval = String.valueOf(vl.getPhaseType()) + lvl + "i+";
                ttr.ttrPhaseName = vl.getPhaseNameDiff();
            } else if (isintrfclower) {
                ttr.ttrPhaseEval = String.valueOf(vl.getPhaseType()) + lvl + "i-";
                ttr.ttrPhaseName = vl.getPhaseNameDiffLower();
            } else {
                ttr.ttrPhaseEval = String.valueOf(vl.getPhaseType()) + lvl + "b";
                ttr.ttrPhaseName = vl.getPhaseName();
            }
            ttr.ttrVelLayer = vl;
            ttr.ttrR = vl.rAtP(p);
            ttr.ttrV = vl.funk(ttr.ttrR);
        } else {
            String updwn = "";
            double r = 0.0;
            if (this.tpsZeroF.getReceiverDepth() < this.tpsZeroF.getSourceDepth()) {
                ttr.ttrRayType = "UpGoing";
                i = this.tpsZeroF.getSourceLayerId();
                updwn = "up";
                r = this.tpsZeroF.getSourceRadius();
            } else {
                ttr.ttrRayType = "DownGoing";
                i = this.tpsZeroF.getReceiverLayerId();
                updwn = "dn";
                r = this.tpsZeroF.getReceiverRadius();
            }
            TPVelocityLayer vl = this.tpsVLayer.get(i);
            String lvl = "" + i;
            ttr.ttrPhaseEval = String.valueOf(vl.getPhaseType()) + lvl + updwn;
            ttr.ttrPhaseName = vl.getPhaseName();
            ttr.ttrVelLayer = vl;
            ttr.ttrR = r;
            ttr.ttrV = vl.funk(r);
        }
        ttr.ttrLayerIndex = i;
        ttr.ttrIsInterfaceUpper = isintrfcupper;
        ttr.ttrIsInterfaceLower = isintrfclower;
        ttr.ttrIsSplitLower = isspltlower;
        ttr.ttrIsSplitUpper = isspltupper;
        ttr.ttrP = p;
        ttr.ttrT = t;
        ttr.ttrDRay = this.tpsZeroF.getRayDistance();
        ttr.ttrTRay = this.tpsZeroF.getRayTime();
        ttr.ttrDSrc = this.tpsZeroF.getSourceLegDistance();
        ttr.ttrTSrc = this.tpsZeroF.getSourceLegTime();
        ttr.ttrDRcvr = this.tpsZeroF.getReceiverLegDistance();
        ttr.ttrTRcvr = this.tpsZeroF.getReceiverLegTime();
        ttr.ttrDIntrfc = 0.0;
        ttr.ttrTIntrfc = 0.0;
        double[] td = ttr.ttrDerivs;
        td[3] = -999999.0;
        td[2] = -999999.0;
        td[1] = -999999.0;
        td[0] = -999999.0;
        return ttr;
    }

    private void clearTTRMap() {
        for (TravelTimeResult ttr : this.tpsTTR.values()) {
            tpsReuseTTR.add(ttr);
        }
        this.tpsTTR.clear();
    }

    TravelTimeResult getFirstTravelTimeResult() {
        if (this.tpsTTR.size() > 0) {
            return this.tpsTTR.firstEntry().getValue();
        }
        return null;
    }

    public double getFirstTravelTime() {
        if (this.tpsTTR.size() > 0) {
            return this.tpsTTR.firstEntry().getKey();
        }
        return -1.0;
    }

    public double getFirstNonDiffractedTravelTime() {
        if (this.tpsTTR.size() > 0) {
            for (Map.Entry<Double, TravelTimeResult> e : this.tpsTTR.entrySet()) {
                if (e.getValue().ttrIsInterfaceUpper || e.getValue().ttrIsInterfaceLower) continue;
                return e.getKey();
            }
            return this.tpsTTR.firstKey();
        }
        return -1.0;
    }

    public double getTravelTime(String phase, boolean matchPhase) {
        double tt = -1.0;
        for (Map.Entry<Double, TravelTimeResult> e : this.tpsTTR.entrySet()) {
            TravelTimeResult ttr = e.getValue();
            if (matchPhase) {
                if ((ttr.ttrPhaseName.length() <= 0 || !phase.equals(ttr.ttrPhaseName)) && !phase.equals(ttr.ttrPhaseEval)) continue;
                return e.getKey();
            }
            if (tt == -1.0) {
                tt = e.getKey();
            }
            if ((ttr.ttrPhaseName.length() <= 0 || !phase.equals(ttr.ttrPhaseName.substring(0, phase.length()))) && !phase.equals(ttr.ttrPhaseEval.substring(0, phase.length()))) continue;
            return e.getKey();
        }
        return tt;
    }

    public TravelTimeResult getTravelTimeResult(String phase, boolean matchPhase) {
        TravelTimeResult ttr = null;
        for (Map.Entry<Double, TravelTimeResult> e : this.tpsTTR.entrySet()) {
            TravelTimeResult ttrit = e.getValue();
            if (matchPhase) {
                if (!phase.equals(ttrit.ttrPhaseName) && !phase.equals(ttrit.ttrPhaseEval)) continue;
                return ttrit;
            }
            if (ttr == null) {
                ttr = e.getValue();
            }
            if ((ttrit.ttrPhaseName.length() <= 0 || !phase.equals(ttrit.ttrPhaseName.substring(0, phase.length()))) && !phase.equals(ttrit.ttrPhaseEval.substring(0, phase.length()))) continue;
            return ttrit;
        }
        return ttr;
    }

    public boolean integrateDistance(double p, doubleW d, boolean bottom_pass) {
        if (p < 0.0) {
            return false;
        }
        if (p == 0.0) {
            d.val = 1.5707963267948966;
            return true;
        }
        d.val = 0.0;
        int i = 0;
        while (i < this.tpsVLayer.size()) {
            d.val += this.tpsVLayer.get(i).integDistance(p, -1.0);
            if (this.tpsVLayer.get(i).invalidRay()) {
                return this.tpsVLayer.get(i).getPt() == p;
            }
            if (this.tpsVLayer.get(i).turningRay() && !bottom_pass) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean integrateDistance(double p, double r, doubleW d) {
        if (p < 0.0) {
            return false;
        }
        d.val = 0.0;
        int i = 0;
        while (i < this.tpsVLayer.size() && r < this.tpsVLayer.get(i).getRt()) {
            d.val += this.tpsVLayer.get(i).integDistance(p, r);
            if (this.tpsVLayer.get(i).invalidRay()) {
                return this.tpsVLayer.get(i).getPt() == p;
            }
            ++i;
        }
        return true;
    }

    public boolean integrateDistance(double p, double r1, double r2, doubleW d) {
        if (p < 0.0) {
            return false;
        }
        int i = 0;
        while (i < this.tpsVLayer.size() && r1 < this.tpsVLayer.get(i).getRb()) {
            ++i;
        }
        d.val = 0.0;
        while (i < this.tpsVLayer.size() && r2 < this.tpsVLayer.get(i).getRt()) {
            d.val += this.tpsVLayer.get(i).integDistance(p, r1, r2);
            if (this.tpsVLayer.get(i).invalidRay()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean integrateTime(double p, doubleW t, boolean bottom_pass) {
        if (p < 0.0) {
            return false;
        }
        t.val = 0.0;
        int i = 0;
        while (i < this.tpsVLayer.size()) {
            t.val += this.tpsVLayer.get(i).integTime(p, -1.0);
            if (this.tpsVLayer.get(i).invalidRay()) {
                return false;
            }
            if (this.tpsVLayer.get(i).turningRay() && !bottom_pass) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean integrateTime(double p, double r, doubleW t) {
        if (p < 0.0) {
            return false;
        }
        t.val = 0.0;
        int i = 0;
        while (i < this.tpsVLayer.size() && r < this.tpsVLayer.get(i).getRt()) {
            t.val += this.tpsVLayer.get(i).integTime(p, r);
            if (this.tpsVLayer.get(i).invalidRay()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean integrateTime(double p, double r1, double r2, doubleW t) {
        if (p < 0.0) {
            return false;
        }
        int i = 0;
        while (i < this.tpsVLayer.size() && r1 < this.tpsVLayer.get(i).getRb()) {
            ++i;
        }
        t.val = 0.0;
        while (i < this.tpsVLayer.size() && r2 < this.tpsVLayer.get(i).getRt()) {
            t.val += this.tpsVLayer.get(i).integTime(p, r1, r2);
            if (this.tpsVLayer.get(i).invalidRay()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void findLimits() {
        doubleW d = new doubleW(0.0);
        doubleW dp = new doubleW(0.0);
        int i = 0;
        while (i < this.tpsVLayer.size()) {
            double dDdP;
            double delP = 0.1 * Math.abs(this.tpsVLayer.get(i).getPt() - this.tpsVLayer.get(i).getPb());
            if (delP > 1.0) {
                delP = 1.0;
            }
            this.tpsVLayer.get(i).setLayerType(3);
            if (i == 0) {
                this.tpsVLayer.get(0).setPmin(Math.max(this.tpsVLayer.get(0).getPt(), this.tpsVLayer.get(0).getPb()) + 1.0);
            } else {
                this.tpsVLayer.get(i).setPmin(Math.min(this.tpsVLayer.get(i - 1).getPmin(), Math.min(this.tpsVLayer.get(i - 1).getPt(), this.tpsVLayer.get(i - 1).getPb())));
            }
            if (this.tpsVLayer.get(i).getPt() <= this.tpsVLayer.get(i).getPmin()) {
                this.tpsVLayer.get(i).setLayerType(0);
                this.integrateDistance(this.tpsVLayer.get(i).getPt(), d, true);
                this.tpsVLayer.get(i).setDistT(d.val);
                if (this.tpsVLayer.get(i).getPb() < this.tpsVLayer.get(i).getPt()) {
                    this.integrateDistance(this.tpsVLayer.get(i).getPt() - delP, dp, false);
                    dDdP = (d.val - dp.val) / delP;
                } else {
                    this.integrateDistance(this.tpsVLayer.get(i).getPt() + delP, dp, false);
                    dDdP = (dp.val - d.val) / delP;
                }
                this.tpsVLayer.get(i).setdDistdPT(dDdP);
            } else if (this.tpsVLayer.get(i).getPb() <= this.tpsVLayer.get(i).getPmin()) {
                this.tpsVLayer.get(i).setLayerType(1);
                this.integrateDistance(this.tpsVLayer.get(i).getPmin(), d, true);
                this.tpsVLayer.get(i).setDistT(d.val);
                if (this.tpsVLayer.get(i).getPb() < this.tpsVLayer.get(i).getPt()) {
                    this.integrateDistance(this.tpsVLayer.get(i).getPmin() - delP, dp, false);
                    dDdP = (d.val - dp.val) / delP;
                } else {
                    this.integrateDistance(this.tpsVLayer.get(i).getPmin() + delP, dp, false);
                    dDdP = (dp.val - d.val) / delP;
                }
                this.tpsVLayer.get(i).setdDistdPT(dDdP);
            }
            if (this.tpsVLayer.get(i).getPb() <= this.tpsVLayer.get(i).getPmin()) {
                this.integrateDistance(this.tpsVLayer.get(i).getPb(), d, false);
                this.tpsVLayer.get(i).setDistB(d.val);
                if (this.tpsVLayer.get(i).getPb() > this.tpsVLayer.get(i).getPt()) {
                    this.integrateDistance(this.tpsVLayer.get(i).getPb() - delP, dp, false);
                    dDdP = (d.val - dp.val) / delP;
                } else {
                    this.integrateDistance(this.tpsVLayer.get(i).getPb() + delP, dp, false);
                    dDdP = (dp.val - d.val) / delP;
                }
                this.tpsVLayer.get(i).setdDistdPB(dDdP);
            } else if (this.tpsVLayer.get(i).getPt() <= this.tpsVLayer.get(i).getPmin()) {
                this.tpsVLayer.get(i).setLayerType(2);
                this.integrateDistance(this.tpsVLayer.get(i).getPmin(), d, false);
                this.tpsVLayer.get(i).setDistB(d.val);
                if (this.tpsVLayer.get(i).getPb() > this.tpsVLayer.get(i).getPt()) {
                    this.integrateDistance(this.tpsVLayer.get(i).getPmin() - delP, dp, false);
                    dDdP = (d.val - dp.val) / delP;
                } else {
                    this.integrateDistance(this.tpsVLayer.get(i).getPmin() + delP, dp, false);
                    dDdP = (dp.val - d.val) / delP;
                }
                this.tpsVLayer.get(i).setdDistdPB(dDdP);
            }
            double a = this.tpsVLayer.get(i).getdDistdPT();
            double b = this.tpsVLayer.get(i).getdDistdPB();
            double c = a * b;
            if (this.tpsVLayer.get(i).getdDistdPT() * this.tpsVLayer.get(i).getdDistdPB() < 0.0) {
                SplitDistance sd = new SplitDistance(this);
                Brents zb = new Brents(sd, 1.0E-6);
                double pml = Math.min(this.tpsVLayer.get(i).getPt(), this.tpsVLayer.get(i).getPmin()) - delP;
                double pb = this.tpsVLayer.get(i).getPb() + delP;
                double psplit = 0.5 * (pml + pb);
                if (this.tpsVLayer.get(i).getdDistdPT() > 0.0) {
                    zb.setMinimumSearch();
                } else {
                    zb.setMaximumSearch();
                }
                doubleW w = new doubleW(psplit);
                double dcrit = zb.minF(pml, pb, psplit, w);
                psplit = w.val;
                this.tpsVLayer.get(i).setSplitLayer(psplit, dcrit);
            }
            ++i;
        }
    }

    public void writeLayerData(int i, PrintWriter os, int n, double f0, double f1) {
        double plast;
        TPVelocityLayer layri;
        doubleW d = new doubleW(0.0);
        doubleW t = new doubleW(0.0);
        if (this.tpsVLayer.get(0).getPmin() == -1.0) {
            this.findLimits();
        }
        double p0 = (layri = this.tpsVLayer.get(i)).getPt() <= layri.getPmin() ? layri.getPt() : layri.getPmin();
        double p1 = layri.getPb() <= layri.getPmin() ? layri.getPb() : layri.getPmin();
        p0 = (p1 - p0) * f0 + p0;
        p1 = (p1 - p0) * f1 + p0;
        double d0 = layri.getDistT();
        double d1 = layri.getDistB();
        double dd = Math.abs(d1 - d0) / (double)n;
        double dp = (p1 - p0) / (double)n;
        double p = plast = p0;
        this.integrateDistance(p0, d, true);
        double r = layri.rAtP(p);
        double v = layri.funk(r);
        this.integrateTime(p0, t, true);
        os.printf("%d    %12.8f    %12.8f   %12.8f    %12.8f   %12.8f\n", i, r, p * (Math.PI / 180), v, 2.0 * d.val * 57.29577951308232, 2.0 * t.val);
        double dlast = d.val;
        int m = 1;
        double ddp = dp;
        while (p != p1) {
            p = plast + ddp;
            if (p < p1) {
                p = p1;
            }
            this.integrateDistance(p, d, false);
            if (Math.abs(d.val - dlast) > dd) {
                while (Math.abs(d.val - dlast) > dd) {
                    ddp = dp / (double)(m *= 2);
                    p = plast + ddp;
                    if (p < p1) {
                        p = p1;
                    }
                    this.integrateDistance(p, d, false);
                }
            } else if (Math.abs(d.val - dlast) < dd && m > 1 && p != p1) {
                while (Math.abs(d.val - dlast) < dd && m > 1 && p != p1) {
                    ddp = dp / (double)(m /= 2);
                    p = plast + ddp;
                    if (p < p1) {
                        p = p1;
                    }
                    this.integrateDistance(p, d, false);
                }
            }
            r = layri.rAtP(p);
            v = layri.funk(r);
            this.integrateTime(p, t, false);
            os.printf("%d    %12.8f    %12.8f   %12.8f    %12.8f   %12.8f\n", i, r, p * (Math.PI / 180), v, 2.0 * d.val * 57.29577951308232, 2.0 * t.val);
            plast = p;
            dlast = d.val;
        }
    }

    public String toString() {
        CharArrayWriter caw = new CharArrayWriter(128);
        PrintWriter os = new PrintWriter(caw);
        this.toStream(os, "  ");
        return caw.toString();
    }

    public void toStream(PrintWriter os, String indent) {
        this.writeData(os);
    }

    public void writeData(String filename) {
        try {
            PrintWriter os = new PrintWriter(new FileWriter(filename));
            this.writeData(os);
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void debugOutZeros(int n, double p0, double p1) {
        double del = (p1 - p0) / (double)(n - 1);
        int i = 0;
        while (i < n) {
            double p = del * (double)i + p0;
            System.out.printf("%f  %f\n", p, this.tpsZeroF.funk(p));
            ++i;
        }
    }

    private void writeData(PrintWriter os) {
        os.printf("  // Site Information\n\n", new Object[0]);
        os.printf("  Name            = \"%s\"\n", this.tpsRcvrName);
        os.printf("  Phase           = \"%s\"\n", this.tpsRcvrPhase);
        os.printf("  Model           = \"%s\"\n", this.tpsModelName);
        os.printf("  Depth(km)       = %.2f\n", this.tpsRcvrDepth);
        os.printf("  Radius(km)      = %,2f\n", this.tpsRcvrRad);
        os.printf("  // CLR format data\n\n", new Object[0]);
        if (this.tpsVLayer.size() > 0) {
            int i = 0;
            while (i < this.tpsVLayer.size()) {
                TPVelocityLayer tpvl = this.tpsVLayer.get(i);
                os.printf("  [Layer]\n", new Object[0]);
                os.printf("    Name  = \"%s\"\n", tpvl.getLayerName());
                tpvl.writeNormRadius(os);
                os.printf("    Depth = %12.4f  %12.4f\n", this.tpsZeroF.getPlanetRadius() - tpvl.getRt(), this.tpsZeroF.getPlanetRadius() - tpvl.getRb());
                String nm = tpvl.getPhaseName();
                if (nm.length() > 0) {
                    os.printf("    %s PhaseName = %s\n", this.tpsRcvrPhase, nm);
                }
                if ((nm = tpvl.getPhaseNameUpper()).length() > 0) {
                    os.printf("    %s PhaseNameUpper = %s\n", this.tpsRcvrPhase, nm);
                }
                if ((nm = tpvl.getPhaseNameLower()).length() > 0) {
                    os.printf("    %s PhaseNameLower = %s\n", this.tpsRcvrPhase, nm);
                }
                nm = tpvl.getPhaseNameDiff();
                if (tpvl.isPhaseDiffDefined()) {
                    os.printf("    %s PhaseNameDiff = %s\n", this.tpsRcvrPhase, nm);
                }
                nm = tpvl.getPhaseNameDiffLower();
                if (tpvl.isPhaseDiffLowerDefined()) {
                    os.printf("    %s PhaseNameDiffLower = %s\n", this.tpsRcvrPhase, nm);
                }
                os.printf("    Vel %s  = ", this.tpsRcvrPhase);
                tpvl.writeVelocity(os);
                os.printf("  [End:Layer]\n\n", new Object[0]);
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void appendConstVelocityModel(double c, double rt, double rb, String layrnam) {
        if (this.tpsVLayer.size() > 0) {
            if (!this.tpsIsVelModlOwned) {
                String msg = String.format("\nERROR: Attempting to add a new velocity model layer to an existing \"Owned\" velocity model ...\nOperation is not allowed ...\n", new Object[0]);
                throw new TauPException(msg);
            }
            if (rt != this.tpsVLayer.lastElement().getRb()) {
                String msg = String.format("\nERROR: Top radius (%f km) does not equal previous layer bottom radius (%f km) ...\n", rt, this.tpsVLayer.lastElement().getRb());
                throw new TauPException(msg);
            }
            this.tpsVLayer.add(new VelocityConst(c, rt, rb, layrnam));
        } else {
            this.tpsVLayer.add(new VelocityConst(c, rt, rb, layrnam));
            this.tpsIsVelModlOwned = true;
        }
        this.tpsVLayer.lastElement().setPhaseType(this.tpsRcvrPhase);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void appendLinearVelocityModel(double a0, double a1, double rt, double rb, String layrnam, double normradius) {
        if (this.tpsVLayer.size() > 0) {
            if (!this.tpsIsVelModlOwned) {
                String msg = "\nERROR: Attempting to add a new velocity model layer to an existing \"Owned\" velocity model ...\nOperation is not allowed ...\n";
                throw new TauPException(msg);
            }
            if (rt != this.tpsVLayer.lastElement().getRb()) {
                String msg = String.format("\nERROR: Top radius (%f km) does not equal previous layer bottom radius (%f km) ...", rt, this.tpsVLayer.lastElement().getRb());
                throw new TauPException(msg);
            }
            this.tpsVLayer.add(new VelocityLinear(a0, a1, rt, rb, layrnam, normradius));
        } else {
            this.tpsVLayer.add(new VelocityLinear(a0, a1, rt, rb, layrnam, normradius));
            this.tpsIsVelModlOwned = true;
        }
        this.tpsVLayer.lastElement().setPhaseType(this.tpsRcvrPhase);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void appendQuadraticVelocityModel(double a0, double a1, double a2, double rt, double rb, String layrnam, double normradius) {
        if (this.tpsVLayer.size() > 0) {
            if (!this.tpsIsVelModlOwned) {
                String msg = "\nERROR: Attempting to add a new velocity model layer to an existing \"Owned\" velocity model ...\nOperation is not allowed ...\n";
                throw new TauPException(msg);
            }
            if (rt != this.tpsVLayer.lastElement().getRb()) {
                String msg = String.format("\nERROR: Top radius (%f km) does not equal previous layer bottom radius (%f km) ...\n", rt, this.tpsVLayer.lastElement().getRb());
                throw new TauPException(msg);
            }
            this.tpsVLayer.add(new VelocityQuadratic(a0, a1, a2, rt, rb, layrnam, normradius));
        } else {
            this.tpsVLayer.add(new VelocityQuadratic(a0, a1, a2, rt, rb, layrnam, normradius));
            this.tpsIsVelModlOwned = true;
        }
        this.tpsVLayer.lastElement().setPhaseType(this.tpsRcvrPhase);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void appendCubicVelocityModel(double a0, double a1, double a2, double a3, double rt, double rb, String layrnam, double normradius) {
        if (this.tpsVLayer.size() > 0) {
            if (!this.tpsIsVelModlOwned) {
                String msg = "\nERROR: Attempting to add a new velocity model layer to an existing \"Owned\" velocity model ...\nOperation is not allowed ...\n";
                throw new TauPException(msg);
            }
            if (rt != this.tpsVLayer.lastElement().getRb()) {
                String msg = String.format("\nERROR: Top radius (%f km) does not equal previous layer bottom radius (%f km) ...\n", rt, this.tpsVLayer.lastElement().getRb());
                throw new TauPException(msg);
            }
            this.tpsVLayer.add(new VelocityCubic(a0, a1, a2, a3, rt, rb, layrnam, normradius));
        } else {
            this.tpsVLayer.add(new VelocityCubic(a0, a1, a2, a3, rt, rb, layrnam, normradius));
            this.tpsIsVelModlOwned = true;
        }
        this.tpsVLayer.lastElement().setPhaseType(this.tpsRcvrPhase);
    }
}

