/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

import cn.org.gddsn.seis.location.rstt.DataBuffer;
import cn.org.gddsn.seis.location.rstt.VelocityIntegrate;
import java.io.PrintWriter;

class VelocityConst
extends VelocityIntegrate {
    private double vc;

    public VelocityConst() {
        this.vc = 0.0;
    }

    public VelocityConst(double c, double rt, double rb, String layrnam) {
        super(rt, rb, layrnam);
        this.vc = c;
        this.init();
    }

    public VelocityConst(VelocityConst vcst) {
        super(vcst);
        this.vc = vcst.vc;
    }

    public VelocityConst(DataBuffer buffer) {
        this.deserialize(buffer);
    }

    public VelocityConst copy(VelocityConst vcst) {
        super.copy(vcst);
        this.vc = vcst.vc;
        return this;
    }

    public double funk(double r) {
        return this.vc;
    }

    public double rAtP(double p) {
        return p * this.vc;
    }

    public double integrateDistance(double p, double ra, boolean r_open) {
        return this.integrateDistance(p, ra, this.vlRt, r_open);
    }

    public double integrateDistance(double p, double ra, double rb, boolean r_open) {
        if (this.vc == 0.0) {
            return 0.0;
        }
        double pv = p * this.vc;
        double prt = pv / rb;
        double prb = pv / ra;
        return Math.asin(Math.min(prb, 1.0)) - Math.asin(Math.min(prt, 1.0));
    }

    public double integrateTime(double p, double ra) {
        return this.integrateTime(p, ra, this.vlRt);
    }

    public double integrateTime(double p, double ra, double rb) {
        if (this.vc == 0.0) {
            return 0.0;
        }
        double pt = rb / this.vc;
        double pr = ra / this.vc;
        return Math.sqrt(Math.abs(pt - p) * (pt + p)) - Math.sqrt(Math.abs(pr - p) * (pr + p));
    }

    public boolean isTimeIntegralTau() {
        return false;
    }

    public void writeVelocity(PrintWriter os) {
        os.printf("%12.4f Constant", this.vc);
    }

    public void toStream(PrintWriter os, String indent) {
        os.printf(indent + "Velocity Definition          = ", new Object[0]);
        this.writeVelocity(os);
        os.println();
        super.toStream(os, indent);
    }

    public static String class_name() {
        return "VelocityConst";
    }

    public String get_class_name() {
        return VelocityConst.class_name();
    }

    public boolean isVelocityConstant() {
        return true;
    }

    public int bufferSize() {
        return 16 + super.bufferSize();
    }

    public void serialize(DataBuffer buffer) {
        buffer.writeDouble(this.vc);
        super.serialize(buffer);
    }

    public void deserialize(DataBuffer buffer) {
        this.vc = buffer.readDouble();
        super.deserialize(buffer);
    }
}

