/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.monitor;

import cn.org.gddsn.jopens.entity.mon.SSSClient;
import cn.org.gddsn.jopens.service.MonitorService;
import cn.org.gddsn.liss.message.ConnectionStatus;
import cn.org.gddsn.liss.message.LoginUserInfo;
import cn.org.gddsn.liss.message.MessageParseException;
import cn.org.gddsn.liss.message.Result;
import cn.org.gddsn.seis.monitor.AnimatingSurface;
import cn.org.gddsn.seis.monitor.LocaleResource;
import cn.org.gddsn.seis.monitor.MonitorJApplet;
import cn.org.gddsn.util.QueueAddElementEvent;
import cn.org.gddsn.util.QueueAddElementEventListener;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;

public class ConnectionPanel
extends AnimatingSurface
implements QueueAddElementEventListener {
    private LoginUserInfo[] info = null;
    private static final int UPLOAD = 1;
    private static final int DOWNLOAD = 2;
    BorderLayout borderLayout1 = new BorderLayout();
    private static final int INACTIVE_SERVER = 0;
    private static final int ACTIVE_SERVER = 1;
    private static final int INACTIVE_UPLOAD_CLIENT = 2;
    private static final int ACTIVE_UPLOAD_CLIENT = 3;
    private static final int INACTIVE_DOWNLOAD_CLIENT = 4;
    private static final int ACTIVE_DOWNLOAD_CLIENT = 5;
    Image[] img = new Image[]{this.getImage("server_down.gif", this), this.getImage("server_active.gif", this), this.getImage("server_down.gif", this), this.getImage("client_upload.gif", this), this.getImage("server_down.gif", this), this.getImage("client_download.gif", this)};
    private float alpha = 1.0f;
    private boolean bneg = true;
    private float ballPos = 0.0f;
    ClientStatus[] clientStatus = new ClientStatus[0];
    Point serverPos = null;
    private int selectedClientIdx = -1;
    JPopupMenu jPopupMenu1 = new JPopupMenu();
    JCheckBoxMenuItem jCheckBoxMenuItem1 = new JCheckBoxMenuItem();
    transient PropertyChangeSupport linkBrokenSupport = new PropertyChangeSupport(this);

    public ConnectionPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void config() {
        this.loadMonitorClientConfig();
        this.start();
        MonitorJApplet.monitorClient.addMonitorMessageListener(this);
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.setBackground(new Color(204, 204, 220));
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ConnectionPanel.this.this_mouseClicked(e);
            }
        });
        this.jCheckBoxMenuItem1.setText(LocaleResource.getResourceString("Alarm"));
        this.jCheckBoxMenuItem1.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ConnectionPanel.this.jCheckBoxMenuItem1_itemStateChanged(e);
            }
        });
        this.jPopupMenu1.add(this.jCheckBoxMenuItem1);
    }

    private void fillInfo() {
        int i = 0;
        while (i < this.clientStatus.length) {
            this.clientStatus[i].activeIdx = 0;
            ++i;
        }
        Vector<ClientStatus> vecOld = new Vector<ClientStatus>();
        Vector<ClientStatus> vecNew = new Vector<ClientStatus>();
        int i2 = 0;
        while (i2 < this.clientStatus.length) {
            boolean bmatch = false;
            int j = 0;
            while (j < this.info.length) {
                int idx = this.info[j].getFullUserName().indexOf(64);
                if (this.info[j].getFullUserName().equals(this.clientStatus[i2].mClient) || this.clientStatus[i2].mClient.substring(idx + 1).equals("0.0.0.0") && this.clientStatus[i2].mClient.substring(0, idx).equals(this.info[j].getFullUserName().substring(0, idx))) {
                    if (this.info[j].getPermission() == 2) {
                        this.clientStatus[i2].activeIdx = 5;
                        this.clientStatus[i2].upload = false;
                    } else if (this.info[j].getPermission() == 1) {
                        this.clientStatus[i2].activeIdx = 3;
                        this.clientStatus[i2].upload = true;
                    } else {
                        this.clientStatus[i2].activeIdx = 1;
                        this.clientStatus[i2].upload = true;
                    }
                    bmatch = true;
                    break;
                }
                ++j;
            }
            if (!bmatch && this.clientStatus[i2].joinAlarm) {
                ClientStatus oldStatus = (ClientStatus)this.clientStatus[i2].clone();
                this.clientStatus[i2].broken = true;
                vecOld.add(oldStatus);
                vecNew.add((ClientStatus)this.clientStatus[i2].clone());
            }
            ++i2;
        }
        if (vecOld.size() != 0) {
            this.linkBrokenSupport.firePropertyChange("clientStatus", vecOld, vecNew);
        }
    }

    public synchronized void QueueAddElementHandler(QueueAddElementEvent e) {
        Result res = (Result)e.getValue();
        if (res.getType() != 131077) {
            return;
        }
        try {
            ConnectionStatus conn = new ConnectionStatus(res);
            this.info = conn.getConnectionStatus();
            this.fillInfo();
        }
        catch (MessageParseException mpEx) {
            mpEx.printStackTrace();
        }
    }

    void caliClientPos(double R) {
        int i = 0;
        while (i < this.clientStatus.length) {
            double sita = Math.PI * 2 / (double)this.clientStatus.length * (double)i;
            double x = (double)this.serverPos.x + R * Math.cos(sita);
            double y = (double)this.serverPos.y + R * Math.sin(sita);
            this.clientStatus[i].mClientPos = new Point((int)x, (int)y);
            ++i;
        }
    }

    public void render(int w, int h, Graphics2D g2) {
        this.serverPos = new Point(w / 2, h / 2);
        int imgw = this.img[0].getWidth(this);
        int imgh = this.img[0].getHeight(this);
        double R = Math.min(w, h) / 2 - Math.max(imgw, imgh) * 2;
        this.caliClientPos(R);
        AlphaComposite ac = AlphaComposite.getInstance(3, this.alpha);
        g2.setComposite(ac);
        imgw = this.img[1].getWidth(this);
        imgh = this.img[1].getHeight(this);
        g2.drawImage(this.img[1], this.serverPos.x - imgw / 2, this.serverPos.y - imgh / 2, this);
        FontRenderContext frc = g2.getFontRenderContext();
        Font font = new Font("\ufffd\ufffd\ufffd\ufffd", 1, 18);
        g2.setColor(Color.black);
        TextLayout tl = new TextLayout("NetSeis/IP Server", font, frc);
        tl.draw(g2, (float)((double)this.serverPos.x - tl.getBounds().getWidth() / 2.0), this.serverPos.y + imgh / 2 + 20);
        int i = 0;
        while (i < this.clientStatus.length) {
            double sita = Math.PI * 2 / (double)this.clientStatus.length * (double)i;
            switch (this.clientStatus[i].activeIdx) {
                case 3: {
                    g2.setComposite(ac);
                    imgw = this.img[3].getWidth(this);
                    imgh = this.img[3].getHeight(this);
                    g2.drawImage(this.img[3], this.clientStatus[i].mClientPos.x - imgw / 2, this.clientStatus[i].mClientPos.y - imgh / 2, this);
                    this.animatingBall1(R, sita, 1.0f - this.ballPos, Color.red, g2);
                    break;
                }
                case 2: {
                    g2.setComposite(AlphaComposite.SrcOver);
                    imgw = this.img[2].getWidth(this);
                    imgh = this.img[2].getHeight(this);
                    g2.drawImage(this.img[2], this.clientStatus[i].mClientPos.x - imgw / 2, this.clientStatus[i].mClientPos.y - imgh / 2, this);
                    break;
                }
                case 5: {
                    g2.setComposite(ac);
                    imgw = this.img[5].getWidth(this);
                    imgh = this.img[5].getHeight(this);
                    g2.drawImage(this.img[5], this.clientStatus[i].mClientPos.x - imgw / 2, this.clientStatus[i].mClientPos.y - imgh / 2, this);
                    this.animatingBall1(R, sita, this.ballPos, Color.blue, g2);
                    break;
                }
                case 4: {
                    g2.setComposite(AlphaComposite.SrcOver);
                    imgw = this.img[4].getWidth(this);
                    imgh = this.img[4].getHeight(this);
                    g2.drawImage(this.img[4], this.clientStatus[i].mClientPos.x - imgw / 2, this.clientStatus[i].mClientPos.y - imgh / 2, this);
                    break;
                }
                case 0: {
                    g2.setComposite(AlphaComposite.SrcOver);
                    imgw = this.img[0].getWidth(this);
                    imgh = this.img[0].getHeight(this);
                    g2.drawImage(this.img[0], this.clientStatus[i].mClientPos.x - imgw / 2, this.clientStatus[i].mClientPos.y - imgh / 2, this);
                    break;
                }
            }
            g2.setColor(Color.black);
            g2.setComposite(AlphaComposite.SrcOver);
            tl = new TextLayout(this.clientStatus[i].mClientLabel, font, frc);
            tl.draw(g2, (float)((double)this.clientStatus[i].mClientPos.x - tl.getBounds().getWidth() / 2.0), this.clientStatus[i].mClientPos.y + imgh / 2 + 20);
            ++i;
        }
    }

    public void reset(int newwidth, int newheight) {
        this.setSleepAmount(100L);
        this.alpha = 1.0f;
        this.bneg = true;
    }

    public void step(int w, int h) {
        this.alpha = this.bneg ? (this.alpha -= 0.05f) : (this.alpha += 0.05f);
        if (this.alpha <= 0.15f) {
            this.alpha = 0.2f;
            this.bneg = false;
        }
        if (this.alpha > 1.0f) {
            this.alpha = 1.0f;
            this.bneg = true;
        }
        this.ballPos += 0.05f;
        if (this.ballPos >= 1.0f) {
            this.ballPos = 0.0f;
        }
    }

    void animatingBall1(double R, double sita, float pos, Color ballCol, Graphics2D g2) {
        double x = (double)this.serverPos.x + R * Math.cos(sita) * (double)pos;
        double y = (double)this.serverPos.y + R * Math.sin(sita) * (double)pos;
        Ellipse2D.Float ball = new Ellipse2D.Float();
        ((RectangularShape)ball).setFrame(x, y, 5.0, 5.0);
        g2.setColor(ballCol);
        g2.setComposite(AlphaComposite.SrcOver);
        g2.setStroke(new BasicStroke(1.0f));
        g2.fill(ball);
    }

    void animatingBall(int srcx, int srcy, int dstx, int dsty, float pos, Color ballCol, Graphics2D g2) {
        double sita;
        if (srcx == dstx) {
            sita = 1.5707963267948966;
        } else {
            double deltay = dsty - srcy;
            double deltax = dstx - srcx;
            sita = Math.atan(deltay / deltax);
            if (deltax < 0.0 && deltay > 0.0) {
                sita += Math.PI;
            } else if (deltax < 0.0 && deltay < 0.0) {
                sita += Math.PI;
            } else if (deltax > 0.0 && deltay < 0.0) {
                sita += Math.PI * 2;
            }
        }
        double diam = Math.sqrt((dsty - srcy) * (dsty - srcy) + (dstx - srcx) * (dstx - srcx));
        double x = (double)srcx + diam * Math.cos(sita) * (double)pos;
        double y = (double)srcy + diam * Math.sin(sita) * (double)pos;
        Ellipse2D.Float ball = new Ellipse2D.Float();
        ((RectangularShape)ball).setFrame(x, y, 10.0, 10.0);
        g2.setColor(ballCol);
        g2.setStroke(new BasicStroke(1.0f));
        g2.setComposite(AlphaComposite.SrcOver);
        g2.fill(ball);
    }

    private void loadMonitorClientConfig() {
        MonitorService service = (MonitorService)MonitorJApplet.factory.getBean("monitorService");
        Collection clients = service.findAllSSSClient();
        this.clientStatus = new ClientStatus[clients.size()];
        int i = 0;
        for (SSSClient c : clients) {
            this.clientStatus[i] = new ClientStatus();
            this.clientStatus[i].mClient = c.getClient();
            this.clientStatus[i].mClientLabel = c.getLabel();
            this.clientStatus[i].broken = false;
            this.clientStatus[i].joinAlarm = true;
            ++i;
        }
    }

    public boolean contains(int x, int y) {
        if (!super.contains(x, y)) {
            return false;
        }
        if (this.serverPos == null) {
            return false;
        }
        this.setToolTipText("<html><center><b><H3>move mouse to Icon, see what happen.</H3></b></center></html>");
        int imgw = this.img[1].getWidth(this);
        int imgh = this.img[1].getHeight(this);
        if (Math.abs(this.serverPos.x - x) < imgw / 2 && Math.abs(this.serverPos.y - y) < imgh / 2) {
            this.setToolTipText("<html><center><b><H1>NetSeis/IP Server</H1></b></center></html>");
            return true;
        }
        int i = 0;
        while (i < this.clientStatus.length) {
            imgw = this.img[this.clientStatus[i].activeIdx].getWidth(this);
            imgh = this.img[this.clientStatus[i].activeIdx].getHeight(this);
            if (Math.abs(x - this.clientStatus[i].mClientPos.x) < imgw / 2 && Math.abs(y - this.clientStatus[i].mClientPos.y) < imgh / 2) {
                this.setToolTipText(this.generateTooltipText(i));
                break;
            }
            ++i;
        }
        return true;
    }

    private String generateTooltipText(int i) {
        StringBuffer buf = new StringBuffer(1024);
        buf.append("<html>");
        buf.append("<center><H2>" + this.clientStatus[i].mClient + "</H2></center>");
        buf.append("<HR>");
        buf.append("<LI>Not Implemented yet:(");
        buf.append("<LI><STRONG>I need suggestion!</STRONG>");
        buf.append("<LI><font =+1>Fix ME</font>");
        buf.append("</html>");
        return buf.toString();
    }

    public void jCheckBoxMenuItem1_itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.clientStatus[this.selectedClientIdx].joinAlarm = true;
        } else if (e.getStateChange() == 2) {
            this.clientStatus[this.selectedClientIdx].joinAlarm = false;
        }
    }

    private int getSelectedClient(int x, int y) {
        int selected = -1;
        int i = 0;
        while (i < this.clientStatus.length) {
            int imgw = this.img[this.clientStatus[i].activeIdx].getWidth(this);
            int imgh = this.img[this.clientStatus[i].activeIdx].getHeight(this);
            if (Math.abs(x - this.clientStatus[i].mClientPos.x) < imgw / 2 && Math.abs(y - this.clientStatus[i].mClientPos.y) < imgh / 2) {
                this.setToolTipText(this.generateTooltipText(i));
                selected = i;
                break;
            }
            ++i;
        }
        return selected;
    }

    public void this_mouseClicked(MouseEvent e) {
        if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0 || (e.getModifiers() & 8) != 0) {
            this.selectedClientIdx = this.getSelectedClient(e.getX(), e.getY());
            if (this.selectedClientIdx != -1) {
                if (this.clientStatus[this.selectedClientIdx].joinAlarm) {
                    this.jCheckBoxMenuItem1.setSelected(true);
                } else {
                    this.jCheckBoxMenuItem1.setSelected(false);
                }
                this.add(this.jPopupMenu1);
                this.jPopupMenu1.show(this, e.getX(), e.getY());
            }
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.linkBrokenSupport.removePropertyChangeListener(l);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.linkBrokenSupport.addPropertyChangeListener(l);
    }

    public static class ClientStatus
    implements Cloneable {
        String mClient;
        String mClientLabel;
        boolean broken = false;
        boolean joinAlarm = true;
        Point mClientPos;
        int activeIdx;
        boolean upload;

        public Object clone() {
            ClientStatus result = null;
            try {
                result = (ClientStatus)super.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                throw new InternalError();
            }
            return result;
        }
    }
}

