/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.monitor;

import cn.org.gddsn.jopens.service.StationManagerService;
import cn.org.gddsn.seis.monitor.AlarmEqimHandler;
import cn.org.gddsn.seis.monitor.AlarmStrategy;
import cn.org.gddsn.seis.monitor.AlarmTopicHandler;
import cn.org.gddsn.seis.monitor.GobalsJPanel;
import cn.org.gddsn.seis.monitor.InternalFramePanel;
import cn.org.gddsn.seis.monitor.LoggerJPanel;
import cn.org.gddsn.seis.monitor.MonitorClient;
import cn.org.gddsn.seis.monitor.NetworkInfo;
import cn.org.gddsn.seis.monitor.StationJPanel;
import cn.org.gddsn.seis.monitor.StrategyBean;
import cn.org.gddsn.seis.monitor.StrategyJPanel;
import cn.org.gddsn.seis.rts.AlarmEvent;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

public class MonitorJApplet
extends JApplet
implements PropertyChangeListener {
    private static final long serialVersionUID = -6180274838277202206L;
    static Logger logger = Logger.getLogger(MonitorJApplet.class);
    boolean isStandalone = false;
    static MonitorClient monitorClient = null;
    static ApplicationContext factory;
    static StationManagerService sms;
    static NetworkInfo networkInfo;
    static AlarmStrategy alarm;
    static URL baseURL;
    InternalFramePanel gobalsfp = new InternalFramePanel();
    InternalFramePanel stationfp = new InternalFramePanel();
    InternalFramePanel strategyfp = new InternalFramePanel();
    InternalFramePanel loggerfp = new InternalFramePanel();
    JTabbedPane jTabbedPane1 = new JTabbedPane();
    GobalsJPanel jPanel1 = new GobalsJPanel();
    StationJPanel jPanel2 = null;
    StrategyJPanel jPanel4 = new StrategyJPanel();
    LoggerJPanel jPanel3 = new LoggerJPanel();
    private AlarmEvent alarmEvent;
    DefaultMessageListenerContainer alarmTopicHandlerContainer = null;
    DefaultMessageListenerContainer alarmEventContainer = null;
    DefaultMessageListenerContainer eqimContainer = null;
    AudioClip audioEQ = null;

    static {
        networkInfo = null;
        alarm = null;
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getParameter(String key, String def) {
        return this.isStandalone ? System.getProperty(key, def) : (this.getParameter(key) != null ? this.getParameter(key) : def);
    }

    public void init() {
        logger.info((Object)"init ...");
        try {
            try {
                baseURL = this.getCodeBase();
            }
            catch (Exception e) {
                baseURL = null;
            }
            if (baseURL == null) {
                File file = new File(".");
                baseURL = file.toURI().toURL();
            }
            logger.info((Object)("file to url..." + baseURL.toString()));
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.config();
        logger.info((Object)"config success");
    }

    public void config() {
        factory = new FileSystemXmlApplicationContext(new String[]{"resource/MonitorJApplet.xml"});
        logger.info((Object)"getting Monitor client ...");
        monitorClient = (MonitorClient)factory.getBean("monitorClient");
        logger.info((Object)"got Monitor client.");
        logger.info((Object)"getting StationManager Service ...");
        sms = (StationManagerService)factory.getBean("stationManagerService");
        logger.info((Object)"got StationManager Service.");
        networkInfo = new NetworkInfo();
        logger.info((Object)"got Network Info.");
        alarm = new AlarmStrategy();
        logger.info((Object)"new alarm strategy");
        this.jPanel1.config();
        this.jPanel2.config(this.stationfp);
        this.jPanel2.addPropertyChangeListener(this.jPanel1.alarmJPanel);
        AlarmEqimHandler eqimHandler = (AlarmEqimHandler)factory.getBean("eqimHandler");
        eqimHandler.setAlarmJPanel(this.jPanel1.alarmJPanel);
        this.eqimContainer = (DefaultMessageListenerContainer)factory.getBean("eqimContainer");
        this.eqimContainer.start();
        logger.info((Object)"started eqim Container.");
        AlarmTopicHandler ath = (AlarmTopicHandler)factory.getBean("alarmTopicHandler");
        ath.setAlarmJPanel(this.jPanel1.alarmJPanel);
        this.jPanel1.alarmJPanel.setAlarmTopicHandler(ath);
        this.alarmTopicHandlerContainer = (DefaultMessageListenerContainer)factory.getBean("athc");
        this.alarmTopicHandlerContainer.start();
        logger.info((Object)"started Alarm Topic Container.");
        this.alarmEventContainer = (DefaultMessageListenerContainer)factory.getBean("alarmEventContainer");
        this.alarmEventContainer.start();
        logger.info((Object)"started Alarm Event Container.");
        this.alarmEvent = (AlarmEvent)factory.getBean("alarmEvent");
        this.alarmEvent.addPropertyChangeListener(this);
        factory = new FileSystemXmlApplicationContext(new String[]{"resource/alarmStrategy.xml"});
        StrategyBean bean = (StrategyBean)factory.getBean("strategyBean");
        this.jPanel4.config(bean);
        this.jPanel3.config(bean);
        this.jPanel4.addPropertyChangeListener(this.jPanel1.alarmJPanel);
        this.jPanel4.addPropertyChangeListener(this.jPanel3);
        try {
            this.audioEQ = Applet.newAudioClip(new URL(baseURL, "resource/audio/alarm.au"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("alarmEvent")) {
            if (this.audioEQ != null) {
                this.audioEQ.stop();
            }
            this.audioEQ.play();
            String eventMsg = (String)evt.getNewValue();
            this.gobalsfp.setTitle(eventMsg);
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(1024, 768));
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.gobalsfp.addMainInternalFrame(this.jPanel1);
        this.jPanel2 = new StationJPanel();
        this.stationfp.addMainInternalFrame(this.jPanel2);
        this.strategyfp.addMainInternalFrame(this.jPanel4);
        this.loggerfp.addMainInternalFrame(this.jPanel3);
        this.jTabbedPane1.add((Component)this.gobalsfp, "Global");
        this.jTabbedPane1.add((Component)this.stationfp, "Station");
        this.jTabbedPane1.add((Component)this.strategyfp, "Strategy");
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MonitorJApplet.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.jTabbedPane1.add((Component)this.loggerfp, "Logger");
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        if (this.jTabbedPane1.getSelectedIndex() == 2) {
            this.jPanel4.getParameter();
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
        monitorClient.quit();
        this.jPanel1.stop();
        this.jPanel2.stop();
        this.alarmEventContainer.shutdown();
        this.alarmTopicHandlerContainer.shutdown();
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        return null;
    }

    public static void main(String[] args) {
        PropertyConfigurator.configureAndWatch((String)"Monitor.properties");
        MonitorJApplet applet = new MonitorJApplet();
        applet.isStandalone = true;
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setTitle("Applet Frame");
        frame.getContentPane().add((Component)applet, "Center");
        applet.init();
        applet.start();
        frame.setSize(1024, 788);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
        frame.setVisible(true);
    }
}

