/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.monitor;

import cn.org.gddsn.jopens.entity.seed.Channel;
import cn.org.gddsn.jopens.entity.seed.Station;
import cn.org.gddsn.seis.ChannelLocator;
import cn.org.gddsn.seis.monitor.MonitorJApplet;
import cn.org.gddsn.seis.monitor.StationConnectionInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkInfo {
    static Logger logger = Logger.getLogger(NetworkInfo.class);
    private ArrayList<StationConnectionInfo> stationInfo = new ArrayList();

    public NetworkInfo() {
        List stns = MonitorJApplet.sms.findAllStation();
        for (Station s : stns) {
            StationConnectionInfo sci = new StationConnectionInfo();
            if (s.getBlockette050().getNetworkCode() == null || s.getBlockette050().getStation() == null) {
                logger.warn((Object)"Got invalid NN/SSSS, please station info in db");
                continue;
            }
            sci.setNetworkId(s.getBlockette050().getNetworkCode());
            sci.setStation(s.getBlockette050().getStation());
            sci.setDasType(0);
            sci.setMultiDas(false);
            if (s.getStationInfo() == null) continue;
            sci.setPort(s.getStationInfo().getPortNumber());
            sci.setIpAddress(s.getStationInfo().getHost());
            sci.setUser(s.getStationInfo().getUserName());
            sci.setPassword(s.getStationInfo().getPassword());
            sci.setLat(s.getBlockette050().getLatitude());
            sci.setLon(s.getBlockette050().getLongitude());
            List chs = MonitorJApplet.sms.findStationById(s.getId()).getChannel();
            ChannelLocator[] chans = new ChannelLocator[chs.size()];
            int i = 0;
            while (i < chans.length) {
                Channel ch = (Channel)chs.get(i);
                chans[i] = new ChannelLocator(s.getBlockette050().getNetworkCode(), s.getBlockette050().getStation(), ch.getBlockette052().getLocation(), ch.getBlockette052().getChannel());
                ++i;
            }
            sci.setChans(chans);
            this.stationInfo.add(sci);
        }
    }

    public String toString() {
        int size = this.stationInfo.size();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < size) {
            sb.append(this.stationInfo.get(i) + " , ");
            ++i;
        }
        return sb.substring(0);
    }

    public StationConnectionInfo findStation(String networkId, String station) {
        for (StationConnectionInfo e : this.stationInfo) {
            if (!e.getNetworkId().equals(networkId) || !e.getStation().equals(station)) continue;
            return e;
        }
        return null;
    }

    public ArrayList<StationConnectionInfo> getStationInfo() {
        return this.stationInfo;
    }

    public void setStationInfo(ArrayList<StationConnectionInfo> stationInfo) {
        this.stationInfo = stationInfo;
    }
}

