/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.monitor;

import cn.org.gddsn.jopens.entity.seed.Station;
import cn.org.gddsn.liss.client.LissClient;
import cn.org.gddsn.liss.message.MessageParseException;
import cn.org.gddsn.liss.message.Result;
import cn.org.gddsn.liss.message.WaveformStreamStatus;
import cn.org.gddsn.seis.monitor.AnimatingSurface;
import cn.org.gddsn.seis.monitor.InternalFramePanel;
import cn.org.gddsn.seis.monitor.LocaleResource;
import cn.org.gddsn.seis.monitor.MonitorJApplet;
import cn.org.gddsn.seis.monitor.StationConnectionInfo;
import cn.org.gddsn.seis.monitor.StationWaveformJPanel;
import cn.org.gddsn.seis.monitor.VectorMap2D;
import cn.org.gddsn.seis.monitor.edas.Controler;
import cn.org.gddsn.seis.monitor.edas.awt.MainClass;
import cn.org.gddsn.util.QueueAddElementEvent;
import cn.org.gddsn.util.QueueAddElementEventListener;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

public class StationJPanel
extends AnimatingSurface
implements QueueAddElementEventListener {
    static Logger logger = Logger.getLogger(StationJPanel.class);
    private static final int INACTIVE_ICON = 0;
    private static final int ACTIVE_ICON = 1;
    private static final int TRIGGER_ICON = 2;
    Image[] img = new Image[]{this.getImage("gray.gif", this), this.getImage("green.gif", this), this.getImage("red.gif", this)};
    private float alpha = 1.0f;
    private boolean bneg = true;
    public StationStatus[] stationStatus = null;
    private int selectedStationIdx = -1;
    transient PropertyChangeSupport stationBrokenSupport = new PropertyChangeSupport(this);
    InternalFramePanel ifpanel;
    BorderLayout borderLayout1 = new BorderLayout();
    VectorMap2D map2d = new VectorMap2D(this);
    JPopupMenu jPopupMenu = new JPopupMenu();
    JMenuItem jMenuItem2 = new JMenuItem();
    JMenuItem jMenuItem3 = new JMenuItem();
    JMenuItem jMenuItem4 = new JMenuItem();
    JCheckBoxMenuItem jCheckBoxMenuItem1 = new JCheckBoxMenuItem();
    JMenu jMenu1 = new JMenu();
    JMenuItem jMenuItem1 = new JMenuItem();
    JMenuItem jMenuItem5 = new JMenuItem();
    JMenuItem jMenuItem6 = new JMenuItem();
    JMenuItem jMenuItemDas = new JMenuItem();
    JMenuItem jmnuSwitch = new JMenuItem();

    public StationJPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void config(InternalFramePanel ifpanel) {
        this.ifpanel = ifpanel;
        List stns = MonitorJApplet.sms.findAllStation();
        logger.info((Object)("station number: " + stns.size()));
        String[] netStn = new String[stns.size()];
        int j = 0;
        for (Station s : stns) {
            netStn[j++] = String.valueOf(s.getBlockette050().getNetworkCode()) + "/" + s.getBlockette050().getStation();
        }
        this.stationStatus = new StationStatus[netStn.length];
        int i = 0;
        while (i < this.stationStatus.length) {
            this.stationStatus[i] = new StationStatus();
            int idx = netStn[i].indexOf(47);
            this.stationStatus[i].networkId = netStn[i].substring(0, idx);
            this.stationStatus[i].stnCode = netStn[i].substring(idx + 1);
            ++i;
        }
        this.setSleepAmount(1000L);
        this.start();
        MonitorJApplet.monitorClient.addMonitorMessageListener(this);
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jMenuItem2.setText(LocaleResource.getResourceString("StationInfo"));
        this.jMenuItem3.setText(LocaleResource.getResourceString("WaveformScan"));
        this.jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StationJPanel.this.jMenuItem3_actionPerformed(e);
            }
        });
        this.jMenuItem4.setText("Broken Statistics");
        this.jMenuItem4.setEnabled(false);
        this.jCheckBoxMenuItem1.setText(LocaleResource.getResourceString("Alarm"));
        this.jCheckBoxMenuItem1.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                StationJPanel.this.jCheckBoxMenuItem1_itemStateChanged(e);
            }
        });
        this.jMenu1.setText(LocaleResource.getResourceString("DasInfo"));
        this.jMenu1.setEnabled(false);
        this.jMenuItem1.setText("Fix Me 1:(");
        this.jMenuItem5.setText("Fix Me 2:(");
        this.jMenuItem6.setText("?");
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                StationJPanel.this.this_mouseClicked(e);
            }
        });
        this.jMenuItemDas.setText(LocaleResource.getResourceString("DasControl"));
        this.jMenuItemDas.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StationJPanel.this.jMenuItemDas_actionPerformed(e);
            }
        });
        this.jmnuSwitch.setText("switch to Das: 1");
        this.jmnuSwitch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StationJPanel.this.jmnuSwitch_actionPerformed(e);
            }
        });
        this.jPopupMenu.add(this.jMenuItemDas);
        this.jPopupMenu.add(this.jMenuItem2);
        this.jPopupMenu.add(this.jMenu1);
        this.jPopupMenu.add(this.jMenuItem3);
        this.jPopupMenu.add(this.jMenuItem4);
        this.jPopupMenu.add(this.jCheckBoxMenuItem1);
        this.jPopupMenu.add(this.jmnuSwitch);
        this.jMenu1.add(this.jMenuItem1);
        this.jMenu1.add(this.jMenuItem5);
        this.jMenu1.add(this.jMenuItem6);
    }

    public void paintIcon(Image[] imgs, Point[] imgPos, float[] alpha, Graphics2D g2) {
    }

    public synchronized void QueueAddElementHandler(QueueAddElementEvent e) {
        Result res = (Result)e.getValue();
        if (res.getType() != 131074) {
            return;
        }
        try {
            WaveformStreamStatus wfStatus = new WaveformStreamStatus(res);
            Vector<StationStatus> vecNew = new Vector<StationStatus>();
            Vector<StationStatus> vecOld = new Vector<StationStatus>();
            int i = 0;
            while (i < this.stationStatus.length) {
                String stationName = String.valueOf(this.stationStatus[i].networkId) + "/" + this.stationStatus[i].stnCode;
                short newStatus = wfStatus.getStatus(stationName);
                if (MonitorJApplet.alarm.getWhetherJoinAlarm(stationName)) {
                    this.stationStatus[i].joinAlarm = true;
                }
                if (newStatus == 0 && this.stationStatus[i].joinAlarm) {
                    StationStatus oldStatus = (StationStatus)this.stationStatus[i].clone();
                    this.stationStatus[i].activeIdx = newStatus;
                    vecOld.add(oldStatus);
                    vecNew.add((StationStatus)this.stationStatus[i].clone());
                }
                this.stationStatus[i].activeIdx = newStatus;
                ++i;
            }
            vecOld.size();
        }
        catch (MessageParseException mpEx) {
            mpEx.printStackTrace();
        }
    }

    public synchronized void render(int w, int h, Graphics2D g2) {
        boolean brepaint = this.map2d.paintComponent(g2);
        if (this.stationStatus == null) {
            return;
        }
        if (brepaint) {
            int i = 0;
            while (i < this.stationStatus.length) {
                StationConnectionInfo stn = MonitorJApplet.networkInfo.findStation(this.stationStatus[i].networkId, this.stationStatus[i].stnCode);
                if (stn == null) {
                    logger.warn((Object)("Warning: could not found " + this.stationStatus[i].stnCode));
                } else {
                    this.stationStatus[i].stnPos = new Point2D.Double();
                    this.stationStatus[i].par = this.map2d.getPoint(this.stationStatus[i].stnPos, stn.getLat(), stn.getLon());
                }
                ++i;
            }
        }
        AlphaComposite ac = AlphaComposite.getInstance(3, this.alpha);
        g2.setComposite(ac);
        int imgw = this.img[0].getWidth(this);
        int imgh = this.img[0].getHeight(this);
        int i = 0;
        while (i < this.stationStatus.length) {
            if (this.stationStatus[i].par >= 0) {
                switch (this.stationStatus[i].activeIdx) {
                    case 1: {
                        ac = AlphaComposite.getInstance(3, this.alpha);
                        g2.setComposite(ac);
                        if (this.stationStatus[i].stnPos == null) break;
                        Point2D.Double srcP = new Point2D.Double(this.stationStatus[i].stnPos.getX(), this.stationStatus[i].stnPos.getY());
                        Point2D.Double dstP = new Point2D.Double();
                        this.map2d.getTransform().transform(srcP, dstP);
                        g2.drawImage(this.img[1], (int)((Point2D)dstP).getX() - imgw / 2, (int)((Point2D)dstP).getY() - imgh / 2, this);
                        break;
                    }
                    case 0: {
                        g2.setComposite(AlphaComposite.SrcOver);
                        if (this.stationStatus[i].stnPos == null) break;
                        Point2D.Double srcP = new Point2D.Double(this.stationStatus[i].stnPos.getX(), this.stationStatus[i].stnPos.getY());
                        Point2D.Double dstP = new Point2D.Double();
                        this.map2d.getTransform().transform(srcP, dstP);
                        g2.drawImage(this.img[0], (int)((Point2D)dstP).getX() - imgw / 2, (int)((Point2D)dstP).getY() - imgh / 2, this);
                        if (this.stationStatus[i].stnPos == null) break;
                        srcP = new Point2D.Double(this.stationStatus[i].stnPos.getX(), this.stationStatus[i].stnPos.getY());
                        g2.drawString(String.valueOf(this.stationStatus[i].networkId) + "/" + this.stationStatus[i].stnCode, (int)((Point2D)dstP).getX() + 3, (int)((Point2D)dstP).getY() - 3);
                        break;
                    }
                }
            }
            ++i;
        }
    }

    public void step(int w, int h) {
        this.alpha = this.bneg ? (this.alpha -= 0.05f) : (this.alpha += 0.05f);
        if (this.alpha <= 0.15f) {
            this.alpha = 0.2f;
            this.bneg = false;
        }
        if (this.alpha > 1.0f) {
            this.alpha = 1.0f;
            this.bneg = true;
        }
    }

    public void reset(int newwidth, int newheight) {
        this.setSleepAmount(100L);
        this.alpha = 1.0f;
        this.bneg = true;
    }

    public boolean contains(int x, int y) {
        int imgh;
        if (!super.contains(x, y)) {
            return false;
        }
        if (this.stationStatus == null) {
            return false;
        }
        Point2D.Double pnt = new Point2D.Double();
        try {
            this.map2d.getTransform().inverseTransform(new Point2D.Double(x, y), pnt);
        }
        catch (NoninvertibleTransformException ntfEx) {
            ntfEx.printStackTrace();
        }
        this.setToolTipText("<html><center><H2>TIPS</H2><HR></center><LI>CTL+Left Button ---- Zoom Out<LI>CTL+Right Button --- Zoom In<LI>Shift+Left Button -- Center<LI>Left Button -------- Popup Menu<LI><b><H3>move mouse to Icon, see what happen.</H3></b></html>");
        int i = 0;
        while (i < this.stationStatus.length) {
            if (this.stationStatus[i].par >= 0) {
                if (this.stationStatus[i].activeIdx == -1) {
                    this.stationStatus[i].activeIdx = 0;
                    logger.warn((Object)("SSS do not have staion " + this.stationStatus[i].networkId + "/" + this.stationStatus[i].stnCode));
                }
                int imgw = this.img[this.stationStatus[i].activeIdx].getWidth(this);
                imgh = this.img[this.stationStatus[i].activeIdx].getHeight(this);
                if (this.stationStatus[i].stnPos != null && Math.abs(((Point2D)pnt).getX() - this.stationStatus[i].stnPos.getX()) < (double)(imgw / 2) && Math.abs(((Point2D)pnt).getY() - this.stationStatus[i].stnPos.getY()) < (double)(imgh / 2)) {
                    this.setToolTipText(this.generateTooltipText(i));
                    return true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.stationStatus.length) {
            if (this.stationStatus[i].par >= 0) {
                if (this.stationStatus[i].activeIdx == -1) {
                    this.stationStatus[i].activeIdx = 0;
                    logger.warn((Object)("SSS do not have staion " + this.stationStatus[i].networkId + "/" + this.stationStatus[i].stnCode));
                }
                int imgw = this.img[this.stationStatus[i].activeIdx].getWidth(this);
                imgh = this.img[this.stationStatus[i].activeIdx].getHeight(this);
                if (this.stationStatus[i].stnPos != null) {
                    this.map2d.getTransform().transform(this.stationStatus[i].stnPos, pnt);
                    if (Math.abs(((Point2D)pnt).getX() - (double)x) < (double)(imgw / 2) && Math.abs(((Point2D)pnt).getY() - (double)y) < (double)(imgh / 2)) {
                        this.setToolTipText(this.generateTooltipText(i));
                        return true;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    private int getSelectedStationCode(int x, int y) {
        int imgh;
        int selected = -1;
        Point2D.Double pnt = new Point2D.Double();
        try {
            this.map2d.getTransform().inverseTransform(new Point2D.Double(x, y), pnt);
        }
        catch (NoninvertibleTransformException ntfEx) {
            ntfEx.printStackTrace();
        }
        int i = 0;
        while (i < this.stationStatus.length) {
            if (this.stationStatus[i].par >= 0) {
                if (this.stationStatus[i].activeIdx == -1) {
                    this.stationStatus[i].activeIdx = 0;
                    logger.warn((Object)("SSS do not have staion " + this.stationStatus[i].networkId + "/" + this.stationStatus[i].stnCode));
                }
                int imgw = this.img[this.stationStatus[i].activeIdx].getWidth(this);
                imgh = this.img[this.stationStatus[i].activeIdx].getHeight(this);
                if (this.stationStatus[i].stnPos != null && Math.abs(((Point2D)pnt).getX() - this.stationStatus[i].stnPos.getX()) < (double)(imgw / 2) && Math.abs(((Point2D)pnt).getY() - this.stationStatus[i].stnPos.getY()) < (double)(imgh / 2)) {
                    return i;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.stationStatus.length) {
            if (this.stationStatus[i].par >= 0) {
                if (this.stationStatus[i].activeIdx == -1) {
                    this.stationStatus[i].activeIdx = 0;
                    logger.warn((Object)("SSS do not have staion " + this.stationStatus[i].networkId + "/" + this.stationStatus[i].stnCode));
                }
                int imgw = this.img[this.stationStatus[i].activeIdx].getWidth(this);
                imgh = this.img[this.stationStatus[i].activeIdx].getHeight(this);
                this.map2d.getTransform().transform(this.stationStatus[i].stnPos, pnt);
                if (Math.abs(((Point2D)pnt).getX() - (double)x) < (double)(imgw / 2) && Math.abs(((Point2D)pnt).getY() - (double)y) < (double)(imgh / 2)) {
                    return i;
                }
            }
            ++i;
        }
        return selected;
    }

    private String generateTooltipText(int i) {
        StringBuffer buf = new StringBuffer(1024);
        buf.append("<html>");
        buf.append("<center><H2>" + this.stationStatus[i].networkId + "/" + this.stationStatus[i].stnCode + "</H2></center>");
        buf.append("<HR>");
        buf.append("<LI>Not Implement Yet:(");
        buf.append("<LI><STRONG>I need suggestion!</STRONG>");
        buf.append("<LI><font =+1>Fix ME</font>");
        buf.append("</html>");
        return buf.toString();
    }

    public static void main(String[] args) {
        StationStatus status = new StationStatus();
        StationStatus newStatus = (StationStatus)status.clone();
    }

    void this_mouseClicked(MouseEvent e) {
        if ((e.getModifiers() & 2) != 0) {
            return;
        }
        if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0 || (e.getModifiers() & 8) != 0) {
            this.add(this.jPopupMenu);
            this.selectedStationIdx = this.getSelectedStationCode(e.getX(), e.getY());
            if (this.selectedStationIdx != -1) {
                this.jMenuItem2.setEnabled(true);
                this.jMenuItem3.setEnabled(true);
                this.jCheckBoxMenuItem1.setEnabled(true);
                this.jCheckBoxMenuItem1.setState(this.stationStatus[this.selectedStationIdx].joinAlarm);
                this.jMenu1.setEnabled(true);
                String networkId = this.stationStatus[this.selectedStationIdx].networkId;
                String sta = this.stationStatus[this.selectedStationIdx].stnCode;
                StationConnectionInfo info = MonitorJApplet.networkInfo.findStation(networkId, sta);
                if (info != null) {
                    int toDas = (this.stationStatus[this.selectedStationIdx].curDas + 1) % 2;
                    this.jmnuSwitch.setText("Switch to Das: " + toDas);
                    if (info.isMultiDas()) {
                        this.jmnuSwitch.setEnabled(true);
                    } else {
                        this.jmnuSwitch.setEnabled(false);
                    }
                } else {
                    logger.warn((Object)("could not find StationConnectionInfo of " + networkId + "/" + sta));
                }
            } else {
                this.jMenuItem2.setEnabled(false);
                this.jMenuItem3.setEnabled(false);
                this.jCheckBoxMenuItem1.setEnabled(false);
                this.jMenu1.setEnabled(false);
                this.jmnuSwitch.setEnabled(false);
            }
            this.jPopupMenu.show(this, e.getX(), e.getY());
        }
    }

    void jMenuItem3_actionPerformed(ActionEvent e) {
        this.ifpanel.showInternalFrame(new StationWaveformJPanel(this.stationStatus[this.selectedStationIdx].networkId, this.stationStatus[this.selectedStationIdx].stnCode));
    }

    public void jCheckBoxMenuItem1_itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.stationStatus[this.selectedStationIdx].joinAlarm = true;
            MonitorJApplet.alarm.setStationJoinAlarm(String.valueOf(this.stationStatus[this.selectedStationIdx].networkId) + "/" + this.stationStatus[this.selectedStationIdx].stnCode, true);
            logger.info((Object)("set" + this.stationStatus[this.selectedStationIdx].networkId + "/" + this.stationStatus[this.selectedStationIdx].stnCode + "to join alarm monitor"));
        } else if (e.getStateChange() == 2) {
            this.stationStatus[this.selectedStationIdx].joinAlarm = false;
            MonitorJApplet.alarm.setStationJoinAlarm(String.valueOf(this.stationStatus[this.selectedStationIdx].networkId) + "/" + this.stationStatus[this.selectedStationIdx].stnCode, false);
            logger.info((Object)("set" + this.stationStatus[this.selectedStationIdx].networkId + "/" + this.stationStatus[this.selectedStationIdx].stnCode + "to not join alarm monitor"));
        }
    }

    public void jMenuItemDas_actionPerformed(ActionEvent e) {
        String networkId = this.stationStatus[this.selectedStationIdx].networkId;
        String sta = this.stationStatus[this.selectedStationIdx].stnCode;
        logger.info((Object)("select station: " + networkId + "/" + sta));
        MainClass cls = new MainClass(false);
        StationConnectionInfo info = MonitorJApplet.networkInfo.findStation(networkId, sta);
        if (info != null) {
            Controler.host = info.getIpAddress();
            Controler.port = info.getPort();
            Controler.user = info.getUser();
            Controler.password = info.getPassword();
            if (Controler.connect()) {
                logger.info((Object)("connecting " + Controler.host + ":" + Controler.port));
                System.out.println("connecting " + Controler.host + ":" + Controler.port);
                cls.frame.enableGUI(true);
                cls.frame.showWaveform();
            } else {
                cls.frame.warnStatusBar("Falit to Connect " + Controler.host);
            }
        } else {
            logger.warn((Object)("could not find StationConnectionInfo of " + networkId + "/" + sta));
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.stationBrokenSupport.removePropertyChangeListener(l);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.stationBrokenSupport.addPropertyChangeListener(l);
    }

    public void jmnuSwitch_actionPerformed(ActionEvent e) {
        String networkId = this.stationStatus[this.selectedStationIdx].networkId;
        String sta = this.stationStatus[this.selectedStationIdx].stnCode;
        StationConnectionInfo info = MonitorJApplet.networkInfo.findStation(networkId, sta);
        if (info != null) {
            try {
                LissClient client = new LissClient(info.getIpAddress(), info.getPort());
                client.login("root", "netseis");
                int toDas = (this.stationStatus[this.selectedStationIdx].curDas + 1) % 2;
                client.shellCommand(new String[]{"/bin/sh", "/home/ipbox/swDas.sh", "" + toDas});
                this.stationStatus[this.selectedStationIdx].curDas = toDas;
            }
            catch (Exception ex) {
                logger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            logger.warn((Object)("could not find StationConnectionInfo of " + networkId + "/" + sta));
        }
    }

    public static class StationStatus
    implements Cloneable {
        public Point2D stnPos;
        public int par;
        public short activeIdx = 0;
        public String networkId;
        public String stnCode;
        public boolean joinAlarm = true;
        public int curDas = 0;

        public Object clone() {
            StationStatus result = null;
            try {
                result = (StationStatus)super.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                throw new InternalError();
            }
            return result;
        }
    }
}

