/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.monitor;

import cn.org.gddsn.jopens.entity.seed.Station;
import cn.org.gddsn.liss.message.MessageParseException;
import cn.org.gddsn.liss.message.Result;
import cn.org.gddsn.liss.message.WaveformStreamStatus;
import cn.org.gddsn.seis.monitor.MonitorJApplet;
import cn.org.gddsn.seis.monitor.StationJPanel;
import cn.org.gddsn.seis.monitor.StrategyBean;
import cn.org.gddsn.util.QueueAddElementEvent;
import cn.org.gddsn.util.QueueAddElementEventListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;

public class StrategyJPanel
extends JPanel
implements QueueAddElementEventListener {
    static Logger logger = Logger.getLogger(StrategyJPanel.class);
    private static final int INACTIVE_ICON = 0;
    private static final int ACTIVE_ICON = 1;
    private static final int TRIGGER_ICON = 2;
    private static final int FRS = 1;
    private static final int FRAME_RELAY = 1;
    private static final int SDH = 2;
    private static final int SATELLITE = 3;
    private static final int VPDN = 4;
    private static final int ADSL = 5;
    public StationJPanel.StationStatus[] stationStatus = null;
    private String[] netStn = null;
    public static ApplicationContext ctx;
    transient PropertyChangeSupport stationBrokenSupport = new PropertyChangeSupport(this);
    BorderLayout borderLayout1 = new BorderLayout();
    String[] str3 = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};
    JPanel StrategyPanel = new JPanel();
    JPanel StationPanel = new JPanel();
    JPanel CommentPanel = new JPanel();
    JLabel label11 = new JLabel("\u4e2d\u65ad\u591a\u957f\u65f6\u95f4\u62a5\u8b66\uff08\u79d2\uff09", 0);
    JLabel label12 = new JLabel("\u4e2d\u65ad\u591a\u5c11\u53f0\u7ad9\u62a5\u8b66", 0);
    JLabel label13 = new JLabel("\u7b56\u7565\u5f00\u59cb\u65f6\u95f4", 0);
    JLabel label14 = new JLabel("\u7b56\u7565\u7ec8\u6b62\u65f6\u95f4", 0);
    JLabel label21 = new JLabel("\u4e3b\u76d1\u63a7\u53f0\u7f51", 0);
    JLabel label22 = new JLabel("\u526f\u76d1\u63a7\u53f0\u7f51", 0);
    JLabel label23 = new JLabel("\u901f\u62a5\u53f0\u7ad9", 0);
    JLabel label24 = new JLabel("\u5e27\u4e2d\u7ee7\u53f0\u7ad9", 0);
    JLabel label25 = new JLabel("SDH\u53f0\u7ad9", 0);
    JLabel label26 = new JLabel("\u536b\u661f\u53f0\u7ad9", 0);
    JLabel label27 = new JLabel("VPDN\u53f0\u7ad9", 0);
    JLabel label28 = new JLabel("ADSL\u53f0\u7ad9", 0);
    JTextField text11 = new JTextField(10);
    JTextField text12 = new JTextField(10);
    JComboBox cbox13 = new JComboBox<String>(this.str3);
    JComboBox cbox14 = new JComboBox<String>(this.str3);
    JTextField text21 = new JTextField(5);
    JTextField text22 = new JTextField(10);
    JTextArea txar23 = new JTextArea(3, 50);
    JTextArea txar24 = new JTextArea(3, 50);
    JTextArea txar25 = new JTextArea(3, 50);
    JTextArea txar26 = new JTextArea(3, 50);
    JTextArea txar27 = new JTextArea(3, 50);
    JTextArea txar28 = new JTextArea(3, 50);
    JTextArea txar31 = new JTextArea(3, 80);

    public StrategyJPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.add((Component)this.StrategyPanel, "North");
        this.StrategyPanel.setLayout(new GridLayout(4, 2));
        this.StrategyPanel.setBorder(BorderFactory.createTitledBorder("\u7b56\u7565\u914d\u7f6e"));
        this.StrategyPanel.add(this.label11);
        this.StrategyPanel.add(this.text11);
        this.StrategyPanel.add(this.label12);
        this.StrategyPanel.add(this.text12);
        this.StrategyPanel.add(this.label13);
        this.StrategyPanel.add(this.cbox13);
        this.StrategyPanel.add(this.label14);
        this.StrategyPanel.add(this.cbox14);
        this.add((Component)this.StationPanel, "Center");
        this.StationPanel.setLayout(new GridLayout(8, 2));
        this.StationPanel.setBorder(BorderFactory.createTitledBorder("\u53f0\u7f51\u4e0e\u53f0\u7ad9\u4fe1\u606f\u914d\u7f6e"));
        this.StationPanel.add(this.label21);
        this.StationPanel.add(this.text21);
        this.StationPanel.add(this.label22);
        this.StationPanel.add(this.text22);
        this.StationPanel.add(this.label23);
        this.txar23.setLineWrap(true);
        this.txar23.setWrapStyleWord(true);
        this.StationPanel.add(new JScrollPane(this.txar23));
        this.StationPanel.add(this.label24);
        this.txar24.setLineWrap(true);
        this.txar24.setWrapStyleWord(true);
        this.StationPanel.add(new JScrollPane(this.txar24));
        this.StationPanel.add(this.label25);
        this.txar25.setLineWrap(true);
        this.txar25.setWrapStyleWord(true);
        this.StationPanel.add(new JScrollPane(this.txar25));
        this.StationPanel.add(this.label26);
        this.txar26.setLineWrap(true);
        this.txar26.setWrapStyleWord(true);
        this.StationPanel.add(new JScrollPane(this.txar26));
        this.StationPanel.add(this.label27);
        this.txar27.setLineWrap(true);
        this.txar27.setWrapStyleWord(true);
        this.StationPanel.add(new JScrollPane(this.txar27));
        this.StationPanel.add(this.label28);
        this.txar28.setLineWrap(true);
        this.txar28.setWrapStyleWord(true);
        this.StationPanel.add(new JScrollPane(this.txar28));
        this.add((Component)this.CommentPanel, "South");
        this.CommentPanel.setLayout(new FlowLayout());
        this.CommentPanel.setBorder(BorderFactory.createTitledBorder("\u62a5\u8b66\u7b56\u7565\u8bf4\u660e"));
        this.CommentPanel.add(new JScrollPane(this.txar31));
        this.txar31.setLineWrap(true);
        this.txar31.setWrapStyleWord(true);
        this.txar31.setText("1\uff1a\u53ef\u4ee5\u8bbe\u7f6e\u4e2d\u65ad\u591a\u957f\u65f6\u95f4\u62a5\u8b66\uff0c\u53ef\u4ee5\u8bbe\u7f6e\u4e2d\u65ad\u591a\u5c11\u53f0\u7ad9\u4ee5\u4e0a\u62a5\u8b66.\n2\uff1a\u6240\u6709\u53f0\u7ad9\u6309\u7167\u6240\u5c5e\u53f0\u7f51\u5206\u4e3a\u4e3b\u76d1\u63a7\u53f0\u7f51\u53f0\u7ad9\u548c\u526f\u76d1\u63a7\u53f0\u7f51\u53f0\u7ad9\uff0c\u526f\u76d1\u63a7\u53f0\u7f51\u53f0\u7ad9\u4e2d\u65ad\u4e0d\u62a5\u8b66\uff0c\u4f46\u662f\u67d0\u526f\u76d1\u63a7\u53f0\u7f51\u53f0\u7ad9\u5168\u90e8\u4e2d\u65ad\u65f6\u62a5\u8b66.\n3:\u5206\u65f6\u6bb5\u6267\u884c\u7b56\u7565\uff0c\u5728\u4e0d\u6267\u884c\u7b56\u7565\u65f6\u6bb5\uff0c\u4efb\u4f55\u4e3b\u76d1\u63a7\u53f0\u7f51\u53f0\u7ad9\u4e2d\u65ad\u90fd\u62a5\u8b66.\n4:\u6267\u884c\u7b56\u7565\u65f6\u6bb5\uff0c\u53f0\u7ad9\u5206\u4e3a\u901f\u62a5\u53f0\u7ad9\u548c\u975e\u901f\u62a5\u53f0\u7ad9\uff0c\u901f\u62a5\u53f0\u7ad9\u4e2d\u65ad\u90fd\u62a5\u8b66\uff0c\u975e\u901f\u62a5\u53f0\u7ad9\u4e2d\u65ad\u8fbe\u5230\u8bbe\u7f6e\u7684\u6570\u91cf\u65f6\u624d\u62a5\u8b66.\n5\uff1a\u53f0\u7ad9\u6309\u4f20\u8f93\u7c7b\u578b\u5206\u7c7b\uff0c\u5f53\u67d0\u4e00\u79cd\u4f20\u8f93\u7c7b\u578b\u7684\u53f0\u7ad9\u5168\u90e8\u4e2d\u65ad\u4e00\u6b21\u65f6\u4e5f\u62a5\u8b66.");
    }

    public void getParameter() {
        ArrayList<String> list = new ArrayList<String>();
        int brokeTime = MonitorJApplet.alarm.getAlarmIntervalTime();
        int brokeNumber = MonitorJApplet.alarm.getAlarmLeastSta();
        int startTime = MonitorJApplet.alarm.getUseStartegyStartTime();
        int endTime = MonitorJApplet.alarm.getCancelStrategyTime();
        this.text11.setText(Integer.toString(brokeTime));
        this.text12.setText(Integer.toString(brokeNumber));
        this.cbox13.setSelectedItem(Integer.toString(startTime));
        this.cbox14.setSelectedItem(Integer.toString(endTime));
        String[] station = MonitorJApplet.alarm.getMonitorNet();
        int i = 0;
        while (i < station.length) {
            list.add(station[i]);
            ++i;
        }
        this.text21.setText("" + list);
        list.clear();
        station = MonitorJApplet.alarm.getOtherNet();
        i = 0;
        while (i < station.length) {
            list.add(station[i]);
            ++i;
        }
        this.text22.setText("" + list);
        list.clear();
        station = MonitorJApplet.alarm.getFastReportStations();
        i = 0;
        while (i < station.length) {
            list.add(station[i]);
            ++i;
        }
        this.txar23.setText("" + list);
        list.clear();
        station = MonitorJApplet.alarm.getFRStations();
        i = 0;
        while (i < station.length) {
            list.add(station[i]);
            ++i;
        }
        this.txar24.setText("" + list);
        list.clear();
        station = MonitorJApplet.alarm.getSDHStations();
        i = 0;
        while (i < station.length) {
            list.add(station[i]);
            ++i;
        }
        this.txar25.setText("" + list);
        list.clear();
        station = MonitorJApplet.alarm.getSATELLITEStations();
        i = 0;
        while (i < station.length) {
            list.add(station[i]);
            ++i;
        }
        this.txar26.setText("" + list);
        list.clear();
        station = MonitorJApplet.alarm.getVPDNStations();
        i = 0;
        while (i < station.length) {
            list.add(station[i]);
            ++i;
        }
        this.txar27.setText("" + list);
        list.clear();
        station = MonitorJApplet.alarm.getADSLStations();
        i = 0;
        while (i < station.length) {
            list.add(station[i]);
            ++i;
        }
        this.txar28.setText("" + list);
    }

    public synchronized void QueueAddElementHandler(QueueAddElementEvent e) {
        Result res = (Result)e.getValue();
        if (res.getType() != 131074) {
            return;
        }
        try {
            WaveformStreamStatus wfStatus = new WaveformStreamStatus(res);
            Vector<StationJPanel.StationStatus> vecNew = new Vector<StationJPanel.StationStatus>();
            Vector<StationJPanel.StationStatus> vecOld = new Vector<StationJPanel.StationStatus>();
            String[] stationName = new String[this.netStn.length];
            int[] status = new int[this.netStn.length];
            int i = 0;
            while (i < this.netStn.length) {
                short newStatus = wfStatus.getStatus(this.netStn[i]);
                if (MonitorJApplet.alarm.getWhetherJoinAlarm(this.netStn[i])) {
                    MonitorJApplet.alarm.setStationJoinAlarm(this.netStn[i], true);
                }
                if (newStatus == 0 && this.stationStatus[i].joinAlarm) {
                    StationJPanel.StationStatus oldStatus = (StationJPanel.StationStatus)this.stationStatus[i].clone();
                    this.stationStatus[i].activeIdx = newStatus;
                    vecOld.add(oldStatus);
                    vecNew.add((StationJPanel.StationStatus)this.stationStatus[i].clone());
                }
                this.stationStatus[i].activeIdx = newStatus;
                stationName[i] = this.netStn[i];
                status[i] = newStatus;
                ++i;
            }
            MonitorJApplet.alarm.groupSetStationStatus(stationName, status);
            if (MonitorJApplet.alarm.getBrokeAlarmStatus()) {
                this.stationBrokenSupport.firePropertyChange("stationStatus", vecOld, vecNew);
                logger.info((Object)"fire property change stationStatus");
            }
        }
        catch (MessageParseException mpEx) {
            mpEx.printStackTrace();
        }
    }

    public void config(StrategyBean bean) {
        int brokeTime = Integer.valueOf(bean.getBrokeTime());
        if (brokeTime > 150 && brokeTime < 27000) {
            MonitorJApplet.alarm.setAlarmIntervalTime(Integer.valueOf(bean.getBrokeTime()));
            logger.info((Object)("brokeTime:" + brokeTime));
        } else {
            MonitorJApplet.alarm.setAlarmIntervalTime(300);
            logger.warn((Object)"broke time not between 150 to 27000,set default to 300");
        }
        int brokeNumber = Integer.valueOf(bean.getBrokeNumber());
        if (brokeNumber < 1) {
            MonitorJApplet.alarm.setAlarmLeastSta(1);
            logger.warn((Object)"broke number cant small 1,default set to 3");
        } else {
            MonitorJApplet.alarm.setAlarmLeastSta(brokeNumber);
            logger.info((Object)("brokeNumber:" + brokeNumber));
        }
        int startTime = Integer.valueOf(bean.getStartTime());
        if (startTime >= 0 && startTime <= 23) {
            MonitorJApplet.alarm.setUseStrategyStartTime(startTime);
            logger.info((Object)("startTime:" + startTime));
        } else {
            MonitorJApplet.alarm.setUseStrategyStartTime(0);
            logger.info((Object)"startTime not between 0 to 23,set default to 0");
        }
        int endTime = Integer.valueOf(bean.getEndTime());
        if (endTime >= 0 && endTime <= 23) {
            MonitorJApplet.alarm.setCancelStrategyTime(endTime);
            logger.info((Object)("endTime:" + endTime));
        } else {
            MonitorJApplet.alarm.setCancelStrategyTime(8);
            logger.info((Object)"endTime not between 0 to 23,set default to 8");
        }
        List<String> mainNetList = bean.getMainNet();
        MonitorJApplet.alarm.setMonitorNet(mainNetList.toArray(new String[mainNetList.size()]));
        logger.info((Object)("mainNet:" + bean.getMainNet().toString()));
        List<String> otherNetList = bean.getOtherNet();
        MonitorJApplet.alarm.setOtherNet(otherNetList.toArray(new String[otherNetList.size()]));
        logger.info((Object)("otherNet:" + bean.getOtherNet().toString()));
        List<String> reportList = bean.getReport();
        MonitorJApplet.alarm.groupSetReportType(reportList.toArray(new String[reportList.size()]), 1);
        logger.info((Object)("Fast report station:" + bean.getReport().toString()));
        List<String> frameRelayList = bean.getFrameRelay();
        MonitorJApplet.alarm.groupSetTransmitType(frameRelayList.toArray(new String[frameRelayList.size()]), 1);
        logger.info((Object)("frame relay station:" + bean.getFrameRelay().toString()));
        List<String> SDHList = bean.getSDH();
        MonitorJApplet.alarm.groupSetTransmitType(SDHList.toArray(new String[SDHList.size()]), 2);
        logger.info((Object)("SDH:" + bean.getSDH().toString()));
        List<String> satalliteList = bean.getSatellite();
        MonitorJApplet.alarm.groupSetTransmitType(satalliteList.toArray(new String[satalliteList.size()]), 3);
        logger.info((Object)("satallite:" + bean.getSatellite().toString()));
        List<String> VPDNList = bean.getVPDN();
        MonitorJApplet.alarm.groupSetTransmitType(VPDNList.toArray(new String[VPDNList.size()]), 4);
        logger.info((Object)("VPDN:" + bean.getVPDN().toString()));
        List<String> ADSLList = bean.getADSL();
        MonitorJApplet.alarm.groupSetTransmitType(ADSLList.toArray(new String[ADSLList.size()]), 5);
        logger.info((Object)("ADSL:" + bean.getADSL().toString()));
        List stns = MonitorJApplet.sms.findAllStation();
        logger.info((Object)("station number: " + stns.size()));
        this.netStn = new String[stns.size()];
        int j = 0;
        for (Station s : stns) {
            this.netStn[j++] = String.valueOf(s.getBlockette050().getNetworkCode()) + "/" + s.getBlockette050().getStation();
        }
        this.stationStatus = new StationJPanel.StationStatus[this.netStn.length];
        int i = 0;
        while (i < this.stationStatus.length) {
            this.stationStatus[i] = new StationJPanel.StationStatus();
            int idx = this.netStn[i].indexOf(47);
            this.stationStatus[i].networkId = this.netStn[i].substring(0, idx);
            this.stationStatus[i].stnCode = this.netStn[i].substring(idx + 1);
            ++i;
        }
        MonitorJApplet.alarm.setStations(this.netStn);
        MonitorJApplet.alarm.strategyInit();
        MonitorJApplet.monitorClient.addMonitorMessageListener(this);
        this.getParameter();
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.stationBrokenSupport.removePropertyChangeListener(l);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.stationBrokenSupport.addPropertyChangeListener(l);
    }
}

