/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.monitor;

import cn.org.gddsn.seis.monitor.AnimatingSurface;
import cn.org.gddsn.seis.monitor.StationJPanel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import org.apache.log4j.Logger;

public abstract class Surface
extends JPanel
implements Printable {
    static Logger logger = Logger.getLogger(StationJPanel.class);
    public Object AntiAlias = RenderingHints.VALUE_ANTIALIAS_ON;
    public Object Rendering = RenderingHints.VALUE_RENDER_SPEED;
    public AlphaComposite composite;
    public Paint texture;
    public String perfStr;
    public BufferedImage bimg;
    public int imageType;
    public String name;
    public boolean clearSurface = true;
    public boolean dontThread;
    public AnimatingSurface animating;
    protected long sleepAmount = 50L;
    private long orig;
    private long start;
    private long frame;
    private Toolkit toolkit;
    private boolean perfMonitor;
    private boolean outputPerf;
    private int biw;
    private int bih;
    private boolean clearOnce;
    private boolean toBeInitialized = true;
    static byte[] lut1Arr;
    static byte[] lut2Arr;
    static byte[] lut4Arr;
    private static final int REPORTFRAMES = 30;

    static {
        byte[] byArray = new byte[2];
        byArray[1] = -1;
        lut1Arr = byArray;
        byte[] byArray2 = new byte[4];
        byArray2[1] = 85;
        byArray2[2] = -86;
        byArray2[3] = -1;
        lut2Arr = byArray2;
        byte[] byArray3 = new byte[16];
        byArray3[1] = 17;
        byArray3[2] = 34;
        byArray3[3] = 51;
        byArray3[4] = 68;
        byArray3[5] = 85;
        byArray3[6] = 102;
        byArray3[7] = 119;
        byArray3[8] = -120;
        byArray3[9] = -103;
        byArray3[10] = -86;
        byArray3[11] = -69;
        byArray3[12] = -52;
        byArray3[13] = -35;
        byArray3[14] = -18;
        byArray3[15] = -1;
        lut4Arr = byArray3;
    }

    public Surface() {
        this.setDoubleBuffered(this instanceof AnimatingSurface);
        this.toolkit = this.getToolkit();
        this.name = this.getClass().getName();
        this.name = this.name.substring(this.name.indexOf(".", 7) + 1);
        this.setImageType(0);
        try {
            if (System.getProperty("java2demo.perf") != null) {
                this.outputPerf = true;
                this.perfMonitor = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this instanceof AnimatingSurface) {
            this.animating = (AnimatingSurface)this;
        }
    }

    public int getImageType() {
        return this.imageType;
    }

    public void setImageType(int imgType) {
        this.imageType = imgType == 0 ? (this instanceof AnimatingSurface ? 2 : 1) : imgType;
        this.bimg = null;
    }

    public void setAntiAlias(boolean aa) {
        this.AntiAlias = aa ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF;
    }

    public void setRendering(boolean rd) {
        this.Rendering = rd ? RenderingHints.VALUE_RENDER_QUALITY : RenderingHints.VALUE_RENDER_SPEED;
    }

    public void setTexture(Object obj) {
        this.texture = obj instanceof GradientPaint ? new GradientPaint(0.0f, 0.0f, Color.white, this.getSize().width * 2, 0.0f, Color.green) : (Paint)obj;
    }

    public void setComposite(boolean cp) {
        this.composite = cp ? AlphaComposite.getInstance(3, 0.5f) : null;
    }

    public void setMonitor(boolean pm) {
        this.perfMonitor = pm;
    }

    public void setSleepAmount(long amount) {
        this.sleepAmount = amount;
    }

    public long getSleepAmount() {
        return this.sleepAmount;
    }

    public BufferedImage createBufferedImage(int w, int h, int imgType) {
        BufferedImage bi = null;
        if (imgType == 0) {
            bi = (BufferedImage)this.createImage(w, h);
        } else if (imgType > 0 && imgType < 14) {
            bi = new BufferedImage(w, h, imgType);
        } else if (imgType == 14) {
            bi = this.createBinaryImage(w, h, 2);
        } else if (imgType == 15) {
            bi = this.createBinaryImage(w, h, 4);
        } else if (imgType == 16) {
            bi = this.createSGISurface(w, h, 32);
        } else if (imgType == 17) {
            bi = this.createSGISurface(w, h, 16);
        }
        this.biw = w;
        this.bih = h;
        return bi;
    }

    private BufferedImage createBinaryImage(int w, int h, int pixelBits) {
        int bytesPerRow = w * pixelBits / 8;
        if (w * pixelBits % 8 != 0) {
            ++bytesPerRow;
        }
        byte[] imageData = new byte[h * bytesPerRow];
        IndexColorModel cm = null;
        switch (pixelBits) {
            case 1: {
                cm = new IndexColorModel(pixelBits, lut1Arr.length, lut1Arr, lut1Arr, lut1Arr);
                break;
            }
            case 2: {
                cm = new IndexColorModel(pixelBits, lut2Arr.length, lut2Arr, lut2Arr, lut2Arr);
                break;
            }
            case 4: {
                cm = new IndexColorModel(pixelBits, lut4Arr.length, lut4Arr, lut4Arr, lut4Arr);
                break;
            }
            default: {
                new Exception("Invalid # of bit per pixel").printStackTrace();
            }
        }
        DataBufferByte db = new DataBufferByte(imageData, imageData.length);
        WritableRaster r = Raster.createPackedRaster(db, w, h, pixelBits, null);
        return new BufferedImage(cm, r, false, null);
    }

    private BufferedImage createSGISurface(int w, int h, int pixelBits) {
        int rMask32 = -16777216;
        int rMask16 = 63488;
        int gMask32 = 0xFF0000;
        int gMask16 = 1984;
        int bMask32 = 65280;
        int bMask16 = 62;
        DirectColorModel dcm = null;
        DataBuffer db = null;
        WritableRaster wr = null;
        switch (pixelBits) {
            case 16: {
                short[] imageDataUShort = new short[w * h];
                dcm = new DirectColorModel(16, rMask16, gMask16, bMask16);
                db = new DataBufferUShort(imageDataUShort, imageDataUShort.length);
                wr = Raster.createPackedRaster(db, w, h, w, new int[]{rMask16, gMask16, bMask16}, null);
                break;
            }
            case 32: {
                int[] imageDataInt = new int[w * h];
                dcm = new DirectColorModel(32, rMask32, gMask32, bMask32);
                db = new DataBufferInt(imageDataInt, imageDataInt.length);
                wr = Raster.createPackedRaster(db, w, h, w, new int[]{rMask32, gMask32, bMask32}, null);
                break;
            }
            default: {
                new Exception("Invalid # of bit per pixel").printStackTrace();
            }
        }
        return new BufferedImage(dcm, wr, false, null);
    }

    public Graphics2D createGraphics2D(int width, int height, BufferedImage bi, Graphics g) {
        Graphics2D g2 = null;
        g2 = bi != null ? bi.createGraphics() : (Graphics2D)g;
        g2.setBackground(this.getBackground());
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.AntiAlias);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, this.Rendering);
        if (this.clearSurface || this.clearOnce) {
            g2.clearRect(0, 0, width, height);
            this.clearOnce = false;
        }
        if (this.texture != null) {
            g2.setComposite(AlphaComposite.SrcOver);
            g2.setPaint(this.texture);
            g2.fillRect(0, 0, width, height);
        }
        if (this.composite != null) {
            g2.setComposite(this.composite);
        }
        return g2;
    }

    public abstract void render(int var1, int var2, Graphics2D var3);

    public void paintImmediately(int x, int y, int w, int h) {
        RepaintManager repaintManager = null;
        boolean save = true;
        if (!this.isDoubleBuffered()) {
            repaintManager = RepaintManager.currentManager(this);
            save = repaintManager.isDoubleBufferingEnabled();
            repaintManager.setDoubleBufferingEnabled(false);
        }
        super.paintImmediately(x, y, w, h);
        if (repaintManager != null) {
            repaintManager.setDoubleBufferingEnabled(save);
        }
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        if (this.imageType == 1) {
            this.bimg = null;
        } else if (this.bimg == null || this.biw != d.width || this.bih != d.height) {
            this.bimg = this.createBufferedImage(d.width, d.height, this.imageType - 2);
            this.clearOnce = true;
            this.toBeInitialized = true;
        }
        if (this.toBeInitialized) {
            if (this.animating != null) {
                this.animating.reset(d.width, d.height);
            }
            this.toBeInitialized = false;
            this.startClock();
        }
        if (this.animating != null && this.animating.thread != null) {
            this.animating.step(d.width, d.height);
        }
        Graphics2D g2 = this.createGraphics2D(d.width, d.height, this.bimg, g);
        this.render(d.width, d.height, g2);
        g2.dispose();
        if (this.bimg != null) {
            g.drawImage(this.bimg, 0, 0, null);
            this.toolkit.sync();
        }
        if (this.perfMonitor) {
            this.LogPerformance();
        }
    }

    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        if (pi >= 1) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pf.getImageableX(), pf.getImageableY());
        g2d.translate(pf.getImageableWidth() / 2.0, pf.getImageableHeight() / 2.0);
        Dimension d = this.getSize();
        double scale = Math.min(pf.getImageableWidth() / (double)d.width, pf.getImageableHeight() / (double)d.height);
        if (scale < 1.0) {
            g2d.scale(scale, scale);
        }
        g2d.translate((double)(-d.width) / 2.0, (double)(-d.height) / 2.0);
        if (this.bimg == null) {
            Graphics2D g2 = this.createGraphics2D(d.width, d.height, null, g2d);
            this.render(d.width, d.height, g2);
            g2.dispose();
        } else {
            g2d.drawImage((Image)this.bimg, 0, 0, this);
        }
        return 0;
    }

    public void startClock() {
        this.start = this.orig = System.currentTimeMillis();
        this.frame = 0L;
    }

    private void LogPerformance() {
        if (this.frame % 30L == 0L) {
            long end = System.currentTimeMillis();
            long rel = end - this.start;
            long tot = end - this.orig;
            if (this.frame == 0L) {
                this.perfStr = String.valueOf(this.name) + " " + rel + " ms";
                if (this.animating == null || this.animating.thread == null) {
                    this.frame = -1L;
                }
            } else {
                String s1 = Float.toString(30.0f / ((float)rel / 1000.0f));
                s1 = s1.length() < 4 ? s1.substring(0, s1.length()) : s1.substring(0, 4);
                this.perfStr = String.valueOf(this.name) + " " + s1 + " fps";
            }
            if (this.outputPerf) {
                logger.info((Object)this.perfStr);
            }
            this.start = end;
        }
        ++this.frame;
    }

    public Image getImage(String name, Component cmp) {
        Image img = null;
        img = Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("resource/images/" + name));
        MediaTracker tracker = new MediaTracker(cmp);
        tracker.addImage(img, 0);
        try {
            tracker.waitForID(0);
            if (tracker.isErrorAny()) {
                logger.warn((Object)("Error loading image " + name));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return img;
    }

    public static void createDemoFrame(Surface surface) {
        JFrame f = new JFrame("Java2D Demo - " + surface.name);
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.getContentPane().add("Center", surface);
        f.pack();
        f.setSize(new Dimension(500, 300));
        f.setVisible(true);
        if (surface.animating != null) {
            surface.animating.start();
        }
    }
}

