/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.monitor;

import cn.org.gddsn.io.LittleEndianInputStream;
import cn.org.gddsn.seis.monitor.MonitorJApplet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class VectorMap2D {
    static Logger logger = Logger.getLogger(VectorMap2D.class);
    private JPanel thisPanel;
    double scale = 100.0;
    double fic = 39.9;
    double lamc = 116.3;
    double delta = 1.0;
    double p2p = 1.0;
    BufferedImage image = null;
    Graphics2D big = null;
    Dimension imageDim = null;
    String[] mapFiles = new String[]{"coasts.bin"};
    Color[] colors = new Color[]{Color.blue};
    boolean[] fills = new boolean[1];
    AffineTransform transform = null;

    public VectorMap2D(JPanel panel) {
        this.loadMapParam();
        this.thisPanel = panel;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public VectorMap2D() {
        this.loadMapParam();
    }

    public void setMapFiles(String[] mapFiles, Color[] colors, boolean[] fills) {
        this.mapFiles = mapFiles;
    }

    public void setMapParam(double scale, double fic, double lamc, double delta, double p2p) {
        this.scale = scale;
        this.fic = fic;
        this.lamc = lamc;
        this.delta = delta;
        this.p2p = p2p;
    }

    public void setMapParam(double fic, double lamc) {
        this.fic = fic;
        this.lamc = lamc;
    }

    public void setPanel(JPanel panel) {
        this.thisPanel = panel;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.thisPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                VectorMap2D.this.this_mouseClicked(e);
            }
        });
    }

    float[] readMapData(String mapFileName) {
        float[] filam = null;
        try {
            InputStream in = this.getClass().getResourceAsStream("resource/map/" + mapFileName);
            if (in == null) {
                File mapFile = new File(mapFileName);
                in = new FileInputStream(mapFile);
            }
            BufferedInputStream BufferedIn = new BufferedInputStream(in, 4096);
            LittleEndianInputStream DatIn = new LittleEndianInputStream((InputStream)BufferedIn);
            long num = in.available() / 4;
            filam = new float[(int)num];
            int i = 0;
            while ((long)i < num) {
                filam[i] = DatIn.readFloat();
                ++i;
            }
            in.close();
            in.close();
            BufferedIn.close();
            DatIn.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return filam;
    }

    void paintPartOfMap(Graphics2D g2d, Color color, float lineWidth, String mapFileName, boolean bfill) {
        boolean pup = false;
        Point2D.Double point = new Point2D.Double();
        float[] filam = this.readMapData(mapFileName);
        Dimension dim = this.thisPanel.getSize();
        double mas = this.scale / (double)dim.height;
        this.transform = new AffineTransform(1.0 / mas, 0.0, 0.0, -1.0 / mas, (double)dim.width / 2.0, (double)dim.height / 2.0);
        g2d.setTransform(this.transform);
        g2d.setStroke(new BasicStroke(lineWidth));
        g2d.setColor(color);
        GeneralPath gp = new GeneralPath(1);
        int i = 0;
        while (i < filam.length) {
            if (Math.abs(filam[i]) > 90.0f) {
                pup = false;
            } else {
                double fi = filam[i];
                double lam = filam[i + 1];
                int par = this.condek(this.fic, this.lamc, 0.0, fi, lam, point);
                if (par < 0) {
                    pup = false;
                } else {
                    if (!pup) {
                        gp.moveTo((float)((Point2D)point).getX(), (float)((Point2D)point).getY());
                    } else {
                        gp.lineTo((float)((Point2D)point).getX(), (float)((Point2D)point).getY());
                    }
                    pup = true;
                }
            }
            i += 2;
        }
        if (bfill) {
            g2d.setColor(color);
            g2d.fill(gp);
            g2d.setColor(Color.blue);
            g2d.draw(gp);
        } else {
            g2d.setColor(color);
            g2d.draw(gp);
        }
    }

    void drawFiLamLine(Graphics2D g2d) {
        int par;
        double lam;
        Point2D.Double point = new Point2D.Double();
        Dimension dim = this.thisPanel.getSize();
        double mas = this.scale / (double)dim.height;
        this.transform = new AffineTransform(1.0 / mas, 0.0, 0.0, -1.0 / mas, (double)dim.width / 2.0, (double)dim.height / 2.0);
        g2d.setTransform(this.transform);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.setColor(Color.black);
        GeneralPath gp = new GeneralPath(1);
        double fi = -90.0;
        while (fi <= 90.0) {
            lam = -180.0;
            while (lam <= 180.0) {
                par = this.condek(this.fic, this.lamc, 0.0, fi, lam, point);
                if (par < 0) {
                    gp.moveTo((float)((Point2D)point).getX(), (float)((Point2D)point).getY());
                } else if (lam == -180.0) {
                    gp.moveTo((float)((Point2D)point).getX(), (float)((Point2D)point).getY());
                } else {
                    gp.lineTo((float)((Point2D)point).getX(), (float)((Point2D)point).getY());
                }
                lam += this.p2p;
            }
            fi += this.delta;
        }
        lam = -180.0;
        while (lam < 180.0) {
            fi = -90.0;
            while (fi <= 90.0) {
                par = this.condek(this.fic, this.lamc, 0.0, fi, lam, point);
                if (par < 0) {
                    gp.moveTo((float)((Point2D)point).getX(), (float)((Point2D)point).getY());
                } else if (fi == -90.0) {
                    gp.moveTo((float)((Point2D)point).getX(), (float)((Point2D)point).getY());
                } else {
                    gp.lineTo((float)((Point2D)point).getX(), (float)((Point2D)point).getY());
                }
                fi += this.p2p;
            }
            lam += this.delta;
        }
        g2d.draw(gp);
    }

    public int getPoint(Point2D point, double fi, double lam) {
        return this.condek(this.fic, this.lamc, 0.0, fi, lam, point);
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public boolean paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Dimension dim = this.thisPanel.getSize();
        if (this.image != null && dim.equals(this.imageDim)) {
            g2d.drawImage((Image)this.image, 0, 0, this.thisPanel);
            return false;
        }
        this.image = (BufferedImage)this.thisPanel.createImage(dim.width, dim.height);
        this.big = this.image.createGraphics();
        this.big.setColor(Color.white);
        this.big.fillRect(0, 0, dim.width, dim.height);
        this.big.setColor(Color.white);
        this.big.draw3DRect(0, 0, dim.width - 1, dim.height - 1, true);
        int i = 0;
        while (i < this.mapFiles.length) {
            this.paintPartOfMap(this.big, this.colors[i], 1.0f, this.mapFiles[i], this.fills[i]);
            ++i;
        }
        this.drawFiLamLine(this.big);
        g2d.drawImage((Image)this.image, 0, 0, this.thisPanel);
        this.imageDim = dim;
        return true;
    }

    private int condek(double fic, double lamc, double alf, double fi, double lam, Point2D point) {
        double grad = Math.PI / 180;
        double R = 6371.0;
        fic *= grad;
        alf *= grad;
        double x1 = R * Math.cos(fi *= grad) * Math.cos(lam *= grad);
        double y1 = R * Math.cos(fi) * Math.sin(lam);
        double z1 = R * Math.sin(fi);
        double x2 = x1 * Math.cos(lamc *= grad) + y1 * Math.sin(lamc);
        double y2 = -x1 * Math.sin(lamc) + y1 * Math.cos(lamc);
        double z2 = z1;
        double x3 = x2 * Math.sin(fic) - z2 * Math.cos(fic);
        double z3 = x2 * Math.cos(fic) + z2 * Math.sin(fic);
        double y3 = y2;
        double x = x3 * Math.cos(alf) - y3 * Math.sin(alf);
        double y = x3 * Math.sin(alf) + y3 * Math.cos(alf);
        x3 = x;
        x = y;
        y = -x3;
        point.setLocation(x, y);
        if (z3 <= 0.0) {
            return -1;
        }
        return 0;
    }

    void invCondek(double fic, double lamc, Point2D dstPoint, Point2D srcPoint) {
        double z2;
        double grad = Math.PI / 180;
        double R = 6371.0;
        double z3 = 597.1;
        fic *= grad;
        lamc *= grad;
        double x = srcPoint.getX();
        double y = srcPoint.getY();
        double x3 = -y;
        y = x;
        x = x3;
        double y3 = y;
        x3 = x;
        double y2 = y3;
        double a1 = Math.cos(fic);
        double b1 = Math.sin(fic);
        double c1 = z3;
        double a2 = Math.sin(fic);
        double b2 = -Math.cos(fic);
        double c2 = x3;
        double x2 = this.eqx(a1, b1, c1, a2, b2, c2);
        double z1 = z2 = this.eqy(a1, b1, c1, a2, b2, c2);
        a1 = -Math.sin(lamc);
        b1 = Math.cos(lamc);
        c1 = y2;
        a2 = Math.cos(lamc);
        b2 = Math.sin(lamc);
        c2 = x2;
        double x1 = this.eqx(a1, b1, c1, a2, b2, c2);
        double y1 = this.eqy(a1, b1, c1, a2, b2, c2);
        double fi = Math.asin(z1 / R);
        double lam = Math.atan(y1 / x1);
        fi *= 57.29577951308232;
        lam *= 57.29577951308232;
        if (x1 < 0.0 && y1 < 0.0) {
            lam -= 180.0;
        }
        if (x1 < 0.0 && y1 > 0.0) {
            lam += 180.0;
        }
        dstPoint.setLocation(fi, lam);
    }

    private double eqx(double a1, double b1, double c1, double a2, double b2, double c2) {
        return (c1 * b2 - c2 * b1) / (a1 * b2 - a2 * b1);
    }

    private double eqy(double a1, double b1, double c1, double a2, double b2, double c2) {
        return (a1 * c2 - a2 * c1) / (a1 * b2 - a2 * b1);
    }

    private void filam(double f, double l, double dist, double aza, Point2D point) {
        double grad = Math.PI / 180;
        double RZ = 6371.0;
        aza *= grad;
        dist /= RZ;
        double x = Math.cos(f *= grad) * Math.cos(l *= grad);
        double y = Math.cos(f) * Math.sin(l);
        double z = Math.sin(f);
        double x1 = x * Math.cos(l) + y * Math.sin(l);
        double y1 = -x * Math.sin(l) + y * Math.cos(l);
        double z1 = z;
        double x2 = -z1 * Math.cos(f) + x1 * Math.sin(f);
        double y2 = y1;
        double z2 = z1 * Math.sin(f) + x1 * Math.cos(f);
        aza = -Math.PI - aza;
        x2 = Math.sin(dist) * Math.cos(aza);
        y2 = Math.sin(dist) * Math.sin(aza);
        z2 = Math.cos(dist);
        x1 = -(-z2 * Math.cos(-f) + x2 * Math.sin(-f));
        y1 = y2;
        z1 = -(z2 * Math.sin(-f) + x2 * Math.cos(-f));
        x = x1 * Math.cos(-l) + y1 * Math.sin(-l);
        y = -x1 * Math.sin(-l) + y1 * Math.cos(-l);
        z = z1;
        double fi = Math.asin(z) / grad;
        double lam = Math.atan2(y, x) / grad;
        point.setLocation(fi, lam);
    }

    void this_mouseClicked(MouseEvent e) {
        Dimension dim;
        if ((e.getModifiers() & 1) != 0) {
            dim = this.thisPanel.getSize();
            Point2D.Double point = new Point2D.Double();
            double dist = (double)(e.getX() - dim.width / 2) * (double)(e.getX() - dim.width / 2) + (double)(e.getY() - dim.height / 2) * (double)(e.getY() - dim.height / 2);
            dist = Math.sqrt(dist) * this.scale / (double)dim.height;
            if ((dist /= 6371.0) <= 1.0) {
                double aza = (dist = Math.asin(dist) * 6371.0) == 0.0 ? 0.0 : Math.atan2(e.getX() - dim.width / 2, -e.getY() + dim.height / 2) * 180.0 / Math.PI;
                this.filam(this.fic, this.lamc, dist, aza, point);
                this.fic = ((Point2D)point).getX();
                this.lamc = ((Point2D)point).getY();
                logger.info((Object)("move to lamc=" + this.lamc + " , fic=" + this.fic));
            }
            this.image = null;
        } else if ((e.getModifiers() & 2) != 0 && (e.getModifiers() & 4) != 0) {
            this.scale *= 2.0;
            this.image = null;
        } else if ((e.getModifiers() & 2) != 0) {
            this.scale /= 2.0;
            this.image = null;
        }
        dim = this.thisPanel.getSize();
        double mas = this.scale / (double)dim.height;
        this.transform = new AffineTransform(1.0 / mas, 0.0, 0.0, -1.0 / mas, (double)dim.width / 2.0, (double)dim.height / 2.0);
        this.thisPanel.repaint();
    }

    private void loadMapParam() {
        try {
            Properties props = new Properties();
            URL url = new URL(MonitorJApplet.baseURL, "resource/MapParam.properties");
            props.load(url.openStream());
            this.scale = Double.parseDouble(props.getProperty("map.draw.scale"));
            this.fic = Double.parseDouble(props.getProperty("map.draw.fic"));
            this.lamc = Double.parseDouble(props.getProperty("map.draw.lamc"));
            this.delta = Double.parseDouble(props.getProperty("map.draw.delta"));
            this.p2p = Double.parseDouble(props.getProperty("map.draw.p2p"));
            logger.info((Object)("load Map Param: lamc=" + this.lamc + " , fic=" + this.fic));
            int ndata = 0;
            while (props.getProperty("map.data" + ndata + ".file") != null) {
                ++ndata;
            }
            this.mapFiles = new String[ndata];
            this.colors = new Color[ndata];
            this.fills = new boolean[ndata];
            StringTokenizer st = null;
            int i = 0;
            while (i < ndata) {
                this.mapFiles[i] = props.getProperty("map.data" + i + ".file");
                st = new StringTokenizer(props.getProperty("map.data" + i + ".rgb"), ",");
                this.colors[i] = new Color(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
                this.fills[i] = props.getProperty("map.data" + i + ".fill").equalsIgnoreCase("true");
                ++i;
            }
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
        }
    }

    public static void main(String[] args) {
        VectorMap2D vectorMap2D = new VectorMap2D();
        JPanel panel = new JPanel(){

            public void paintComponent(Graphics g) {
                VectorMap2D.this.paintComponent(g);
            }
        };
        vectorMap2D.setPanel(panel);
        JFrame frame = new JFrame("SimpleExample");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.getContentPane().add("Center", panel);
        frame.setSize(800, 800);
        frame.setVisible(true);
    }
}

