/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.phaseidentification;

import cn.org.gddsn.seis.evtformat.DatabaseEvtData;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.pca.Polarization;
import org.apache.log4j.Logger;

public class PhaseIdentify {
    static Logger logger = Logger.getLogger(PhaseIdentify.class);
    private double samp;
    private int winLenDetect = 200;
    private int stepDetect = 20;
    private double threshold = 3.5;
    private int delay = 100 / this.stepDetect;
    private Polarization polarization = new Polarization();
    private int length = 0;
    private double[][] nez = null;

    public PhaseIdentify(EvtData evt, int[] chanOrder, int start, int length) {
        this.length = length;
        this.samp = evt.getSampleRate(chanOrder[0]);
        this.delay = (int)(this.samp / (double)this.stepDetect);
        int chn = chanOrder[0];
        this.nez = new double[length][3];
        double norm = evt.getCalibFactor(chn);
        if (evt instanceof DatabaseEvtData) {
            int j = 0;
            while (j < 3) {
                double factor = evt.getCalibFactor(chanOrder[j]);
                int k = start;
                while (k < start + length) {
                    this.nez[k - start][j] = evt.getSampData(chanOrder[j])[k] * norm / factor;
                    ++k;
                }
                ++j;
            }
        } else {
            int j = 0;
            while (j < 3) {
                double factor = evt.getCalibFactor(chanOrder[j]);
                int k = start;
                while (k < start + length) {
                    this.nez[k - start][2 - j] = evt.getSampData(chanOrder[j])[k] * norm / factor;
                    ++k;
                }
                ++j;
            }
        }
    }

    public int getPhaseIndex() {
        int minIndex = this.getEventTriggerIndex();
        int[] winLenP = new int[]{200, 50, 10};
        int[] winLenS = new int[]{200, 50, 20};
        int indexPhaseP = this.getPhaseAT(minIndex, this.length - 2 * this.winLenDetect, winLenP);
        return indexPhaseP;
    }

    private int getEventTriggerIndex() {
        int minP = 2 * this.winLenDetect;
        int maxP = this.length - 2 * this.winLenDetect;
        double[] maxEig = new double[(maxP - minP) / this.stepDetect + 1];
        int n = 0;
        int i = minP;
        while (i < maxP) {
            this.polarization.calPolarization(this.nez, i, this.winLenDetect);
            maxEig[n] = this.polarization.getMaxEig();
            i += this.stepDetect;
            ++n;
        }
        n = this.delay;
        while (n < maxEig.length && maxEig[n] - this.threshold * maxEig[n - this.delay] <= 0.0) {
            ++n;
        }
        return minP + n * this.stepDetect + this.winLenDetect - 2 * this.winLenDetect;
    }

    private int getPhaseAT(int startIdx, int endIdx, int[] winLen) {
        double[] character = new double[endIdx - startIdx + 1];
        int i = 0;
        while (i < character.length) {
            character[i] = 1.0;
            ++i;
        }
        i = startIdx;
        while (i < endIdx) {
            int j = 0;
            while (j < winLen.length) {
                this.polarization.calPolarization(this.nez, i, winLen[j]);
                int n = i - startIdx;
                character[n] = character[n] * this.polarization.getMaxEig();
                this.polarization.calPolarization(this.nez, i - winLen[j], winLen[j]);
                int n2 = i - startIdx;
                character[n2] = character[n2] / this.polarization.getMaxEig();
                ++j;
            }
            ++i;
        }
        int maxIndx = 0;
        int i2 = character.length - 1;
        while (i2 >= 0) {
            if (character[i2] > character[maxIndx]) {
                maxIndx = i2;
            }
            --i2;
        }
        return startIdx + maxIndx;
    }
}

