/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.picker;

class BPF {
    double FC1;
    double FC2;
    int FILTER_ORDER;
    int SPS;
    double H0;
    double H2;
    double H4;
    double K1;
    double K2;
    double K3;
    double K4;

    BPF() {
    }

    double calc_A0() {
        double fr = 1.0 / ((1.0 / this.FC1 + 1.0 / this.FC2) / 2.0);
        double wk = Math.PI * 2 * this.FC2;
        double wc = Math.PI * 2 * this.FC1;
        double sqrt2 = 1.414213562;
        double b = sqrt2 * wk + sqrt2 * wc;
        double c = wk * wk + 2.0 * wc * wk + wc * wc;
        double d = sqrt2 * wc * wk * wk + sqrt2 * wk * wc * wc;
        double e = wc * wc * wk * wk;
        double om = Math.PI * 2 * fr;
        double R = om * om * om * om - c * om * om + e;
        double I = -b * om * om * om + d * om;
        double G = Math.sqrt(R * R + I * I) / (om * om);
        return G;
    }

    void bp_butter_coef(double sps) {
        this.SPS = (int)sps;
        double fs = sps;
        this.FILTER_ORDER = 4;
        if (this.FC1 < this.FC2) {
            double fct = this.FC1;
            this.FC1 = this.FC2;
            this.FC2 = fct;
        }
        double G = this.calc_A0();
        G /= (double)(2 * this.SPS * 2 * this.SPS);
        double wc = Math.tan(Math.PI * this.FC1 / fs);
        double wk = Math.tan(Math.PI * this.FC2 / fs);
        double sqrt2 = 1.414213562;
        double A = 1.0;
        double B = sqrt2 * wk + sqrt2 * wc;
        double C = wk * wk + 2.0 * wc * wk + wc * wc;
        double D = sqrt2 * wc * wk * wk + sqrt2 * wk * wc * wc;
        double E = wc * wc * wk * wk;
        double F1 = A + B + C + D + E;
        double F2 = -4.0 * A - 2.0 * B + 2.0 * D + 4.0 * E;
        double F3 = 6.0 * A - 2.0 * C + 6.0 * E;
        double F4 = -4.0 * A + 2.0 * B + -2.0 * D + 4.0 * E;
        double F5 = A - B + C - D + E;
        this.H0 = G / F1;
        this.H2 = -2.0 * G / F1;
        this.H4 = G / F1;
        this.K1 = -F2 / F1;
        this.K2 = -F3 / F1;
        this.K3 = -F4 / F1;
        this.K4 = -F5 / F1;
    }

    double[] bp_butterworth(double[] x, int ns, double cf1, double cf2, double sps) {
        this.FC1 = cf1;
        this.FC2 = cf2;
        this.bp_butter_coef(sps);
        double[] y = new double[ns];
        y[0] = this.H0 * x[0];
        y[1] = this.H0 * x[1] + this.K1 * y[0];
        y[2] = this.H0 * x[2] + this.H2 * x[0] + this.K1 * y[1] + this.K2 * y[0];
        y[3] = this.H0 * x[3] + this.H2 * x[1] + this.K1 * y[2] + this.K2 * y[1] + this.K3 * y[0];
        int i = 4;
        while (i < ns) {
            y[i] = this.H0 * x[i] + this.H2 * x[i - 2] + this.H4 * x[i - 4] + this.K1 * y[i - 1] + this.K2 * y[i - 2] + this.K3 * y[i - 3] + this.K4 * y[i - 4];
            ++i;
        }
        if (this.FILTER_ORDER > 2) {
            this.bp_butterworth2(y, ns);
        }
        double[] retv = new double[ns];
        i = 0;
        while (i < ns) {
            retv[i] = y[i];
            ++i;
        }
        return retv;
    }

    void bp_butterworth2(double[] x, int ns) {
        double[] z = new double[ns];
        z[0] = this.H0 * x[0];
        z[1] = this.H0 * x[1] + this.K1 * z[0];
        z[2] = this.H0 * x[2] + this.H2 * x[0] + this.K1 * z[1] + this.K2 * z[0];
        z[3] = this.H0 * x[3] + this.H2 * x[1] + this.K1 * z[2] + this.K2 * z[1] + this.K3 * z[0];
        int i = 4;
        while (i < ns) {
            z[i] = this.H0 * x[i] + this.H2 * x[i - 2] + this.H4 * x[i - 4] + this.K1 * z[i - 1] + this.K2 * z[i - 2] + this.K3 * z[i - 3] + this.K4 * z[i - 4];
            ++i;
        }
        i = 0;
        while (i < ns) {
            x[i] = z[i];
            ++i;
        }
    }
}

