/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.picker;

import cn.org.gddsn.seis.picker.BasicPicker;
import cn.org.gddsn.seis.picker.PickData;
import cn.org.gddsn.seis.picker.TimeDomainException;
import cn.org.gddsn.seis.picker.TimeDomainMemory;
import java.util.Vector;
import java.util.concurrent.Callable;

public class FilterPicker5
extends BasicPicker {
    private static final double WINDOW_MIN = Double.MIN_VALUE;
    private static final double WINDOW_MAX = Double.MAX_VALUE;
    private static final double THRESHOLD_MIN = Double.MIN_VALUE;
    private static final double THRESHOLD_MAX = Double.MAX_VALUE;
    private static final double TIME_MIN = -1.7976931348623157E308;
    private static final double TIME_MAX = Double.MAX_VALUE;
    private static final int INT_UNSET = -1073741823;
    public double filterWindow = 4.0;
    public double longTermWindow = 10.0;
    public double threshold1 = 10.0;
    public double threshold2 = 10.0;
    public double tUpEvent = 0.5;
    private FilterPicker5_Memory mem = null;
    private double deltaTime;
    private boolean onlyOnePick = false;
    private static int index_recursive = 0;

    public FilterPicker5(double longTermWindow, double s1, double s2, double tUpEvent, double filterWindow, int direction) {
        super(direction);
        this.longTermWindow = longTermWindow;
        this.threshold1 = s1;
        this.threshold2 = s2;
        this.tUpEvent = tUpEvent;
        this.filterWindow = filterWindow;
    }

    public FilterPicker5(double longTermWindow, double s1, double s2, double tUpEvent, double filterWindow) {
        this(longTermWindow, s1, s2, tUpEvent, filterWindow, 1);
    }

    public FilterPicker5(FilterPicker5 tp) {
        super(tp.direction);
        this.resultType = tp.resultType;
        this.longTermWindow = tp.longTermWindow;
        this.threshold1 = tp.threshold1;
        this.threshold2 = tp.threshold2;
        this.tUpEvent = tp.tUpEvent;
        this.filterWindow = tp.filterWindow;
    }

    public void clearMemory() {
        this.mem = null;
    }

    public void setLongTermWindow(double longTermWindowValue) throws TimeDomainException {
        if (longTermWindowValue < Double.MIN_VALUE || longTermWindowValue > Double.MAX_VALUE) {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_long_term_window_value) + ": " + longTermWindowValue);
        }
        this.longTermWindow = longTermWindowValue;
    }

    public void setLongTermWindow(String str) throws TimeDomainException {
        double longTermWindowValue;
        try {
            longTermWindowValue = Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_long_term_window_value) + ": " + str);
        }
        this.setLongTermWindow(longTermWindowValue);
    }

    public void setThreshold1(double threshold1Value) throws TimeDomainException {
        if (threshold1Value < Double.MIN_VALUE || threshold1Value > Double.MAX_VALUE) {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_threshold1_value) + ": " + threshold1Value);
        }
        this.threshold1 = threshold1Value;
    }

    public void setThreshold1(String str) throws TimeDomainException {
        double threshold1Value;
        try {
            threshold1Value = Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_threshold1_value) + ": " + str);
        }
        this.setThreshold1(threshold1Value);
    }

    public void setThreshold2(double threshold2Value) throws TimeDomainException {
        if (threshold2Value < Double.MIN_VALUE || threshold2Value > Double.MAX_VALUE) {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_threshold2_value) + ": " + threshold2Value);
        }
        this.threshold2 = threshold2Value;
    }

    public void setThreshold2(String str) throws TimeDomainException {
        double threshold2Value;
        try {
            threshold2Value = Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_threshold2_value) + ": " + str);
        }
        this.setThreshold2(threshold2Value);
    }

    public void setTUpEvent(double tUpEventValue) throws TimeDomainException {
        if (tUpEventValue < -1.7976931348623157E308 || tUpEventValue > Double.MAX_VALUE) {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_tUpEvent_value) + ": " + tUpEventValue);
        }
        this.tUpEvent = tUpEventValue;
    }

    public void setTUpEvent(String str) throws TimeDomainException {
        double tUpEventValue;
        try {
            tUpEventValue = Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_tUpEvent_value) + ": " + str);
        }
        this.setTUpEvent(tUpEventValue);
    }

    public void setFilterWindow(double filterWindowValue) throws TimeDomainException {
        if (filterWindowValue < Double.MIN_VALUE || filterWindowValue > Double.MAX_VALUE) {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_filterWindow_value) + ": " + filterWindowValue);
        }
        this.filterWindow = filterWindowValue;
    }

    public void setFilterWindow(String str) throws TimeDomainException {
        double filterWindowValue;
        try {
            filterWindowValue = Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_filterWindow_value) + ": " + str);
        }
        this.setFilterWindow(filterWindowValue);
    }

    public void checkSettings() throws TimeDomainException {
        super.checkSettings();
        String errMessage = "";
        int badSettings = 0;
        if (this.longTermWindow < Double.MIN_VALUE || this.longTermWindow > Double.MAX_VALUE) {
            errMessage = String.valueOf(errMessage) + ": " + TimeDomainException.invalid_long_term_window_value;
            ++badSettings;
        }
        if (this.threshold1 < Double.MIN_VALUE || this.threshold1 > Double.MAX_VALUE) {
            errMessage = String.valueOf(errMessage) + ": " + TimeDomainException.invalid_threshold1_value;
            ++badSettings;
        }
        if (this.threshold2 < Double.MIN_VALUE || this.threshold2 > Double.MAX_VALUE) {
            errMessage = String.valueOf(errMessage) + ": " + TimeDomainException.invalid_threshold2_value;
            ++badSettings;
        }
        if (this.tUpEvent < -1.7976931348623157E308 || this.tUpEvent > Double.MAX_VALUE) {
            errMessage = String.valueOf(errMessage) + ": " + TimeDomainException.invalid_tUpEvent_value;
            ++badSettings;
        }
        if (this.filterWindow < -1.7976931348623157E308 || this.filterWindow > Double.MAX_VALUE) {
            errMessage = String.valueOf(errMessage) + ": " + TimeDomainException.invalid_filterWindow_value;
            ++badSettings;
        }
        if (badSettings > 0) {
            throw new TimeDomainException(String.valueOf(errMessage) + ".");
        }
    }

    public final double[] apply(double dt, double[] sample) {
        this.deltaTime = dt;
        if (this.mem == null) {
            this.mem = new FilterPicker5_Memory(sample);
        }
        double[] sampleNew = null;
        if (this.resultType == 2 || this.resultType == 1) {
            sampleNew = new double[sample.length];
        }
        double maxCharFunctValue = 5.0 * this.threshold1;
        boolean error1_not_printed = true;
        double charFunctValueTrigger = -1.0;
        int indexUpEventTrigger = -1;
        int indexUncertaintyPick = -1;
        int n = 0;
        while (n < sample.length) {
            boolean acceptedPick = false;
            int upEventBufPtrLast = this.mem.upEventBufPtr;
            this.mem.upEventBufPtr = (this.mem.upEventBufPtr + 1) % this.mem.nTUpEvent;
            double charFunct = 0.0;
            double charFunctClipped = 0.0;
            double currentSample = sample[n];
            double currentDiffSample = currentSample - this.mem.lastSample;
            int k = this.mem.numRecursive - 1;
            while (k >= 0) {
                double dy;
                double currentFilteredSample = this.mem.highPassConst[k] * (this.mem.filteredSample[k][0] + currentDiffSample);
                double currentDiffSample2 = currentFilteredSample - this.mem.filteredSample[k][0];
                this.mem.filteredSample[k][0] = currentFilteredSample;
                this.mem.filteredSample[k][1] = currentFilteredSample = this.mem.highPassConst[k] * (this.mem.filteredSample[k][1] + currentDiffSample2);
                currentFilteredSample = this.mem.filteredSample[k][2] + this.mem.lowPassConst[k] * (currentFilteredSample - this.mem.filteredSample[k][2]);
                this.mem.lastFilteredSample[k] = this.mem.filteredSample[k][2];
                this.mem.filteredSample[k][2] = currentFilteredSample;
                this.mem.test[k] = dy = currentFilteredSample;
                this.mem.xRec[k] = dy * dy;
                double charFunctClippedTest = 0.0;
                if (this.mem.mean_stdDev_xRec[k] <= Double.MIN_VALUE) {
                    if (this.mem.enableTriggering && error1_not_printed) {
                        System.out.println("ERROR: mem.mean_stdDev_xRec[k] <= Double.MIN_VALUE (this should not happen!) k=" + k);
                        error1_not_printed = false;
                    }
                } else {
                    double charFunctTest = (this.mem.xRec[k] - this.mem.mean_xRec[k]) / this.mem.mean_stdDev_xRec[k];
                    charFunctClippedTest = charFunctTest;
                    if (charFunctClippedTest > maxCharFunctValue) {
                        charFunctClippedTest = maxCharFunctValue;
                        this.mem.xRec[k] = maxCharFunctValue * this.mem.mean_stdDev_xRec[k] + this.mem.mean_xRec[k];
                    }
                    if (charFunctTest >= charFunct) {
                        charFunct = charFunctTest;
                        charFunctClipped = charFunctClippedTest;
                        this.mem.charFuntNumRecursiveIndex[this.mem.upEventBufPtr] = k;
                    }
                    if (charFunctTest >= this.threshold1) {
                        this.mem.charFuntNumRecursiveIndex[this.mem.upEventBufPtr] = k;
                    }
                }
                this.mem.charFunctUncertainty[k] = charFunctClippedTest;
                boolean upCharFunctUncertainty = this.mem.charFunctUncertaintyLast[k] < this.mem.uncertaintyThreshold[k] && this.mem.charFunctUncertainty[k] >= this.mem.uncertaintyThreshold[k];
                this.mem.charFunctUncertaintyLast[k] = this.mem.charFunctUncertainty[k];
                this.mem.indexUncertainty[k][this.mem.upEventBufPtr] = upCharFunctUncertainty ? n - 1 : this.mem.indexUncertainty[k][upEventBufPtrLast];
                if (upCharFunctUncertainty) {
                    this.mem.polarityDerivativeSum[k][this.mem.upEventBufPtr] = 0.0;
                    this.mem.polaritySumAbsDerivative[k][this.mem.upEventBufPtr] = 0.0;
                } else {
                    this.mem.polarityDerivativeSum[k][this.mem.upEventBufPtr] = this.mem.polarityDerivativeSum[k][upEventBufPtrLast];
                    this.mem.polaritySumAbsDerivative[k][this.mem.upEventBufPtr] = this.mem.polaritySumAbsDerivative[k][upEventBufPtrLast];
                }
                double polarityderivativeIncrement = this.mem.filteredSample[k][2] - this.mem.lastFilteredSample[k];
                double[] dArray = this.mem.polarityDerivativeSum[k];
                int n2 = this.mem.upEventBufPtr;
                dArray[n2] = dArray[n2] + polarityderivativeIncrement;
                double[] dArray2 = this.mem.polaritySumAbsDerivative[k];
                int n3 = this.mem.upEventBufPtr;
                dArray2[n3] = dArray2[n3] + Math.abs(polarityderivativeIncrement);
                --k;
            }
            if (this.mem.enableTriggering || this.mem.nTotal++ > this.mem.indexEnableTriggering) {
                this.mem.enableTriggering = true;
                this.mem.integralCharFunctClipped[this.mem.upEventBufPtr] = this.mem.integralCharFunctClipped[upEventBufPtrLast] - this.mem.charFunctClippedValue[this.mem.upEventBufPtr] + charFunctClipped;
                this.mem.charFunctClippedValue[this.mem.upEventBufPtr] = charFunctClipped;
                this.mem.charFunctValue[this.mem.upEventBufPtr] = charFunct;
                if (this.mem.allowNewPickIndex != -1073741823 && this.mem.integralCharFunctClipped[this.mem.upEventBufPtr] >= this.mem.criticalIntegralCharFunct) {
                    int m = this.mem.upEventBufPtr;
                    double integralCharFunctClippedWindow = this.mem.charFunctClippedValue[m];
                    int k2 = 0;
                    while (k2++ < this.mem.nTUpEvent - 1 && n - k2 > this.mem.allowNewPickIndex) {
                        if (--m < 0) {
                            m += this.mem.nTUpEvent;
                        }
                        integralCharFunctClippedWindow += this.mem.charFunctClippedValue[m];
                        if (!(this.mem.charFunctValue[m] >= this.threshold1)) continue;
                        int l = m - 1;
                        if (l < 0) {
                            l += this.mem.nTUpEvent;
                        }
                        if (!(this.mem.charFunctValue[l] < this.threshold1) || !(integralCharFunctClippedWindow >= this.mem.criticalIntegralCharFunct)) continue;
                        acceptedPick = true;
                        charFunctValueTrigger = this.mem.charFunctValue[m];
                        this.mem.triggerNumRecursiveIndex = this.mem.charFuntNumRecursiveIndex[m];
                        indexUpEventTrigger = n - k2;
                        indexUncertaintyPick = this.mem.indexUncertainty[this.mem.triggerNumRecursiveIndex][m];
                        int iPolarity = m + 1;
                        if (iPolarity >= this.mem.nTUpEvent) {
                            iPolarity -= this.mem.nTUpEvent;
                        }
                        this.mem.pickPolarity = 0;
                        if (this.mem.polarityDerivativeSum[this.mem.triggerNumRecursiveIndex][iPolarity] > 0.0 && this.mem.polarityDerivativeSum[this.mem.triggerNumRecursiveIndex][iPolarity] / this.mem.polaritySumAbsDerivative[this.mem.triggerNumRecursiveIndex][iPolarity] > 0.667) {
                            this.mem.pickPolarity = 1;
                        } else if (this.mem.polarityDerivativeSum[this.mem.triggerNumRecursiveIndex][iPolarity] < 0.0 && -this.mem.polarityDerivativeSum[this.mem.triggerNumRecursiveIndex][iPolarity] / this.mem.polaritySumAbsDerivative[this.mem.triggerNumRecursiveIndex][iPolarity] > 0.667) {
                            this.mem.pickPolarity = -1;
                        }
                        this.mem.allowNewPickIndex = -1073741823;
                        break;
                    }
                }
                if (!acceptedPick && this.mem.allowNewPickIndex == -1073741823) {
                    k = 0;
                    while (k < this.mem.numRecursive) {
                        if (this.mem.charFunctUncertainty[k] > this.mem.maxAllowNewPickThreshold) break;
                        ++k;
                    }
                    if (k == this.mem.numRecursive) {
                        this.mem.allowNewPickIndex = n;
                    }
                }
            }
            k = 0;
            while (k < this.mem.numRecursive) {
                this.mem.mean_xRec[k] = this.mem.mean_xRec[k] * this.mem.longDecayConst + this.mem.xRec[k] * this.mem.longDecayFactor;
                double dev = this.mem.xRec[k] - this.mem.mean_xRec[k];
                this.mem.mean_var_xRec[k] = this.mem.mean_var_xRec[k] * this.mem.longDecayConst + dev * dev * this.mem.longDecayFactor;
                this.mem.mean_stdDev_xRec[k] = Math.sqrt(this.mem.mean_var_xRec[k]);
                this.mem.uncertaintyThreshold[k] = this.mem.uncertaintyThreshold[k] * this.mem.longDecayConst + this.mem.charFunctUncertainty[k] * this.mem.longDecayFactor;
                if (this.mem.uncertaintyThreshold[k] > this.mem.maxUncertaintyThreshold) {
                    this.mem.uncertaintyThreshold[k] = this.mem.maxUncertaintyThreshold;
                } else if (this.mem.uncertaintyThreshold[k] < this.mem.minUncertaintyThreshold) {
                    this.mem.uncertaintyThreshold[k] = this.mem.minUncertaintyThreshold;
                }
                ++k;
            }
            if (this.resultType == 2) {
                sampleNew[n] = acceptedPick ? 1.0 : 0.0;
                sampleNew[n] = this.mem.test[index_recursive];
            } else if (this.resultType == 1) {
                sampleNew[n] = charFunctClipped;
            } else if (acceptedPick) {
                int indexEndPick = indexUpEventTrigger;
                int indexBeginPick = indexUncertaintyPick - (indexUpEventTrigger - indexUncertaintyPick);
                double uncertainty = this.deltaTime * (double)(indexEndPick - indexBeginPick);
                double triggerPeriod = this.mem.period[this.mem.triggerNumRecursiveIndex];
                if (uncertainty < triggerPeriod / 20.0) {
                    int ishift = (int)(0.5 * (triggerPeriod / 20.0 - uncertainty) / this.deltaTime);
                    indexBeginPick -= ishift;
                    indexEndPick += ishift;
                }
                PickData pickData = new PickData(indexBeginPick, indexEndPick, this.mem.pickPolarity, charFunctValueTrigger, "_CF", triggerPeriod);
                this.triggerPickData.add(pickData);
            }
            this.mem.lastSample = currentSample;
            this.mem.lastDiffSample = currentDiffSample;
            if (this.onlyOnePick && this.triggerPickData.size() != 0) break;
            ++n;
        }
        if (this.useMemory) {
            int i = 0;
            while (i < this.mem.nTUpEvent) {
                int k = 0;
                while (k < this.mem.numRecursive) {
                    int[] nArray = this.mem.indexUncertainty[k];
                    int n4 = i;
                    nArray[n4] = nArray[n4] - sample.length;
                    ++k;
                }
                ++i;
            }
            if (this.mem.allowNewPickIndex != -1073741823) {
                this.mem.allowNewPickIndex -= sample.length;
            }
        } else {
            this.mem = null;
        }
        if (this.resultType == 2 || this.resultType == 1) {
            sample = sampleNew;
            ++index_recursive;
        }
        return sample;
    }

    public boolean supportsMemory() {
        return true;
    }

    public boolean isOnlyOnePick() {
        return this.onlyOnePick;
    }

    public void setOnlyOnePick(boolean onlyOnePick) {
        this.onlyOnePick = onlyOnePick;
    }

    public void reset() {
        if (this.mem != null) {
            this.mem.nTotal = -1;
            this.mem.enableTriggering = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CallFP5
    implements Callable<PD> {
        public int chn;
        double dt;
        double[] dz;
        double longTermWindow;
        double threshold1;
        double threshold2;
        double tUpEvent;
        double filterWindow;
        boolean onlyOnePick;

        public CallFP5(int chn, double dt, double[] dz, double longTermWindow, double s1, double s2, double tUpEvent, double filterWindow, boolean onlyOnePick) {
            this.chn = chn;
            this.dt = dt;
            this.dz = dz;
            this.longTermWindow = longTermWindow;
            this.threshold1 = s1;
            this.threshold2 = s2;
            this.tUpEvent = tUpEvent;
            this.filterWindow = filterWindow;
            this.onlyOnePick = onlyOnePick;
        }

        @Override
        public PD call() {
            FilterPicker5 fp5 = new FilterPicker5(this.longTermWindow, this.threshold1, this.threshold2, this.tUpEvent, this.filterWindow, 1);
            fp5.setOnlyOnePick(this.onlyOnePick);
            fp5.apply(this.dt, this.dz);
            return new PD(this.chn, fp5.getPickData());
        }
    }

    public class FilterPicker5_Memory
    extends TimeDomainMemory {
        double longDecayFactor;
        double longDecayConst;
        int nLongTermWindow;
        int indexEnableTriggering;
        boolean enableTriggering;
        int nTotal;
        int numRecursive;
        int nTemp;
        double[] xRec;
        double[] test;
        double[][] filteredSample;
        double[] lastFilteredSample;
        double[] mean_xRec;
        double[] mean_stdDev_xRec;
        double[] mean_var_xRec;
        double[] period;
        double[] lowPassConst;
        double[] highPassConst;
        double window;
        double lastSample;
        double lastDiffSample;
        double[] charFunctUncertainty;
        double[] charFunctUncertaintyLast;
        double[] uncertaintyThreshold;
        double maxUncertaintyThreshold;
        double minUncertaintyThreshold;
        double maxAllowNewPickThreshold;
        int nTUpEvent;
        int[][] indexUncertainty;
        double[][] polarityDerivativeSum;
        double[][] polaritySumAbsDerivative;
        double criticalIntegralCharFunct;
        double[] integralCharFunctClipped;
        int allowNewPickIndex;
        double[] charFunctClippedValue;
        double[] charFunctValue;
        int[] charFuntNumRecursiveIndex;
        int upEventBufPtr;
        int pickPolarity;
        int triggerNumRecursiveIndex;

        public FilterPicker5_Memory(double[] sample) {
            this.longDecayFactor = FilterPicker5.this.deltaTime / FilterPicker5.this.longTermWindow;
            this.longDecayConst = 1.0 - this.longDecayFactor;
            this.indexEnableTriggering = this.nLongTermWindow = 1 + (int)(FilterPicker5.this.longTermWindow / FilterPicker5.this.deltaTime);
            this.enableTriggering = false;
            this.nTotal = -1;
            this.numRecursive = 1;
            this.nTemp = 1;
            int numPrevious = (int)(FilterPicker5.this.filterWindow / FilterPicker5.this.deltaTime);
            while (this.nTemp < numPrevious) {
                ++this.numRecursive;
                this.nTemp *= 2;
            }
            numPrevious = this.nTemp;
            this.xRec = new double[this.numRecursive];
            this.test = new double[this.numRecursive];
            this.filteredSample = new double[this.numRecursive][3];
            this.lastFilteredSample = new double[this.numRecursive];
            this.mean_xRec = new double[this.numRecursive];
            this.mean_stdDev_xRec = new double[this.numRecursive];
            this.mean_var_xRec = new double[this.numRecursive];
            this.period = new double[this.numRecursive];
            this.lowPassConst = new double[this.numRecursive];
            this.highPassConst = new double[this.numRecursive];
            this.window = FilterPicker5.this.deltaTime / (Math.PI * 2);
            int k = 0;
            while (k < this.numRecursive) {
                this.mean_xRec[k] = 0.0;
                this.mean_stdDev_xRec[k] = 0.0;
                this.mean_var_xRec[k] = 0.0;
                this.period[k] = this.window * 2.0 * Math.PI;
                this.lowPassConst[k] = FilterPicker5.this.deltaTime / (this.window + FilterPicker5.this.deltaTime);
                this.highPassConst[k] = this.window / (this.window + FilterPicker5.this.deltaTime);
                this.window *= 2.0;
                ++k;
            }
            this.lastSample = Double.MAX_VALUE;
            this.lastDiffSample = 0.0;
            this.charFunctUncertainty = new double[this.numRecursive];
            this.charFunctUncertaintyLast = new double[this.numRecursive];
            this.uncertaintyThreshold = new double[this.numRecursive];
            k = 0;
            while (k < this.numRecursive) {
                this.uncertaintyThreshold[k] = FilterPicker5.this.threshold1 / 2.0;
                ++k;
            }
            this.maxUncertaintyThreshold = FilterPicker5.this.threshold1 / 2.0;
            this.minUncertaintyThreshold = 0.5;
            this.maxAllowNewPickThreshold = 2.0;
            this.nTUpEvent = (int)Math.round(FilterPicker5.this.tUpEvent / FilterPicker5.this.deltaTime) + 1;
            if (this.nTUpEvent < 1) {
                this.nTUpEvent = 1;
            }
            this.indexUncertainty = new int[this.numRecursive][this.nTUpEvent];
            this.polarityDerivativeSum = new double[this.numRecursive][this.nTUpEvent];
            this.polaritySumAbsDerivative = new double[this.numRecursive][this.nTUpEvent];
            this.criticalIntegralCharFunct = (double)this.nTUpEvent * FilterPicker5.this.threshold2;
            this.integralCharFunctClipped = new double[this.nTUpEvent];
            this.allowNewPickIndex = -1073741823;
            this.charFunctClippedValue = new double[this.nTUpEvent];
            this.charFunctValue = new double[this.nTUpEvent];
            this.charFuntNumRecursiveIndex = new int[this.nTUpEvent];
            k = 0;
            while (k < this.nTUpEvent) {
                int l = 0;
                while (l < this.numRecursive) {
                    this.indexUncertainty[l][k] = 0;
                    ++l;
                }
                this.charFunctClippedValue[k] = 0.0;
                this.charFunctValue[k] = 0.0;
                this.charFuntNumRecursiveIndex[k] = 0;
                ++k;
            }
            this.upEventBufPtr = 0;
            this.pickPolarity = 0;
            this.triggerNumRecursiveIndex = -1;
            int nmean = this.nLongTermWindow < sample.length ? this.nLongTermWindow : sample.length;
            double sample_mean = 0.0;
            int i = 0;
            while (i < nmean) {
                sample_mean += sample[i];
                ++i;
            }
            sample_mean /= (double)nmean;
            int k2 = 0;
            while (k2 < this.numRecursive) {
                int j = 0;
                while (j < 3) {
                    this.filteredSample[k2][j] = 0.0;
                    ++j;
                }
                ++k2;
            }
            this.lastSample = sample_mean;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PD {
        public int chn;
        public Vector<PickData> pd;

        public PD(int chn, Vector<PickData> pd) {
            this.chn = chn;
            this.pd = pd;
        }
    }
}

