/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.picker;

import cn.org.gddsn.seis.picker.BasicPicker;
import cn.org.gddsn.seis.picker.PickData;
import cn.org.gddsn.seis.picker.TimeDomainException;

public class ShortLongTermAve
extends BasicPicker {
    public double shortTermWindow = 1.0;
    public double longTermWindow = 10.0;
    public double triggerRatio = 2.0;
    public String errorMessage;
    private static final double WINDOW_MIN = Double.MIN_VALUE;
    private static final double WINDOW_MAX = Double.MAX_VALUE;
    private static final double RATIO_MIN = -1.7976931348623157E308;
    private static final double RATIO_MAX = Double.MAX_VALUE;

    public ShortLongTermAve(double shortTermWindow, double longTermWindow, double triggerRatio, int direction) {
        super(direction);
        this.shortTermWindow = shortTermWindow;
        this.longTermWindow = longTermWindow;
        this.triggerRatio = triggerRatio;
    }

    public void setShortTermWindow(double shortTermWindowValue) throws TimeDomainException {
        if (shortTermWindowValue < Double.MIN_VALUE || shortTermWindowValue > Double.MAX_VALUE) {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_short_term_window_value) + ": " + shortTermWindowValue);
        }
        this.shortTermWindow = shortTermWindowValue;
    }

    public void setShortTermWindow(String str) throws TimeDomainException {
        double shortTermWindowValue;
        try {
            shortTermWindowValue = Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_short_term_window_value) + ": " + str);
        }
        this.setShortTermWindow(shortTermWindowValue);
    }

    public void setLongTermWindow(double longTermWindowValue) throws TimeDomainException {
        if (longTermWindowValue < Double.MIN_VALUE || longTermWindowValue > Double.MAX_VALUE) {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_long_term_window_value) + ": " + longTermWindowValue);
        }
        this.longTermWindow = longTermWindowValue;
    }

    public void setLongTermWindow(String str) throws TimeDomainException {
        double longTermWindowValue;
        try {
            longTermWindowValue = Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_long_term_window_value) + ": " + str);
        }
        this.setLongTermWindow(longTermWindowValue);
    }

    public void setRatio(double ratioValue) throws TimeDomainException {
        if (ratioValue < -1.7976931348623157E308 || ratioValue > Double.MAX_VALUE) {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_ratio_value) + ": " + ratioValue);
        }
        this.triggerRatio = ratioValue;
    }

    public void setRatio(String str) throws TimeDomainException {
        double ratioValue;
        try {
            ratioValue = Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_ratio_value) + ": " + str);
        }
        this.setRatio(ratioValue);
    }

    public void checkSettings() throws TimeDomainException {
        super.checkSettings();
        String errMessage = "";
        int badSettings = 0;
        if (this.shortTermWindow < Double.MIN_VALUE || this.shortTermWindow > Double.MAX_VALUE) {
            errMessage = String.valueOf(errMessage) + ": " + TimeDomainException.invalid_short_term_window_value;
            ++badSettings;
        }
        if (this.longTermWindow < Double.MIN_VALUE || this.longTermWindow > Double.MAX_VALUE) {
            errMessage = String.valueOf(errMessage) + ": " + TimeDomainException.invalid_long_term_window_value;
            ++badSettings;
        }
        if (this.triggerRatio < -1.7976931348623157E308 || this.triggerRatio > Double.MAX_VALUE) {
            errMessage = String.valueOf(errMessage) + ": " + TimeDomainException.invalid_ratio_value;
            ++badSettings;
        }
        if (badSettings > 0) {
            throw new TimeDomainException(String.valueOf(errMessage) + ".");
        }
    }

    public final double[] apply(double dt, double[] sample) {
        double shortDecayConst = 1.0 - dt / this.shortTermWindow;
        double shortFactor = 1.0 - shortDecayConst;
        double longDecayConst = 1.0 - dt / this.longTermWindow;
        double longFactor = 1.0 - longDecayConst;
        double sval = 0.0;
        double lval = 0.0;
        double mval = sample[0];
        double ratio = 0.0;
        int nLongTermWindow = 1 + (int)(this.longTermWindow / dt);
        boolean backwards = this.direction == -1;
        int lastCriticalRatioIndex = -1;
        double criticalRatio = 1.0;
        double ratioLast = sval;
        double lastPickIndex1 = 0.0;
        int n = 0;
        while (n < sample.length) {
            boolean triggered;
            int i = backwards ? sample.length - n - 1 : n;
            mval = 0.0;
            sval = sval * shortDecayConst + Math.abs(sample[i] - mval) * shortFactor;
            if (n > nLongTermWindow) {
                lval = lval * longDecayConst + Math.abs(sample[i] - mval) * longFactor;
                ratio = sval / lval;
            } else {
                lval = sval;
            }
            boolean bl = triggered = n > nLongTermWindow && ratio > this.triggerRatio;
            if (this.resultType == 2) {
                sample[i] = triggered ? 1.0 : 0.0;
            } else if (this.resultType == 1) {
                sample[i] = ratio;
            } else {
                if (triggered) {
                    double[] pickIndices = new double[2];
                    pickIndices[0] = (double)i - (ratio - 1.0) / (ratio - ratioLast);
                    if (pickIndices[0] < lastPickIndex1) {
                        pickIndices[0] = lastPickIndex1;
                    }
                    if (pickIndices[0] < (double)lastCriticalRatioIndex) {
                        pickIndices[0] = lastCriticalRatioIndex;
                    }
                    pickIndices[1] = i;
                    PickData pickData = new PickData(pickIndices[0], pickIndices[1], 0, ratio, "_CF");
                    this.triggerPickData.add(pickData);
                    lastPickIndex1 = pickIndices[1];
                }
                if (lastCriticalRatioIndex < 0 && n > nLongTermWindow && ratio > criticalRatio) {
                    lastCriticalRatioIndex = i;
                } else if (n > nLongTermWindow && ratio < criticalRatio) {
                    lastCriticalRatioIndex = -1;
                }
            }
            if (this.triggerRatio != 0.0 && ratio > Math.abs(this.triggerRatio)) {
                lval = sval;
            }
            ratioLast = ratio;
            ++n;
        }
        return sample;
    }
}

