/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.realtimeplot.gui;

import JSci.maths.ArrayMath;
import cn.org.gddsn.liss.client.LissClient;
import cn.org.gddsn.liss.client.LissException;
import cn.org.gddsn.liss.port.event.MiniSeedPortEvent;
import cn.org.gddsn.liss.port.event.MiniSeedPortEventListener;
import cn.org.gddsn.liss.port.sss.SSSPort;
import cn.org.gddsn.util.Log4jConfig;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelayRecordDlg
implements MiniSeedPortEventListener {
    static Logger logger = Logger.getLogger(DelayRecordDlg.class);
    private static final int TablePage = 3;
    private final int refreshTime = 1;
    private LissClient lissClient = null;
    private SSSPort cPort = null;
    private String[] stnCodes = null;
    private ConcurrentHashMap<String, List<Double>> delayMap;
    private final double abnormalDelay = 60000.0;
    private Timer timer;
    private static final String nullVal = "-";
    private final String[] columnNames = new String[]{"Station", "Avg(ms)", "STDEV", "Max(ms)", "Min(ms)"};
    private JTextField hostTF = null;
    private JTextField userTF = null;
    private JPasswordField passPF = null;
    private MyTableModel[] tableModels = null;
    private static final String recordFile = "delayrecord.txt";
    boolean hasGUI;
    private String host;
    private String user;
    private String pass;

    public DelayRecordDlg() {
        this.hasGUI = true;
        this.initGUI();
    }

    public DelayRecordDlg(String host, String user, String pass) {
        this.hasGUI = false;
        this.host = host;
        this.user = user;
        this.pass = pass;
        this.connectServer();
        this.clearDelayMap();
        this.initTimer();
    }

    private void initGUI() {
        JDialog dlg = new JDialog();
        dlg.setTitle(String.format("Delay Recorder, refresh Every %d Minute(s)", 1));
        dlg.setBounds(20, 20, 1000, 700);
        dlg.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (DelayRecordDlg.this.cPort != null) {
                    DelayRecordDlg.this.cPort.removeMiniSeedPortEventListener((MiniSeedPortEventListener)DelayRecordDlg.this);
                    DelayRecordDlg.this.cPort.closePort();
                }
                System.exit(0);
            }
        });
        JPanel contentPane = new JPanel(new BorderLayout());
        JPanel connectPane = new JPanel(new FlowLayout(0, 5, 5));
        JLabel hostLB = new JLabel("   HOST:");
        this.hostTF = new JTextField(10);
        JLabel userLB = new JLabel("   USER:");
        this.userTF = new JTextField(5);
        JLabel passLB = new JLabel("   PASSWORD:");
        this.passPF = new JPasswordField(5);
        JButton connectBT = new JButton("CONNECT");
        connectBT.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                DelayRecordDlg.this.updateTable(null);
                DelayRecordDlg.this.connectServer();
                DelayRecordDlg.this.clearDelayMap();
                DelayRecordDlg.this.initTimer();
            }
        });
        connectPane.add(hostLB);
        connectPane.add(this.hostTF);
        connectPane.add(userLB);
        connectPane.add(this.userTF);
        connectPane.add(passLB);
        connectPane.add(this.passPF);
        connectPane.add(connectBT);
        JPanel tablePane = new JPanel(new GridLayout(1, 3, 5, 5));
        JTable[] tables = new JTable[3];
        this.tableModels = new MyTableModel[3];
        int i = 0;
        while (i < 3) {
            tables[i] = new JTable();
            this.tableModels[i] = new MyTableModel(i);
            tables[i].setModel(this.tableModels[i]);
            this.initTable(tables[i]);
            tablePane.add(new JScrollPane(tables[i]));
            ++i;
        }
        JLabel infoLB = new JLabel();
        infoLB.setHorizontalAlignment(0);
        infoLB.setText("TIPs: also see lastest record in FILE:delayrecord.txt");
        contentPane.add((Component)connectPane, "North");
        contentPane.add((Component)tablePane, "Center");
        contentPane.add((Component)infoLB, "South");
        dlg.setContentPane(contentPane);
        dlg.setVisible(true);
    }

    private void initTable(JTable t) {
        t.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        t.setColumnSelectionAllowed(false);
        t.setRowSelectionAllowed(true);
        t.setSelectionMode(0);
        t.setFillsViewportHeight(true);
        t.setRowHeight(25);
        t.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            public int getHorizontalAlignment() {
                return 0;
            }

            public Component getTableCellRendererComponent(JTable t, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                double val;
                if (row % 2 == 0) {
                    this.setBackground(Color.WHITE);
                } else {
                    this.setBackground(new Color(232, 242, 254));
                }
                if (column > 0 && value != null && value.toString().equals(DelayRecordDlg.nullVal)) {
                    this.setBackground(Color.LIGHT_GRAY);
                }
                this.setForeground(Color.BLACK);
                if (column == 1 && value != null && !value.toString().isEmpty() && !value.toString().equals(DelayRecordDlg.nullVal) && ((val = Double.parseDouble(value.toString().trim())) < -60000.0 || val > 60000.0)) {
                    this.setForeground(Color.RED);
                }
                return super.getTableCellRendererComponent(t, value, isSelected, hasFocus, row, column);
            }
        });
        int columnCount = t.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            switch (i) {
                case 0: {
                    t.getColumn(this.columnNames[i]).setPreferredWidth(40);
                    break;
                }
                default: {
                    t.getColumn(this.columnNames[i]).setPreferredWidth(25);
                }
            }
            ++i;
        }
    }

    public void connectServer() {
        boolean succeed = false;
        this.stnCodes = null;
        this.delayMap = null;
        if (this.hasGUI) {
            this.host = this.hostTF.getText().trim();
            this.user = this.userTF.getText().trim();
            this.pass = new String(this.passPF.getPassword());
        }
        try {
            this.lissClient = new LissClient(this.host, 5000);
            logger.info((Object)("NetSeisIP version is: " + this.lissClient.getVersion()));
            this.lissClient.login(this.user, this.pass);
            this.stnCodes = this.lissClient.getAllStationCode();
            this.lissClient.quit();
            if (this.cPort != null) {
                this.cPort.removeMiniSeedPortEventListener((MiniSeedPortEventListener)this);
                this.cPort.closePort();
                this.cPort = null;
            }
            this.cPort = new SSSPort(this.host, 5000, this.user, this.pass, this.stnCodes);
            this.cPort.addMiniSeedPortEventListener((MiniSeedPortEventListener)this);
            succeed = true;
        }
        catch (ConnectException cEx) {
            logger.warn((Object)("Caught ConnectionException : " + cEx.getMessage()));
        }
        catch (IOException ex) {
            logger.warn((Object)("Caught IOException: " + ex.getMessage()));
        }
        catch (LissException ex) {
            logger.warn((Object)("Caught LissException: " + ex.getMessage()));
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        if (!succeed) {
            if (this.hasGUI) {
                JOptionPane.showMessageDialog(null, "Connect failed!", "failed", 0);
            } else {
                logger.warn((Object)"Connect failed.");
            }
        }
    }

    private void initTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)new CalculationTask(), 2000L, 60000L);
    }

    private void clearDelayMap() {
        if (this.stnCodes == null) {
            return;
        }
        if (this.delayMap == null) {
            this.delayMap = new ConcurrentHashMap(this.stnCodes.length);
        }
        this.delayMap.clear();
        String[] stringArray = this.stnCodes;
        int n = this.stnCodes.length;
        int n2 = 0;
        while (n2 < n) {
            String stn = stringArray[n2];
            this.delayMap.put(stn, new ArrayList());
            ++n2;
        }
    }

    private void updateTable(List<StationDelay> delays) {
        if (!this.hasGUI) {
            return;
        }
        int i = 0;
        while (i < this.tableModels.length) {
            this.tableModels[i].setTableData(delays);
            this.tableModels[i].fireTableDataChanged();
            ++i;
        }
    }

    public void miniSeedEvent(MiniSeedPortEvent me) {
        if (this.delayMap == null) {
            return;
        }
        GenericMiniSeedRecord gmsr = me.getGenericMiniSeedRecord();
        String stnCode = String.format("%s/%s", gmsr.getNetwork(), gmsr.getStation());
        long delay = this.getSTDtime().getTime() - gmsr.getStartTime().getTime();
        List<Double> delays = this.delayMap.get(stnCode);
        if (delays != null) {
            delays.add(Double.valueOf(delay));
        }
    }

    public Date getSTDtime() {
        return new Date();
    }

    public static void main(String[] args) {
        Log4jConfig.loadForMain((String)"log4j.properties");
        if (args.length == 0) {
            new DelayRecordDlg();
            logger.info((Object)"starting GUI model ....");
        } else if (args.length == 3) {
            new DelayRecordDlg(args[0], args[1], args[2]);
            logger.info((Object)"starting letter model ....");
        } else {
            logger.warn((Object)"usage: DelayRecordDlg HOST USER PASSWORD");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CalculationTask
    extends TimerTask {
        private List<StationDelay> delays;
        private PrintWriter pw;

        public CalculationTask() {
            try {
                this.pw = new PrintWriter(new FileOutputStream(DelayRecordDlg.recordFile));
            }
            catch (FileNotFoundException e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public void run() {
            if (DelayRecordDlg.this.stnCodes == null || DelayRecordDlg.this.delayMap == null) {
                return;
            }
            this.calulate();
            DelayRecordDlg.this.clearDelayMap();
            DelayRecordDlg.this.updateTable(this.delays);
            this.write2File();
        }

        private void calulate() {
            this.delays = new ArrayList<StationDelay>(DelayRecordDlg.this.stnCodes.length);
            Enumeration enumKey = DelayRecordDlg.this.delayMap.keys();
            while (enumKey.hasMoreElements()) {
                String key = (String)enumKey.nextElement();
                List value = (List)DelayRecordDlg.this.delayMap.get(key);
                StationDelay stnDelay = new StationDelay();
                stnDelay.stnCode = key;
                if (value.isEmpty()) {
                    stnDelay.average = Double.NaN;
                    stnDelay.standardDeviation = Double.NaN;
                    stnDelay.max = Double.NaN;
                    stnDelay.min = Double.NaN;
                } else {
                    double[] d = this.toArray(value);
                    stnDelay.average = ArrayMath.mean((double[])d);
                    stnDelay.standardDeviation = ArrayMath.standardDeviation((double[])d);
                    stnDelay.max = ArrayMath.max((double[])d);
                    stnDelay.min = ArrayMath.min((double[])d);
                }
                this.delays.add(stnDelay);
            }
            Collections.sort(this.delays);
        }

        private double[] toArray(List<Double> value) {
            double[] d = new double[value.size()];
            int i = 0;
            while (i < d.length) {
                d[i] = value.get(i);
                ++i;
            }
            return d;
        }

        private void write2File() {
            StringBuffer sb = new StringBuffer(2048);
            this.pw.printf("\n%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS.%1$tL\n", new Date());
            sb.append(String.format("\n%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS.%1$tL\n", new Date()));
            this.pw.printf("%12s%15s%15s%15s%15s\n", "Station", "Avg(ms)", "STDEV", "Max(ms)", "Min(ms)");
            sb.append(String.format("%12s%15s%15s%15s%15s\n", "Station", "Avg(ms)", "STDEV", "Max(ms)", "Min(ms)"));
            for (StationDelay sd : this.delays) {
                this.pw.printf("%12s%15.0f%15.2f%15.0f%15.0f\n", sd.stnCode, sd.average, sd.standardDeviation, sd.max, sd.min);
                sb.append(String.format("%12s%15.0f%15.2f%15.0f%15.0f\n", sd.stnCode, sd.average, sd.standardDeviation, sd.max, sd.min));
            }
            logger.info((Object)sb.toString());
            this.pw.flush();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private int rowCount = 20;
        private int pageIndex;
        private List<StationDelay> delays;

        public MyTableModel(int pageIndex) {
            this.pageIndex = pageIndex;
        }

        @Override
        public int getColumnCount() {
            return DelayRecordDlg.this.columnNames.length;
        }

        @Override
        public String getColumnName(int col) {
            return DelayRecordDlg.this.columnNames[col];
        }

        @Override
        public int getRowCount() {
            return this.rowCount;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.delays == null || row >= this.delays.size()) {
                return "";
            }
            StationDelay staDelay = this.delays.get(row);
            if (staDelay == null) {
                return "";
            }
            switch (col) {
                case 0: {
                    return staDelay.stnCode;
                }
                case 1: {
                    return Double.isNaN(staDelay.average) ? DelayRecordDlg.nullVal : String.format("%.0f", staDelay.average);
                }
                case 2: {
                    return Double.isNaN(staDelay.standardDeviation) ? DelayRecordDlg.nullVal : String.format("%.2f", staDelay.standardDeviation);
                }
                case 3: {
                    return Double.isNaN(staDelay.max) ? DelayRecordDlg.nullVal : String.format("%.0f", staDelay.max);
                }
                case 4: {
                    return Double.isNaN(staDelay.min) ? DelayRecordDlg.nullVal : String.format("%.0f", staDelay.min);
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public void setTableData(List<StationDelay> delays) {
            if (delays == null) {
                this.delays = new ArrayList<StationDelay>();
                return;
            }
            int size = delays.size();
            int mod = size % 3;
            this.rowCount = mod > 0 ? size / 3 + 1 : size / 3;
            int from = this.rowCount * this.pageIndex;
            int to = this.rowCount * this.pageIndex + this.rowCount - 1;
            this.delays = delays.subList(from, to >= size ? size : to);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StationDelay
    implements Comparable<StationDelay> {
        public String stnCode;
        public double average;
        public double standardDeviation;
        public double max;
        public double min;

        @Override
        public int compareTo(StationDelay s) {
            return this.stnCode.compareTo(s.stnCode);
        }
    }
}

