/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.realtimeplot.gui;

import cn.org.gddsn.liss.port.event.MiniSeedPortEvent;
import cn.org.gddsn.liss.port.event.MiniSeedPortEventListener;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

class SimpleJFrame
extends JFrame
implements MiniSeedPortEventListener {
    private static final long serialVersionUID = 1L;
    static Logger logger = Logger.getLogger(SimpleJFrame.class);
    boolean bRecord = false;
    JMenu jmenuFile;
    JMenuBar jmenubar;
    JMenuItem jmItemStartRecord;
    JMenuItem jmItemStopRecord;
    String[] netID;
    String[] stnCode;
    String[] locID;
    String[] chanCode;
    Hashtable<String, PrintWriter> tbl = new Hashtable();
    Hashtable<String, Boolean> firstTbl = new Hashtable();

    public SimpleJFrame() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public SimpleJFrame(String title) {
        super(title);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private void jbInit() throws Exception {
        this.jmenuFile = new JMenu("File");
        this.jmItemStartRecord = new JMenuItem("Start Record...");
        this.jmenuFile.add(this.jmItemStartRecord);
        this.jmItemStartRecord.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleJFrame.this.jmItemStartRecord_actionPerformed(e);
            }
        });
        this.jmItemStopRecord = new JMenuItem("Stop Record");
        this.jmItemStopRecord.setEnabled(false);
        this.jmItemStopRecord.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleJFrame.this.jmItemStopRecord_actionPerformed(e);
            }
        });
        this.jmenuFile.add(this.jmItemStopRecord);
        this.jmenubar = new JMenuBar();
        this.jmenubar.add(this.jmenuFile);
        this.setJMenuBar(this.jmenubar);
    }

    synchronized void jmItemStartRecord_actionPerformed(ActionEvent e) {
        this.bRecord = true;
        this.jmItemStartRecord.setEnabled(false);
        this.jmItemStopRecord.setEnabled(true);
        try {
            int i = 0;
            while (i < this.netID.length) {
                String key = String.valueOf(this.netID[i]) + "_" + this.stnCode[i] + "_" + this.locID[i] + "_" + this.chanCode[i];
                PrintWriter pw = new PrintWriter(new FileOutputStream(key));
                this.tbl.put(key, pw);
                this.firstTbl.put(key, new Boolean(true));
                ++i;
            }
        }
        catch (IOException ioEx) {
            logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
        }
    }

    synchronized void jmItemStopRecord_actionPerformed(ActionEvent e) {
        this.bRecord = false;
        this.jmItemStartRecord.setEnabled(true);
        this.jmItemStopRecord.setEnabled(false);
        int i = 0;
        while (i < this.netID.length) {
            String key = String.valueOf(this.netID[i]) + "_" + this.stnCode[i] + "_" + this.locID[i] + "_" + this.chanCode[i];
            PrintWriter pw = this.tbl.get(key);
            pw.flush();
            pw.close();
            this.tbl.remove(key);
            this.firstTbl.remove(key);
            ++i;
        }
    }

    public void setStationInfo(String[] netID, String[] stnCode, String[] locID, String[] chanCode) {
        this.netID = netID;
        this.stnCode = stnCode;
        this.locID = locID;
        this.chanCode = chanCode;
    }

    public synchronized void miniSeedEvent(MiniSeedPortEvent MiniSeedPortEvent2) {
        GenericMiniSeedRecord gmsRec = MiniSeedPortEvent2.getGenericMiniSeedRecord();
        if (gmsRec == null) {
            return;
        }
        if (this.bRecord) {
            String net = gmsRec.getNetwork();
            String stnCode = gmsRec.getStation();
            String locID = gmsRec.getLocID();
            String chanCode = gmsRec.getChannel();
            SimpleDateFormat dateFmt = new SimpleDateFormat("MM-dd-yyy");
            SimpleDateFormat timeFmt = new SimpleDateFormat("HH:mm:ss.ss");
            String key = String.valueOf(net) + "_" + stnCode + "_" + locID + "_" + chanCode;
            Boolean bFirst = this.firstTbl.get(key);
            PrintWriter pw = this.tbl.get(key);
            if (pw == null) {
                return;
            }
            if (bFirst.booleanValue()) {
                this.firstTbl.remove(key);
                this.firstTbl.put(key, new Boolean(false));
                pw.println("DATASET " + stnCode);
                pw.println("VERSION NXT");
                pw.println("SERIES " + chanCode);
                pw.println("DATE " + dateFmt.format((Date)gmsRec.getStartTime()));
                pw.println("TIME " + timeFmt.format((Date)gmsRec.getStartTime()));
                pw.println("FILE_TYPE ASCII");
                pw.println("NUM_SAMPS ALL");
                pw.println("INTERVAL " + 1.0 / gmsRec.getSampleRate());
                pw.println("X_OFFSET 0");
                pw.println("MAX_VAL 8388608");
                pw.println("MIN_VAL -8388608");
                pw.println("VERT_UNITS Counts");
                pw.println("HORZ_UNITS Sec");
                pw.println("COMMENT ");
                pw.println("DATA ");
            }
            gmsRec.decompress();
            int[] samps = gmsRec.getUData();
            int i = 0;
            while (i < samps.length) {
                pw.println(samps[i]);
                ++i;
            }
        }
    }
}

