/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.regions;

import cn.org.gddsn.seis.regions.Bounds2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polygon2D {
    static Logger logger = Logger.getLogger(Polygon2D.class);
    private String name;
    private double[] Xcoordinates;
    private double[] Ycoordinates;
    private int nPoints;
    private Area area;
    private double mag;

    public Polygon2D() {
    }

    public Polygon2D(String name_mag, List<Double> XcoordinatesList, List<Double> YcoordinatesList) {
        this.nPoints = XcoordinatesList.size();
        this.Xcoordinates = new double[this.nPoints];
        this.Ycoordinates = new double[this.nPoints];
        GeneralPath gp = new GeneralPath();
        int i = 0;
        while (i < this.nPoints) {
            this.Xcoordinates[i] = XcoordinatesList.get(i);
            this.Ycoordinates[i] = YcoordinatesList.get(i);
            if (i == 0) {
                gp.moveTo(this.Xcoordinates[i], this.Ycoordinates[i]);
            } else {
                gp.lineTo(this.Xcoordinates[i], this.Ycoordinates[i]);
            }
            ++i;
        }
        this.area = new Area(gp);
        String[] split = name_mag.split("_");
        this.name = split[0];
        try {
            this.mag = Double.parseDouble(split[1]);
            logger.info((Object)String.format("Rreport range:%s, Mag>=%s", this.name, this.mag));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean contains(Point2D p2d) {
        return this.contains(p2d.getX(), p2d.getY());
    }

    public boolean contains(double x, double y) {
        if (this.Xcoordinates.length <= 2) {
            return false;
        }
        return this.area.contains(x, y);
    }

    public Bounds2D getBounds() {
        double boundsMinX = Double.MAX_VALUE;
        double boundsMinY = Double.MAX_VALUE;
        double boundsMaxX = Double.MIN_VALUE;
        double boundsMaxY = Double.MIN_VALUE;
        int i = 0;
        while (i < this.nPoints) {
            double xTemp = this.Xcoordinates[i];
            boundsMinX = Math.min(boundsMinX, xTemp);
            boundsMaxX = Math.max(boundsMaxX, xTemp);
            double yTemp = this.Ycoordinates[i];
            boundsMinY = Math.min(boundsMinY, yTemp);
            boundsMaxY = Math.max(boundsMaxY, yTemp);
            ++i;
        }
        return new Bounds2D(boundsMinX, boundsMaxX, boundsMinY, boundsMaxY);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Polygon2D[" + this.name + "]{");
        int i = 0;
        while (i < this.nPoints) {
            sb.append("(");
            sb.append(this.Xcoordinates[i]);
            sb.append(",");
            sb.append(this.Ycoordinates[i]);
            sb.append(") ");
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double[] getXcoordinates() {
        return this.Xcoordinates;
    }

    public double[] getYcoordinates() {
        return this.Ycoordinates;
    }

    public double getMag() {
        return this.mag;
    }

    public void setMag(double mag) {
        this.mag = mag;
    }
}

