/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.regions.geotools;

import cn.org.gddsn.seis.SourceParam;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.util.Date;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeImpl;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CreateFeature {
    public SimpleFeature genSeisFeature(SourceParam sourceParam) {
        System.out.println("### step1: create seis feature for sourceParam");
        Coordinate ptc = new Coordinate(sourceParam.getLon(), sourceParam.getLat());
        GeometryFactory geomFac = new GeometryFactory();
        Point ptG = geomFac.createPoint(ptc);
        AttributeTypeBuilder atb = new AttributeTypeBuilder();
        atb.setName("the_geom");
        atb.setBinding(ptG.getClass());
        atb.setNillable(true);
        atb.setLength(1);
        atb.setDefaultValue(null);
        atb.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GeometryDescriptor ptGA = (GeometryDescriptor)atb.buildDescriptor("the_geom");
        atb.setName("ms");
        atb.setBinding(Double.class);
        AttributeDescriptor cityAT = atb.buildDescriptor("ms");
        atb.setName("O_time");
        atb.setBinding(Date.class);
        AttributeDescriptor popAT = atb.buildDescriptor("O_time");
        atb.setName("\u7701\u540d");
        atb.setBinding(String.class);
        AttributeDescriptor proAT = atb.buildDescriptor("\u7701\u540d");
        AttributeDescriptor[] ptATs = new AttributeDescriptor[]{ptGA, cityAT, popAT, proAT};
        SimpleFeatureTypeImpl ptFT = null;
        try {
            ptFT = (SimpleFeatureTypeImpl)FeatureTypes.newFeatureType((AttributeDescriptor[])ptATs, (String)"seis");
        }
        catch (SchemaException schex) {
            String msg = "SchemaException on FeatureType creation: " + (Object)((Object)schex);
            new IOException(msg).initCause(schex);
        }
        Object[] ptElems = new Object[]{ptG, sourceParam.getMs(), sourceParam.getOriginTime(), sourceParam.getFeRegion()};
        SimpleFeature ptF = null;
        try {
            ptF = SimpleFeatureBuilder.build((SimpleFeatureType)ptFT, (Object[])ptElems, (String)"seis.1");
        }
        catch (IllegalAttributeException iaex) {
            System.err.println("IllegalAttributeException on Feature creation: " + (Object)((Object)iaex));
        }
        return ptF;
    }

    public void genGeometry(double lat, double lon) {
        Point ptG;
        Coordinate ptc = new Coordinate(lon, lat);
        GeometryFactory geomFac = new GeometryFactory();
        Point g = ptG = geomFac.createPoint(ptc);
        System.out.println(ptG);
    }

    private static Geometry createCircle(double epic_lat, double epi_lon, double radius) {
        int SIDES = 32;
        Coordinate[] coords = new Coordinate[32];
        int i = 0;
        while (i < 32) {
            double angle = (double)i / 32.0 * 360.0;
            double dx = Math.cos(angle) * radius;
            double dy = Math.sin(angle) * radius;
            coords[i] = new Coordinate(epic_lat + dx, epi_lon + dy);
            ++i;
        }
        coords[coords.length - 1] = coords[0];
        GeometryFactory geomFac = new GeometryFactory();
        LinearRing ring = geomFac.createLinearRing(coords);
        Polygon polygon = geomFac.createPolygon(ring, null);
        return polygon;
    }

    public static void main(String[] args) {
        new SourceParam(114.4, 23.6, new Date(), 3.1, "test place");
        System.out.println(CreateFeature.createCircle(23.26, 114.5, 0.08992805755395683));
    }
}

