/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.regions.geotools;

import cn.org.gddsn.seis.regions.geotools.DataResource;
import cn.org.gddsn.seis.regions.geotools.GeoRegion;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;

public class GeoRegionTest {
    static Logger logger = Logger.getLogger(GeoRegionTest.class);

    public static String getCountyId(String countyName) {
        logger.info((Object)">>> find countyName=countyName");
        long now_ms = System.currentTimeMillis();
        String id = null;
        String valiFullName = null;
        try {
            logger.info((Object)DataResource.COUNTY_SHP);
            ShapefileDataStore shpDataStore = new ShapefileDataStore(DataResource.toURL(DataResource.COUNTY_SHP));
            SimpleFeatureSource fs = shpDataStore.getFeatureSource();
            FeatureCollection features = fs.getFeatures();
            logger.debug((Object)("Filter county feature size=" + features.size()));
            FeatureIterator iterator = features.features();
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                String nameTmp = (String)feature.getAttribute(4);
                String fullName = new String(nameTmp.getBytes("ISO8859-1"), "GBK");
                nameTmp = (String)feature.getAttribute(2);
                String className3 = new String(nameTmp.getBytes("ISO8859-1"), "GBK");
                nameTmp = (String)feature.getAttribute(6);
                String className1 = new String(nameTmp.getBytes("ISO8859-1"), "GBK");
                nameTmp = (String)feature.getAttribute(5);
                String className2 = new String(nameTmp.getBytes("ISO8859-1"), "GBK");
                GeoRegion.SimBox sb = new GeoRegion.SimBox();
                String objId = feature.getID();
                sb.setID(objId);
                sb.setFullName(fullName);
                sb.setClassName1(className1);
                sb.setClassName2(className2);
                sb.setClassName3(className3);
                sb.setBbx((Envelope)feature.getBounds());
                Envelope e = new Envelope(sb.getBbx());
                e.expandBy(0.08993614533681087);
                sb.setEnlargedBbx(e);
                if (sb.getFullName().indexOf(countyName) < 0) continue;
                logger.info((Object)(String.valueOf(sb.getID()) + " " + sb.getFullName()));
                id = sb.getID();
            }
        }
        catch (NullPointerException ex) {
            logger.debug((Object)("exception   valiFullName=" + valiFullName));
            ex.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger.info((Object)("Load shpfile time: " + (System.currentTimeMillis() - now_ms) + "ms"));
        return id;
    }

    private static Geometry getGeometry(String id) {
        Geometry p = null;
        String fileName = String.valueOf(DataResource.COUNTY_DIRECTORY) + id;
        ObjectInputStream in = null;
        try {
            try {
                in = new ObjectInputStream(new FileInputStream(new File(fileName)));
                p = (Geometry)in.readObject();
            }
            catch (Exception e) {
                logger.debug((Object)e.getMessage());
                try {
                    in.close();
                }
                catch (Exception e2) {
                    logger.debug((Object)e2.getMessage());
                }
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {
                logger.debug((Object)e.getMessage());
            }
        }
        return p;
    }

    public static void main(String[] args) throws IOException {
        PropertyConfigurator.configureAndWatch((String)"log4j.properties");
        String countyId = GeoRegionTest.getCountyId("\u5185\u8499\u53e4\u81ea\u6cbb\u533a\u4e4c\u5170\u5bdf\u5e03\u5e02\u5bdf\u54c8\u5c14\u53f3\u7ffc\u540e\u65d7");
        Geometry g = GeoRegionTest.getGeometry(countyId);
        Coordinate[] cs = g.getCoordinates();
        int size = cs.length;
        long testCount = 0L;
        int i = 0;
        while (i < size) {
            double lat = cs[i].y;
            double lon = cs[i].x;
            logger.info((Object)("######## test_" + ++testCount + " name(" + lat + "," + lon + ")"));
            logger.info((Object)(">>> finalResult: " + GeoRegion.getSuBaoName(lat, lon)));
            ++i;
        }
    }
}

