/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.rts;

import cn.org.gddsn.util.Log4jConfig;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.log4j.Logger;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

public class AlarmBMGEvent
implements MessageListener {
    static Logger logger = Logger.getLogger(AlarmBMGEvent.class);
    private JmsTemplate jmsTemplate;
    private Destination ackDestination;
    private String clientId = "";

    public void sendAck(final String dataType, final String id) {
        this.jmsTemplate.send(new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                BytesMessage tm = session.createBytesMessage();
                tm.writeBytes("ack".getBytes());
                tm.setStringProperty("dataType", dataType);
                tm.setStringProperty("id", id);
                tm.setStringProperty("sender", AlarmBMGEvent.this.clientId);
                tm.setStringProperty("ack", "ack");
                tm.setJMSDestination(AlarmBMGEvent.this.ackDestination);
                tm.setJMSDeliveryMode(2);
                return tm;
            }
        });
    }

    public void send(final String dataType, final String id, final byte[] eventMsg) {
        this.jmsTemplate.send(new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                BytesMessage tm = session.createBytesMessage();
                tm.writeBytes(eventMsg);
                tm.setStringProperty("dataType", dataType);
                tm.setStringProperty("id", id);
                tm.setStringProperty("Operator", "MSDP");
                tm.setJMSDeliveryMode(2);
                tm.setStringProperty("Net_code", "HE");
                tm.setStringProperty("Type", "P");
                tm.setStringProperty("Cata_id", "2003090600243");
                return tm;
            }
        });
    }

    public void onMessage(Message message) {
        block10: {
            if (message instanceof BytesMessage) {
                BytesMessage tm = (BytesMessage)message;
                try {
                    String ack = tm.getStringProperty("ack");
                    String id = tm.getStringProperty("id");
                    String sender = tm.getStringProperty("sender");
                    String dataType = tm.getStringProperty("dataType");
                    if (ack != null) {
                        logger.info((Object)("Client: " + sender + " got the message: " + id));
                        break block10;
                    }
                    byte[] buf = new byte[(int)tm.getBodyLength()];
                    tm.readBytes(buf);
                    if (id == null) {
                        logger.warn((Object)"Got null id");
                    }
                    logger.info((Object)("Got msg id: " + id));
                    try {
                        if (dataType.equals("alarm")) {
                            FileOutputStream fos = new FileOutputStream("alarm.txt");
                            fos.write(buf);
                            fos.close();
                            fos = new FileOutputStream(id);
                            fos.write(buf);
                            fos.close();
                        } else if (!dataType.equals("sed")) {
                            dataType.equals("dummy");
                        }
                    }
                    catch (IOException ioEx) {
                        logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
                    }
                    this.sendAck(dataType, id);
                    logger.info((Object)("send ack: " + id));
                }
                catch (JMSException ex) {
                    logger.warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public static void main(String[] args) throws Exception {
        Log4jConfig.loadForMain((String)"log4j.properties");
        FileSystemXmlApplicationContext ctx = new FileSystemXmlApplicationContext(new String[]{"AlarmBMGEvent.xml"});
        AlarmBMGEvent ath = (AlarmBMGEvent)ctx.getBean("alarmBMGEvent");
        if (args[0].equals("receiver")) {
            DefaultMessageListenerContainer container = (DefaultMessageListenerContainer)ctx.getBean("listenerContainer");
            container.start();
        } else if (args[0].equals("sender")) {
            String dataType = args[1];
            String file = args[2];
            FileInputStream fr = new FileInputStream(file);
            int size = fr.available();
            byte[] buf = new byte[size];
            fr.read(buf);
            ath.send(dataType, dataType, buf);
            System.out.println("sent message.");
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(-1);
        }
    }

    public Destination getAckDestination() {
        return this.ackDestination;
    }

    public void setAckDestination(Destination ackDestination) {
        this.ackDestination = ackDestination;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public JmsTemplate getJmsTemplate() {
        return this.jmsTemplate;
    }
}

