/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.rts;

import cn.org.gddsn.util.Log4jConfig;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

public class AlarmEvent
implements MessageListener {
    static Logger logger = Logger.getLogger(AlarmEvent.class);
    private JmsTemplate jmsTemplate;
    private String destinationName = "topic/alarm/event";
    transient PropertyChangeSupport alarmBrokerSupport = new PropertyChangeSupport(this);

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.alarmBrokerSupport.removePropertyChangeListener(l);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.alarmBrokerSupport.addPropertyChangeListener(l);
    }

    public void send(final String event) {
        this.jmsTemplate.send(this.destinationName, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                return session.createTextMessage(event);
            }
        });
    }

    public void send(final String dataType, final String id, final byte[] eventMsg) {
        this.jmsTemplate.send(this.destinationName, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                BytesMessage tm = session.createBytesMessage();
                tm.writeBytes(eventMsg);
                tm.setStringProperty("dataType", dataType);
                tm.setStringProperty("id", id);
                tm.setStringProperty("Operator", "MSDP");
                tm.setJMSDeliveryMode(2);
                tm.setStringProperty("Net_code", "HE");
                tm.setStringProperty("Type", "P");
                tm.setStringProperty("Cata_id", "2003090600243");
                return tm;
            }
        });
    }

    public void onMessage(Message message) {
        if (message instanceof TextMessage) {
            TextMessage tm = (TextMessage)message;
            try {
                String msg = tm.getText();
                this.alarmBrokerSupport.firePropertyChange("alarmEvent", "", msg);
                logger.info((Object)("Got msg: " + msg));
            }
            catch (JMSException ex) {
                logger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public static void main(String[] args) {
        Log4jConfig.loadForMain((String)"log4j.properties");
        FileSystemXmlApplicationContext ctx = new FileSystemXmlApplicationContext(new String[]{"AlarmEvent.xml"});
        AlarmEvent ath = new AlarmEvent();
        ath.setJmsTemplate((JmsTemplate)ctx.getBean("jmsTemplate"));
        if (args[0].equals("receiver")) {
            DefaultMessageListenerContainer container = (DefaultMessageListenerContainer)ctx.getBean("listenerContainer");
            container.start();
        } else {
            ath.send("Alarm/Start");
            System.out.println("sent");
        }
        try {
            Thread.sleep(3600000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(-1);
    }
}

