/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.rts;

import cn.org.gddsn.liss.client.LissClient;
import cn.org.gddsn.liss.client.LissException;
import cn.org.gddsn.liss.port.MiniSeedHeaderFilter;
import cn.org.gddsn.seis.ChannelLocator;
import cn.org.gddsn.seis.rts.NotifyAction;
import cn.org.gddsn.util.Log4jConfig;
import edu.iris.miniseedutils.steim.MiniSeedHeader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.context.support.FileSystemXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiniSeed2Server
implements Runnable {
    static Logger logger = Logger.getLogger(MiniSeed2Server.class);
    private LissClient lissClient = null;
    private String eventDirectory;
    private BufferedOutputStream socketOutputStream = null;
    private String[] stnCodes;
    private MiniSeedHeaderFilter miniSeedHeaderFilter = null;
    private Map<String, String> stationMap = null;
    private boolean orderByTime = true;
    private boolean moveToCurrentTime = false;
    private int ignorePreLength = 0;
    private NotifyAction notifyAction;
    private Hashtable<ChannelLocator, List<byte[]>> glist = new Hashtable();
    private MiniSeedHeader msh = new MiniSeedHeader();

    @Override
    public void run() {
        if (this.moveToCurrentTime) {
            this.orderByTime = true;
        }
        if (this.orderByTime) {
            this.scanDirectory(new File(this.eventDirectory));
            try {
                this.syncProcess();
            }
            catch (Exception ex) {
                logger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            this.process();
        }
    }

    public void process() {
        try {
            this.connectServer(this.stnCodes);
            logger.info((Object)"connected SSS");
            this.processDirectory(new File(this.eventDirectory));
            this.closeServer();
            logger.info((Object)"closed SSS");
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private void scanDirectory(File dir) {
        if (dir.isFile()) {
            this.scanMiniSeedFile(dir);
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.scanDirectory(files[i]);
            } else {
                this.scanMiniSeedFile(files[i]);
            }
            ++i;
        }
    }

    private void scanMiniSeedFile(File msf) {
        logger.info((Object)("scan " + msf.getPath()));
        DataInputStream bis = null;
        byte[] buf = new byte[512];
        int nsize = (int)(msf.length() / 512L);
        logger.info((Object)("size = " + nsize));
        try {
            Hashtable<ChannelLocator, Double> firstTbl = new Hashtable<ChannelLocator, Double>(128);
            bis = new DataInputStream(new BufferedInputStream(new FileInputStream(msf.getPath()), 8192));
            int i = 0;
            while (i < nsize) {
                buf = new byte[512];
                bis.readFully(buf);
                if (buf[6] == 68 || buf[6] == 81 || buf[6] == 82) {
                    Double st;
                    this.msh.setHead(buf);
                    ChannelLocator cl = new ChannelLocator(this.msh.getNetwork(), this.msh.getStation(), this.msh.getLocID(), this.msh.getChannel());
                    List<byte[]> list = this.glist.get(cl);
                    if (list == null) {
                        list = new LinkedList<byte[]>();
                        this.glist.put(cl, list);
                    }
                    if ((st = (Double)firstTbl.get(cl)) == null) {
                        st = this.msh.getStartTime();
                        firstTbl.put(cl, st);
                    }
                    if (this.msh.getStartTime() - (double)this.ignorePreLength > st) {
                        list.add(buf);
                    }
                }
                ++i;
            }
            bis.close();
        }
        catch (EOFException ex) {
            logger.info((Object)("EOF: " + msf.getPath()));
        }
        catch (IOException ioEx) {
            logger.warn((Object)ioEx.getMessage());
            logger.warn((Object)("could not process " + msf));
        }
    }

    public void syncProcess() throws Exception {
        int maxSize = -1;
        double[] ssec = new double[this.glist.size()];
        int n = 0;
        for (List<byte[]> lst : this.glist.values()) {
            int size = lst.size();
            if (size == 0) continue;
            if (size > maxSize) {
                maxSize = size;
            }
            this.msh.setHead(lst.get(0));
            ssec[n++] = this.msh.getStartTime();
        }
        Arrays.sort(ssec);
        HashSet<String> ss = new HashSet<String>();
        for (ChannelLocator cl : this.glist.keySet()) {
            ss.add(String.valueOf(cl.getNetCode()) + "/" + cl.getStationCode());
        }
        this.stnCodes = new String[ss.size()];
        ss.toArray(this.stnCodes);
        logger.info((Object)"sort waveform by time.");
        this.connectServer(this.stnCodes);
        logger.info((Object)"connected SSS");
        double sec = ssec[ssec.length / 2];
        if (this.moveToCurrentTime) {
            long startTime = (long)(sec * 1000.0);
            this.miniSeedHeaderFilter.setMoveToCurrentTime(true, startTime);
        }
        long baseTime = System.currentTimeMillis() - (long)(sec * 1000.0);
        if (this.moveToCurrentTime) {
            baseTime = 0L;
        }
        boolean hasData = true;
        boolean busy = true;
        while (hasData) {
            hasData = false;
            if (!busy) {
                Thread.sleep(100L);
            }
            busy = false;
            Collection<List<byte[]>> c = this.glist.values();
            for (List<byte[]> list : c) {
                if (list.size() <= 0) continue;
                hasData = true;
                byte[] mbuf = this.filtMiniSeedHead(list.get(0));
                this.msh.setHead(mbuf);
                long now = System.currentTimeMillis();
                if (!(this.msh.getEndTime() * 1000.0 + (double)baseTime < (double)now)) continue;
                this.socketOutputStream.write(mbuf);
                list.remove(0);
                busy = true;
            }
        }
        this.closeServer();
        logger.info((Object)"closed SSS");
    }

    private void connectServer(String[] stnCodes) throws Exception {
        this.lissClient.init();
        String[] stringArray = stnCodes;
        int n = stnCodes.length;
        int n2 = 0;
        while (n2 < n) {
            String ns = stringArray[n2];
            try {
                this.lissClient.addStation(new String[]{ns});
            }
            catch (LissException ex) {
                logger.info((Object)ex);
            }
            ++n2;
        }
        this.lissClient.setRtServerPassiveMode(true);
        OutputStream lissOutputStream = this.lissClient.storeRealTimeStream(stnCodes).getOutputStream();
        this.socketOutputStream = new BufferedOutputStream(lissOutputStream);
        if (this.notifyAction != null) {
            this.notifyAction.action();
        }
    }

    private void closeServer() throws Exception {
        Thread.sleep(10000L);
        this.socketOutputStream.close();
        Thread.sleep(5000L);
        this.lissClient.quit();
    }

    private void processDirectory(File dir) throws Exception {
        if (dir.isFile()) {
            this.processFile(dir);
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.processDirectory(files[i]);
            } else {
                this.processFile(files[i]);
            }
            ++i;
        }
    }

    private void processFile(File evtFile) throws Exception {
        logger.info((Object)("process " + evtFile.getPath()));
        DataInputStream bis = null;
        byte[] buf = new byte[512];
        int nsize = (int)(evtFile.length() / 512L);
        logger.info((Object)("size=" + nsize));
        try {
            bis = new DataInputStream(new BufferedInputStream(new FileInputStream(evtFile.getPath()), 8192));
            int i = 0;
            while (i < nsize) {
                bis.readFully(buf);
                if (buf[6] == 68 || buf[6] == 81 || buf[6] == 82) {
                    this.socketOutputStream.write(this.filtMiniSeedHead(buf));
                }
                if (logger.isDebugEnabled()) {
                    this.msh.setHead(buf);
                    logger.debug((Object)("Sent " + this.msh));
                }
                ++i;
            }
            bis.close();
        }
        catch (EOFException ex) {
            logger.info((Object)("EOF: " + evtFile.getPath()));
        }
        catch (IOException ioEx) {
            logger.warn((Object)ioEx.getMessage());
            logger.warn((Object)("could not process " + evtFile));
        }
    }

    private byte[] filtMiniSeedHead(byte[] buf) {
        if (this.miniSeedHeaderFilter == null) {
            return buf;
        }
        return this.miniSeedHeaderFilter.filter(buf);
    }

    public void setMiniSeedHeaderFilter(MiniSeedHeaderFilter miniSeedHeaderFilter) {
        this.miniSeedHeaderFilter = miniSeedHeaderFilter;
    }

    public String getEventDirectory() {
        return this.eventDirectory;
    }

    public void setEventDirectory(String eventDirectory) {
        this.eventDirectory = eventDirectory;
    }

    public LissClient getLissClient() {
        return this.lissClient;
    }

    public void setLissClient(LissClient lissClient) {
        this.lissClient = lissClient;
    }

    public String[] getStnCodes() {
        return this.stnCodes;
    }

    public void setStnCodes(String[] stnCodes) {
        this.stnCodes = stnCodes;
    }

    public Map<String, String> getStationMap() {
        return this.stationMap;
    }

    public void setStationMap(Map<String, String> stationMap) {
        this.stationMap = stationMap;
    }

    public boolean isOrderByTime() {
        return this.orderByTime;
    }

    public void setOrderByTime(boolean orderByTime) {
        this.orderByTime = orderByTime;
    }

    public void setMoveToCurrentTime(boolean moveToCurrentTime) {
        this.moveToCurrentTime = moveToCurrentTime;
    }

    public NotifyAction getNotifyAction() {
        return this.notifyAction;
    }

    public void setNotifyAction(NotifyAction notifyAction) {
        this.notifyAction = notifyAction;
    }

    public void setIgnorePreLength(int ignorePreLength) {
        this.ignorePreLength = ignorePreLength;
    }

    public static void main(String[] args) throws IOException {
        Log4jConfig.loadForMain((String)"MiniSeed2Server.properties");
        FileSystemXmlApplicationContext ctx = new FileSystemXmlApplicationContext(new String[]{"MiniSeed2Server.xml"});
        MiniSeed2Server miniSeed2Server = (MiniSeed2Server)ctx.getBean("miniSeed2Server");
        miniSeed2Server.run();
    }
}

