/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.sntp;

import be.ac.luc.vdbergh.ntp.NtpDatagramPacket;
import be.ac.luc.vdbergh.ntp.NtpHeader;
import be.ac.luc.vdbergh.ntp.TimeStamp;
import cn.org.gddsn.seis.sntp.NtpServer;
import cn.org.gddsn.seis.sntp.Scavenger;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Calendar;
import org.apache.log4j.Logger;

class NtpClientThread
extends Thread {
    static Logger logger = Logger.getLogger(NtpClientThread.class);
    private static final double MAX_PROXY_TIME = 0.005555555555555556;
    Socket socket;
    DatagramSocket dataSocket;
    int num;
    static int nSum = 1;
    public double f;
    NtpServer ntpServer;
    InetAddress inetaddress;
    int port;
    boolean bStop = false;

    NtpClientThread(NtpServer ntpServer, Socket socket, int port) {
        super(ntpServer.threadGroup, "SNTP_CLIENT" + nSum);
        this.ntpServer = ntpServer;
        this.socket = socket;
        this.port = port;
        this.num = nSum++;
        if (nSum > 9999) {
            nSum = 1;
        }
        Calendar calendar = Calendar.getInstance();
        this.f = NtpClientThread.getDoubleTime(calendar, 0.0);
        try {
            this.dataSocket = new DatagramSocket();
        }
        catch (Exception _ex) {
            return;
        }
        this.start();
    }

    private static double getDoubleTime(Calendar calendar, double d1) {
        int k = calendar.get(2) + 1;
        int l = calendar.get(1);
        int i1 = calendar.get(5);
        int j1 = calendar.get(11);
        int k1 = calendar.get(12);
        double d2 = calendar.get(13);
        d2 += (double)calendar.get(14) / 1000.0;
        if (k <= 2) {
            --l;
            k += 12;
        }
        double d3 = l / 100;
        double d4 = 2.0 - d3 + (double)((int)(d3 / 4.0));
        double d5 = (double)((int)(365.25 * (double)l) + (int)(30.6001 * (double)(k + 1)) + i1) + 1720994.5 + d4;
        d5 = d5 + ((double)j1 - d1) / 24.0 + (double)k1 / 1440.0 + d2 / 86400.0;
        return d5;
    }

    public boolean isOverAge(Calendar calendar) {
        if (!this.isAlive()) {
            return true;
        }
        double d1 = NtpClientThread.getDoubleTime(calendar, 0.0);
        if (d1 - this.f > 0.005555555555555556) {
            this.bStop = true;
            try {
                this.dataSocket.close();
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block14: {
            try {
                try {
                    InputStream inputstream = this.socket.getInputStream();
                    OutputStream outputstream = this.socket.getOutputStream();
                    NtpDatagramPacket ndp = new NtpDatagramPacket();
                    DatagramPacket dp = ndp.getDatagramPacket();
                    byte[] bData = dp.getData();
                    TimeStamp refTS = this.ntpServer.getCurrentTimeStamp();
                    this.socket.setSoTimeout(10000);
                    inputstream.read(bData, 0, bData.length);
                    logger.info((Object)"Has Read Request");
                    TimeStamp rcvTS = this.ntpServer.getCurrentTimeStamp();
                    TimeStamp clntTmTS = ndp.getTransmitTimeStamp();
                    byte[] snhData = new byte[16];
                    snhData[0] = 28;
                    snhData[1] = 1;
                    snhData[12] = 76;
                    snhData[13] = 67;
                    snhData[14] = 76;
                    NtpHeader snh = new NtpHeader(snhData);
                    NtpDatagramPacket sntp = new NtpDatagramPacket(snh, refTS, clntTmTS, rcvTS, this.ntpServer.getCurrentTimeStamp());
                    outputstream.write(sntp.getDatagramPacket().getData());
                    logger.info((Object)sntp.getHeader());
                    logger.info((Object)"Write Response");
                    outputstream.flush();
                    outputstream.close();
                    inputstream.close();
                    logger.info((Object)"Server close");
                }
                catch (Exception ex) {
                    logger.warn((Object)ex.getMessage(), (Throwable)ex);
                    try {
                        this.dataSocket.close();
                        this.socket.close();
                    }
                    catch (Exception exception) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.dataSocket.close();
                    this.socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.dataSocket.close();
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Scavenger scavenger = this.ntpServer.scavenger;
        synchronized (scavenger) {
            this.ntpServer.scavenger.notify();
        }
    }
}

