/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.ttt3d;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Scanner;

public class Tomo3d {
    public static final int MEQ = 1010;
    public static final int MST = 105;
    public static final int MAX = 400;
    public static final int MDT = 1500;
    public static final int MD = 10000;
    public static final int MU = 50000;
    public static final int MG = 10000000;
    public static final int MPA = 13;
    public static final int MRA = 11;
    public static final int MHA = 11;
    public static final int MPB = 13;
    public static final int MRB = 11;
    public static final int MHB = 11;
    public static final int MKA = 3500;
    public static final int MKB = 3500;
    public static final int NP = 13;
    public static final int NR = 11;
    public static final int NH = 11;
    static JBMODV JBMODV = new JBMODV();
    static IASP91 IASP91 = new IASP91();
    static IASPHH IASPHH = new IASPHH();
    static DISCON DISCON = new DISCON();
    static HYPINV HYPINV = new HYPINV();
    static ELLIPS ELLIPS = new ELLIPS();
    static TOYUAN TOYUAN = new TOYUAN();
    static VMOD3D VMOD3D = new VMOD3D();
    static LOCATE LOCATE = new LOCATE();
    static PRHFD PRHFD = new PRHFD();
    static WEIGHT WEIGHT = new WEIGHT();
    static RAYPATH RAYPATH = new RAYPATH();
    static RAYLOC RAYLOC = new RAYLOC();
    static HLASTA HLASTA = new HLASTA();
    static STATIN STATIN = new STATIN();
    static CONTRL CONTRL = new CONTRL();
    static MODINV MODINV = new MODINV();
    static GRINET GRINET = new GRINET();
    static EVENTS EVENTS = new EVENTS();
    static STODAT STODAT = new STODAT();
    static OBSERV OBSERV = new OBSERV();
    static NPRH12 NPRH12 = new NPRH12();
    static ONED ONED = new ONED();
    static STDERR STDERR = new STDERR();
    static INVBOX INVBOX = new INVBOX();
    static PrintStream pwLog = null;
    static PrintStream pwRes = null;

    public static void strt(int nit) {
        Tomo3d.MODINV.neq4 = 0;
        Tomo3d.MODINV.nod = 0;
        Tomo3d.MODINV.itot = 0;
        int i = 1;
        while (i <= 50000) {
            Tomo3d.MODINV.khit[i] = 0;
            ++i;
        }
        pwLog.printf("\n ITERATION STEP:%3d\n", nit);
    }

    public static void strtray() {
        int i;
        double[] hk = new double[1];
        int[] jwv = new int[]{1, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 1, 2, 1, 1, 1, 1, 2, 1, 2, 2, 1, 1, 1, 1, 2, 1, 2, 2, 1, 1, 1};
        Tomo3d.RAYPATH.r0 = 6371.0;
        Tomo3d.RAYPATH.pideg = 0.017453;
        Tomo3d.RAYPATH.eps = 1.0E-6;
        int j = 1;
        while (j <= 8) {
            i = 1;
            while (i <= 5) {
                Tomo3d.RAYPATH.iwv[j][i] = jwv[(i - 1) * 8 + (j - 1)];
                ++i;
            }
            ++j;
        }
        i = 1;
        while (i < 105) {
            double ps = Tomo3d.STATIN.stc[1][i];
            double rs = Tomo3d.STATIN.stc[2][i];
            j = 1;
            while (j <= 2) {
                int k = j++;
                Tomo3d.hlay(ps, rs, hk, k);
                Tomo3d.HLASTA.hlss[i][k] = hk[0];
            }
            ++i;
        }
    }

    public static void input1(File controlFile) throws IOException {
        Scanner sc = new Scanner(controlFile);
        Tomo3d.CONTRL.nsts = sc.nextInt();
        Tomo3d.CONTRL.neqs = sc.nextInt();
        Tomo3d.CONTRL.nitloc = sc.nextInt();
        Tomo3d.CONTRL.rmscut = sc.nextDouble();
        Tomo3d.CONTRL.dvmax = sc.nextDouble();
        Tomo3d.CONTRL.vdamp = sc.nextDouble();
        Tomo3d.CONTRL.nhitct = sc.nextInt();
        Tomo3d.CONTRL.nitmax = sc.nextInt();
        Tomo3d.CONTRL.rmstop = sc.nextDouble();
        Tomo3d.CONTRL.stepl = sc.nextDouble();
        Tomo3d.CONTRL.tlim = sc.nextDouble();
        Tomo3d.CONTRL.nitpb = sc.nextInt();
        sc.close();
    }

    public static void input23(File modelFile, int mps) throws IOException {
        Scanner sc = new Scanner(modelFile);
        double pideg = 0.017453;
        int n = 1;
        while (n <= Tomo3d.CONTRL.nsts) {
            double ps = sc.nextDouble();
            double rs = sc.nextDouble();
            double hs = sc.nextDouble();
            Tomo3d.STATIN.stc[1][n] = (90.0 - ps) * pideg;
            Tomo3d.STATIN.stc[2][n] = rs * pideg;
            Tomo3d.STATIN.stc[3][n] = -hs;
            Tomo3d.STATIN.phis[n] = ps;
            Tomo3d.STATIN.rams[n] = rs;
            Tomo3d.STATIN.higs[n] = -hs;
            ++n;
        }
        Tomo3d.inputjb();
        Tomo3d.VMOD3D.npa = sc.nextInt();
        Tomo3d.VMOD3D.nra = sc.nextInt();
        Tomo3d.VMOD3D.nha = sc.nextInt();
        Tomo3d.put3(sc, Tomo3d.VMOD3D.npa, Tomo3d.VMOD3D.nra, Tomo3d.VMOD3D.nha, Tomo3d.VMOD3D.pna, Tomo3d.VMOD3D.rna, Tomo3d.VMOD3D.hna, Tomo3d.VMOD3D.dvap, Tomo3d.VMOD3D.velap, mps);
        Tomo3d.bldmap();
        sc.close();
    }

    public static void put3(Scanner sc, int npx, int nrx, int nhx, double[] pnx, double[] rnx, double[] hnx, double[][][] dvxp, double[][][] velxp, int mps) {
        int nwidth = 5;
        int i = 1;
        while (i <= npx) {
            pnx[i] = sc.nextDouble();
            ++i;
        }
        i = 1;
        while (i <= nrx) {
            rnx[i] = sc.nextDouble();
            ++i;
        }
        i = 1;
        while (i <= nhx) {
            hnx[i] = sc.nextDouble();
            ++i;
        }
        int k = 1;
        while (k <= nhx) {
            int i2 = 1;
            while (i2 <= npx) {
                int j = 1;
                while (j <= nrx) {
                    String line = sc.nextLine();
                    int nlen = line.length() / 5;
                    int n = 0;
                    while (n < nlen) {
                        dvxp[i2][j++][k] = Double.parseDouble(line.substring(n * 5, (n + 1) * 5).trim());
                        ++n;
                    }
                }
                ++i2;
            }
            ++k;
        }
        int[] lay = new int[1];
        double[] v1 = new double[1];
        int k2 = 1;
        while (k2 <= nhx) {
            double hh = hnx[k2];
            Tomo3d.layer(hh, lay);
            Tomo3d.vel1d(hh, v1, lay[0], mps);
            System.out.printf(" HH = %6.1f V1 = %5.2f\n", hh, v1[0]);
            int j = 1;
            while (j <= nrx) {
                int i3 = 1;
                while (i3 <= npx) {
                    double dv = 0.01 * dvxp[i3][j][k2];
                    velxp[i3][j][k2] = v1[0] * (1.0 + dv);
                    ++i3;
                }
                ++j;
            }
            ++k2;
        }
        int npx2 = npx - 2;
        int nprx2 = npx2 * (nrx - 2);
        int nodesx2 = (nhx - 2) * nprx2;
        Tomo3d.GRINET.npa2 = npx2;
        Tomo3d.GRINET.npra2 = nprx2;
        Tomo3d.GRINET.nodesa2 = nodesx2;
        Tomo3d.GRINET.nodetot = nodesx2;
    }

    public static void layer(double h, int[] lay) {
        double h1 = 25.0;
        double h2 = 46.0;
        if (h <= 25.0) {
            lay[0] = 1;
        }
        if (h > 25.0 && h <= 46.0) {
            lay[0] = 2;
        }
        if (h > 46.0) {
            lay[0] = 3;
        }
    }

    public static void input4(File phaFile) throws IOException {
        Scanner sr = new Scanner(phaFile);
        int[] nstn = new int[7];
        double[] tt = new double[7];
        int[] ikps = new int[7];
        double pideg = 0.017453;
        int n = 1;
        while (n <= Tomo3d.CONTRL.neqs) {
            SPU spu = new SPU(sr.nextLine());
            int iy = Integer.parseInt(spu.substring(2));
            int im = Integer.parseInt(spu.substring(2));
            int id = Integer.parseInt(spu.substring(2));
            int ih = Integer.parseInt(spu.substring(2));
            int imin = Integer.parseInt(spu.substring(2));
            Tomo3d.EVENTS.seco[n] = Float.parseFloat(spu.substring(6));
            double dt = Float.parseFloat(spu.substring(5));
            Tomo3d.EVENTS.phie[n] = Float.parseFloat(spu.substring(7));
            double dphi = Float.parseFloat(spu.substring(6));
            Tomo3d.EVENTS.rame[n] = Float.parseFloat(spu.substring(8));
            double dram = Float.parseFloat(spu.substring(6));
            Tomo3d.EVENTS.depe[n] = Float.parseFloat(spu.substring(6));
            double ddep = Float.parseFloat(spu.substring(5));
            int nstm = Integer.parseInt(spu.substring(3));
            double fmg = Float.parseFloat(spu.substring(4));
            double rms = Float.parseFloat(spu.substring(5));
            Tomo3d.STODAT.iymsto[n] = iy * 100 + im;
            Tomo3d.STODAT.idsto[n] = id;
            Tomo3d.STODAT.ihrsto[n] = ih;
            Tomo3d.EVENTS.mino[n] = imin;
            Tomo3d.EVENTS.evc[1][n] = (90.0 - Tomo3d.EVENTS.phie[n]) * pideg;
            Tomo3d.EVENTS.evc[2][n] = Tomo3d.EVENTS.rame[n] * pideg;
            Tomo3d.EVENTS.evc[3][n] = Tomo3d.EVENTS.depe[n];
            int l = 0;
            double xnum = (double)nstm / 6.0;
            int numb = (int)xnum;
            if (xnum > (double)numb) {
                ++numb;
            }
            int k = 1;
            while (k <= numb) {
                spu = new SPU(sr.nextLine());
                int j = 1;
                while (j <= 6) {
                    nstn[j] = Integer.parseInt(spu.substring(3));
                    tt[j] = Float.parseFloat(spu.substring(6));
                    ikps[j] = Integer.parseInt(spu.substring(2));
                    ++j;
                }
                j = 1;
                while (j <= 6) {
                    Tomo3d.OBSERV.isto[++l][n] = nstn[j];
                    Tomo3d.OBSERV.sect[l][n] = tt[j];
                    Tomo3d.OBSERV.kwv[l][n] = ikps[j];
                    ++j;
                }
                ++k;
            }
            Tomo3d.EVENTS.kobs[n] = nstm;
            ++n;
        }
        sr.close();
    }

    public static void readubpp() throws IOException {
        int j;
        Scanner sc = new Scanner(new File("/tmp/datadis"));
        int np = sc.nextInt();
        int nr = sc.nextInt();
        int i = 1;
        while (i <= np) {
            Tomo3d.DISCON.pn[i] = sc.nextDouble();
            ++i;
        }
        i = 1;
        while (i <= nr) {
            Tomo3d.DISCON.rn[i] = sc.nextDouble();
            ++i;
        }
        i = np;
        while (i >= 1) {
            j = 1;
            while (j <= nr) {
                Tomo3d.DISCON.depa[i][j] = sc.nextDouble();
                ++j;
            }
            --i;
        }
        i = np;
        while (i >= 1) {
            j = 1;
            while (j <= nr) {
                Tomo3d.DISCON.depb[i][j] = sc.nextDouble();
                ++j;
            }
            --i;
        }
        i = np;
        while (i >= 1) {
            j = 1;
            while (j <= nr) {
                Tomo3d.DISCON.depc[i][j] = sc.nextDouble();
                ++j;
            }
            --i;
        }
        sc.close();
    }

    public static void input5() throws IOException {
        Tomo3d.readubpp();
        Tomo3d.ellipse();
        Tomo3d.strtray();
    }

    public static void loceqk(int ne, int isee) {
        double hnew;
        double rnew;
        double pnew;
        double snew;
        double pid = 0.017453;
        double c0 = 111.19;
        double hcor = 200.0;
        double hmax = 700.0;
        double[] adj = new double[5];
        double[] err = new double[5];
        double[][] gf = new double[6][12];
        double[][] ans = new double[6][7];
        double[] hlae = new double[3];
        int[] lay = new int[1];
        double[] dt = new double[1];
        double[] del = new double[1];
        double[] az = new double[1];
        double[] ve = new double[1];
        double[] fstime = new double[1];
        double[] rmswt = new double[1];
        int[] nwr = new int[1];
        int nobs = Tomo3d.EVENTS.kobs[ne];
        if (isee == 1) {
            System.out.printf("\n IEQ: %4d INITIAL VALUE----- %7.2f %8.3f %9.3f %8.2f %3d\n", ne, Tomo3d.EVENTS.seco[ne], Tomo3d.EVENTS.phie[ne], Tomo3d.EVENTS.rame[ne], Tomo3d.EVENTS.depe[ne], nobs);
        } else {
            pwLog.printf("\n IEQ: %4d INITIAL VALUE----- %7.2f %8.3f %9.3f %8.2f %3d\n", ne, Tomo3d.EVENTS.seco[ne], Tomo3d.EVENTS.phie[ne], Tomo3d.EVENTS.rame[ne], Tomo3d.EVENTS.depe[ne], nobs);
        }
        double ostrt = Tomo3d.EVENTS.seco[ne];
        double pstrt = Tomo3d.EVENTS.evc[1][ne];
        double rstrt = Tomo3d.EVENTS.evc[2][ne];
        double hstrt = Tomo3d.EVENTS.evc[3][ne];
        int nit = 0;
        do {
            ++nit;
            double pe = Tomo3d.EVENTS.evc[1][ne];
            double re = Tomo3d.EVENTS.evc[2][ne];
            double he = Tomo3d.EVENTS.evc[3][ne];
            Tomo3d.layhe(pe, re, he, hlae, lay);
            int mo = 1;
            while (mo <= nobs) {
                int ns;
                int no = mo;
                int kps = Tomo3d.OBSERV.kwv[no][ne];
                if (kps >= 1 && kps <= 8 && (ns = Tomo3d.OBSERV.isto[no][ne]) >= 1 && ns <= Tomo3d.CONTRL.nsts) {
                    double ps = Tomo3d.STATIN.stc[1][ns];
                    double rs = Tomo3d.STATIN.stc[2][ns];
                    double hs = Tomo3d.STATIN.stc[3][ns];
                    double po = Tomo3d.OBSERV.sect[no][ne] - Tomo3d.EVENTS.seco[ne];
                    if (ne == 1 && no == 1) {
                        System.out.println("++++++++++++++++++++++++++++++++++");
                    }
                    Tomo3d.travt(pe, re, he, ps, rs, hs, kps, ns, hlae, lay[0], Tomo3d.CONTRL.tlim, Tomo3d.CONTRL.nitpb, po, del, az, ve, fstime);
                    if (ne == 1 && no == 1) {
                        System.out.printf("+++++++++++++++++ %f %f %f %f %f %f %f %f %f\n", pe, re, he, ps, rs, hs, po, ve[0], fstime[0]);
                    }
                    dt[0] = 0.0;
                    double delc = del[0] / 111.19;
                    if (del[0] > 200.0) {
                        Tomo3d.correc(he, delc, kps, pe, az[0], dt);
                    }
                    fstime[0] = fstime[0] + dt[0];
                    if (isee != 0) {
                        double ress = po - fstime[0];
                        System.out.printf(" ne,nobs,no,kps,del,ve,res = %5d %5d %5d %5d %8.1f %6.1f %7.2f\n", ne, nobs, no, kps, del[0], ve[0], ress);
                    }
                    Tomo3d.ttmder(ne, no, kps, ve[0], fstime[0], 0);
                }
                ++mo;
            }
            Tomo3d.wthyp(nobs, gf, rmswt, nwr);
            if (nwr[0] > 4) {
                int j;
                Tomo3d.liner(4, 9, gf, ans);
                int i = 1;
                while (i <= 4) {
                    adj[i] = ans[i][1];
                    if (i == 2 || i == 3) {
                        adj[i] = adj[i] * 0.01;
                    }
                    ++i;
                }
                ans[5][1] = -1.0;
                double sg = 0.0;
                int k = 1;
                while (k <= 5) {
                    j = 1;
                    while (j <= 5) {
                        sg += gf[k][j] * ans[k][1] * ans[j][1];
                        ++j;
                    }
                    ++k;
                }
                dt[0] = Math.sqrt(Math.abs(sg) / (double)(nwr[0] - 4));
                k = 1;
                while (k <= 4) {
                    j = k + 1;
                    err[k] = Math.sqrt(Math.abs(ans[k][j])) * dt[0];
                    if (k == 2 || k == 3) {
                        err[k] = err[k] * 0.01 / 0.017453;
                    }
                    ++k;
                }
                double hadj = adj[4] + Tomo3d.EVENTS.evc[3][ne];
                if (hadj < 0.0) {
                    adj[4] = 0.0;
                }
                Tomo3d.EVENTS.seco[ne] = Tomo3d.EVENTS.seco[ne] + adj[1];
                i = 1;
                while (i <= 3) {
                    j = i + 1;
                    Tomo3d.EVENTS.evc[i][ne] = Tomo3d.EVENTS.evc[i][ne] + adj[j];
                    ++i;
                }
                if (Tomo3d.EVENTS.evc[3][ne] > 700.0) {
                    Tomo3d.EVENTS.evc[3][ne] = 700.0;
                }
            }
            snew = Tomo3d.EVENTS.seco[ne];
            pnew = 90.0 - Tomo3d.EVENTS.evc[1][ne] / 0.017453;
            rnew = Tomo3d.EVENTS.evc[2][ne] / 0.017453;
            hnew = Tomo3d.EVENTS.evc[3][ne];
            if (isee == 1) {
                System.out.printf("%2d %6.2f(%5.2f) %7.3f(%5.3f) %8.3f(%5.3f) %7.2f(%5.2f) %4d %6.2f\n", nit, snew, err[1], pnew, err[2], rnew, err[3], hnew, err[4], nwr[0], rmswt[0]);
                continue;
            }
            pwLog.printf("%2d %6.2f(%5.2f) %7.3f(%5.3f) %8.3f(%5.3f) %7.2f(%5.2f) %4d %6.2f\n", nit, snew, err[1], pnew, err[2], rnew, err[3], hnew, err[4], nwr[0], rmswt[0]);
        } while (nit < Tomo3d.CONTRL.nitloc && rmswt[0] > Tomo3d.CONTRL.rmscut);
        double dpe = (Tomo3d.EVENTS.evc[1][ne] - pstrt) / 0.017453;
        double dre = (Tomo3d.EVENTS.evc[2][ne] - rstrt) / 0.017453;
        double dhe = Tomo3d.EVENTS.evc[3][ne] - hstrt;
        double dot = Tomo3d.EVENTS.seco[ne] - ostrt;
        if (isee == 1) {
            System.out.printf("%6.2f %6.3f %6.3f %8.2f\n", dot, dpe, dre, dhe);
        } else {
            pwLog.printf("%6.2f %6.3f %6.3f %8.2f\n", dot, dpe, dre, dhe);
        }
        pwRes.printf("%7d %8.2f %7.2f %9.3f %8.3f %10.3f %8.3f %9.2f %7.2f %6d %7.2f\n", ne, snew, err[1], pnew, err[2], rnew, err[3], hnew, err[4], nwr[0], rmswt[0]);
    }

    public static void layhe(double pe, double re, double he, double[] hlae, int[] lay) {
        lay[0] = 1;
        double[] hi = new double[1];
        int k = 1;
        while (k <= 2) {
            int i = k;
            Tomo3d.hlay(pe, re, hi, i);
            hlae[i] = hi[0];
            if (he > hi[0]) {
                lay[0] = lay[0] + 1;
            }
            ++k;
        }
    }

    public static void liner(int m, int n, double[][] gf, double[][] ans) {
        double[][] c = new double[6][12];
        int k = 1;
        while (k <= 5) {
            int l = 1;
            while (l <= 11) {
                c[k][l] = gf[k][l];
                ++l;
            }
            ++k;
        }
        k = 1;
        while (k <= m) {
            int kk;
            double w = c[k][k];
            if (Math.abs(w) < 1.0E-5) {
                w = 1.0;
            }
            int j = kk = k + 1;
            while (j <= n) {
                c[k][j] = c[k][j] / w;
                ++j;
            }
            int i = 1;
            while (i <= m) {
                if (i != k) {
                    w = c[i][k];
                    int j2 = kk;
                    while (j2 <= n) {
                        c[i][j2] = c[i][j2] - w * c[k][j2];
                        ++j2;
                    }
                }
                ++i;
            }
            ++k;
        }
        int j = n - m;
        int i = 1;
        while (i <= j) {
            int jj = m + i;
            int k2 = 1;
            while (k2 <= m) {
                ans[k2][i] = c[k2][jj];
                ++k2;
            }
            ++i;
        }
    }

    public static void wthyp(int nobs, double[][] gf, double[] rmswt, int[] nwr) {
        int j;
        double[] aq = new double[6];
        double epc = 1.0E-5;
        int k = 1;
        while (k <= 5) {
            j = 1;
            while (j <= 9) {
                gf[k][j] = 0.0;
                ++j;
            }
            int m = k + 5;
            gf[k][m] = 1.0;
            ++k;
        }
        nwr[0] = 0;
        double wnorm = 0.0;
        rmswt[0] = 0.0;
        int i = 1;
        while (i <= nobs) {
            double wi = Tomo3d.HYPINV.w[i];
            wnorm += wi * wi;
            double rmsw = Tomo3d.HYPINV.res[i] * wi;
            rmswt[0] = rmswt[0] + rmsw * rmsw;
            if (wi > epc) {
                nwr[0] = nwr[0] + 1;
            }
            j = 1;
            while (j <= 4) {
                aq[j] = Tomo3d.HYPINV.dth[i][j] * Tomo3d.HYPINV.w[i];
                ++j;
            }
            aq[5] = Tomo3d.HYPINV.res[i] * Tomo3d.HYPINV.w[i];
            k = 1;
            while (k <= 5) {
                j = 1;
                while (j <= 5) {
                    gf[k][j] = gf[k][j] + aq[k] * aq[j];
                    ++j;
                }
                ++k;
            }
            ++i;
        }
        if (wnorm > epc) {
            rmswt[0] = Math.sqrt(rmswt[0] / wnorm);
        }
    }

    public static void forwrd(int ne, int mps, int isee) {
        double[] hlae = new double[3];
        int[] lay = new int[1];
        double[] fstime = new double[1];
        double[] del = new double[1];
        double[] az = new double[1];
        double[] ve = new double[1];
        double[] dt = new double[1];
        double c0 = 111.19;
        int nobs = Tomo3d.EVENTS.kobs[ne];
        double pe = Tomo3d.EVENTS.evc[1][ne];
        double re = Tomo3d.EVENTS.evc[2][ne];
        double he = Tomo3d.EVENTS.evc[3][ne];
        Tomo3d.layhe(pe, re, he, hlae, lay);
        if (isee == 1) {
            System.out.printf(" neq,phi,ram,dep,nobs = %5d %6.2f %7.2f %6.1f,%4d\n", ne, Tomo3d.EVENTS.phie[ne], Tomo3d.EVENTS.rame[ne], Tomo3d.EVENTS.depe[ne], nobs);
        }
        int mo = 1;
        while (mo <= nobs) {
            int ns;
            int no = mo;
            int kps = Tomo3d.OBSERV.kwv[no][ne];
            if (kps >= 1 && kps <= 8 && kps != 2 && (ns = Tomo3d.OBSERV.isto[no][ne]) >= 1 && ns <= Tomo3d.CONTRL.nsts) {
                double ps = Tomo3d.STATIN.stc[1][ns];
                double rs = Tomo3d.STATIN.stc[2][ns];
                double hs = Tomo3d.STATIN.stc[3][ns];
                double po = Tomo3d.OBSERV.sect[no][ne] - Tomo3d.EVENTS.seco[ne];
                Tomo3d.travt(pe, re, he, ps, rs, hs, kps, ns, hlae, lay[0], Tomo3d.CONTRL.tlim, Tomo3d.CONTRL.nitpb, po, del, az, ve, fstime);
                dt[0] = 0.0;
                double delc = del[0] / c0;
                if (del[0] > 250.0) {
                    Tomo3d.correc(he, delc, kps, pe, az[0], dt);
                }
                fstime[0] = fstime[0] + dt[0];
                if (isee == 1) {
                    double ress = po - fstime[0];
                    System.out.printf(" ne,nobs,no,kps,del,ve,res = %5d %5d %5d %5d %8.1f %6.1f %7.2f\n", ne, nobs, no, kps, del[0], ve[0], ress);
                }
                Tomo3d.ttmder(ne, no, kps, ve[0], fstime[0], 1);
            }
            ++mo;
        }
    }

    public static void fortele(int ne, int mps, int isee) {
        double[] hlae = new double[3];
        int[] lay = new int[1];
        double[] fstime = new double[1];
        double[] del = new double[1];
        double[] az = new double[1];
        double[] ve = new double[1];
        double[] pk = new double[1];
        double[] rk = new double[1];
        double[] hk = new double[1];
        double[] hm = new double[1];
        double[] delp = new double[1];
        int nobs = Tomo3d.EVENTS.kobs[ne];
        double pe = Tomo3d.EVENTS.evc[1][ne];
        double re = Tomo3d.EVENTS.evc[2][ne];
        double he = Tomo3d.EVENTS.evc[3][ne];
        Tomo3d.IASP91.rh = Tomo3d.IASP91.ra - he;
        if (isee == 1) {
            System.out.printf(" neq,phi,ram,dep,nobs = %5d %6.2f %7.2f %6.1f,%4d\n", ne, Tomo3d.EVENTS.phie[ne], Tomo3d.EVENTS.rame[ne], Tomo3d.EVENTS.depe[ne], nobs);
        }
        int mo = 1;
        while (mo <= nobs) {
            int ns;
            int no = mo;
            int kps = Tomo3d.OBSERV.kwv[no][ne];
            if (kps == 1 && (ns = Tomo3d.OBSERV.isto[no][ne]) >= 1 && ns <= Tomo3d.CONTRL.nsts) {
                double ps = Tomo3d.STATIN.stc[1][ns];
                double rs = Tomo3d.STATIN.stc[2][ns];
                double hs = Tomo3d.STATIN.stc[3][ns];
                double po = 0.0;
                Tomo3d.point(pe, re, he, ps, rs, hs, pk, rk, hk, hm, delp);
                Tomo3d.layhe(pk[0], rk[0], hk[0], hlae, lay);
                Tomo3d.travt(pk[0], rk[0], hk[0], ps, rs, hs, kps, ns, hlae, lay[0], Tomo3d.CONTRL.tlim, Tomo3d.CONTRL.nitpb, po, del, az, ve, fstime);
                if (isee == 1) {
                    double ress = Tomo3d.OBSERV.sect[no][ne];
                    System.out.printf(" ne,nb,no,hm,delp,del,ve,res = %5d %3d %3d %7.1f %6.1f %6.1f %6.1f %6.2f\n", ne, nobs, no, hm[0], delp[0], del[0], ve[0], ress);
                }
                Tomo3d.ttmtele(ne, no, kps, ve[0], fstime[0]);
            }
            ++mo;
        }
    }

    public static void ellipse() {
    }

    public static void correc(double dep, double del, int kps, double phi, double azm, double[] dt) {
        int l = 1;
        while (l <= 5) {
            Tomo3d.ELLIPS.deltb[l] = Tomo3d.TOYUAN.delra[l];
            ++l;
        }
        int ips = 2;
        if (kps != 2) {
            ips = 1;
        }
        Tomo3d.ELLIPS.idel = 0;
        int l2 = 1;
        while (l2 <= 5) {
            if (del >= Tomo3d.ELLIPS.deltb[l2]) {
                ++Tomo3d.ELLIPS.idel;
            }
            ++l2;
        }
        Tomo3d.ELLIPS.idel1 = Tomo3d.ELLIPS.idel + 1;
        if (Tomo3d.ELLIPS.idel1 >= 5) {
            Tomo3d.ELLIPS.idel1 = 5;
        }
        if (ips == 1) {
            if (dep >= 0.0 && dep < 300.0) {
                Tomo3d.t012(Tomo3d.TOYUAN.pd0t0, Tomo3d.TOYUAN.pd3t0, Tomo3d.TOYUAN.pd0t1, Tomo3d.TOYUAN.pd3t1, Tomo3d.TOYUAN.pd0t2, Tomo3d.TOYUAN.pd3t2, 0.0, 300.0, dep, del);
            } else if (dep >= 300.0 && dep < 650.0) {
                Tomo3d.t012(Tomo3d.TOYUAN.pd3t0, Tomo3d.TOYUAN.pd6t0, Tomo3d.TOYUAN.pd3t1, Tomo3d.TOYUAN.pd6t1, Tomo3d.TOYUAN.pd3t2, Tomo3d.TOYUAN.pd6t2, 300.0, 650.0, dep, del);
            } else {
                Tomo3d.t012(Tomo3d.TOYUAN.pd6t0, Tomo3d.TOYUAN.pd6t0, Tomo3d.TOYUAN.pd6t1, Tomo3d.TOYUAN.pd6t1, Tomo3d.TOYUAN.pd6t2, Tomo3d.TOYUAN.pd6t2, 650.0, 651.0, dep, del);
            }
        } else if (ips == 2) {
            if (dep >= 0.0 && dep < 300.0) {
                Tomo3d.t012(Tomo3d.TOYUAN.sd0t0, Tomo3d.TOYUAN.sd3t0, Tomo3d.TOYUAN.sd0t1, Tomo3d.TOYUAN.sd3t1, Tomo3d.TOYUAN.sd0t2, Tomo3d.TOYUAN.sd3t2, 0.0, 300.0, dep, del);
            } else if (dep >= 300.0 && dep < 650.0) {
                Tomo3d.t012(Tomo3d.TOYUAN.sd3t0, Tomo3d.TOYUAN.sd6t0, Tomo3d.TOYUAN.sd3t1, Tomo3d.TOYUAN.sd6t1, Tomo3d.TOYUAN.sd3t2, Tomo3d.TOYUAN.sd6t2, 300.0, 650.0, dep, del);
            } else {
                Tomo3d.t012(Tomo3d.TOYUAN.sd6t0, Tomo3d.TOYUAN.sd6t0, Tomo3d.TOYUAN.sd6t1, Tomo3d.TOYUAN.sd6t1, Tomo3d.TOYUAN.sd6t2, Tomo3d.TOYUAN.sd6t2, 650.0, 651.0, dep, del);
            }
        } else {
            Tomo3d.ELLIPS.t0 = 0.0;
            Tomo3d.ELLIPS.t1 = 0.0;
            Tomo3d.ELLIPS.t2 = 0.0;
        }
        double phi2 = 2.0 * phi;
        double sin2p = Math.sin(phi2);
        double cos2p = Math.cos(phi2);
        double cosaz = Math.cos(azm);
        double cos2az = 2.0 * cosaz * cosaz - 1.0;
        dt[0] = (0.25 + 0.75 * cos2p) * Tomo3d.ELLIPS.t0 + 0.866 * sin2p * cosaz * Tomo3d.ELLIPS.t1 + 0.433 * (1.0 - cos2p) * cos2az * Tomo3d.ELLIPS.t2;
    }

    public static void t012(double[] pd0t0, double[] pd3t0, double[] pd0t1, double[] pd3t1, double[] pd0t2, double[] pd3t2, double dep1, double dep2, double dep, double del) {
        double depp = (dep - dep1) / (dep2 - dep1);
        double delt = (del - Tomo3d.ELLIPS.deltb[Tomo3d.ELLIPS.idel]) / 5.0;
        double t0a = (pd0t0[Tomo3d.ELLIPS.idel1] - pd0t0[Tomo3d.ELLIPS.idel]) * delt + pd0t0[Tomo3d.ELLIPS.idel];
        double t0b = (pd3t0[Tomo3d.ELLIPS.idel1] - pd3t0[Tomo3d.ELLIPS.idel]) * delt + pd3t0[Tomo3d.ELLIPS.idel];
        double t1a = (pd0t1[Tomo3d.ELLIPS.idel1] - pd0t1[Tomo3d.ELLIPS.idel]) * delt + pd0t1[Tomo3d.ELLIPS.idel];
        double t1b = (pd3t1[Tomo3d.ELLIPS.idel1] - pd3t1[Tomo3d.ELLIPS.idel]) * delt + pd3t1[Tomo3d.ELLIPS.idel];
        double t2a = (pd0t2[Tomo3d.ELLIPS.idel1] - pd0t2[Tomo3d.ELLIPS.idel]) * delt + pd0t2[Tomo3d.ELLIPS.idel];
        double t2b = (pd3t2[Tomo3d.ELLIPS.idel1] - pd3t2[Tomo3d.ELLIPS.idel]) * delt + pd3t2[Tomo3d.ELLIPS.idel];
        Tomo3d.ELLIPS.t0 = t0a + (t0b - t0a) * depp;
        Tomo3d.ELLIPS.t1 = t1a + (t1b - t1a) * depp;
        Tomo3d.ELLIPS.t2 = t2a + (t2b - t2a) * depp;
    }

    public static void ttmder(int ne, int no, int kps, double ve, double ttime, int kopt) {
        int k;
        double resm = 1.8;
        int[] in = new int[9];
        int[] lx = new int[25];
        double[] des = new double[1];
        double[] az = new double[1];
        double[] sl = new double[1];
        double[] vx = new double[1];
        int[] ind = new int[1];
        int[] ijmn = new int[1];
        Tomo3d.RAYPATH.r0 = 6371.0;
        double epc = 1.0E-5;
        double pe = Tomo3d.RAYLOC.rp[1][Tomo3d.RAYLOC.nrp];
        double re = Tomo3d.RAYLOC.rp[2][Tomo3d.RAYLOC.nrp];
        double he = Tomo3d.RAYLOC.rp[3][Tomo3d.RAYLOC.nrp];
        int nrp1 = Tomo3d.RAYLOC.nrp - 1;
        double pe1 = Tomo3d.RAYLOC.rp[1][nrp1];
        double re1 = Tomo3d.RAYLOC.rp[2][nrp1];
        double he1 = Tomo3d.RAYLOC.rp[3][nrp1];
        Tomo3d.conaz(re, pe, re1, pe1, des, az);
        des[0] = des[0] * (1.0 - he / Tomo3d.RAYPATH.r0);
        double dhe = he1 - he;
        double adh = Math.abs(dhe);
        if (des[0] < epc && adh < epc) {
            dhe = 1.0;
        }
        double th = Math.atan2(des[0], dhe);
        double dtddel = Math.sin(th) * (Tomo3d.RAYPATH.r0 - he) / ve;
        double dtdr = Math.cos(th) / ve;
        Tomo3d.HYPINV.dth[no][1] = 1.0;
        Tomo3d.HYPINV.dth[no][2] = dtddel * Math.cos(az[0]) * 0.01;
        Tomo3d.HYPINV.dth[no][3] = -dtddel * Math.sin(az[0]) * Math.sin(pe) * 0.01;
        Tomo3d.HYPINV.dth[no][4] = -dtdr;
        Tomo3d.HYPINV.res[no] = Tomo3d.OBSERV.sect[no][ne] - Tomo3d.EVENTS.seco[ne] - ttime;
        double ar = Math.abs(Tomo3d.HYPINV.res[no]);
        Tomo3d.HYPINV.w[no] = 0.0;
        if (ar <= 1.8) {
            Tomo3d.HYPINV.w[no] = 1.0;
        }
        if (kopt == 0) {
            return;
        }
        if (Tomo3d.HYPINV.w[no] < epc) {
            return;
        }
        double half = 0.5;
        ++Tomo3d.MODINV.nod;
        Tomo3d.ONED.numb = 0;
        int i = 1;
        while (i <= 300) {
            Tomo3d.ONED.dtm[i] = 0.0;
            Tomo3d.ONED.ndm[i] = 0;
            ++i;
        }
        i = 1;
        while (i <= nrp1) {
            int lay = Tomo3d.RAYLOC.ivk[i];
            int ips = Tomo3d.RAYPATH.iwv[kps][Tomo3d.RAYLOC.iwk[i]];
            Tomo3d.ijmnx(lay, ijmn);
            double p = Tomo3d.RAYLOC.rp[1][i];
            double r = Tomo3d.RAYLOC.rp[2][i];
            double h = Tomo3d.RAYLOC.rp[3][i];
            int i1 = i + 1;
            double p1 = Tomo3d.RAYLOC.rp[1][i1];
            double r1 = Tomo3d.RAYLOC.rp[2][i1];
            double h1 = Tomo3d.RAYLOC.rp[3][i1];
            double dp = p1 - p;
            double dr = r1 - r;
            double dh = h1 - h;
            Tomo3d.length(p, r, h, p1, r1, h1, sl);
            int nseg = (int)(sl[0] / Tomo3d.CONTRL.stepl) + 1;
            double fnsegi = 1.0 / (double)nseg;
            double ssl = sl[0] * fnsegi;
            double dps = dp * fnsegi;
            double drs = dr * fnsegi;
            double dhs = dh * fnsegi;
            double px = p - half * dps;
            double rx = r - half * drs;
            double hx = h - half * dhs;
            int is = 1;
            while (is <= nseg) {
                Tomo3d.vel33(px += dps, rx += drs, hx += dhs, vx, lay, ips);
                double dt = ssl / vx[0];
                Tomo3d.nodo(Tomo3d.NPRH12.np1, Tomo3d.NPRH12.nr1, Tomo3d.NPRH12.nh1, Tomo3d.WEIGHT.ip, Tomo3d.WEIGHT.jp, Tomo3d.WEIGHT.kp, lx, ind);
                in[1] = Tomo3d.WEIGHT.ip - 1 + Tomo3d.NPRH12.np2 * (Tomo3d.WEIGHT.jp - 2) + Tomo3d.NPRH12.npr2 * (Tomo3d.WEIGHT.kp - 2);
                in[2] = in[1] + 1;
                in[3] = in[1] + Tomo3d.NPRH12.np2;
                in[4] = in[3] + 1;
                in[5] = in[1] + Tomo3d.NPRH12.npr2;
                in[6] = in[5] + 1;
                in[7] = in[5] + Tomo3d.NPRH12.np2;
                in[8] = in[7] + 1;
                int kk = 1;
                while (kk <= 2) {
                    int kk1 = kk - 1;
                    int jj = 1;
                    while (jj <= 2) {
                        int jj1 = jj - 1;
                        int ii = 1;
                        while (ii <= 2) {
                            boolean gotoL3 = false;
                            int ijk = ii + 2 * jj1 + 4 * kk1;
                            if (ind[0] != 0) {
                                int kz = 1;
                                while (kz <= 24) {
                                    if (ijk == lx[kz]) {
                                        gotoL3 = true;
                                        break;
                                    }
                                    ++kz;
                                }
                            }
                            if (!gotoL3) {
                                int ii1 = ii - 1;
                                int ini = ijmn[0] + in[ijk];
                                int l = Tomo3d.WEIGHT.ip + ii1;
                                int m = Tomo3d.WEIGHT.jp + jj1;
                                int n = Tomo3d.WEIGHT.kp + kk1;
                                double vijk = Tomo3d.VMOD3D.velap[l][m][n];
                                double dtv = dt * Tomo3d.WEIGHT.wv[ijk] * vijk / vx[0];
                                Tomo3d.oneray(ini, dtv);
                            }
                            ++ii;
                        }
                        ++jj;
                    }
                    ++kk;
                }
                ++is;
            }
            ++i;
        }
        double wn = Tomo3d.HYPINV.w[no];
        int numc = 0;
        i = 1;
        while (i <= Tomo3d.ONED.numb) {
            double dtmi = Tomo3d.ONED.dtm[i];
            if (!(dtmi < epc)) {
                ++numc;
                k = Tomo3d.ONED.ndm[i] + Tomo3d.MODINV.neq4;
                Tomo3d.MODINV.khit[k] = Tomo3d.MODINV.khit[k] + 1;
                ++Tomo3d.MODINV.itot;
                Tomo3d.MODINV.a[Tomo3d.MODINV.itot] = dtmi * wn;
                Tomo3d.MODINV.ja[Tomo3d.MODINV.itot] = k;
            }
            ++i;
        }
        if (Tomo3d.MODINV.neq4 != 0) {
            i = 1;
            while (i <= 4) {
                k = (ne - 1) * 4 + i;
                Tomo3d.MODINV.khit[k] = Tomo3d.MODINV.khit[k] + 1;
                ++Tomo3d.MODINV.itot;
                Tomo3d.MODINV.a[Tomo3d.MODINV.itot] = Tomo3d.HYPINV.dth[no][i] * wn;
                Tomo3d.MODINV.ja[Tomo3d.MODINV.itot] = k;
                ++i;
            }
        }
        int ihypo = Tomo3d.MODINV.neq4 / Tomo3d.CONTRL.neqs;
        Tomo3d.MODINV.na[Tomo3d.MODINV.nod] = numc + ihypo;
        Tomo3d.MODINV.rds[Tomo3d.MODINV.nod] = Tomo3d.HYPINV.res[no] * wn;
    }

    public static void ttmtele(int ne, int no, int kps, double ve, double ttime) {
        double resm = 2.0;
        int[] in = new int[9];
        int[] lx = new int[25];
        double[] sl = new double[1];
        double[] vx = new double[1];
        int[] ind = new int[1];
        int[] ijmn = new int[1];
        double epc = 1.0E-5;
        int nrp1 = Tomo3d.RAYLOC.nrp - 1;
        Tomo3d.HYPINV.res[no] = Tomo3d.OBSERV.sect[no][ne];
        double ar = Math.abs(Tomo3d.HYPINV.res[no]);
        Tomo3d.HYPINV.w[no] = 0.0;
        if (ar <= 2.0) {
            Tomo3d.HYPINV.w[no] = 1.0;
        }
        if (Tomo3d.HYPINV.w[no] < epc) {
            return;
        }
        double half = 0.5;
        ++Tomo3d.MODINV.nod;
        Tomo3d.ONED.numb = 0;
        int i = 1;
        while (i <= 300) {
            Tomo3d.ONED.dtm[i] = 0.0;
            Tomo3d.ONED.ndm[i] = 0;
            ++i;
        }
        i = 1;
        while (i <= nrp1) {
            int lay = Tomo3d.RAYLOC.ivk[i];
            int ips = Tomo3d.RAYPATH.iwv[kps][Tomo3d.RAYLOC.iwk[i]];
            Tomo3d.ijmnx(lay, ijmn);
            double p = Tomo3d.RAYLOC.rp[1][i];
            double r = Tomo3d.RAYLOC.rp[2][i];
            double h = Tomo3d.RAYLOC.rp[3][i];
            int i1 = i + 1;
            double p1 = Tomo3d.RAYLOC.rp[1][i1];
            double r1 = Tomo3d.RAYLOC.rp[2][i1];
            double h1 = Tomo3d.RAYLOC.rp[3][i1];
            double dp = p1 - p;
            double dr = r1 - r;
            double dh = h1 - h;
            Tomo3d.length(p, r, h, p1, r1, h1, sl);
            int nseg = (int)(sl[0] / Tomo3d.CONTRL.stepl) + 1;
            double fnsegi = 1.0 / (double)nseg;
            double ssl = sl[0] * fnsegi;
            double dps = dp * fnsegi;
            double drs = dr * fnsegi;
            double dhs = dh * fnsegi;
            double px = p - half * dps;
            double rx = r - half * drs;
            double hx = h - half * dhs;
            int is = 1;
            while (is <= nseg) {
                Tomo3d.vel33(px += dps, rx += drs, hx += dhs, vx, lay, ips);
                double dt = ssl / vx[0];
                Tomo3d.nodo(Tomo3d.NPRH12.np1, Tomo3d.NPRH12.nr1, Tomo3d.NPRH12.nh1, Tomo3d.WEIGHT.ip, Tomo3d.WEIGHT.jp, Tomo3d.WEIGHT.kp, lx, ind);
                in[1] = Tomo3d.WEIGHT.ip - 1 + Tomo3d.NPRH12.np2 * (Tomo3d.WEIGHT.jp - 2) + Tomo3d.NPRH12.npr2 * (Tomo3d.WEIGHT.kp - 2);
                in[2] = in[1] + 1;
                in[3] = in[1] + Tomo3d.NPRH12.np2;
                in[4] = in[3] + 1;
                in[5] = in[1] + Tomo3d.NPRH12.npr2;
                in[6] = in[5] + 1;
                in[7] = in[5] + Tomo3d.NPRH12.np2;
                in[8] = in[7] + 1;
                int kk = 1;
                while (kk <= 2) {
                    int kk1 = kk - 1;
                    int jj = 1;
                    while (jj <= 2) {
                        int jj1 = jj - 1;
                        int ii = 1;
                        while (ii <= 2) {
                            boolean gotoL3 = false;
                            int ijk = ii + 2 * jj1 + 4 * kk1;
                            if (ind[0] != 0) {
                                int kz = 1;
                                while (kz <= 24) {
                                    if (ijk == lx[kz]) {
                                        gotoL3 = true;
                                        break;
                                    }
                                    ++kz;
                                }
                            }
                            if (!gotoL3) {
                                int ii1 = ii - 1;
                                int ini = ijmn[0] + in[ijk];
                                int l = Tomo3d.WEIGHT.ip + ii1;
                                int m = Tomo3d.WEIGHT.jp + jj1;
                                int n = Tomo3d.WEIGHT.kp + kk1;
                                double vijk = Tomo3d.VMOD3D.velap[l][m][n];
                                double dtv = dt * Tomo3d.WEIGHT.wv[ijk] * vijk / vx[0];
                                Tomo3d.oneray(ini, dtv);
                            }
                            ++ii;
                        }
                        ++jj;
                    }
                    ++kk;
                }
                ++is;
            }
            ++i;
        }
        double wn = Tomo3d.HYPINV.w[no];
        int numc = 0;
        i = 1;
        while (i <= Tomo3d.ONED.numb) {
            double dtmi = Tomo3d.ONED.dtm[i];
            if (!(dtmi < epc)) {
                ++numc;
                int k = Tomo3d.ONED.ndm[i];
                Tomo3d.MODINV.khit[k] = Tomo3d.MODINV.khit[k] + 1;
                ++Tomo3d.MODINV.itot;
                Tomo3d.MODINV.a[Tomo3d.MODINV.itot] = dtmi * wn;
                Tomo3d.MODINV.ja[Tomo3d.MODINV.itot] = k;
            }
            ++i;
        }
        Tomo3d.MODINV.na[Tomo3d.MODINV.nod] = numc;
        Tomo3d.MODINV.rds[Tomo3d.MODINV.nod] = Tomo3d.HYPINV.res[no] * wn;
    }

    public static void oneray(int ini, double dtv) {
        int nb = Math.max(1, Tomo3d.ONED.numb);
        int i = 1;
        while (i <= nb) {
            if (ini == Tomo3d.ONED.ndm[i]) {
                Tomo3d.ONED.dtm[i] = Tomo3d.ONED.dtm[i] + dtv;
                return;
            }
            ++i;
        }
        ++Tomo3d.ONED.numb;
        Tomo3d.ONED.ndm[Tomo3d.ONED.numb] = ini;
        Tomo3d.ONED.dtm[Tomo3d.ONED.numb] = dtv;
    }

    public static void ijmnx(int lay, int[] ijmn) {
        ijmn[0] = 0;
        Tomo3d.nw(Tomo3d.VMOD3D.npa, Tomo3d.VMOD3D.nra, Tomo3d.VMOD3D.nha, Tomo3d.GRINET.npa2, Tomo3d.GRINET.npra2);
    }

    public static void nw(int npa, int nra, int nha, int npa2, int npra2) {
        Tomo3d.NPRH12.np1 = npa - 1;
        Tomo3d.NPRH12.nr1 = nra - 1;
        Tomo3d.NPRH12.nh1 = nha - 1;
        Tomo3d.NPRH12.np2 = npa2;
        Tomo3d.NPRH12.npr2 = npra2;
    }

    public static void nodo(int np1, int nr1, int nh1, int ip, int jp, int kp, int[] lx, int[] ind) {
        int[] nArray = new int[25];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 5;
        nArray[4] = 7;
        nArray[5] = 2;
        nArray[6] = 4;
        nArray[7] = 6;
        nArray[8] = 8;
        nArray[9] = 1;
        nArray[10] = 2;
        nArray[11] = 5;
        nArray[12] = 6;
        nArray[13] = 3;
        nArray[14] = 4;
        nArray[15] = 7;
        nArray[16] = 8;
        nArray[17] = 1;
        nArray[18] = 2;
        nArray[19] = 3;
        nArray[20] = 4;
        nArray[21] = 5;
        nArray[22] = 6;
        nArray[23] = 7;
        nArray[24] = 8;
        int[] lxd = nArray;
        int i = 1;
        while (i <= 24) {
            lx[i] = 0;
            ++i;
        }
        if (ip == 1 || ip == np1) {
            if (ip == 1) {
                i = 1;
                while (i <= 4) {
                    lx[i] = lxd[i];
                    ++i;
                }
            }
            if (ip == np1) {
                i = 5;
                while (i <= 8) {
                    lx[i] = lxd[i];
                    ++i;
                }
            }
            if (jp == 1) {
                i = 9;
                while (i <= 12) {
                    lx[i] = lxd[i];
                    ++i;
                }
            }
            if (jp == nr1) {
                i = 13;
                while (i <= 16) {
                    lx[i] = lxd[i];
                    ++i;
                }
            }
            if (kp == 1) {
                i = 17;
                while (i <= 20) {
                    lx[i] = lxd[i];
                    ++i;
                }
            }
            if (kp == nh1) {
                i = 21;
                while (i <= 24) {
                    lx[i] = lxd[i];
                    ++i;
                }
            }
            ind[0] = 1;
            return;
        }
        if (jp == 1 || jp == nr1) {
            if (jp == 1) {
                i = 9;
                while (i <= 12) {
                    lx[i] = lxd[i];
                    ++i;
                }
            }
            if (jp == nr1) {
                i = 13;
                while (i <= 16) {
                    lx[i] = lxd[i];
                    ++i;
                }
            }
            if (kp == 1) {
                i = 17;
                while (i <= 20) {
                    lx[i] = lxd[i];
                    ++i;
                }
            }
            if (kp == nh1) {
                i = 21;
                while (i <= 24) {
                    lx[i] = lxd[i];
                    ++i;
                }
            }
            ind[0] = 1;
            return;
        }
        if (kp == 1 || kp == nh1) {
            if (kp == 1) {
                i = 17;
                while (i <= 20) {
                    lx[i] = lxd[i];
                    ++i;
                }
            }
            if (kp == nh1) {
                i = 21;
                while (i <= 24) {
                    lx[i] = lxd[i];
                    ++i;
                }
            }
            ind[0] = 1;
            return;
        }
        ind[0] = 0;
    }

    public static void bldmap() {
        Tomo3d.locx(Tomo3d.VMOD3D.pna, Tomo3d.VMOD3D.rna, Tomo3d.VMOD3D.hna, Tomo3d.VMOD3D.npa, Tomo3d.VMOD3D.nra, Tomo3d.VMOD3D.nha, 3500, Tomo3d.LOCATE.pla, Tomo3d.LOCATE.rla, Tomo3d.LOCATE.hla, Tomo3d.LOCATE.iploca, Tomo3d.LOCATE.irloca, Tomo3d.LOCATE.ihloca);
    }

    public static void locx(double[] pnx, double[] rnx, double[] hnx, int npx, int nrx, int nhx, int mkx, double[] plx, double[] rlx, double[] hlx, int[] iplocx, int[] irlocx, int[] ihlocx) {
        plx[0] = 1.0 - pnx[1] * 100.0;
        int ipmax = (int)(pnx[npx] * 100.0 + plx[0]);
        int ip = 1;
        int i = 1;
        while (i <= ipmax) {
            double pnow = ((double)i - plx[0]) / 100.0;
            int ip1 = ip + 1;
            if (pnow >= pnx[ip1]) {
                ip = ip1;
            }
            iplocx[i] = ip;
            ++i;
        }
        rlx[0] = 1.0 - rnx[1] * 100.0;
        int irmax = (int)(rnx[nrx] * 100.0 + rlx[0]);
        int ir = 1;
        i = 1;
        while (i <= irmax) {
            double rnow = ((double)i - rlx[0]) / 100.0;
            int ir1 = ir + 1;
            if (rnow >= rnx[ir1]) {
                ir = ir1;
            }
            irlocx[i] = ir;
            ++i;
        }
        hlx[0] = 1.0 - hnx[1];
        int ihmax = (int)(hnx[nhx] + hlx[0]);
        int ih = 1;
        i = 1;
        while (i <= ihmax) {
            double hnow = (double)i - hlx[0];
            int ih1 = ih + 1;
            if (hnow >= hnx[ih1]) {
                ih = ih1;
            }
            ihlocx[i] = ih;
            ++i;
        }
    }

    public static void hlay(double pe, double re, double[] he, int ijk) {
        double pid = 0.017453;
        int i1 = 0;
        int j1 = 0;
        int i = 0;
        int j = 0;
        double[] p = new double[]{90.0 - pe / pid};
        double[] r = new double[]{re / pid};
        Tomo3d.limit(Tomo3d.DISCON.pn[1], Tomo3d.DISCON.pn[Tomo3d.DISCON.nnp], p);
        Tomo3d.limit(Tomo3d.DISCON.rn[1], Tomo3d.DISCON.rn[Tomo3d.DISCON.nnr], r);
        i = 1;
        while (i <= Tomo3d.DISCON.nnp - 1) {
            i1 = i + 1;
            if (p[0] >= Tomo3d.DISCON.pn[i] && p[0] < Tomo3d.DISCON.pn[i1]) break;
            ++i;
        }
        j = 1;
        while (j <= Tomo3d.DISCON.nnr - 1) {
            j1 = j + 1;
            if (r[0] >= Tomo3d.DISCON.rn[j] && r[0] < Tomo3d.DISCON.rn[j1]) break;
            ++j;
        }
        double pf = (p[0] - Tomo3d.DISCON.pn[i]) / (Tomo3d.DISCON.pn[i1] - Tomo3d.DISCON.pn[i]);
        double rf = (r[0] - Tomo3d.DISCON.rn[j]) / (Tomo3d.DISCON.rn[j1] - Tomo3d.DISCON.rn[j]);
        double pf1 = 1.0 - pf;
        double rf1 = 1.0 - rf;
        double wv1 = pf1 * rf1;
        double wv2 = pf * rf1;
        double wv3 = pf1 * rf;
        double wv4 = pf * rf;
        if (ijk == 1) {
            he[0] = wv1 * Tomo3d.DISCON.depa[i][j] + wv2 * Tomo3d.DISCON.depa[i1][j] + wv3 * Tomo3d.DISCON.depa[i][j1] + wv4 * Tomo3d.DISCON.depa[i1][j1];
        } else if (ijk == 2) {
            he[0] = wv1 * Tomo3d.DISCON.depb[i][j] + wv2 * Tomo3d.DISCON.depb[i1][j] + wv3 * Tomo3d.DISCON.depb[i][j1] + wv4 * Tomo3d.DISCON.depb[i1][j1];
        } else if (ijk == 3) {
            he[0] = wv1 * Tomo3d.DISCON.depc[i][j] + wv2 * Tomo3d.DISCON.depc[i1][j] + wv3 * Tomo3d.DISCON.depc[i][j1] + wv4 * Tomo3d.DISCON.depc[i1][j1];
        }
    }

    public static void vel3(double pe, double re, double he, double[] v, int lay, int ips) {
        Tomo3d.vel1d(he, v, lay, ips);
    }

    public static void vel33(double pe, double re, double he, double[] v, int lay, int ips) {
        double pideg = 0.017453;
        Tomo3d.PRHFD.p = 90.0 - pe / pideg;
        Tomo3d.PRHFD.r = re / pideg;
        Tomo3d.PRHFD.h = he;
        Tomo3d.prhf(Tomo3d.LOCATE.iploca, Tomo3d.LOCATE.irloca, Tomo3d.LOCATE.ihloca, Tomo3d.LOCATE.pla[0], Tomo3d.LOCATE.rla[0], Tomo3d.LOCATE.hla[0], Tomo3d.VMOD3D.pna, Tomo3d.VMOD3D.rna, Tomo3d.VMOD3D.hna, 13, 11, 11, 3500);
        Tomo3d.WEIGHT.wv[1] = Tomo3d.PRHFD.pf1 * Tomo3d.PRHFD.rf1 * Tomo3d.PRHFD.hf1;
        Tomo3d.WEIGHT.wv[2] = Tomo3d.PRHFD.pf * Tomo3d.PRHFD.rf1 * Tomo3d.PRHFD.hf1;
        Tomo3d.WEIGHT.wv[3] = Tomo3d.PRHFD.pf1 * Tomo3d.PRHFD.rf * Tomo3d.PRHFD.hf1;
        Tomo3d.WEIGHT.wv[4] = Tomo3d.PRHFD.pf * Tomo3d.PRHFD.rf * Tomo3d.PRHFD.hf1;
        Tomo3d.WEIGHT.wv[5] = Tomo3d.PRHFD.pf1 * Tomo3d.PRHFD.rf1 * Tomo3d.PRHFD.hf;
        Tomo3d.WEIGHT.wv[6] = Tomo3d.PRHFD.pf * Tomo3d.PRHFD.rf1 * Tomo3d.PRHFD.hf;
        Tomo3d.WEIGHT.wv[7] = Tomo3d.PRHFD.pf1 * Tomo3d.PRHFD.rf * Tomo3d.PRHFD.hf;
        Tomo3d.WEIGHT.wv[8] = Tomo3d.PRHFD.pf * Tomo3d.PRHFD.rf * Tomo3d.PRHFD.hf;
        double[] dv = new double[1];
        double[] v1 = new double[1];
        Tomo3d.vabps(13, 11, 11, Tomo3d.VMOD3D.dvap, dv);
        Tomo3d.vel1d(he, v1, lay, ips);
        v[0] = v1[0] * (1.0 + dv[0] * 0.01);
        if (ips == 2) {
            v[0] = v1[0];
        }
    }

    public static void vabps(int mp, int mr, int mh, double[][][] v, double[] vel) {
        vel[0] = Tomo3d.WEIGHT.wv[1] * v[Tomo3d.WEIGHT.ip][Tomo3d.WEIGHT.jp][Tomo3d.WEIGHT.kp] + Tomo3d.WEIGHT.wv[2] * v[Tomo3d.WEIGHT.ip1][Tomo3d.WEIGHT.jp][Tomo3d.WEIGHT.kp] + Tomo3d.WEIGHT.wv[3] * v[Tomo3d.WEIGHT.ip][Tomo3d.WEIGHT.jp1][Tomo3d.WEIGHT.kp] + Tomo3d.WEIGHT.wv[4] * v[Tomo3d.WEIGHT.ip1][Tomo3d.WEIGHT.jp1][Tomo3d.WEIGHT.kp] + Tomo3d.WEIGHT.wv[5] * v[Tomo3d.WEIGHT.ip][Tomo3d.WEIGHT.jp][Tomo3d.WEIGHT.kp1] + Tomo3d.WEIGHT.wv[6] * v[Tomo3d.WEIGHT.ip1][Tomo3d.WEIGHT.jp][Tomo3d.WEIGHT.kp1] + Tomo3d.WEIGHT.wv[7] * v[Tomo3d.WEIGHT.ip][Tomo3d.WEIGHT.jp1][Tomo3d.WEIGHT.kp1] + Tomo3d.WEIGHT.wv[8] * v[Tomo3d.WEIGHT.ip1][Tomo3d.WEIGHT.jp1][Tomo3d.WEIGHT.kp1];
    }

    public static void vel1d(double he, double[] v, int lay, int ips) {
        double hm = 0.0;
        if (lay == 1) {
            v[0] = 5.9;
            if (ips == 2) {
                v[0] = 3.4;
            }
        } else if (lay == 2) {
            v[0] = 6.5;
            if (ips == 2) {
                v[0] = 3.75;
            }
        } else if (lay >= 3) {
            hm = 40.0;
            if (he < hm) {
                double[] vm = new double[1];
                Tomo3d.jbmodel(ips, hm, vm);
                v[0] = vm[0] - (hm - he) * 0.003;
            } else {
                Tomo3d.jbmodel(ips, he, v);
            }
        }
    }

    public static void inputjb() {
        double[] vp1 = new double[]{7.75, 7.94, 8.13, 8.33, 8.54, 8.75, 8.97, 9.5, 9.91, 10.26, 10.55, 10.99, 11.29, 11.5, 11.67, 11.85, 12.03, 12.2, 12.37, 12.54, 12.71, 12.87, 13.02, 13.16, 13.32, 13.46, 13.6, 13.64, 13.64};
        double[] vs1 = new double[]{4.353, 4.444, 4.539, 4.638, 4.741, 4.85, 4.962, 5.227, 5.463, 5.67, 5.85, 6.125, 6.295, 6.395, 6.483, 6.564, 6.637, 6.706, 6.77, 6.833, 6.893, 6.953, 7.012, 7.074, 7.137, 7.199, 7.258, 7.314, 7.304};
        double[] ra1 = new double[]{1.0, 0.99, 0.98, 0.97, 0.96, 0.95, 0.94, 0.93, 0.92, 0.91, 0.9, 0.88, 0.86, 0.84, 0.82, 0.8, 0.78, 0.76, 0.74, 0.72, 0.7, 0.68, 0.66, 0.64, 0.62, 0.6, 0.58, 0.56, 0.55};
        int i = 0;
        while (i < 29) {
            Tomo3d.JBMODV.vp[i + 1] = vp1[i];
            Tomo3d.JBMODV.vs[i + 1] = vs1[i];
            Tomo3d.JBMODV.ra[i + 1] = ra1[i];
            Tomo3d.JBMODV.depj[i + 1] = 40.0 + 6325.59 * (1.0 - ra1[i]);
            ++i;
        }
    }

    public static void jbmodel(int ips, double h, double[] v) {
        int k1 = 1;
        double h1 = 0.0;
        double h2 = 0.0;
        int k = 0;
        k = 1;
        while (k <= 28) {
            k1 = k + 1;
            h1 = Tomo3d.JBMODV.depj[k];
            h2 = Tomo3d.JBMODV.depj[k1];
            if (h >= h1 && h < h2) break;
            ++k;
        }
        double h12 = (h - h1) / (h2 - h1);
        v[0] = ips == 1 ? (Tomo3d.JBMODV.vp[k1] - Tomo3d.JBMODV.vp[k]) * h12 + Tomo3d.JBMODV.vp[k] : (Tomo3d.JBMODV.vs[k1] - Tomo3d.JBMODV.vs[k]) * h12 + Tomo3d.JBMODV.vs[k];
    }

    public static void intmap(double r, int[] irloc, int nr, double rl, int[] ir) {
        int is = (int)(r + rl);
        ir[0] = irloc[is];
    }

    public static void prhf(int[] iplocx, int[] irlocx, int[] ihlocx, double plx, double rlx, double hlx, double[] pnx, double[] rnx, double[] hnx, int mpx, int mrx, int mhx, int mkx) {
        double[] p_ = new double[]{Tomo3d.PRHFD.p};
        Tomo3d.limit(pnx[1], pnx[mpx], p_);
        Tomo3d.PRHFD.p = p_[0];
        double[] r_ = new double[]{Tomo3d.PRHFD.r};
        Tomo3d.limit(rnx[1], rnx[mrx], r_);
        Tomo3d.PRHFD.r = r_[0];
        double[] h_ = new double[]{Tomo3d.PRHFD.h};
        Tomo3d.limit(hnx[1], hnx[mhx], h_);
        Tomo3d.PRHFD.h = h_[0];
        int[] ip_ = new int[]{Tomo3d.WEIGHT.ip};
        Tomo3d.intmap(Tomo3d.PRHFD.p * 100.0, iplocx, mkx, plx, ip_);
        Tomo3d.WEIGHT.ip = ip_[0];
        int[] jp_ = new int[]{Tomo3d.WEIGHT.jp};
        Tomo3d.intmap(Tomo3d.PRHFD.r * 100.0, irlocx, mkx, rlx, jp_);
        Tomo3d.WEIGHT.jp = jp_[0];
        int[] kp_ = new int[]{Tomo3d.WEIGHT.kp};
        Tomo3d.intmap(Tomo3d.PRHFD.h, ihlocx, mkx, hlx, kp_);
        Tomo3d.WEIGHT.kp = kp_[0];
        Tomo3d.WEIGHT.ip1 = Tomo3d.WEIGHT.ip + 1;
        Tomo3d.WEIGHT.jp1 = Tomo3d.WEIGHT.jp + 1;
        Tomo3d.WEIGHT.kp1 = Tomo3d.WEIGHT.kp + 1;
        Tomo3d.PRHFD.pd = pnx[Tomo3d.WEIGHT.ip1] - pnx[Tomo3d.WEIGHT.ip];
        Tomo3d.PRHFD.rd = rnx[Tomo3d.WEIGHT.jp1] - rnx[Tomo3d.WEIGHT.jp];
        Tomo3d.PRHFD.hd = hnx[Tomo3d.WEIGHT.kp1] - hnx[Tomo3d.WEIGHT.kp];
        Tomo3d.PRHFD.pf = (Tomo3d.PRHFD.p - pnx[Tomo3d.WEIGHT.ip]) / Tomo3d.PRHFD.pd;
        Tomo3d.PRHFD.rf = (Tomo3d.PRHFD.r - rnx[Tomo3d.WEIGHT.jp]) / Tomo3d.PRHFD.rd;
        Tomo3d.PRHFD.hf = (Tomo3d.PRHFD.h - hnx[Tomo3d.WEIGHT.kp]) / Tomo3d.PRHFD.hd;
        Tomo3d.PRHFD.pf1 = 1.0 - Tomo3d.PRHFD.pf;
        Tomo3d.PRHFD.rf1 = 1.0 - Tomo3d.PRHFD.rf;
        Tomo3d.PRHFD.hf1 = 1.0 - Tomo3d.PRHFD.hf;
    }

    public static void azin(double p, double r, double dth, double daz, double[] faz, double[] fin) {
        double eps = 1.0E-6;
        double azm = -1.570796 - daz;
        double sdth = Math.sin(dth);
        double x = sdth * Math.cos(azm);
        double y = sdth * Math.sin(azm);
        double z = Math.cos(dth);
        double sr = Math.sin(r);
        double cr = Math.cos(r);
        double sp = Math.sin(p);
        double cp = Math.cos(p);
        double xg = sr * x + cr * cp * y + cr * sp * z;
        double yg = -cr * x + sr * cp * y + sr * sp * z;
        double zg = -sp * y + cp * z;
        double qg = Math.sqrt(xg * xg + yg * yg);
        fin[0] = Math.atan2(qg, zg);
        faz[0] = 0.0;
        if (qg > eps) {
            faz[0] = Math.atan2(yg, xg);
        }
    }

    public static void conaz(double re, double pe, double rs, double ps, double[] del, double[] az) {
        double r0 = 6371.0;
        double eps = 1.0E-7;
        double pi15 = 4.712389;
        double sps = Math.sin(ps);
        double cps = Math.cos(ps);
        double spe = Math.sin(pe);
        double cpe = Math.cos(pe);
        double ses = Math.sin(re - rs);
        double ces = Math.cos(re - rs);
        double x = sps * ses;
        double y = cpe * sps * ces - spe * cps;
        double s = Math.sqrt(x * x + y * y);
        double c = spe * sps * ces + cpe * cps;
        del[0] = Math.atan2(s, c) * 6371.0;
        az[0] = 0.0;
        double ax = Math.abs(x);
        double ay = Math.abs(y);
        if (ax < 1.0E-7 && ay < 1.0E-7) {
            return;
        }
        az[0] = 4.712389 - Math.atan2(y, x);
    }

    public static void veladj() {
        double[] x = new double[50001];
        double[] se = new double[50001];
        double[] v = new double[50001];
        double[] w = new double[50001];
        int[] istop = new int[1];
        int[] np2 = new int[1];
        int[] npr2 = new int[1];
        int[] nvel = new int[1];
        double[] anorm = new double[1];
        double[] acond = new double[1];
        double[] rnorm = new double[1];
        double[] arnorm = new double[1];
        double[] xnorm = new double[1];
        Tomo3d.reorder();
        double atol = 0.0;
        double btol = 0.0;
        double conlim = 0.0;
        double damp = Tomo3d.CONTRL.vdamp;
        int itmax = 250;
        rnorm[0] = Tomo3d.MODINV.rnorm;
        xnorm[0] = Tomo3d.MODINV.xnorm;
        Tomo3d.lsqr(Tomo3d.MODINV.nod, Tomo3d.MODINV.nou, damp, Tomo3d.MODINV.rds, v, w, x, se, atol, btol, conlim, itmax, istop, anorm, acond, rnorm, arnorm, xnorm);
        Tomo3d.MODINV.rnorm = rnorm[0];
        Tomo3d.MODINV.xnorm = xnorm[0];
        double ressq = 0.0;
        int n1 = Tomo3d.MODINV.neq4 + 1;
        int n2 = Tomo3d.MODINV.neq4 + Tomo3d.GRINET.nodetot;
        int n = n1;
        while (n <= n2) {
            int ktn = Tomo3d.MODINV.khit[n];
            if (ktn >= Tomo3d.CONTRL.nhitct) {
                double dvnd;
                int jnn = Tomo3d.MODINV.jndex[n];
                double rh = x[jnn];
                double sv = se[jnn] * 100.0;
                Tomo3d.npnr(Tomo3d.GRINET.npa2, Tomo3d.GRINET.npra2, Tomo3d.MODINV.neq4, np2, npr2, nvel);
                int nq = n - nvel[0];
                int k = (nq - 1) / npr2[0] + 2;
                int j = 2 + (nq - 1 + (2 - k) * npr2[0]) / np2[0];
                int i = 1 + nq + np2[0] * (2 - j) + npr2[0] * (2 - k);
                double vijk = Tomo3d.VMOD3D.velap[i][j][k];
                double dvn = Tomo3d.VMOD3D.dvap[i][j][k];
                double rh1 = rh / (1.0 + rh);
                ressq += rh1 * rh1;
                double delm = -vijk * rh1;
                double delma = Math.abs(delm);
                if (delma > Tomo3d.CONTRL.dvmax) {
                    delm = Tomo3d.CONTRL.dvmax * delm / delma;
                }
                double vijkd = vijk + delm;
                Tomo3d.VMOD3D.dvap[i][j][k] = dvnd = dvn + 100.0 * delm / vijkd;
                Tomo3d.VMOD3D.velap[i][j][k] = vijkd;
                Tomo3d.STDERR.sevap[i][j][k] = sv;
            }
            ++n;
        }
        double resrms = xnorm[0] / Math.sqrt(Tomo3d.MODINV.nou);
        pwLog.printf(" Norm of solution(vel model) (%%)= %15.4f\n", xnorm[0]);
        pwLog.printf(" Total number of model parameters = %5d\n", Tomo3d.MODINV.nou);
        pwLog.printf(" Total model rms(%%) =%10.2f\n", resrms);
    }

    public static void npnr(int npx2, int nprx2, int nvx, int[] np2, int[] npr2, int[] nvel) {
        np2[0] = npx2;
        npr2[0] = nprx2;
        nvel[0] = nvx;
    }

    public static void outadj() {
        int neq41;
        double ssqr = Tomo3d.MODINV.rnorm * Tomo3d.MODINV.rnorm;
        double rmsres = Math.sqrt(ssqr / (double)Tomo3d.MODINV.nod);
        pwLog.printf(" Sum of squared residuals (sec*sec)=%12.3f\n", ssqr);
        pwLog.printf(" Total number of observations =%6d\n", Tomo3d.MODINV.nod);
        pwLog.printf(" Total rms travel time residual (sec)=%8.5f\n", rmsres);
        pwLog.printf("\n Updated velocity model\n", new Object[0]);
        pwLog.printf(" Velocity model difference (%%)\n\n", new Object[0]);
        pwLog.printf(" Standard error of velocity (%%)\n\n", new Object[0]);
        pwLog.printf(" Hit conuter \n", new Object[0]);
        int jm = neq41 = Tomo3d.MODINV.neq4 - 1;
        Tomo3d.outa(Tomo3d.VMOD3D.npa, Tomo3d.VMOD3D.nra, Tomo3d.VMOD3D.nha, Tomo3d.VMOD3D.pna, Tomo3d.VMOD3D.rna, Tomo3d.VMOD3D.hna, Tomo3d.VMOD3D.dvap, Tomo3d.VMOD3D.velap, Tomo3d.STDERR.sevap, jm);
    }

    public static void outa(int npx, int nrx, int nhx, double[] pnx, double[] rnx, double[] hnx, double[][][] dvp, double[][][] velp, double[][][] sev, int jm) {
        int i;
        int j;
        int[][][] kitp = new int[14][12][12];
        int npx1 = npx - 1;
        int nrx1 = nrx - 1;
        int nhx1 = nhx - 1;
        int npx2 = npx - 2;
        int nprx2 = npx2 * (nrx - 2);
        int k = 1;
        while (k <= nhx) {
            j = 1;
            while (j <= nrx) {
                i = 1;
                while (i <= npx) {
                    kitp[i][j][k] = 0;
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        k = 2;
        while (k <= nhx1) {
            j = 2;
            while (j <= nrx1) {
                int jj = jm + (k - 2) * nprx2 + (j - 2) * npx2;
                i = 2;
                while (i <= npx1) {
                    int ii = jj + i;
                    kitp[i][j][k] = Tomo3d.MODINV.khit[ii];
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        k = 2;
        while (k <= nhx1) {
            pwRes.printf("Layer %2d Depth =%7.2fKM\n", k, hnx[k]);
            int q = 1;
            while (q <= nrx) {
                pwRes.printf("%7.2f ", rnx[q]);
                ++q;
            }
            pwRes.println();
            i = npx;
            while (i >= 1) {
                pwRes.printf("%5.2f\n", pnx[i]);
                j = 1;
                while (j <= nrx) {
                    pwRes.printf("%7.2f ", velp[i][j][k]);
                    ++j;
                }
                pwRes.println();
                j = 1;
                while (j <= nrx) {
                    pwRes.printf("%7.2f ", dvp[i][j][k]);
                    ++j;
                }
                pwRes.println();
                j = 1;
                while (j <= nrx) {
                    pwRes.printf("%7.2f ", sev[i][j][k]);
                    ++j;
                }
                pwRes.println();
                j = 1;
                while (j <= nrx) {
                    pwRes.printf("%7d ", kitp[i][j][k]);
                    ++j;
                }
                pwRes.println();
                --i;
            }
            ++k;
        }
    }

    public static void reorder() {
        int ktj;
        int j;
        double[] b = new double[10000001];
        int[] jb = new int[10000001];
        int[] nb = new int[10001];
        double[] rbs = new double[10001];
        double adit = (float)Tomo3d.MODINV.itot / (float)Tomo3d.MODINV.nod;
        pwLog.printf(" Before REORDER: \n", new Object[0]);
        pwLog.printf("   Number of data : %8d\n", Tomo3d.MODINV.nod);
        pwLog.printf("   Number of non-zero elements in A : %15d\n", Tomo3d.MODINV.itot);
        pwLog.printf("   Number of non-zero elements/per ray : %7.2f\n", adit);
        Tomo3d.MODINV.noueq = 0;
        if (Tomo3d.MODINV.neq4 != 0) {
            j = 1;
            while (j <= Tomo3d.MODINV.neq4) {
                ktj = Tomo3d.MODINV.khit[j];
                Tomo3d.MODINV.jndex[j] = ktj >= 5 ? ++Tomo3d.MODINV.noueq : 0;
                ++j;
            }
        }
        int j1 = Tomo3d.MODINV.neq4 + 1;
        int j2 = Tomo3d.MODINV.neq4 + Tomo3d.GRINET.nodetot;
        Tomo3d.MODINV.nou = Tomo3d.MODINV.noueq;
        j = j1;
        while (j <= j2) {
            ktj = Tomo3d.MODINV.khit[j];
            Tomo3d.MODINV.jndex[j] = ktj >= Tomo3d.CONTRL.nhitct ? ++Tomo3d.MODINV.nou : 0;
            ++j;
        }
        int nougd = Tomo3d.MODINV.nou - Tomo3d.MODINV.noueq;
        int id = 0;
        int ju = 0;
        int l2 = 0;
        int i = 1;
        while (i <= Tomo3d.MODINV.nod) {
            int l1 = l2 + 1;
            l2 += Tomo3d.MODINV.na[i];
            int jj = 0;
            int l = l1;
            while (l <= l2) {
                int jl = Tomo3d.MODINV.ja[l];
                int jnk = Tomo3d.MODINV.jndex[jl];
                if (jnk != 0) {
                    ++jj;
                    jb[++ju] = jnk;
                    b[ju] = Tomo3d.MODINV.a[l];
                }
                ++l;
            }
            if (jj != 0) {
                nb[++id] = jj;
                rbs[id] = Tomo3d.MODINV.rds[i];
            }
            ++i;
        }
        Tomo3d.MODINV.nod = id;
        Tomo3d.MODINV.itot = ju;
        i = 1;
        while (i <= Tomo3d.MODINV.nod) {
            Tomo3d.MODINV.na[i] = nb[i];
            Tomo3d.MODINV.rds[i] = rbs[i];
            ++i;
        }
        i = 1;
        while (i <= Tomo3d.MODINV.itot) {
            Tomo3d.MODINV.ja[i] = jb[i];
            Tomo3d.MODINV.a[i] = b[i];
            ++i;
        }
        int neq = Tomo3d.MODINV.noueq / 4;
        pwLog.printf(" After REORDER :\n", new Object[0]);
        pwLog.printf("   Number of data :%8d\n", Tomo3d.MODINV.nod);
        pwLog.printf("   Number of Eq.  unknowns : %8d\n", Tomo3d.MODINV.noueq);
        pwLog.printf("   Number of Eq.  in A     : %5d\n", neq);
        pwLog.printf("   Number of grid unknowns : %8d\n", nougd);
        pwLog.printf("   Number of non-zero elements in A : %15d\n", Tomo3d.MODINV.itot);
    }

    public static void lsqr(int m, int n, double damp, double[] u, double[] v, double[] w, double[] x, double[] se, double atol, double btol, double conlim, int itmax, int[] istop, double[] anorm, double[] acond, double[] rnorm, double[] arnorm, double[] xnorm) {
        double[] beta = new double[1];
        double[] alfa = new double[1];
        pwLog.printf("\n\n                         LSQR   --   Least-squares solution of  A*X = B\n", new Object[0]);
        pwLog.printf("\n                         The matrix  A  has %d rows and %d cols\n", m, n);
        pwLog.printf("                         The damping parameter is DAMP = %10.2f\n", damp);
        pwLog.printf("\n                         ATOL = %10.2f           CONLIM = %10.2f\n", atol, conlim);
        pwLog.printf("\n                         BTOL = %10.2f           ITMAX  = %10d\n", btol, itmax);
        double zero = 0.0;
        double one = 1.0;
        double ctol = zero;
        if (conlim > zero) {
            ctol = one / conlim;
        }
        double dampsq = damp * damp;
        anorm[0] = zero;
        acond[0] = zero;
        double bbnorm = zero;
        double ddnorm = zero;
        double res2 = zero;
        xnorm[0] = zero;
        double xxnorm = zero;
        double cs2 = -one;
        double sn2 = zero;
        double z = zero;
        int itn = 0;
        istop[0] = 0;
        int nstop = 0;
        int i = 1;
        while (i <= n) {
            v[i] = zero;
            x[i] = zero;
            se[i] = zero;
            ++i;
        }
        Tomo3d.normlz(m, u, beta);
        Tomo3d.aprod(2, m, n, v, u);
        Tomo3d.normlz(n, v, alfa);
        i = 1;
        while (i <= n) {
            w[i] = v[i];
            ++i;
        }
        double rhobar = alfa[0];
        double phibar = beta[0];
        double bnorm = beta[0];
        rnorm[0] = beta[0];
        arnorm[0] = alfa[0] * beta[0];
        if (arnorm[0] > zero) {
            double t;
            if (dampsq <= zero) {
                pwLog.printf("\n\n   ITN         X(1)              FUNCTION       COMPATIBLE INCOMPATIBLE    NORM(A) COND(A)\n", new Object[0]);
            }
            if (dampsq > zero) {
                pwLog.printf("\n\n   ITN         X(1)              FUNCTION       COMPATIBLE INCOMPATIBLE NORM(ABAR) COND(ABAR)\n", new Object[0]);
            }
            double test1 = one;
            double test2 = alfa[0] / beta[0];
            pwLog.printf("%6d %20.10f %19.10f %13.3f %13.3f\n", itn, x[1], rnorm[0], test1, test2);
            pwLog.println();
            while (true) {
                ++itn;
                double af = -alfa[0];
                i = 1;
                while (i <= m) {
                    u[i] = af * u[i];
                    ++i;
                }
                Tomo3d.aprod(1, m, n, v, u);
                Tomo3d.normlz(m, u, beta);
                bbnorm = bbnorm + alfa[0] * alfa[0] + beta[0] * beta[0] + dampsq;
                double bt = -beta[0];
                i = 1;
                while (i <= n) {
                    v[i] = bt * v[i];
                    ++i;
                }
                Tomo3d.aprod(2, m, n, v, u);
                Tomo3d.normlz(n, v, alfa);
                double rhbar2 = rhobar * rhobar + dampsq;
                double rhbar1 = Math.sqrt(rhbar2);
                double cs1 = rhobar / rhbar1;
                double sn1 = damp / rhbar1;
                double psi = sn1 * phibar;
                phibar = cs1 * phibar;
                double rho = Math.sqrt(rhbar2 + beta[0] * beta[0]);
                double cs = rhbar1 / rho;
                double sn = beta[0] / rho;
                double theta = sn * alfa[0];
                rhobar = -cs * alfa[0];
                double phi = cs * phibar;
                phibar = sn * phibar;
                double tau = sn * phi;
                double t1 = phi / rho;
                double t2 = -theta / rho;
                double t3 = one / rho;
                i = 1;
                while (i <= n) {
                    t = w[i];
                    x[i] = t1 * t + x[i];
                    w[i] = t2 * t + v[i];
                    double t3t = t3 * t;
                    t = t3t * t3t;
                    se[i] = t + se[i];
                    ddnorm = t + ddnorm;
                    ++i;
                }
                double delta = sn2 * rho;
                double gambar = -cs2 * rho;
                double rhs = phi - delta * z;
                double zbar = rhs / gambar;
                xnorm[0] = Math.sqrt(xxnorm + zbar * zbar);
                double gamma = Math.sqrt(gambar * gambar + theta * theta);
                cs2 = gambar / gamma;
                sn2 = theta / gamma;
                z = rhs / gamma;
                xxnorm += z * z;
                anorm[0] = Math.sqrt(bbnorm);
                acond[0] = anorm[0] * Math.sqrt(ddnorm);
                double res1 = phibar * phibar;
                rnorm[0] = Math.sqrt(res1 + (res2 += psi * psi));
                arnorm[0] = alfa[0] * Math.abs(tau);
                test1 = rnorm[0] / bnorm;
                test2 = arnorm[0] / (anorm[0] * rnorm[0]);
                double test3 = one / acond[0];
                t1 = test1 / (one + anorm[0] * xnorm[0] / bnorm);
                double rtol = btol + atol * anorm[0] * xnorm[0] / bnorm;
                t3 = one + test3;
                t2 = one + test2;
                t1 = one + t1;
                pwLog.printf("%4d %12.6f %12.6f %12.6f %12.6f %10.3f\n", itn, x[1], x[2], x[3], x[4], rnorm[0]);
                if (itn < 60) continue;
                if (itn >= itmax) {
                    istop[0] = 7;
                }
                if (t3 <= one) {
                    istop[0] = 6;
                }
                if (t2 <= one) {
                    istop[0] = 5;
                }
                if (t1 <= one) {
                    istop[0] = 4;
                }
                if (test3 <= ctol) {
                    istop[0] = 3;
                }
                if (test2 <= atol) {
                    istop[0] = 2;
                }
                if (test1 <= rtol) {
                    istop[0] = 1;
                }
                boolean gotoL600 = false;
                if (!(m <= 40 || n <= 40 || itn <= 10 || itn >= itmax - 10 || itn % 10 == 0 || test3 <= 2.0 * ctol || test2 <= 10.0 * atol || test1 <= 10.0 * rtol)) {
                    gotoL600 = true;
                }
                if (!gotoL600 && itn % 10 == 0) {
                    pwLog.println();
                }
                if (istop[0] == 0) {
                    nstop = 0;
                }
                if (istop[0] == 0) continue;
                int nconv = 1;
                if (++nstop < nconv && itn < itmax) {
                    istop[0] = 0;
                }
                if (istop[0] != 0) break;
            }
            t = one;
            if (m > n) {
                t = m - n;
            }
            if (dampsq > zero) {
                t = m;
            }
            t = rnorm[0] / Math.sqrt(t);
            i = 1;
            while (i <= n) {
                se[i] = t * Math.sqrt(se[i]);
                ++i;
            }
        }
        pwLog.printf("\n No. of iterations =%6d         Stopping condition =%3d\n", itn, istop[0]);
        if (istop[0] == 0) {
            pwLog.printf("\n The exact solution is  x = 0.\n", new Object[0]);
        }
        if (istop[0] == 1) {
            pwLog.printf("\n a*x - b  is small enough, given  atol, btol\n", new Object[0]);
        }
        if (istop[0] == 2) {
            pwLog.printf("\n The least-sqrs solu is good enough, given  atol\n", new Object[0]);
        }
        if (istop[0] == 3) {
            pwLog.printf("\n The estimate of  cond(abar)  has exceeded  conlim\n", new Object[0]);
        }
        if (istop[0] == 4) {
            pwLog.printf("\n a*x - b  is small enough for this machine\n", new Object[0]);
        }
        if (istop[0] == 5) {
            pwLog.printf("\n The least-sqrs solu is good enough for this machine\n", new Object[0]);
        }
        if (istop[0] == 6) {
            pwLog.printf("\n Cond(abar)  seems to be too large for this machine\n", new Object[0]);
        }
        if (istop[0] == 7) {
            pwLog.printf("\n The iteration limit has been reached\n", new Object[0]);
        }
    }

    public static void normlz(int n, double[] x, double[] s) {
        double eps = 1.0E-10;
        s[0] = 0.0;
        int i = 1;
        while (i <= n) {
            double xi = x[i];
            s[0] = s[0] + xi * xi;
            ++i;
        }
        s[0] = Math.sqrt(s[0]);
        double ss = 0.0;
        if (s[0] > eps) {
            ss = 1.0 / s[0];
        }
        i = 1;
        while (i <= n) {
            x[i] = x[i] * ss;
            ++i;
        }
    }

    public static void aprod(int mode, int m, int n, double[] x, double[] y) {
        double zero = 0.0;
        int l2 = 0;
        if (mode != 1) {
            int i = 1;
            while (i <= m) {
                double yi = y[i];
                int l1 = l2 + 1;
                l2 += Tomo3d.MODINV.na[i];
                int l = l1;
                while (l <= l2) {
                    int j = Tomo3d.MODINV.ja[l];
                    x[j] = x[j] + Tomo3d.MODINV.a[l] * yi;
                    ++l;
                }
                ++i;
            }
            return;
        }
        int i = 1;
        while (i <= m) {
            double sum = zero;
            int l1 = l2 + 1;
            l2 += Tomo3d.MODINV.na[i];
            int l = l1;
            while (l <= l2) {
                int j = Tomo3d.MODINV.ja[l];
                sum += Tomo3d.MODINV.a[l] * x[j];
                ++l;
            }
            y[i] = y[i] + sum;
            ++i;
        }
    }

    public static void travt(double pe, double re, double dep, double ps, double rs, double hs, int kps, int nstn, double[] hlae, int lay, double tacc, int nitpb, double po, double[] del, double[] az, double[] ve, double[] fst) {
        double dt0;
        int[] lps = new int[1];
        int[] numsg = new int[1];
        int[] numsga = new int[1];
        double[] hlas = new double[3];
        int[] ns = new int[6];
        double[][] pa = new double[6][201];
        double[][] ra = new double[6][201];
        double[][] ha = new double[6][201];
        double[][] va = new double[6][201];
        double[][] p = new double[6][201];
        double[][] r = new double[6][201];
        double[][] h = new double[6][201];
        double[][] v = new double[6][201];
        int[] ih = new int[6];
        int[] iv = new int[6];
        int[] nsa = new int[6];
        int[] iva = new int[6];
        int[] iha = new int[6];
        double[] fst1 = new double[1];
        double[] fst2 = new double[1];
        int i = 1;
        while (i <= 2) {
            hlas[i] = Tomo3d.HLASTA.hlss[nstn][i];
            ++i;
        }
        Tomo3d.conaz(re, pe, rs, ps, del, az);
        if (lay == 1) {
            double dt1;
            Tomo3d.wvtype(del[0], kps, lps);
            if (lps[0] == 1) {
                Tomo3d.beeline(pe, re, dep, ps, rs, hs, kps, ve, fst);
                return;
            }
            if (lps[0] == 6 || lps[0] == 7) {
                int ihead = lps[0] - 5;
                Tomo3d.find(pe, re, dep, ps, rs, hs, kps, lay, ihead, hlae, hlas, numsg, ns, p, r, h, v, ih, iv, tacc, nitpb, fst);
            } else if (lps[0] == 11) {
                Tomo3d.beeline(pe, re, dep, ps, rs, hs, kps, ve, fst);
                Tomo3d.find(pe, re, dep, ps, rs, hs, kps, lay, 1, hlae, hlas, numsg, ns, p, r, h, v, ih, iv, tacc, nitpb, fst1);
                dt0 = Math.abs(po - fst[0]);
                dt1 = Math.abs(po - fst1[0]);
                if (dt0 <= dt1) {
                    return;
                }
                if (dt0 > dt1) {
                    fst[0] = fst1[0];
                }
            } else if (lps[0] == 12) {
                Tomo3d.find(pe, re, dep, ps, rs, hs, kps, lay, 1, hlae, hlas, numsg, ns, p, r, h, v, ih, iv, tacc, nitpb, fst);
                Tomo3d.find(pe, re, dep, ps, rs, hs, kps, lay, 2, hlae, hlas, numsga, nsa, pa, ra, ha, va, iha, iva, tacc, nitpb, fst1);
                dt0 = Math.abs(po - fst[0]);
                dt1 = Math.abs(po - fst1[0]);
                if (dt1 <= dt0) {
                    Tomo3d.eq3(fst1[0], numsga[0], nsa, pa, ra, ha, va, iha, iva, fst, numsg, ns, p, r, h, v, ih, iv);
                }
            }
        } else if (lay == 2) {
            Tomo3d.wvtype(del[0], kps, lps);
            if (lps[0] == 1 || lps[0] == 6) {
                Tomo3d.find(pe, re, dep, ps, rs, hs, kps, lay, 0, hlae, hlas, numsg, ns, p, r, h, v, ih, iv, tacc, nitpb, fst);
            } else if (lps[0] == 7) {
                Tomo3d.find(pe, re, dep, ps, rs, hs, kps, lay, 2, hlae, hlas, numsg, ns, p, r, h, v, ih, iv, tacc, nitpb, fst);
            } else {
                Tomo3d.find(pe, re, dep, ps, rs, hs, kps, lay, 0, hlae, hlas, numsg, ns, p, r, h, v, ih, iv, tacc, nitpb, fst);
                Tomo3d.find(pe, re, dep, ps, rs, hs, kps, lay, 2, hlae, hlas, numsga, nsa, pa, ra, ha, va, iha, iva, tacc, nitpb, fst2);
                dt0 = Math.abs(po - fst[0]);
                double dt2 = Math.abs(po - fst2[0]);
                if (dt2 < dt0) {
                    Tomo3d.eq3(fst2[0], numsga[0], nsa, pa, ra, ha, va, iha, iva, fst, numsg, ns, p, r, h, v, ih, iv);
                }
            }
        } else if (lay == 3) {
            Tomo3d.find(pe, re, dep, ps, rs, hs, kps, lay, 0, hlae, hlas, numsg, ns, p, r, h, v, ih, iv, tacc, nitpb, fst);
        }
        int na = ns[numsg[0]];
        ve[0] = v[numsg[0]][na];
        Tomo3d.RAYLOC.nrp = 0;
        i = 1;
        while (i <= numsg[0]) {
            int ii = ns[i] - 1;
            if (i == numsg[0]) {
                ii = ns[i];
            }
            int j = 1;
            while (j <= ii) {
                ++Tomo3d.RAYLOC.nrp;
                Tomo3d.RAYLOC.rp[1][Tomo3d.RAYLOC.nrp] = p[i][j];
                Tomo3d.RAYLOC.rp[2][Tomo3d.RAYLOC.nrp] = r[i][j];
                Tomo3d.RAYLOC.rp[3][Tomo3d.RAYLOC.nrp] = h[i][j];
                Tomo3d.RAYLOC.ivk[Tomo3d.RAYLOC.nrp] = iv[i];
                Tomo3d.RAYLOC.iwk[Tomo3d.RAYLOC.nrp] = i;
                ++j;
            }
            ++i;
        }
    }

    public static void wvtype(double del, int kps, int[] lps) {
        double dg = 80.0;
        double dk = 120.0;
        double dn = 160.0;
        lps[0] = kps;
        if (kps >= 3 && kps <= 7) {
            return;
        }
        if (kps == 2) {
            dn = 180.0;
        }
        lps[0] = del < 80.0 ? 1 : (del >= 80.0 && del < 120.0 ? 11 : (del >= 120.0 && del < dn ? 12 : 7));
    }

    public static void find(double pe, double re, double dep, double ps, double rs, double hs, int kps, int lay, int ihead, double[] hlae, double[] hlas, int[] numsg, int[] ns, double[][] p, double[][] r, double[][] h, double[][] v, int[] ih, int[] iv, double tacc, int nitpb, double[] fst) {
        double[][] pg = new double[6][201];
        double[][] rg = new double[6][201];
        double[][] hg = new double[6][201];
        double[][] vg = new double[6][201];
        Tomo3d.inipath(pe, re, dep, ps, rs, hs, kps, lay, ihead, hlae, hlas, numsg, pg, rg, hg, vg, ih, iv);
        Tomo3d.minima(numsg[0], pg, rg, hg, vg, ns, p, r, h, v, ih, iv, kps, tacc, nitpb, fst);
    }

    public static void inipath(double pe, double re, double dep, double ps, double rs, double hs, int kps, int lay, int ihead, double[] hlae, double[] hlas, int[] numsg, double[][] p, double[][] r, double[][] h, double[][] v, int[] ih, int[] iv) {
        double h1 = 0.0;
        double h2 = 0.0;
        double[] v1 = new double[1];
        double[] v2 = new double[1];
        if (ihead == 0) {
            numsg[0] = lay;
            int j = 1;
            while (j <= numsg[0]) {
                int i = j - 1;
                if (j == 1) {
                    h1 = hs;
                }
                if (j > 1) {
                    h1 = hlas[i];
                }
                if (j < numsg[0]) {
                    h2 = hlas[j];
                }
                if (j == numsg[0]) {
                    h2 = dep;
                }
                int ips = Tomo3d.RAYPATH.iwv[kps][j];
                int jj = j;
                Tomo3d.vel3(ps, rs, h1, v1, jj, ips);
                Tomo3d.vel3(ps, rs, h2, v2, jj, ips);
                p[j][1] = ps;
                r[j][1] = rs;
                h[j][1] = h1;
                v[j][1] = v1[0];
                p[j][2] = ps;
                r[j][2] = rs;
                h[j][2] = h2;
                v[j][2] = v2[0];
                if (j == numsg[0]) {
                    Tomo3d.vel3(pe, re, dep, v2, jj, ips);
                    p[j][2] = pe;
                    r[j][2] = re;
                    h[j][2] = dep;
                    v[j][2] = v2[0];
                }
                ih[j] = j;
                iv[j] = j;
                ++j;
            }
        } else {
            int ips;
            numsg[0] = 2 * ihead - lay + 2;
            int j = 1;
            while (j <= ihead) {
                int i = j - 1;
                if (j == 1) {
                    h1 = hs;
                }
                if (j > 1) {
                    h1 = hlas[i];
                }
                h2 = hlas[j];
                ips = Tomo3d.RAYPATH.iwv[kps][j];
                int jj = j;
                Tomo3d.vel3(ps, rs, h1, v1, jj, ips);
                Tomo3d.vel3(ps, rs, h2, v2, jj, ips);
                p[j][1] = ps;
                r[j][1] = rs;
                h[j][1] = h1;
                v[j][1] = v1[0];
                p[j][2] = ps;
                r[j][2] = rs;
                h[j][2] = h2;
                v[j][2] = v2[0];
                ih[j] = j;
                iv[j] = j;
                ++j;
            }
            int ihe = ihead + 1;
            h1 = hlas[ihead];
            h2 = hlae[ihead];
            ips = Tomo3d.RAYPATH.iwv[kps][ihe];
            Tomo3d.vel3(ps, rs, h1, v1, ihe, ips);
            Tomo3d.vel3(ps, rs, h2, v2, ihe, ips);
            p[ihe][1] = ps;
            r[ihe][1] = rs;
            h[ihe][1] = h1;
            v[ihe][1] = v1[0];
            p[ihe][2] = ps;
            r[ihe][2] = rs;
            h[ihe][2] = h2;
            v[ihe][2] = v2[0];
            iv[ihe] = ihe;
            ih[ihe] = ihead;
            int ihea = numsg[0] - ihe;
            int j2 = 1;
            while (j2 <= ihea) {
                int j1 = ihead - j2 + 1;
                int j22 = j1 - 1;
                int j3 = ihe + j2;
                h1 = hlae[j1];
                if (j22 == 0) {
                    h2 = dep;
                }
                if (j22 > 0) {
                    h2 = hlae[j22];
                }
                if (j2 == ihea) {
                    h2 = dep;
                }
                ips = Tomo3d.RAYPATH.iwv[kps][j3];
                Tomo3d.vel3(pe, re, h1, v1, j1, ips);
                Tomo3d.vel3(pe, re, h2, v2, j1, ips);
                p[j3][1] = pe;
                r[j3][1] = re;
                h[j3][1] = h1;
                v[j3][1] = v1[0];
                p[j3][2] = pe;
                r[j3][2] = re;
                h[j3][2] = h2;
                v[j3][2] = v2[0];
                if (j22 == 0) {
                    j22 = 1;
                }
                iv[j3] = j1;
                ih[j3] = j22;
                ++j2;
            }
        }
    }

    public static void minima(int numsg, double[][] pg, double[][] rg, double[][] hg, double[][] vg, int[] ns, double[][] p, double[][] r, double[][] h, double[][] v, int[] ih, int[] iv, int kps, double tacc, int nitpb, double[] fstime) {
        int[] nsg = new int[6];
        double[] sleng = new double[6];
        double[] p2 = new double[1];
        double[] r2 = new double[1];
        double[] h2 = new double[1];
        double[] v2 = new double[1];
        double[] vm = new double[1];
        double[] t1 = new double[1];
        double[] t2 = new double[1];
        double[] t3 = new double[1];
        double[] t4 = new double[1];
        int i = 1;
        while (i <= numsg) {
            ns[i] = 2;
            nsg[i] = 2;
            ++i;
        }
        Tomo3d.eq2(numsg, ns, pg, rg, hg, vg, p, r, h, v);
        Tomo3d.travel(numsg, ns, p, r, h, v, sleng, fstime);
        int lmn = numsg * 2;
        int kmn = 2;
        int itera = 0;
        boolean gotoL2 = true;
        block1: while (true) {
            double dt;
            int ii;
            int j;
            double fst;
            if (!gotoL2) {
                gotoL2 = false;
                if (++itera >= nitpb) {
                    return;
                }
                fst = fstime[0];
                i = 1;
                while (i <= 2) {
                    j = 1;
                    while (j <= 2) {
                        p[i][j] = pg[i][j];
                        r[i][j] = rg[i][j];
                        h[i][j] = hg[i][j];
                        v[i][j] = vg[i][j];
                        ++j;
                    }
                    ++i;
                }
                j = 1;
                while (j <= numsg) {
                    nsg[j] = ns[j];
                    if (iv[j] > 2 && !(sleng[j] <= 5.0)) {
                        ns[j] = 2 * nsg[j] - 1;
                        int lp = nsg[j];
                        int lq = ns[j];
                        p[j][lq] = pg[j][lp];
                        r[j][lq] = rg[j][lp];
                        h[j][lq] = hg[j][lp];
                        v[j][lq] = vg[j][lp];
                        int ivj = iv[j];
                        int iwj = Tomo3d.RAYPATH.iwv[kps][j];
                        i = 1;
                        while (i <= lp - 1) {
                            ii = i + 1;
                            int i2 = 2 * i;
                            int i3 = 2 * i - 1;
                            p[j][i3] = pg[j][i];
                            r[j][i3] = rg[j][i];
                            h[j][i3] = hg[j][i];
                            v[j][i3] = vg[j][i];
                            Tomo3d.midpot(pg[j][i], rg[j][i], hg[j][i], pg[j][ii], rg[j][ii], hg[j][ii], p2, r2, h2);
                            Tomo3d.vel3(p2[0], r2[0], h2[0], v2, ivj, iwj);
                            p[j][i2] = p2[0];
                            r[j][i2] = r2[0];
                            h[j][i2] = h2[0];
                            v[j][i2] = v2[0];
                            ++i;
                        }
                    }
                    ++j;
                }
                Tomo3d.travel(numsg, ns, p, r, h, v, sleng, fstime);
                dt = Math.abs(fst - fstime[0]);
                lmn = 0;
                i = 1;
                while (i <= numsg) {
                    lmn += ns[i];
                    ++i;
                }
                if (lmn >= 200 || lmn > 50 && dt <= tacc) {
                    return;
                }
                Tomo3d.eq2(numsg, ns, p, r, h, v, pg, rg, hg, vg);
            }
            gotoL2 = false;
            kmn = lmn / numsg;
            j = 1;
            while (true) {
                if (j > 6) continue block1;
                fst = fstime[0];
                i = 1;
                while (i <= numsg) {
                    int ia = i;
                    int m = i + 1;
                    ii = ns[i];
                    int k = 2;
                    while (k <= ii) {
                        if (i != numsg || k != ii) {
                            int kk = k - 1;
                            int kj = k + 1;
                            if (k < ii) {
                                t1[0] = p[i][k];
                                t2[0] = r[i][k];
                                t3[0] = h[i][k];
                                t4[0] = v[i][k];
                                Tomo3d.bend(p[i][kk], r[i][kk], h[i][kk], v[i][kk], p[i][kj], r[i][kj], h[i][kj], v[i][kj], t1, t2, t3, t4, iv[i], ia, kps);
                                p[i][k] = t1[0];
                                r[i][k] = t2[0];
                                h[i][k] = t3[0];
                                v[i][k] = t4[0];
                            } else {
                                int ivi = iv[i];
                                int ivm = iv[m];
                                if (ivi > ivm) {
                                    t1[0] = p[i][k];
                                    t2[0] = r[i][k];
                                    t3[0] = h[i][k];
                                    t4[0] = v[i][k];
                                    Tomo3d.snell(p[i][kk], r[i][kk], h[i][kk], v[i][kk], iv[i], ia, p[m][2], r[m][2], h[m][2], v[m][2], iv[m], m, ih[i], kps, t1, t2, t3, t4, vm);
                                    p[i][k] = t1[0];
                                    r[i][k] = t2[0];
                                    h[i][k] = t3[0];
                                    v[i][k] = t4[0];
                                } else if (ivi < ivm) {
                                    t1[0] = p[i][k];
                                    t2[0] = r[i][k];
                                    t3[0] = h[i][k];
                                    t4[0] = v[i][k];
                                    Tomo3d.snell(p[m][2], r[m][2], h[m][2], v[m][2], iv[m], m, p[i][kk], r[i][kk], h[i][kk], v[i][kk], iv[i], ia, ih[i], kps, t1, t2, t3, vm, t4);
                                    p[i][k] = t1[0];
                                    r[i][k] = t2[0];
                                    h[i][k] = t3[0];
                                    v[i][k] = t4[0];
                                }
                                p[m][1] = p[i][k];
                                r[m][1] = r[i][k];
                                h[m][1] = h[i][k];
                                v[m][1] = vm[0];
                            }
                        }
                        ++k;
                    }
                    ++i;
                }
                Tomo3d.travel(numsg, ns, p, r, h, v, sleng, fstime);
                dt = fst - fstime[0];
                if (kmn <= 2 && j <= 5 || dt > 0.0) {
                    Tomo3d.eq2(numsg, ns, p, r, h, v, pg, rg, hg, vg);
                    if ((kmn > 2 || j > 5) && dt < tacc) {
                        continue block1;
                    }
                } else {
                    fstime[0] = fst;
                    continue block1;
                }
                ++j;
            }
            break;
        }
    }

    public static void bend(double a1, double b1, double h1, double v1, double a3, double b3, double h3, double v3, double[] a2, double[] b2, double[] h2, double[] v2, int iv, int iw, int kps) {
        double xfac = 1.15;
        double hmaxm = 1000.0;
        int iww = Tomo3d.RAYPATH.iwv[kps][iw];
        double r1 = Tomo3d.RAYPATH.r0 - h1;
        double r3 = Tomo3d.RAYPATH.r0 - h3;
        double sia1 = Math.sin(a1);
        double sia3 = Math.sin(a3);
        double x1 = r1 * sia1 * Math.cos(b1);
        double y1 = r1 * sia1 * Math.sin(b1);
        double z1 = r1 * Math.cos(a1);
        double x3 = r3 * sia3 * Math.cos(b3);
        double y3 = r3 * sia3 * Math.sin(b3);
        double z3 = r3 * Math.cos(a3);
        double dx = x3 - x1;
        double dy = y3 - y1;
        double dz = z3 - z1;
        double x2 = x1 + dx / 2.0;
        double y2 = y1 + dy / 2.0;
        double z2 = z1 + dz / 2.0;
        double r2 = Math.sqrt(x2 * x2 + y2 * y2 + z2 * z2);
        a2[0] = Math.acos(z2 / r2);
        double sina = Math.sin(a2[0]);
        b2[0] = Math.atan2(y2, x2);
        h2[0] = Tomo3d.RAYPATH.r0 - r2;
        Tomo3d.vel3(a2[0], b2[0], h2[0], v2, iv, iww);
        double[] va = new double[1];
        double[] vb = new double[1];
        double[] vh = new double[1];
        Tomo3d.veld(a2[0], b2[0], h2[0], va, vb, vh, iv, iww);
        double vr = -vh[0];
        double dn = dx * dx + dy * dy + dz * dz;
        double ddn = Math.sqrt(dn);
        double dr = (r3 - r1) / ddn;
        double da = (a3 - a1) / ddn;
        double db = (b3 - b1) / ddn;
        double pr = dr;
        double pa = r2 * da;
        double pb = r2 * sina * db;
        double vrd = pr * vr + pa * va[0] + pb * vb[0];
        double rvr = vr - vrd * pr;
        double rva = va[0] - vrd * pa;
        double rvb = vb[0] - vrd * pb;
        double rvs = Math.sqrt(rvr * rvr + rva * rva + rvb * rvb);
        if (rvs == 0.0) {
            return;
        }
        double cc = (1.0 / v1 + 1.0 / v3) / 2.0;
        double rcur = vr * (rvr /= rvs) + va[0] * (rva /= rvs) + vb[0] * (rvb /= rvs);
        rcur = (cc * v2[0] + 1.0) / (4.0 * cc * rcur);
        rcur = -rcur + Math.sqrt(rcur * rcur + dn / (8.0 * cc * v2[0]));
        double rdr = rvr * rcur;
        double rda = rva * rcur;
        double rdb = rvb * rcur;
        double rp = r2 + rdr;
        double ap = a2[0] + rda / r2;
        double bp = b2[0] + rdb / (r2 * sina);
        r2 = (rp - r2) * xfac + r2;
        a2[0] = (ap - a2[0]) * xfac + a2[0];
        b2[0] = (bp - b2[0]) * xfac + b2[0];
        h2[0] = Tomo3d.RAYPATH.r0 - r2;
        Tomo3d.limit(0.0, hmaxm, h2);
        Tomo3d.vel3(a2[0], b2[0], h2[0], v2, iv, iww);
    }

    public static void length(double pe, double re, double he, double ps, double rs, double hs, double[] ds) {
        double r0 = 6371.0;
        double r0e = r0 - he;
        double r0s = r0 - hs;
        double sinpe = Math.sin(pe);
        double sinps = Math.sin(ps);
        double xe = r0e * sinpe * Math.cos(re);
        double ye = r0e * sinpe * Math.sin(re);
        double ze = r0e * Math.cos(pe);
        double xs = r0s * sinps * Math.cos(rs);
        double ys = r0s * sinps * Math.sin(rs);
        double zs = r0s * Math.cos(ps);
        double dx = xe - xs;
        double dy = ye - ys;
        double dz = ze - zs;
        ds[0] = dx * dx + dy * dy + dz * dz;
        ds[0] = Math.sqrt(ds[0]);
    }

    public static void veld(double pe, double re, double he, double[] vp, double[] vr, double[] vh, int lay, int ips) {
        vp[0] = 0.0;
        vr[0] = 0.0;
        vh[0] = 0.0;
        if (lay <= 2) {
            return;
        }
        double dh = 5.0;
        double h1 = he - dh;
        double h2 = he + dh;
        double[] v1 = new double[1];
        double[] v2 = new double[1];
        Tomo3d.vel3(pe, re, h1, v1, lay, ips);
        Tomo3d.vel3(pe, re, h2, v2, lay, ips);
        vh[0] = (v2[0] - v1[0]) / (h2 - h1);
    }

    public static void snell(double pe, double re, double he, double ve, int ive, int iwe, double ps, double rs, double hs, double vs, int ivs, int iws, int ih, int kps, double[] pl, double[] rl, double[] hl, double[] vel, double[] vsl) {
        double pi = Math.PI;
        double[] h0 = new double[1];
        Tomo3d.midpot(pe, re, he, ps, rs, hs, pl, rl, h0);
        Tomo3d.hlay(pl[0], rl[0], hl, ih);
        int iwve = Tomo3d.RAYPATH.iwv[kps][iwe];
        int iwvs = Tomo3d.RAYPATH.iwv[kps][iws];
        Tomo3d.vel3(pl[0], rl[0], hl[0], vel, ive, iwve);
        Tomo3d.vel3(pl[0], rl[0], hl[0], vsl, ivs, iwvs);
        double[] del = new double[1];
        double[] az = new double[1];
        Tomo3d.conaz(re, pe, rs, ps, del, az);
        if (del[0] < Tomo3d.RAYPATH.eps) {
            return;
        }
        double[] hel = new double[1];
        double[] hsl = new double[1];
        Tomo3d.hlay(pe, re, hel, ih);
        Tomo3d.hlay(ps, rs, hsl, ih);
        double dh = hel[0] - hsl[0];
        double bz = az[0] + pi;
        double azs = az[0];
        double aze = bz;
        if (dh <= 0.0) {
            azs = bz;
            aze = az[0];
        }
        double tanp = Math.abs(dh) * (1.0 + 0.5 * hl[0] / Tomo3d.RAYPATH.r0) / del[0];
        double thp = Math.atan(tanp);
        double de = Math.abs(he - hel[0]) * tanp / (Tomo3d.RAYPATH.r0 - hel[0]);
        double ds = Math.abs(hsl[0] - hs) * tanp / (Tomo3d.RAYPATH.r0 - hsl[0]);
        double[] ree = new double[1];
        double[] pee = new double[1];
        double[] rss = new double[1];
        double[] pss = new double[1];
        double[] hee = new double[1];
        double[] hss = new double[1];
        Tomo3d.azin(pe, re, de, aze, ree, pee);
        Tomo3d.azin(ps, rs, ds, azs, rss, pss);
        Tomo3d.hlay(pee[0], ree[0], hee, ih);
        Tomo3d.hlay(pss[0], rss[0], hss, ih);
        double[] d = new double[1];
        Tomo3d.length(pee[0], ree[0], hee[0], pss[0], rss[0], hss[0], d);
        double azes = az[0];
        double cthp = Math.cos(thp);
        double s1 = Math.abs(he - hel[0]) * cthp;
        double s2 = Math.abs(hsl[0] - hs) * cthp;
        double sx = 0.001;
        int k = 1;
        while (k <= 3) {
            double v1 = (ve + vel[0]) * 0.5;
            double v2 = (vs + vsl[0]) * 0.5;
            double[] x = new double[1];
            Tomo3d.faspo(s1, s2, d[0], v1, v2, x);
            double dx = 0.2 * d[0];
            double ax = Math.min(sx, dx);
            if (x[0] <= ax) {
                x[0] = ax;
            }
            double xc = x[0] * cthp / (Tomo3d.RAYPATH.r0 - hl[0]);
            Tomo3d.azin(pee[0], ree[0], xc, azes, rl, pl);
            Tomo3d.limit(pee[0], pss[0], pl);
            Tomo3d.limit(ree[0], rss[0], rl);
            Tomo3d.hlay(pl[0], rl[0], hl, ih);
            Tomo3d.vel3(pl[0], rl[0], hl[0], vsl, ivs, iwvs);
            Tomo3d.vel3(pl[0], rl[0], hl[0], vel, ive, iwve);
            ++k;
        }
    }

    public static void midpot(double p1, double r1, double h1, double p3, double r3, double h3, double[] p2, double[] r2, double[] h2) {
        double r0 = 6371.0;
        double[] del = new double[1];
        double[] az = new double[1];
        Tomo3d.conaz(r1, p1, r3, p3, del, az);
        double del2 = 0.5 * del[0] / r0;
        Tomo3d.azin(p1, r1, del2, az[0], r2, p2);
        h2[0] = (h1 + h3) * 0.5;
        double dh = (r0 - h2[0]) * (1.0 - Math.cos(del2));
        h2[0] = h2[0] + dh;
        Tomo3d.limit(0.0, 2888.0, h2);
    }

    public static void limit(double c1, double c2, double[] c) {
        double a1 = Math.min(c1, c2);
        double a2 = Math.max(c1, c2);
        if (c[0] < a1) {
            c[0] = a1;
        }
        if (c[0] > a2) {
            c[0] = a2;
        }
    }

    public static void travel(int numsg, int[] ns, double[][] p, double[][] r, double[][] h, double[][] v, double[] sleng, double[] fst) {
        double[] ds = new double[1];
        fst[0] = 0.0;
        int i = 1;
        while (i <= numsg) {
            sleng[i] = 0.0;
            int ii = ns[i];
            int j = 2;
            while (j <= ii) {
                int k = j - 1;
                Tomo3d.length(p[i][j], r[i][j], h[i][j], p[i][k], r[i][k], h[i][k], ds);
                double vij = v[i][j];
                double vik = v[i][k];
                fst[0] = fst[0] + ds[0] / vij + ds[0] / vik;
                sleng[i] = sleng[i] + ds[0];
                ++j;
            }
            sleng[i] = sleng[i] / ((double)ii - 1.0);
            ++i;
        }
        fst[0] = fst[0] * 0.5;
        if (fst[0] < 0.0) {
            fst[0] = 999.9;
        }
    }

    public static void faspo(double s1, double s2, double d, double v1, double v2, double[] x) {
        double dx;
        double eps = 1.0E-7;
        double dv = 0.0;
        if (Math.abs(s1 * s2) < eps) {
            double v12 = v1 / v2;
            if (v12 > 1.0) {
                v12 = 1.0 / v12;
            }
            dv = v12 / Math.sqrt(1.0 - v12 * v12);
            if (Math.abs(s1) < eps) {
                x[0] = d - s2 * dv;
            }
            if (Math.abs(s2) < eps) {
                x[0] = s1 * dv;
            }
            return;
        }
        double x1 = 0.0;
        double x2 = d;
        double[] y = new double[1];
        double[] f = new double[1];
        Tomo3d.fun(s1, s2, d, v1, v2, x1, y);
        int nk = 0;
        double xm = 0.0;
        do {
            ++nk;
            xm = (x1 + x2) * 0.5;
            Tomo3d.fun(s1, s2, d, v1, v2, xm, f);
            if (y[0] * f[0] < 0.0) {
                x2 = xm;
            } else {
                x1 = xm;
            }
            dx = Math.abs(x2 - x1);
        } while (nk <= 30 && dx > 0.05);
        x[0] = xm;
    }

    public static void fun(double s1, double s2, double d, double v1, double v2, double x, double[] y) {
        double dx = d - x;
        double d2 = dx * dx;
        double x2 = x * x;
        double y1 = v1 * v1 * d2 * (x2 + s1 * s1);
        double y2 = v2 * v2 * x2 * (d2 + s2 * s2);
        y[0] = y1 - y2;
    }

    public static void beeline(double pe, double re, double he, double ps, double rs, double hs, int kps, double[] ve, double[] fst) {
        double[] sl = new double[1];
        double[] v = new double[1];
        Tomo3d.length(pe, re, he, ps, rs, hs, sl);
        double stepl = 5.0;
        int nrp = (int)(sl[0] / stepl) + 2;
        int nrp1 = nrp - 1;
        double ab = 1.0 / (double)nrp1;
        double dp = (pe - ps) * ab;
        double dr = (re - rs) * ab;
        double dh = (he - hs) * ab;
        fst[0] = 0.0;
        int k1 = 0;
        while (k1 <= nrp1) {
            int k = k1 + 1;
            double c = k1;
            Tomo3d.RAYLOC.rp[1][k] = ps + dp * c;
            Tomo3d.RAYLOC.rp[2][k] = rs + dr * c;
            Tomo3d.RAYLOC.rp[3][k] = hs + dh * c;
            Tomo3d.RAYLOC.ivk[k] = 1;
            Tomo3d.RAYLOC.iwk[k] = 1;
            Tomo3d.vel3(Tomo3d.RAYLOC.rp[1][k], Tomo3d.RAYLOC.rp[2][k], Tomo3d.RAYLOC.rp[3][k], v, 1, kps);
            if (k == 1 || k == nrp) {
                v[0] = v[0] * 2.0;
            }
            fst[0] = fst[0] + 1.0 / v[0];
            ++k1;
        }
        fst[0] = fst[0] * sl[0] * ab;
        if (fst[0] < 0.0) {
            fst[0] = 999.9;
        }
        ve[0] = v[0] * 0.5;
    }

    public static void eq1(double pg, double rg, double hg, double vg, double[] p, double[] r, double[] h, double[] v) {
        p[0] = pg;
        r[0] = rg;
        h[0] = hg;
        v[0] = vg;
    }

    public static void eq2(int numsg, int[] ns, double[][] pg, double[][] rg, double[][] hg, double[][] vg, double[][] p, double[][] r, double[][] h, double[][] v) {
        int i = 1;
        while (i <= numsg) {
            int j = 1;
            while (j <= ns[i]) {
                p[i][j] = pg[i][j];
                r[i][j] = rg[i][j];
                h[i][j] = hg[i][j];
                v[i][j] = vg[i][j];
                ++j;
            }
            ++i;
        }
    }

    public static void eq3(double fsta, int numsga, int[] nsa, double[][] pa, double[][] ra, double[][] ha, double[][] va, int[] iha, int[] iva, double[] fst, int[] numsg, int[] ns, double[][] p, double[][] r, double[][] h, double[][] v, int[] ih, int[] iv) {
        fst[0] = fsta;
        numsg[0] = numsga;
        int k = 1;
        while (k <= numsg[0]) {
            ns[k] = nsa[k];
            iv[k] = iva[k];
            ih[k] = iha[k];
            ++k;
        }
        Tomo3d.eq2(numsg[0], ns, pa, ra, ha, va, p, r, h, v);
    }

    public static void telebox() {
        double pid = 0.017453;
        int mp = 12;
        int mr = 10;
        int mh = 10;
        Tomo3d.INVBOX.p11 = (90.0 - Tomo3d.VMOD3D.pna[2]) * pid;
        Tomo3d.INVBOX.p22 = (90.0 - Tomo3d.VMOD3D.pna[mp]) * pid;
        Tomo3d.INVBOX.r11 = Tomo3d.VMOD3D.rna[2] * pid;
        Tomo3d.INVBOX.r22 = Tomo3d.VMOD3D.rna[mr] * pid;
        Tomo3d.INVBOX.hab = Tomo3d.VMOD3D.hna[mh];
        System.out.printf(" hab = %9.7f", Tomo3d.INVBOX.hab);
    }

    public static void iaspcon() {
        Tomo3d.IASP91.dr1 = 1.0;
        Tomo3d.IASP91.dr2 = 2.0;
        Tomo3d.IASPHH.hz1 = 17.0;
        Tomo3d.IASPHH.hz2 = 32.0;
        Tomo3d.IASP91.ra = 6371.0;
        Tomo3d.IASP91.r1 = Tomo3d.IASP91.ra - Tomo3d.IASPHH.hz1;
        Tomo3d.IASP91.r2 = Tomo3d.IASP91.ra - Tomo3d.IASPHH.hz2;
        Tomo3d.IASP91.r3 = Tomo3d.IASP91.ra - 410.0;
        Tomo3d.IASP91.r4 = Tomo3d.IASP91.ra - 660.0;
    }

    public static void rminima(double[] rm) {
        double drm;
        double[] y = new double[1];
        double[] f = new double[1];
        double sr = 0.01;
        double rm2 = 2889.0;
        double rm1 = Tomo3d.IASP91.rh - 10.0;
        double r22 = Tomo3d.IASP91.ra - 100.0;
        double zero = 0.0;
        if (rm1 > r22) {
            rm1 = r22;
        }
        Tomo3d.delfun(rm1, y);
        double rmm = 0.0;
        do {
            rmm = (rm1 + rm2) / 2.0;
            Tomo3d.delfun(rmm, f);
            if (y[0] * f[0] > zero) {
                rm1 = rmm;
            } else {
                rm2 = rmm;
            }
            drm = rm1 - rm2;
        } while (drm > sr);
        rm[0] = rmm;
    }

    public static void delfun(double rm, double[] y) {
        double pid = 0.017453;
        double[] vm = new double[1];
        Tomo3d.vump(rm, vm);
        double p = rm / vm[0];
        double pp = p * p;
        double[] a1 = new double[1];
        double[] a2 = new double[1];
        double[] a3 = new double[1];
        double[] a4 = new double[1];
        double[] a5 = new double[1];
        double[] a6 = new double[1];
        if (Tomo3d.IASP91.rh > Tomo3d.IASP91.r1) {
            Tomo3d.delab(Tomo3d.IASP91.rh, Tomo3d.IASP91.ra, Tomo3d.IASP91.dr1, pp, a1);
            Tomo3d.delab(Tomo3d.IASP91.r1, Tomo3d.IASP91.rh, Tomo3d.IASP91.dr1, pp, a2);
            Tomo3d.delab(Tomo3d.IASP91.r2, Tomo3d.IASP91.r1, Tomo3d.IASP91.dr1, pp, a3);
            if (rm >= Tomo3d.IASP91.r3) {
                Tomo3d.delab(rm, Tomo3d.IASP91.r2, Tomo3d.IASP91.dr2, pp, a4);
                y[0] = a1[0] + 2.0 * (a2[0] + a3[0] + a4[0]);
            } else if (rm >= Tomo3d.IASP91.r4 && rm < Tomo3d.IASP91.r3) {
                Tomo3d.delab(Tomo3d.IASP91.r3, Tomo3d.IASP91.r2, Tomo3d.IASP91.dr2, pp, a4);
                Tomo3d.delab(rm, Tomo3d.IASP91.r3, Tomo3d.IASP91.dr2, pp, a5);
                y[0] = a1[0] + 2.0 * (a2[0] + a3[0] + a4[0] + a5[0]);
            } else if (rm < Tomo3d.IASP91.r4) {
                Tomo3d.delab(Tomo3d.IASP91.r3, Tomo3d.IASP91.r2, Tomo3d.IASP91.dr2, pp, a4);
                Tomo3d.delab(Tomo3d.IASP91.r4, Tomo3d.IASP91.r3, Tomo3d.IASP91.dr2, pp, a5);
                Tomo3d.delab(rm, Tomo3d.IASP91.r4, Tomo3d.IASP91.dr2, pp, a6);
                y[0] = a1[0] + 2.0 * (a2[0] + a3[0] + a4[0] + a5[0] + a6[0]);
            }
        } else if (Tomo3d.IASP91.rh > Tomo3d.IASP91.r2 && Tomo3d.IASP91.rh <= Tomo3d.IASP91.r1) {
            Tomo3d.delab(Tomo3d.IASP91.r1, Tomo3d.IASP91.ra, Tomo3d.IASP91.dr1, pp, a1);
            Tomo3d.delab(Tomo3d.IASP91.rh, Tomo3d.IASP91.r1, Tomo3d.IASP91.dr1, pp, a2);
            Tomo3d.delab(Tomo3d.IASP91.r2, Tomo3d.IASP91.rh, Tomo3d.IASP91.dr1, pp, a3);
            if (rm >= Tomo3d.IASP91.r3) {
                Tomo3d.delab(rm, Tomo3d.IASP91.r2, Tomo3d.IASP91.dr2, pp, a4);
                y[0] = a1[0] + a2[0] + 2.0 * (a3[0] + a4[0]);
            } else if (rm >= Tomo3d.IASP91.r4 && rm < Tomo3d.IASP91.r3) {
                Tomo3d.delab(Tomo3d.IASP91.r3, Tomo3d.IASP91.r2, Tomo3d.IASP91.dr2, pp, a4);
                Tomo3d.delab(rm, Tomo3d.IASP91.r3, Tomo3d.IASP91.dr2, pp, a5);
                y[0] = a1[0] + a2[0] + 2.0 * (a3[0] + a4[0] + a5[0]);
            } else if (rm < Tomo3d.IASP91.r4) {
                Tomo3d.delab(Tomo3d.IASP91.r3, Tomo3d.IASP91.r2, Tomo3d.IASP91.dr2, pp, a4);
                Tomo3d.delab(Tomo3d.IASP91.r4, Tomo3d.IASP91.r3, Tomo3d.IASP91.dr2, pp, a5);
                Tomo3d.delab(rm, Tomo3d.IASP91.r4, Tomo3d.IASP91.dr2, pp, a6);
                y[0] = a1[0] + a2[0] + 2.0 * (a3[0] + a4[0] + a5[0] + a6[0]);
            }
        } else if (Tomo3d.IASP91.rh > Tomo3d.IASP91.r3 && Tomo3d.IASP91.rh <= Tomo3d.IASP91.r2) {
            Tomo3d.delab(Tomo3d.IASP91.r1, Tomo3d.IASP91.ra, Tomo3d.IASP91.dr1, pp, a1);
            Tomo3d.delab(Tomo3d.IASP91.r2, Tomo3d.IASP91.r1, Tomo3d.IASP91.dr1, pp, a2);
            Tomo3d.delab(Tomo3d.IASP91.rh, Tomo3d.IASP91.r2, Tomo3d.IASP91.dr2, pp, a3);
            if (rm >= Tomo3d.IASP91.r3) {
                Tomo3d.delab(rm, Tomo3d.IASP91.rh, Tomo3d.IASP91.dr2, pp, a4);
                y[0] = a1[0] + a2[0] + a3[0] + 2.0 * a4[0];
            } else if (rm >= Tomo3d.IASP91.r4 && rm < Tomo3d.IASP91.r3) {
                Tomo3d.delab(Tomo3d.IASP91.r3, Tomo3d.IASP91.rh, Tomo3d.IASP91.dr2, pp, a4);
                Tomo3d.delab(rm, Tomo3d.IASP91.r3, Tomo3d.IASP91.dr2, pp, a5);
                y[0] = a1[0] + a2[0] + a3[0] + 2.0 * (a4[0] + a5[0]);
            } else if (rm < Tomo3d.IASP91.r4) {
                Tomo3d.delab(Tomo3d.IASP91.r3, Tomo3d.IASP91.rh, Tomo3d.IASP91.dr2, pp, a4);
                Tomo3d.delab(Tomo3d.IASP91.r4, Tomo3d.IASP91.r3, Tomo3d.IASP91.dr2, pp, a5);
                Tomo3d.delab(rm, Tomo3d.IASP91.r4, Tomo3d.IASP91.dr2, pp, a6);
                y[0] = a1[0] + a2[0] + a3[0] + 2.0 * (a4[0] + a5[0] + a6[0]);
            }
        } else if (Tomo3d.IASP91.rh > Tomo3d.IASP91.r4 && Tomo3d.IASP91.rh <= Tomo3d.IASP91.r3) {
            Tomo3d.delab(Tomo3d.IASP91.r1, Tomo3d.IASP91.ra, Tomo3d.IASP91.dr1, pp, a1);
            Tomo3d.delab(Tomo3d.IASP91.r2, Tomo3d.IASP91.r1, Tomo3d.IASP91.dr1, pp, a2);
            Tomo3d.delab(Tomo3d.IASP91.r3, Tomo3d.IASP91.r2, Tomo3d.IASP91.dr2, pp, a3);
            Tomo3d.delab(Tomo3d.IASP91.rh, Tomo3d.IASP91.r3, Tomo3d.IASP91.dr2, pp, a4);
            if (rm >= Tomo3d.IASP91.r4) {
                Tomo3d.delab(rm, Tomo3d.IASP91.rh, Tomo3d.IASP91.dr2, pp, a5);
                y[0] = a1[0] + a2[0] + a3[0] + a4[0] + 2.0 * a5[0];
            } else if (rm < Tomo3d.IASP91.r4) {
                Tomo3d.delab(Tomo3d.IASP91.r4, Tomo3d.IASP91.rh, Tomo3d.IASP91.dr2, pp, a5);
                Tomo3d.delab(rm, Tomo3d.IASP91.r4, Tomo3d.IASP91.dr2, pp, a6);
                y[0] = a1[0] + a2[0] + a3[0] + a4[0] + 2.0 * (a5[0] + a6[0]);
            }
        } else if (Tomo3d.IASP91.rh <= Tomo3d.IASP91.r4) {
            Tomo3d.delab(Tomo3d.IASP91.r1, Tomo3d.IASP91.ra, Tomo3d.IASP91.dr1, pp, a1);
            Tomo3d.delab(Tomo3d.IASP91.r2, Tomo3d.IASP91.r1, Tomo3d.IASP91.dr1, pp, a2);
            Tomo3d.delab(Tomo3d.IASP91.r3, Tomo3d.IASP91.r2, Tomo3d.IASP91.dr2, pp, a3);
            Tomo3d.delab(Tomo3d.IASP91.r4, Tomo3d.IASP91.r3, Tomo3d.IASP91.dr2, pp, a4);
            Tomo3d.delab(Tomo3d.IASP91.rh, Tomo3d.IASP91.r4, Tomo3d.IASP91.dr2, pp, a5);
            Tomo3d.delab(rm, Tomo3d.IASP91.rh, Tomo3d.IASP91.dr2, pp, a6);
            y[0] = a1[0] + a2[0] + a3[0] + a4[0] + a5[0] + 2.0 * a6[0];
        }
        y[0] = (p * y[0] - Tomo3d.IASP91.del91) / pid;
    }

    public static void delab(double r1, double r2, double drr, double pp, double[] a) {
        double eps = 1.0E-4;
        double h = r2 - r1;
        double[] v = new double[1];
        a[0] = 0.0;
        if (h < eps) {
            return;
        }
        int nn = (int)(h / drr) + 1;
        double dr = h / (double)nn;
        double r12 = r1 + dr / 2.0;
        int i = 1;
        while (i <= nn) {
            double r = r12 + dr * (double)(i - 1);
            Tomo3d.vump(r, v);
            double rr = r * r;
            double vv = v[0] * v[0];
            a[0] = a[0] + dr / r / Math.sqrt(Math.abs(rr / vv - pp));
            ++i;
        }
    }

    public static void vump(double r, double[] v) {
        double r0 = 6371.0;
        double h = r0 - r;
        double x = r / r0;
        double x2 = x * x;
        double x3 = x * x2;
        if (h < Tomo3d.IASPHH.hz1) {
            v[0] = 6.0;
        } else if (h >= Tomo3d.IASPHH.hz1 && h < Tomo3d.IASPHH.hz2) {
            v[0] = 6.67;
        } else if (h >= Tomo3d.IASPHH.hz2 && h < 120.0) {
            v[0] = 8.78541 - 0.74953 * x;
        } else if (h >= 120.0 && h < 210.0) {
            v[0] = 25.41389 - 17.69722 * x;
        } else if (h >= 210.0 && h < 410.0) {
            v[0] = 30.78765 - 23.25415 * x;
        } else if (h >= 410.0 && h < 660.0) {
            v[0] = 29.38896 - 21.40656 * x;
        } else if (h >= 660.0 && h < 760.0) {
            v[0] = 25.96984 - 16.93412 * x;
        } else if (h >= 760.0 && h < 2740.0) {
            v[0] = 25.1486 - 41.1538 * x + 51.9932 * x2 - 26.6083 * x3;
        } else if (h >= 2740.0 && h < 2889.0) {
            v[0] = 14.4947 - 1.47089 * x;
        } else if (h >= 2889.0 && h < 5153.9) {
            v[0] = 10.03904 + 3.75665 * x - 13.67046 * x2;
        } else if (h >= 5153.9 && h < 6371.0) {
            v[0] = 11.24094 - 4.09689 * x2;
        }
    }

    public static void depdel(double rm, double hh, double[] del) {
        double[] vm = new double[1];
        Tomo3d.vump(rm, vm);
        double p = rm / vm[0];
        double pp = p * p;
        double rk = Tomo3d.IASP91.ra - hh;
        if (rk < rm) {
            del[0] = Tomo3d.IASP91.del91 * 0.5;
            return;
        }
        double[] a1 = new double[1];
        double[] a2 = new double[1];
        double[] a3 = new double[1];
        double[] a4 = new double[1];
        double[] a5 = new double[1];
        Tomo3d.delab(Tomo3d.IASP91.r1, Tomo3d.IASP91.ra, Tomo3d.IASP91.dr1, pp, a1);
        Tomo3d.delab(Tomo3d.IASP91.r2, Tomo3d.IASP91.r1, Tomo3d.IASP91.dr1, pp, a2);
        if (rk > Tomo3d.IASP91.r3 && rk <= Tomo3d.IASP91.r2) {
            Tomo3d.delab(rk, Tomo3d.IASP91.r2, Tomo3d.IASP91.dr2, pp, a3);
            del[0] = p * (a1[0] + a2[0] + a3[0]);
        } else if (rk > Tomo3d.IASP91.r4 && rk <= Tomo3d.IASP91.r3) {
            Tomo3d.delab(Tomo3d.IASP91.r3, Tomo3d.IASP91.r2, Tomo3d.IASP91.dr2, pp, a3);
            Tomo3d.delab(rk, Tomo3d.IASP91.r3, Tomo3d.IASP91.dr2, pp, a4);
            del[0] = p * (a1[0] + a2[0] + a3[0] + a4[0]);
        } else if (rk <= Tomo3d.IASP91.r4) {
            Tomo3d.delab(Tomo3d.IASP91.r3, Tomo3d.IASP91.r2, Tomo3d.IASP91.dr2, pp, a3);
            Tomo3d.delab(Tomo3d.IASP91.r4, Tomo3d.IASP91.r3, Tomo3d.IASP91.dr2, pp, a4);
            Tomo3d.delab(rk, Tomo3d.IASP91.r4, Tomo3d.IASP91.dr2, pp, a5);
            del[0] = p * (a1[0] + a2[0] + a3[0] + a4[0] + a5[0]);
        }
    }

    public static void deldep(double rm, double del, double[] hh) {
        double dh;
        double[] del1 = new double[1];
        Tomo3d.depdel(rm, rm, del1);
        if (del >= del1[0]) {
            hh[0] = Tomo3d.IASP91.ra - rm;
            return;
        }
        double zero = 0.0;
        double dhm = 1.0;
        double h1 = 50.0;
        double h2 = Tomo3d.IASP91.ra - rm;
        double y = del;
        double hx = 0.0;
        do {
            hx = (h1 + h2) * 0.5;
            Tomo3d.depdel(rm, hx, del1);
            double f = del - del1[0];
            double yf = y * f;
            if (yf > zero) {
                h1 = hx;
            } else {
                h2 = hx;
            }
            dh = h2 - h1;
        } while (dh > dhm);
        hh[0] = hx;
    }

    public static void point(double pe, double re, double he, double ps, double rs, double hs, double[] pk, double[] rk, double[] hk, double[] hm, double[] delp) {
        double delk = 0.0;
        double[] del = new double[1];
        double[] az = new double[1];
        double[] rm = new double[1];
        double[] del0 = new double[1];
        double[] r0 = new double[1];
        double[] p0 = new double[1];
        double[] pp = new double[1];
        double[] rr = new double[1];
        int[] ip = new int[1];
        int[] ir = new int[1];
        double pid = Math.PI / 180;
        Tomo3d.conaz(rs, ps, re, pe, del, az);
        Tomo3d.IASP91.del91 = del[0] / Tomo3d.IASP91.ra;
        delp[0] = Tomo3d.IASP91.del91 / pid;
        Tomo3d.rminima(rm);
        hm[0] = Tomo3d.IASP91.ra - rm[0] - 1.0;
        double hu = Tomo3d.INVBOX.hab;
        if (hu > hm[0]) {
            hu = hm[0];
        }
        Tomo3d.depdel(rm[0], hu, del0);
        Tomo3d.azin(ps, rs, del0[0], az[0], r0, p0);
        if (p0[0] >= Tomo3d.INVBOX.p22 && p0[0] <= Tomo3d.INVBOX.p11 && r0[0] >= Tomo3d.INVBOX.r11 && r0[0] <= Tomo3d.INVBOX.r22) {
            pk[0] = p0[0];
            rk[0] = r0[0];
            hk[0] = hu;
            return;
        }
        Tomo3d.prok(Tomo3d.INVBOX.p11, Tomo3d.INVBOX.p22, ps, p0[0], ip, pp);
        Tomo3d.prok(Tomo3d.INVBOX.r11, Tomo3d.INVBOX.r22, rs, r0[0], ir, rr);
        double a = Math.abs(ps - pp[0]);
        double b = Math.abs(p0[0] - pp[0]);
        double del1 = a * del0[0] / (a + b);
        a = Math.abs(rs - rr[0]) * Math.sin(p0[0]);
        b = Math.abs(r0[0] - rr[0]) * Math.sin(ps);
        double del2 = a * del0[0] / (a + b);
        if (ip[0] == 1 && ir[0] == 0) {
            delk = del1;
        } else if (ip[0] == 0 && ir[0] == 1) {
            delk = del2;
        } else if (ip[0] == 1 && ir[0] == 1) {
            delk = Math.min(del1, del2);
        }
        Tomo3d.azin(ps, rs, delk, az[0], rk, pk);
        Tomo3d.deldep(rm[0], delk, hk);
    }

    public static void prok(double pa, double pb, double p1, double p2, int[] ip, double[] pp) {
        ip[0] = 0;
        pp[0] = 999.0;
        if (pa >= p1 && pa <= p2) {
            ip[0] = 1;
        }
        if (pa <= p1 && pa >= p2) {
            ip[0] = 1;
        }
        if (ip[0] == 1) {
            pp[0] = pa;
            return;
        }
        if (pb >= p1 && pb <= p2) {
            ip[0] = 1;
        }
        if (pb <= p1 && pb >= p2) {
            ip[0] = 1;
        }
        if (ip[0] == 1) {
            pp[0] = pb;
        }
    }

    public static void main(String[] args) throws IOException {
        System.out.println(" determine tomography:");
        System.out.println(" p- (1) or s-wave (2) or not (0).....");
        int mps = 1;
        System.out.println(" relocate hypocenter (1) or not(0)...");
        boolean ihypo = true;
        System.out.println(" see every residual in the scren:");
        System.out.println(" yes (1) or not(0) .....");
        int isee = 1;
        System.out.println(" use local & regional events only (1)...");
        System.out.println(" use teleseismic events only (2)........");
        System.out.println(" use all events (3).....................");
        int ievent = 1;
        Tomo3d.input1(new File("/tmp/datajp"));
        Tomo3d.input23(new File("/tmp/model1p"), mps);
        Tomo3d.input4(new File("/tmp/time.zhao"));
        pwLog = new PrintStream("/tmp/resjp1.txt");
        pwRes = new PrintStream("/tmp/resjp2.txt");
        Tomo3d.input5();
        Tomo3d.iaspcon();
        Tomo3d.telebox();
        int nit = 0;
        do {
            int ne;
            int ie;
            Tomo3d.strt(++nit);
            if (ievent != 2) {
                ie = 1;
                while (ie <= Tomo3d.CONTRL.neqs) {
                    System.out.printf(" neq. = %d\n", ie);
                    ne = ie;
                    if (ihypo) {
                        Tomo3d.loceqk(ne, isee);
                    }
                    if (mps != 0) {
                        Tomo3d.forwrd(ne, mps, isee);
                    }
                    ++ie;
                }
            }
            if (ievent != 1) {
                ie = 68;
                while (ie <= Tomo3d.CONTRL.neqs) {
                    System.out.printf(" neq. = %d\n", ie);
                    ne = ie++;
                    Tomo3d.fortele(ne, mps, isee);
                }
            }
            Tomo3d.veladj();
            Tomo3d.outadj();
        } while (nit < Tomo3d.CONTRL.nitmax);
    }

    public static class CONTRL {
        int nsts;
        int neqs;
        int nitloc;
        double rmscut;
        double dvmax;
        double vdamp;
        int nhitct;
        int nitmax;
        double rmstop;
        double stepl;
        double tlim;
        int nitpb;
    }

    public static class DISCON {
        final int nnp = 51;
        final int nnr = 63;
        double[] pn = new double[52];
        double[] rn = new double[64];
        double[][] depa = new double[52][64];
        double[][] depb = new double[52][64];
        double[][] depc = new double[52][64];
    }

    public static class ELLIPS {
        double[] deltb = new double[6];
        int idel;
        int idel1;
        double t0;
        double t1;
        double t2;
    }

    public static class EVENTS {
        int[] mino = new int[1011];
        double[] seco = new double[1011];
        double[] phie = new double[1011];
        double[] rame = new double[1011];
        double[] depe = new double[1011];
        double[][] evc = new double[4][1011];
        int[] kobs = new int[1011];
    }

    public static class GRINET {
        int npa2;
        int npra2;
        int nodesa2;
        int nodetot;
    }

    public static class HLASTA {
        double[][] hlss = new double[106][3];
    }

    public static class HYPINV {
        double[] res = new double[401];
        double[][] dth = new double[401][5];
        double[] w = new double[401];
    }

    public static class IASP91 {
        double ra;
        double r1;
        double r2;
        double r3;
        double r4;
        double rh;
        double dr1;
        double dr2;
        double del91;
    }

    public static class IASPHH {
        double hz1;
        double hz2;
    }

    public static class INVBOX {
        double p11;
        double p22;
        double r11;
        double r22;
        double hab;
    }

    public static class JBMODV {
        double[] vp = new double[30];
        double[] vs = new double[30];
        double[] ra = new double[30];
        double[] depj = new double[30];
    }

    public static class LOCATE {
        double[] pla = new double[1];
        double[] rla = new double[1];
        double[] hla = new double[1];
        int[] iploca = new int[3501];
        int[] irloca = new int[3501];
        int[] ihloca = new int[3501];
    }

    public static class MODINV {
        double[] a = new double[10000001];
        int[] ja = new int[10000001];
        int[] na = new int[10001];
        double[] rds = new double[10001];
        int[] khit = new int[50001];
        int neq4;
        int[] jndex = new int[50001];
        int nod;
        int nou;
        int noueq;
        int itot;
        double rnorm;
        double xnorm;
    }

    public static class NPRH12 {
        public int np1;
        public int nr1;
        public int nh1;
        public int np2;
        public int npr2;
    }

    public static class OBSERV {
        int[][] isto = new int[401][1011];
        double[][] sect = new double[401][1011];
        int[][] kwv = new int[401][1011];
    }

    public static class ONED {
        double[] dtm = new double[301];
        int[] ndm = new int[301];
        int numb;
    }

    public static class PRHFD {
        double p;
        double r;
        double h;
        double pf;
        double rf;
        double hf;
        double pf1;
        double rf1;
        double hf1;
        double pd;
        double rd;
        double hd;
    }

    public static class RAYLOC {
        int nrp;
        double[][] rp = new double[4][1501];
        int[] ivk = new int[1501];
        int[] iwk = new int[1501];
    }

    public static class RAYPATH {
        int[][] iwv = new int[9][6];
        double r0;
        double pideg;
        double eps;
    }

    public static class SPU {
        private int idx;
        String line;

        SPU(String line) {
            this.line = line;
            this.idx = 0;
        }

        String substring(int width) {
            String s = this.line.substring(this.idx, this.idx + width).trim();
            this.idx += width;
            return s;
        }
    }

    public static class STATIN {
        double[] phis = new double[106];
        double[] rams = new double[106];
        double[] higs = new double[106];
        double[][] stc = new double[4][106];
    }

    public static class STDERR {
        double[][][] sevap = new double[14][12][12];
    }

    public static class STODAT {
        int[] iymsto = new int[1011];
        int[] idsto = new int[1011];
        int[] ihrsto = new int[1011];
    }

    public static class TOYUAN {
        double[] pd0t0 = new double[]{0.0, 0.0, -0.18, -0.34, -0.48, -0.57};
        double[] pd0t1 = new double[]{0.0, 0.0, -0.02, -0.05, -0.1, -0.16};
        double[] pd0t2 = new double[]{0.0, 0.0, 0.0, -0.01, -0.03, -0.06};
        double[] pd3t0 = new double[]{0.0, -0.12, -0.17, -0.29, -0.38, -0.46};
        double[] pd3t1 = new double[]{0.0, 0.0, -0.11, -0.14, -0.19, -0.24};
        double[] pd3t2 = new double[]{0.0, 0.0, 0.0, -0.01, -0.03, -0.07};
        double[] pd6t0 = new double[]{0.0, -0.26, -0.27, -0.31, -0.37, -0.41};
        double[] pd6t1 = new double[]{0.0, 0.0, -0.2, -0.28, -0.34, -0.37};
        double[] pd6t2 = new double[]{0.0, 0.0, 0.0, -0.02, -0.04, -0.08};
        double[] sd0t0 = new double[]{0.0, 0.0, -0.33, -0.57, -0.82, -1.0};
        double[] sd0t1 = new double[]{0.0, 0.0, -0.02, -0.1, -0.19, -0.3};
        double[] sd0t2 = new double[]{0.0, 0.0, 0.0, -0.02, -0.05, -0.12};
        double[] sd3t0 = new double[]{0.0, -0.22, -0.31, -0.52, -0.68, -0.84};
        double[] sd3t1 = new double[]{0.0, 0.0, -0.2, -0.25, -0.34, -0.43};
        double[] sd3t2 = new double[]{0.0, 0.0, 0.0, -0.02, -0.05, -0.13};
        double[] sd6t0 = new double[]{0.0, -0.47, -0.49, -0.56, -0.66, -0.72};
        double[] sd6t1 = new double[]{0.0, 0.0, -0.36, -0.5, -0.61, -0.67};
        double[] sd6t2 = new double[]{0.0, 0.0, 0.0, -0.03, -0.07, -0.14};
        double[] delra = new double[]{0.0, 0.0, 5.0, 10.0, 15.0, 20.0};
    }

    public static class VMOD3D {
        int npa;
        int nra;
        int nha;
        double[] pna = new double[14];
        double[] rna = new double[12];
        double[] hna = new double[12];
        double[][][] dvap = new double[14][12][12];
        double[][][] velap = new double[14][12][12];
    }

    public static class WEIGHT {
        double[] wv = new double[9];
        int ip;
        int jp;
        int kp;
        int ip1;
        int jp1;
        int kp1;
    }
}

