/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class FilterDB
implements Serializable {
    static Logger logger = Logger.getLogger(FilterDB.class);
    static final long serialVersionUID = 3300519651960109652L;
    private int sample;
    private int order;
    private double fPass;
    private double rPass = 0.1;
    private double fStop;
    private double rStop;
    private double[] num;
    private double[] den;
    private transient String filterName;

    public int getSample() {
        return this.sample;
    }

    public double getFStop() {
        return this.fStop;
    }

    public double getFPass() {
        return this.fPass;
    }

    public double getRPass() {
        return this.rPass;
    }

    public double getRStop() {
        return this.rStop;
    }

    public double[] getNum() {
        return this.num;
    }

    public double[] getDen() {
        return this.den;
    }

    public void writeFilterData() {
        try {
            FileOutputStream fos = new FileOutputStream(this.filterName);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeInt(this.sample);
            oos.writeInt(this.order);
            oos.writeDouble(this.fPass);
            oos.writeDouble(this.rPass);
            oos.writeDouble(this.fStop);
            oos.writeDouble(this.rStop);
            oos.writeObject(this.num);
            oos.writeObject(this.den);
            oos.flush();
            oos.close();
            fos.close();
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            logger.warn((Object)("Trouble writing " + this.filterName));
        }
    }

    public void readFilterData() {
        try {
            FileInputStream fis = new FileInputStream(this.filterName);
            ObjectInputStream ois = new ObjectInputStream(fis);
            this.sample = ois.readInt();
            this.order = ois.readInt();
            this.fPass = ois.readDouble();
            this.rPass = ois.readDouble();
            this.fStop = ois.readDouble();
            this.rStop = ois.readDouble();
            this.num = (double[])ois.readObject();
            this.den = (double[])ois.readObject();
            ois.close();
            fis.close();
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            logger.warn((Object)("Trouble writing " + this.filterName));
        }
    }

    public void readAsciiFilterData(String fName) {
        try {
            FileReader fs = new FileReader(fName);
            BufferedReader ds = new BufferedReader(fs);
            String LineStr = ds.readLine();
            StringTokenizer st = new StringTokenizer(LineStr);
            this.sample = Integer.parseInt(st.nextToken());
            this.order = Integer.parseInt(st.nextToken());
            this.fPass = Double.valueOf(st.nextToken());
            this.rPass = Double.valueOf(st.nextToken());
            this.fStop = Double.valueOf(st.nextToken());
            this.rStop = Double.valueOf(st.nextToken());
            this.num = new double[this.order + 1];
            this.den = new double[this.order + 1];
            int i = 0;
            while (i < this.order + 1) {
                LineStr = ds.readLine();
                st = new StringTokenizer(LineStr);
                this.num[i] = Double.valueOf(st.nextToken());
                this.den[i] = Double.valueOf(st.nextToken());
                ++i;
            }
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            logger.warn((Object)("Trouble writing " + this.filterName));
        }
    }

    public String getFilterName() {
        return this.filterName;
    }

    public int getOrder() {
        return this.order;
    }

    public void setFilterName(String newFilterName) {
        this.filterName = newFilterName;
        this.readFilterData();
    }

    public void setNum(double[] num) {
        this.num = num;
    }

    public void setDen(double[] den) {
        this.den = den;
    }
}

