/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.StringTokenizer;

public class TFRNative {
    int[] maxrad = new int[1024];
    double[] xr = new double[1024];
    double[] xi = new double[1024];
    double[] rectafr = null;
    double[] rectafi = null;
    double[] rectafm2 = null;
    double[] polafm2 = null;
    double[] rectrotr = null;
    double[] rectroti = null;
    double[] req = null;
    double[] pheq = null;
    double[] plag = null;
    double[] ptheta = null;
    double[] rarN = null;
    double[] raiN = null;
    double[] sigma = new double[1024];
    double[] rar = new double[1024];
    double[] rai = new double[1024];
    double[] tfslicer = new double[1024];
    double[] tfslicei = new double[1024];
    double[] grad = new double[1024];
    int m_nraf;
    int m_nlag;
    int m_mfft;
    int m_nrad;
    int m_nphi;
    int m_nits;
    int m_slen;
    int m_fstep;
    double m_pi;
    double m_rtemp;
    double m_rtemp1;
    double m_rtemp2;
    double m_mu;
    double m_forget;
    double m_outdelay;
    int tlag;
    int fftlen;
    int tstep;
    double vol;

    static {
        System.loadLibrary("TFR");
    }

    public void init(int o_tlag, int o_fftlen, int o_tstep, double o_vol) {
        this.tlag = o_tlag;
        this.fftlen = o_fftlen;
        this.tstep = o_tstep;
        this.vol = o_vol;
        int num = (this.tlag + 2) * (this.tlag + 2);
        this.rectafr = new double[num];
        this.rectafi = new double[num];
        this.rectafm2 = new double[num];
        this.polafm2 = new double[num];
        this.rectrotr = new double[num];
        this.rectroti = new double[num];
        this.req = new double[num];
        this.pheq = new double[num];
        this.plag = new double[num];
        this.ptheta = new double[num];
        this.rarN = new double[num];
        this.raiN = new double[num];
        if (this.fftlen < 2 * this.tlag) {
            this.m_fstep = 2 * this.tlag / this.fftlen;
            this.fftlen = 2 * this.tlag;
        } else {
            this.m_fstep = 1;
        }
        this.m_nits = (int)(Math.log((double)this.tstep + 2.0) / Math.log(2.0));
        this.m_mu = 0.5;
        this.m_forget = 0.001;
        this.m_nraf = this.tlag;
        this.m_nrad = this.tlag;
        this.m_nphi = this.tlag;
        this.m_outdelay = this.tlag / 2;
        this.m_nlag = this.tlag + 1;
        this.m_mfft = TFRNative.po2(this.fftlen);
        this.m_slen = (int)(1.42 * (double)(this.m_nlag - 1) + (double)this.m_nraf + 3.0);
        this.m_pi = Math.PI;
        this.vol = 2.0 * this.vol * (double)this.m_nphi * (double)this.m_nrad * (double)this.m_nrad / (this.m_pi * (double)this.tlag);
        TFRNative.kfill(this.m_nrad * this.m_nphi, 0.0, this.polafm2);
        TFRNative.kfill(this.m_nraf * this.m_nlag, 0.0, this.rectafr);
        TFRNative.kfill(this.m_nraf * this.m_nlag, 0.0, this.rectafi);
        TFRNative.kfill(this.m_slen, 0.0, this.xr);
        TFRNative.kfill(this.m_slen, 0.0, this.xi);
        TFRNative.kfill(this.m_nphi, 1.0, this.sigma);
        TFRNative.rectamake(this.m_nlag, this.m_nraf, this.m_forget, this.rar, this.rai, this.rarN, this.raiN);
        TFRNative.plagmake(this.m_nrad, this.m_nphi, this.m_nlag, this.plag);
        TFRNative.pthetamake(this.m_nrad, this.m_nphi, this.m_nraf, this.ptheta, this.maxrad);
        TFRNative.rectrotmake(this.m_nraf, this.m_nlag, this.m_outdelay, this.rectrotr, this.rectroti);
        TFRNative.rectopol(this.m_nraf, this.m_nlag, this.m_nrad, this.m_nphi, this.req, this.pheq);
    }

    public double[][] aok(double[][] signal, int s_strt, int xlen, double[][] tfr, boolean bFinish) {
        int m_tlen = bFinish ? xlen + s_strt + this.m_nraf + 2 : xlen + s_strt;
        int outct = 0;
        int ii = s_strt;
        while (ii < m_tlen) {
            TFRNative.cshift(this.m_slen, this.xr);
            TFRNative.cshift(this.m_slen, this.xi);
            if (ii < xlen + s_strt) {
                this.xr[0] = signal[0][ii];
                this.xi[0] = signal[1][ii];
            } else {
                this.xr[0] = 0.0;
                this.xi[0] = 0.0;
            }
            TFRNative.rectaf(this.xr, this.xi, this.m_nlag, this.m_nraf, this.rar, this.rai, this.rarN, this.raiN, this.rectafr, this.rectafi);
            if (ii - ii / this.tstep * this.tstep == 0) {
                int j;
                TFRNative.mkmag2(this.m_nlag * this.m_nraf, this.rectafr, this.rectafi, this.rectafm2);
                TFRNative.polafint(this.m_nrad, this.m_nphi, this.m_nraf, this.maxrad, this.m_nlag, this.plag, this.ptheta, this.rectafm2, this.polafm2);
                TFRNative.sigupdate(this.m_nrad, this.m_nphi, this.m_nits, this.vol, this.m_mu, this.maxrad, this.polafm2, this.sigma, this.grad);
                int i = 0;
                while (i < this.m_nlag - 1) {
                    this.tfslicer[i] = 0.0;
                    this.tfslicei[i] = 0.0;
                    j = 0;
                    while (j < this.m_nraf) {
                        this.m_rtemp = TFRNative.ccmr(this.rectafr[i * this.m_nraf + j], this.rectafi[i * this.m_nraf + j], this.rectrotr[i * this.m_nraf + j], this.rectroti[i * this.m_nraf + j]);
                        this.m_rtemp1 = TFRNative.ccmi(this.rectafr[i * this.m_nraf + j], this.rectafi[i * this.m_nraf + j], this.rectrotr[i * this.m_nraf + j], this.rectroti[i * this.m_nraf + j]);
                        this.m_rtemp2 = TFRNative.rectkern(i, j, this.m_nraf, this.m_nphi, this.req, this.pheq, this.sigma);
                        this.tfslicer[i] = this.tfslicer[i] + this.m_rtemp * this.m_rtemp2;
                        this.tfslicei[i] = this.tfslicei[i] + this.m_rtemp1 * this.m_rtemp2;
                        ++j;
                    }
                    ++i;
                }
                i = this.m_nlag - 1;
                while (i < this.fftlen - this.m_nlag + 2) {
                    this.tfslicer[i] = 0.0;
                    this.tfslicei[i] = 0.0;
                    ++i;
                }
                i = this.fftlen - this.m_nlag + 2;
                while (i < this.fftlen) {
                    this.tfslicer[i] = this.tfslicer[this.fftlen - i];
                    this.tfslicei[i] = -this.tfslicei[this.fftlen - i];
                    ++i;
                }
                TFRNative.fft(this.fftlen, this.m_mfft, this.tfslicer, this.tfslicei);
                int itemp = this.fftlen / 2 + this.m_fstep;
                j = 0;
                i = itemp;
                while (i < this.fftlen) {
                    tfr[outct][j] = this.tfslicer[i];
                    ++j;
                    i += this.m_fstep;
                }
                i = 0;
                while (i < itemp) {
                    tfr[outct][j] = this.tfslicer[i];
                    ++j;
                    i += this.m_fstep;
                }
                ++outct;
            }
            ++ii;
        }
        return tfr;
    }

    public double[][] aok(double[][] signal, int s_strt, int xlen, double[][] tfr) {
        int m_start = s_strt + this.tlag / 2;
        int m_tlen = s_strt + this.tlag / 2 + xlen;
        int outct = 0;
        int ii = 0;
        while (ii < m_tlen) {
            TFRNative.cshift(this.m_slen, this.xr);
            TFRNative.cshift(this.m_slen, this.xi);
            this.xr[0] = signal[0][ii];
            this.xi[0] = signal[1][ii];
            TFRNative.rectaf(this.xr, this.xi, this.m_nlag, this.m_nraf, this.rar, this.rai, this.rarN, this.raiN, this.rectafr, this.rectafi);
            int ic = ii - m_start;
            if (ic >= 0 && ic - ic / this.tstep * this.tstep == 0) {
                int j;
                TFRNative.mkmag2(this.m_nlag * this.m_nraf, this.rectafr, this.rectafi, this.rectafm2);
                TFRNative.polafint(this.m_nrad, this.m_nphi, this.m_nraf, this.maxrad, this.m_nlag, this.plag, this.ptheta, this.rectafm2, this.polafm2);
                TFRNative.sigupdate(this.m_nrad, this.m_nphi, this.m_nits, this.vol, this.m_mu, this.maxrad, this.polafm2, this.sigma, this.grad);
                int i = 0;
                while (i < this.m_nlag - 1) {
                    this.tfslicer[i] = 0.0;
                    this.tfslicei[i] = 0.0;
                    j = 0;
                    while (j < this.m_nraf) {
                        this.m_rtemp = TFRNative.ccmr(this.rectafr[i * this.m_nraf + j], this.rectafi[i * this.m_nraf + j], this.rectrotr[i * this.m_nraf + j], this.rectroti[i * this.m_nraf + j]);
                        this.m_rtemp1 = TFRNative.ccmi(this.rectafr[i * this.m_nraf + j], this.rectafi[i * this.m_nraf + j], this.rectrotr[i * this.m_nraf + j], this.rectroti[i * this.m_nraf + j]);
                        this.m_rtemp2 = TFRNative.rectkern(i, j, this.m_nraf, this.m_nphi, this.req, this.pheq, this.sigma);
                        this.tfslicer[i] = this.tfslicer[i] + this.m_rtemp * this.m_rtemp2;
                        this.tfslicei[i] = this.tfslicei[i] + this.m_rtemp1 * this.m_rtemp2;
                        ++j;
                    }
                    ++i;
                }
                i = this.m_nlag - 1;
                while (i < this.fftlen - this.m_nlag + 2) {
                    this.tfslicer[i] = 0.0;
                    this.tfslicei[i] = 0.0;
                    ++i;
                }
                i = this.fftlen - this.m_nlag + 2;
                while (i < this.fftlen) {
                    this.tfslicer[i] = this.tfslicer[this.fftlen - i];
                    this.tfslicei[i] = -this.tfslicei[this.fftlen - i];
                    ++i;
                }
                TFRNative.fft(this.fftlen, this.m_mfft, this.tfslicer, this.tfslicei);
                int itemp = this.fftlen / 2;
                j = 0;
                i = 0;
                while (i < itemp) {
                    tfr[outct][j] = this.tfslicer[i];
                    ++j;
                    i += this.m_fstep;
                }
                ++outct;
            }
            ++ii;
        }
        return tfr;
    }

    static int po2(int n) {
        int mm = 1;
        int m = 0;
        while (mm < n) {
            ++m;
            mm *= 2;
        }
        return m;
    }

    static int power(int x, int n) {
        int p = 1;
        int i = 1;
        while (i <= n) {
            p *= x;
            ++i;
        }
        return p;
    }

    static void kfill(int len, double k, double[] x) {
        int i = 0;
        while (i < len) {
            x[i] = k;
            ++i;
        }
    }

    static void cshift(int len, double[] x) {
        double rtemp = x[len - 1];
        int i = len - 1;
        while (i > 0) {
            x[i] = x[i - 1];
            --i;
        }
        x[0] = rtemp;
    }

    static void rectamake(int nlag, int n, double forget, double[] ar, double[] ai, double[] arN, double[] aiN) {
        double trig = Math.PI * 2 / (double)n;
        double decay = Math.exp(-forget);
        int j = 0;
        while (j < n) {
            ar[j] = decay * Math.cos(trig * (double)j);
            ai[j] = decay * Math.sin(trig * (double)j);
            ++j;
        }
        int i = 0;
        while (i < nlag) {
            double trigN = Math.PI * 2 * (double)(n - i);
            trigN /= (double)n;
            double decayN = Math.exp(-forget * (double)(n - i));
            j = 0;
            while (j < n) {
                arN[i * n + j] = decayN * Math.cos(trigN * (double)j);
                aiN[i * n + j] = decayN * Math.sin(trigN * (double)j);
                ++j;
            }
            ++i;
        }
    }

    static void pthetamake(int nrad, int nphi, int ntheta, double[] ptheta, int[] maxrad) {
        double deltheta = Math.PI * 2 / (double)ntheta;
        int i = 0;
        while (i < nphi) {
            maxrad[i] = nrad;
            int j = 0;
            while (j < nrad) {
                double rtemp;
                double theta = -(4.442882938 / (double)nrad * (double)j) * Math.cos(Math.PI * (double)i / (double)nphi);
                if (theta >= 0.0) {
                    rtemp = theta / deltheta;
                    if (rtemp > (double)(ntheta / 2 - 1)) {
                        rtemp = -1.0;
                        if (j < maxrad[i]) {
                            maxrad[i] = j;
                        }
                    }
                } else {
                    rtemp = (theta + Math.PI * 2) / deltheta;
                    if (rtemp < (double)(ntheta / 2 + 1)) {
                        rtemp = -1.0;
                        if (j < maxrad[i]) {
                            maxrad[i] = j;
                        }
                    }
                }
                ptheta[i * nrad + j] = rtemp;
                ++j;
            }
            ++i;
        }
    }

    static void plagmake(int nrad, int nphi, int nlag, double[] plag) {
        int i = 0;
        while (i < nphi) {
            int j = 0;
            while (j < nrad) {
                plag[i * nrad + j] = TFRNative.mklag(nrad, nphi, nlag, i, j);
                ++j;
            }
            ++i;
        }
    }

    static void rectopol(int nraf, int nlag, int nrad, int nphi, double[] req, double[] pheq) {
        double pi = Math.PI;
        double deltau = Math.sqrt(pi / (double)(nlag - 1));
        double deltheta = 2.0 * Math.sqrt((double)(nlag - 1) * pi) / (double)nraf;
        double delrad = Math.sqrt(2.0 * pi * (double)(nlag - 1)) / (double)nrad;
        double delphi = pi / (double)nphi;
        int i = 0;
        while (i < nlag) {
            int j = 0;
            while (j < nraf / 2) {
                req[i * nraf + j] = Math.sqrt((double)(i * i) * deltau * deltau + (double)(j * j) * deltheta * deltheta) / delrad;
                pheq[i * nraf + j] = i == 0 ? 0.0 : (Math.atan((double)j * deltheta / ((double)i * deltau)) + 1.5707963267948966) / delphi;
                ++j;
            }
            j = 0;
            while (j < nraf / 2) {
                int jt = j - nraf / 2;
                req[i * nraf + nraf / 2 + j] = Math.sqrt((double)(i * i) * deltau * deltau + (double)(jt * jt) * deltheta * deltheta) / delrad;
                pheq[i * nraf + nraf / 2 + j] = i == 0 ? 0.0 : (Math.atan((double)jt * deltheta / ((double)i * deltau)) + 1.5707963267948966) / delphi;
                ++j;
            }
            ++i;
        }
    }

    static void rectrotmake(int nraf, int nlag, double outdelay, double[] rectrotr, double[] rectroti) {
        double twopin = Math.PI * 2 / (double)nraf;
        int i = 0;
        while (i < nlag) {
            int j = 0;
            while (j < nraf / 2) {
                rectrotr[i * nraf + j] = Math.cos(twopin * (double)j * (outdelay - (double)i / 2.0));
                rectroti[i * nraf + j] = Math.sin(twopin * (double)j * (outdelay - (double)i / 2.0));
                ++j;
            }
            j = nraf / 2;
            while (j < nraf) {
                rectrotr[i * nraf + j] = Math.cos(twopin * (double)(j - nraf) * (outdelay - (double)i / 2.0));
                rectroti[i * nraf + j] = Math.sin(twopin * (double)(j - nraf) * (outdelay - (double)i / 2.0));
                ++j;
            }
            ++i;
        }
    }

    static native void fft(int var0, int var1, double[] var2, double[] var3);

    static native double ccmr(double var0, double var2, double var4, double var6);

    static native double ccmi(double var0, double var2, double var4, double var6);

    static native void rectaf(double[] var0, double[] var1, int var2, int var3, double[] var4, double[] var5, double[] var6, double[] var7, double[] var8, double[] var9);

    static native void polafint(int var0, int var1, int var2, int[] var3, int var4, double[] var5, double[] var6, double[] var7, double[] var8);

    static native double mklag(int var0, int var1, int var2, int var3, int var4);

    static native double rectkern(int var0, int var1, int var2, int var3, double[] var4, double[] var5, double[] var6);

    static native void sigupdate(int var0, int var1, int var2, double var3, double var5, int[] var7, double[] var8, double[] var9, double[] var10);

    static native void mkmag2(int var0, double[] var1, double[] var2, double[] var3);

    public static void main(String[] args) throws Exception {
        System.out.println();
        System.out.println("ADAPTIVE OPTIMAL-KERNEL (AOK) TIME-FREQUENCY REPRESENTATION\n");
        System.out.println();
        System.out.println("  Version 4.0\n");
        System.out.println("  java TFR.aok in_file, out_file xlen tlag fftlen tstep vol");
        System.out.println();
        System.out.println("\tin_file:\tInput File");
        System.out.println("\tout_file:\tOutput File");
        System.out.println("\txlen:\tNumber of signal samples in input file");
        System.out.println("\ttlag:\tLength of sliding analysis window?  (power of two, no larger than 256)");
        System.out.println(" \t(Number of samples along each dimension of the STAF)");
        System.out.println("\tfftlen:\tNumber of output frequency samples per time-slice  (power of two)");
        System.out.println("\ttstep:\tTime increment in samples between time-slice outputs");
        System.out.println("\tvol:\tNormalized volume of optimal kernel");
        System.out.println("\t(Typically between 1 and 5)");
        BufferedReader frdr = new BufferedReader(new FileReader(args[0]));
        BufferedWriter fwrtr = new BufferedWriter(new FileWriter(args[1]));
        int xlen = Integer.parseInt(args[2]);
        int tlag = Integer.parseInt(args[3]);
        int fftlen = Integer.parseInt(args[4]);
        int tstep = Integer.parseInt(args[5]);
        double vol = Double.parseDouble(args[6]);
        double[][] signal = new double[2][xlen];
        int ntime = (int)Math.ceil((double)(xlen + tlag + 2) / (double)tstep);
        double[][] tfr = new double[ntime][fftlen];
        System.out.println("xlen= " + xlen);
        System.out.println("tlag= " + tlag);
        System.out.println("fftlen= " + fftlen);
        System.out.println("tstep= " + tstep);
        System.out.println("vol= " + vol);
        System.out.println("tfr.t= " + ntime);
        String line = null;
        StringTokenizer st = null;
        int i = 0;
        while (i < xlen) {
            line = frdr.readLine();
            st = new StringTokenizer(line);
            signal[0][i] = Double.parseDouble(st.nextToken());
            signal[1][i] = Double.parseDouble(st.nextToken());
            ++i;
        }
        frdr.close();
        TFRNative aok = new TFRNative();
        aok.init(tlag, fftlen, tstep, vol);
        int n = 1;
        int win = xlen / n;
        int i2 = 0;
        while (i2 < n) {
            if (i2 == n - 1) {
                ntime = (int)Math.ceil((double)(win + tlag + 2) / (double)tstep);
                tfr = new double[ntime][fftlen];
                aok.aok(signal, win * i2, win, tfr, true);
            } else {
                ntime = win / tstep;
                tfr = new double[ntime][fftlen];
                aok.aok(signal, win * i2, win, tfr, false);
            }
            int t = 0;
            while (t < ntime) {
                int f = 0;
                while (f < fftlen) {
                    fwrtr.write(tfr[t][f] + " ");
                    ++f;
                }
                fwrtr.newLine();
                ++t;
            }
            ++i2;
        }
        fwrtr.close();
    }
}

