/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter;

import cn.org.gddsn.signal.filter.Complex;
import cn.org.gddsn.signal.filter.PoleFilterType;

abstract class ChebyFilterType
extends PoleFilterType {
    double epsilon;
    int sign;

    ChebyFilterType() {
    }

    void selectCheby(int s) {
        this.auxLabels[s] = "Passband Ripple";
        this.auxBars[s] = 60;
    }

    void setupCheby(int a) {
        int val = this.auxBars[a];
        double ripdb = 0.0;
        ripdb = val < 300 ? (double)(5 * val) / 300.0 : 5.0 + (double)(45 * (val - 300)) / 700.0;
        double ripval = Math.exp(-ripdb * 0.1 * 2.302585092994046);
        this.epsilon = Math.sqrt(1.0 / ripval - 1.0);
    }

    void getSPole(int i, Complex c1, double wc) {
        double alpha = 1.0 / this.epsilon + Math.sqrt(1.0 + 1.0 / (this.epsilon * this.epsilon));
        double a = 0.5 * (Math.pow(alpha, 1.0 / (double)this.n) - Math.pow(alpha, -1.0 / (double)this.n));
        double b = 0.5 * (Math.pow(alpha, 1.0 / (double)this.n) + Math.pow(alpha, -1.0 / (double)this.n));
        double theta = 1.5707963267948966 + (double)(2 * i + 1) * Math.PI / (double)(2 * this.n);
        if (this.sign == -1) {
            wc = Math.PI - wc;
        }
        c1.setMagPhase(Math.tan(wc * 0.5), theta);
        c1.re *= a;
        c1.im *= b;
        c1.setMagPhase();
    }

    void getInfoCheby(String[] x) {
        x[2] = "Ripple: " + -10.0 * Math.log(1.0 / (1.0 + this.epsilon * this.epsilon)) / 2.302585092994046 + " dB";
    }
}

