/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter;

import cn.org.gddsn.signal.filter.Complex;
import cn.org.gddsn.signal.filter.DirectFilter;
import cn.org.gddsn.signal.filter.Filter;
import cn.org.gddsn.signal.filter.IIRFilterType;

class CombFilter
extends IIRFilterType {
    int n;
    int sign;
    double mult;
    double peak;

    CombFilter(int s) {
        this.sign = s;
    }

    int select() {
        this.auxLabels[0] = "1st Pole";
        this.auxBars[0] = 60;
        this.auxLabels[1] = "Sharpness";
        this.auxBars[1] = 700;
        return 2;
    }

    void setup() {
        this.n = 2000 / this.auxBars[0];
        this.mult = (double)this.auxBars[1] / 1000.0;
        this.peak = 1.0 / (1.0 - this.mult);
    }

    void getPole(int i, Complex c1) {
        int odd = this.sign == 1 ? 0 : 1;
        c1.setMagPhase(Math.pow(this.mult, 1.0 / (double)this.n), Math.PI * (double)(odd + 2 * i) / (double)this.n);
    }

    Filter genFilter() {
        DirectFilter f = new DirectFilter();
        f.aList = new double[]{1.0 / this.peak, 0.0};
        f.bList = new double[]{0.0, (double)(-this.sign) * this.mult};
        int[] nArray = new int[2];
        nArray[1] = this.n;
        f.nList = nArray;
        this.setResponse(f);
        return f;
    }

    void getInfo(String[] x) {
        x[0] = "Comb (IIR); Resonance every " + this.getOmegaText(Math.PI * 2 / (double)this.n);
        x[1] = "Delay: " + this.n + " samples, " + this.getUnitText((double)this.n / (double)this.sampleRate, "s");
        double tl = 340.0 * (double)this.n / (double)(this.sampleRate * 2);
        x[2] = "Tube length: " + this.getUnitText(tl, "m");
        x[2] = this.sign == -1 ? String.valueOf(x[2]) + " (closed)" : String.valueOf(x[2]) + " (open)";
    }

    int getPoleCount() {
        return this.n;
    }

    int getZeroCount() {
        return this.n;
    }

    void getZero(int i, Complex c1) {
        c1.set(0.0);
    }
}

