/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter;

import cn.org.gddsn.signal.filter.Complex;
import cn.org.gddsn.signal.filter.FilterType;
import cn.org.gddsn.signal.filter.IIRFilterType;

class CustomIIRFilter
extends IIRFilterType {
    Complex[] customPoles;
    Complex[] customZeros;
    int npoles;
    int nzeros;
    int selectedPole;
    int selectedZero;
    int lastPoleCount = 2;
    int lastZeroCount = 2;
    FilterType filterType;

    CustomIIRFilter() {
    }

    int select() {
        this.auxLabels[0] = "# of Pole Pairs";
        this.auxBars[0] = this.lastPoleCount / 2;
        return 1;
    }

    void setup() {
        this.npoles = this.nzeros = this.auxBars[0] * 2;
    }

    void getPole(int i, Complex c1) {
        c1.set(this.customPoles[i]);
    }

    int getPoleCount() {
        return this.npoles;
    }

    void getZero(int i, Complex c1) {
        c1.set(this.customZeros[i]);
    }

    int getZeroCount() {
        return this.nzeros;
    }

    void getInfo(String[] x) {
        x[0] = "Custom IIR";
        x[1] = String.valueOf(this.npoles) + " poles and zeros";
    }

    void editPoleZero(Complex c) {
        if (c.mag > 1.1) {
            return;
        }
        if (this.selectedPole != -1) {
            this.customPoles[this.selectedPole].set(c);
            this.customPoles[this.selectedPole ^ 1].set(c.re, -c.im);
        }
        if (this.selectedZero != -1) {
            this.customZeros[this.selectedZero].set(c);
            this.customZeros[this.selectedZero ^ 1].set(c.re, -c.im);
        }
    }

    void setCustomPolesZeros() {
        if (this.filterType instanceof CustomIIRFilter) {
            return;
        }
        int polect = this.filterType.getPoleCount();
        int zeroct = this.filterType.getZeroCount();
        Complex c1 = new Complex();
        int n = 0;
        int i = 0;
        while (i != polect) {
            this.filterType.getPole(i, c1);
            if (c1.im >= 0.0) {
                this.customPoles[n++].set(c1);
                this.customPoles[n++].set(c1.re, -c1.im);
                if (n == this.customPoles.length) break;
            }
            ++i;
        }
        this.lastPoleCount = n;
        n = 0;
        i = 0;
        while (i != zeroct) {
            this.filterType.getZero(i, c1);
            if (c1.im >= 0.0) {
                this.customZeros[n++].set(c1);
                this.customZeros[n++].set(c1.re, -c1.im);
                if (n == this.customZeros.length) break;
            }
            ++i;
        }
        this.lastZeroCount = n;
    }
}

