/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter;

class FFT {
    double[] wtabf;
    double[] wtabi;
    int size;

    FFT(int sz) {
        this.size = sz;
        if ((this.size & this.size - 1) != 0) {
            System.out.println("size must be power of two!");
        }
        this.calcWTable();
    }

    void calcWTable() {
        this.wtabf = new double[this.size];
        this.wtabi = new double[this.size];
        int i = 0;
        while (i != this.size) {
            double th = Math.PI * (double)i / (double)this.size;
            this.wtabf[i] = Math.cos(th);
            this.wtabf[i + 1] = Math.sin(th);
            this.wtabi[i] = this.wtabf[i];
            this.wtabi[i + 1] = -this.wtabf[i + 1];
            i += 2;
        }
    }

    void transform(double[] data, boolean inv) {
        double d2i;
        double d2r;
        double d1i;
        double d1r;
        int j = 0;
        int size2 = this.size * 2;
        if ((this.size & this.size - 1) != 0) {
            System.out.println("size must be power of two!");
        }
        int i = 0;
        while (i != size2) {
            if (i > j) {
                double q = data[i];
                data[i] = data[j];
                data[j] = q;
                q = data[i + 1];
                data[i + 1] = data[j + 1];
                data[j + 1] = q;
            }
            int bit = this.size;
            while ((bit & j) != 0) {
                j &= ~bit;
                bit >>= 1;
            }
            j |= bit;
            i += 2;
        }
        int tabskip = this.size << 1;
        double[] wtab = inv ? this.wtabi : this.wtabf;
        i = 0;
        while (i != size2) {
            d1r = data[i];
            d1i = data[i + 1];
            d2r = data[i + 2];
            d2i = data[i + 3];
            data[i] = d1r + d2r;
            data[i + 1] = d1i + d2i;
            data[i + 2] = d1r - d2r;
            data[i + 3] = d1i - d2i;
            i += 4;
        }
        tabskip >>= 1;
        int imult = inv ? -1 : 1;
        i = 0;
        while (i != size2) {
            d1r = data[i];
            d1i = data[i + 1];
            d2r = data[i + 4];
            d2i = data[i + 5];
            data[i] = d1r + d2r;
            data[i + 1] = d1i + d2i;
            data[i + 4] = d1r - d2r;
            data[i + 5] = d1i - d2i;
            d1r = data[i + 2];
            d1i = data[i + 3];
            d2r = data[i + 6] * (double)imult;
            d2i = data[i + 7] * (double)imult;
            data[i + 2] = d1r - d2i;
            data[i + 3] = d1i + d2r;
            data[i + 6] = d1r + d2i;
            data[i + 7] = d1i - d2r;
            i += 8;
        }
        tabskip >>= 1;
        int skip1 = 16;
        while (skip1 <= size2) {
            int skip2 = skip1 >> 1;
            tabskip >>= 1;
            i = 0;
            while (i != 1000) {
                ++i;
            }
            i = 0;
            while (i < size2) {
                int ix = 0;
                j = i;
                while (j != i + skip2) {
                    double wr = wtab[ix];
                    double wi = wtab[ix + 1];
                    d1r = data[j];
                    d1i = data[j + 1];
                    int j2 = j + skip2;
                    d2r = data[j2];
                    d2i = data[j2 + 1];
                    double d2wr = d2r * wr - d2i * wi;
                    double d2wi = d2r * wi + d2i * wr;
                    data[j] = d1r + d2wr;
                    data[j + 1] = d1i + d2wi;
                    data[j2] = d1r - d2wr;
                    data[j2 + 1] = d1i - d2wi;
                    j += 2;
                    ix += tabskip;
                }
                i += skip1;
            }
            skip1 <<= 1;
        }
    }
}

