/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter;

import cn.org.gddsn.signal.filter.Complex;

abstract class Filter {
    Filter() {
    }

    abstract void run(double[] var1, double[] var2, int var3, int var4, int var5, double[] var6);

    abstract void evalTransfer(Complex var1);

    abstract int getImpulseOffset();

    abstract int getStepOffset();

    abstract int getLength();

    boolean useConvolve() {
        return false;
    }

    double[] getImpulseResponse(int offset) {
        int pts = 1000;
        double[] inbuf = new double[offset + pts];
        double[] outbuf = new double[offset + pts];
        inbuf[offset] = 1.0;
        double[] state = this.createState();
        this.run(inbuf, outbuf, offset, -1, pts, state);
        return outbuf;
    }

    double[] getStepResponse(int offset) {
        int pts = 1000;
        double[] inbuf = new double[offset + pts];
        double[] outbuf = new double[offset + pts];
        int i = offset;
        while (i != inbuf.length) {
            inbuf[i] = 1.0;
            ++i;
        }
        double[] state = this.createState();
        this.run(inbuf, outbuf, offset, -1, pts, state);
        return outbuf;
    }

    int getImpulseLen(int offset, double[] buf) {
        return this.countPoints(buf, offset);
    }

    int getStepLen(int offset, double[] buf) {
        return this.countPoints(buf, offset);
    }

    int countPoints(double[] buf, int offset) {
        int len = buf.length;
        double max = 0.0;
        int result = 0;
        double last = 123.0;
        int i = offset;
        while (i < len) {
            double qa = Math.abs(buf[i]);
            if (qa > max) {
                max = qa;
            }
            if (Math.abs(qa - last) > max * 0.003) {
                result = i - offset + 1;
            }
            last = qa;
            ++i;
        }
        return result;
    }

    double[] createState() {
        return null;
    }
}

